/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.adapter.ipfix;

import com.google.common.primitives.UnsignedLong;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.bson.BsonDocument;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.telemetry.protocols.common.utils.BsonUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.adapter.common.UpdatingFlow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IpfixFlow
extends UpdatingFlow
implements Flow {
    private static final Logger LOG = LoggerFactory.getLogger(IpfixFlow.class);
    private final BsonDocument document;

    public IpfixFlow(BsonDocument document) {
        this.document = Objects.requireNonNull(document);
    }

    public long getTimestamp() {
        return (Long)BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@exportTime"}).get() * 1000L;
    }

    public Long getBytes() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"octetDeltaCount"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"postOctetDeltaCount"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"layer2OctetDeltaCount"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"postLayer2OctetDeltaCount"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"transportOctetDeltaCount"})}).orElse(null);
    }

    public Flow.Direction getDirection() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"flowDirection"}).map(v -> v == 0L ? Flow.Direction.INGRESS : (v == 1L ? Flow.Direction.EGRESS : null)).orElse(null);
    }

    public String getDstAddr() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"destinationIPv6Address", "address"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"destinationIPv4Address", "address"})}).orElse(null);
    }

    public Optional<String> getDstAddrHostname() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"destinationIPv6Address", "hostname"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"destinationIPv4Address", "hostname"})});
    }

    public Long getDstAs() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"bgpDestinationAsNumber"}).orElse(null);
    }

    public Integer getDstMaskLen() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"destinationIPv6PrefixLength"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"destinationIPv4PrefixLength"})}).map(Long::intValue).orElse(null);
    }

    public Integer getDstPort() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"destinationTransportPort"}).map(Long::intValue).orElse(null);
    }

    public Integer getEngineId() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"engineId"}).map(Long::intValue).orElse(null);
    }

    public Integer getEngineType() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"engineType"}).map(Long::intValue).orElse(null);
    }

    public Long getFirstSwitched() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.first((Optional[])new Optional[]{BsonUtils.getTime((BsonDocument)this.document, (String[])new String[]{"flowStartSeconds"}), BsonUtils.getTime((BsonDocument)this.document, (String[])new String[]{"flowStartMilliseconds"}), BsonUtils.getTime((BsonDocument)this.document, (String[])new String[]{"flowStartMicroseconds"}), BsonUtils.getTime((BsonDocument)this.document, (String[])new String[]{"flowStartNanoseconds"})}).map(Instant::toEpochMilli), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"flowStartDeltaMicroseconds"}).map(t -> this.getTimestamp() + t), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"flowStartSysUpTime"}).flatMap(t -> BsonUtils.getTime((BsonDocument)this.document, (String[])new String[]{"systemInitTimeMilliseconds"}).map(ts -> ts.toEpochMilli() + t))}).orElse(null);
    }

    public int getFlowRecords() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@recordCount"}).map(Long::intValue).orElse(0);
    }

    public long getFlowSeqNum() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"@sequenceNumber"}).orElse(0L);
    }

    public Integer getInputSnmp() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"ingressInterface"}).map(Long::intValue).orElse(null);
    }

    public Integer getIpProtocolVersion() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"ipVersion"}).map(Long::intValue).orElse(null);
    }

    public Long getLastSwitched() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.first((Optional[])new Optional[]{BsonUtils.getTime((BsonDocument)this.document, (String[])new String[]{"flowEndSeconds"}), BsonUtils.getTime((BsonDocument)this.document, (String[])new String[]{"flowEndMilliseconds"}), BsonUtils.getTime((BsonDocument)this.document, (String[])new String[]{"flowEndMicroseconds"}), BsonUtils.getTime((BsonDocument)this.document, (String[])new String[]{"flowEndNanoseconds"})}).map(Instant::toEpochMilli), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"flowEndDeltaMicroseconds"}).map(t -> this.getTimestamp() + t), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"flowEndSysUpTime"}).flatMap(t -> BsonUtils.getTime((BsonDocument)this.document, (String[])new String[]{"systemInitTimeMilliseconds"}).map(ts -> ts.toEpochMilli() + t))}).orElse(null);
    }

    public String getNextHop() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"ipNextHopIPv6Address", "address"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"ipNextHopIPv4Address", "address"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"bgpNextHopIPv6Address", "address"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"bgpNextHopIPv4Address", "address"})}).orElse(null);
    }

    public Optional<String> getNextHopHostname() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"ipNextHopIPv6Address", "hostname"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"ipNextHopIPv4Address", "hostname"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"bgpNextHopIPv6Address", "hostname"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"bgpNextHopIPv4Address", "hostname"})});
    }

    public Integer getOutputSnmp() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"egressInterface"}).map(Long::intValue).orElse(null);
    }

    public Long getPackets() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"packetDeltaCount"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"postPacketDeltaCount"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"transportPacketDeltaCount"})}).orElse(null);
    }

    public Integer getProtocol() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"protocolIdentifier"}).map(Long::intValue).orElse(null);
    }

    public Flow.SamplingAlgorithm getSamplingAlgorithm() {
        Integer selectorAlgorithm;
        Integer deprecatedSamplingAlgorithm = BsonUtils.first((Optional[])new Optional[]{BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"samplingAlgorithm"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"samplerMode"})}).map(Long::intValue).orElse(null);
        if (deprecatedSamplingAlgorithm != null) {
            if (deprecatedSamplingAlgorithm == 1) {
                return Flow.SamplingAlgorithm.SystematicCountBasedSampling;
            }
            if (deprecatedSamplingAlgorithm == 2) {
                return Flow.SamplingAlgorithm.RandomNoutOfNSampling;
            }
        }
        if ((selectorAlgorithm = (Integer)BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"selectorAlgorithm"}).map(Long::intValue).orElse(null)) != null) {
            switch (selectorAlgorithm) {
                case 0: {
                    return Flow.SamplingAlgorithm.Unassigned;
                }
                case 1: {
                    return Flow.SamplingAlgorithm.SystematicCountBasedSampling;
                }
                case 2: {
                    return Flow.SamplingAlgorithm.SystematicTimeBasedSampling;
                }
                case 3: {
                    return Flow.SamplingAlgorithm.RandomNoutOfNSampling;
                }
                case 4: {
                    return Flow.SamplingAlgorithm.UniformProbabilisticSampling;
                }
                case 5: {
                    return Flow.SamplingAlgorithm.PropertyMatchFiltering;
                }
                case 6: 
                case 7: 
                case 8: {
                    return Flow.SamplingAlgorithm.HashBasedFiltering;
                }
                case 9: {
                    return Flow.SamplingAlgorithm.FlowStateDependentIntermediateFlowSelectionProcess;
                }
            }
            LOG.warn("Unknown selector algorithm: {}", (Object)selectorAlgorithm);
        }
        return Flow.SamplingAlgorithm.Unassigned;
    }

    public Double getSamplingInterval() {
        Double deprecatedSamplingInterval = BsonUtils.first((Optional[])new Optional[]{BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"samplingInterval"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"samplerRandomInterval"})}).map(Long::doubleValue).orElse(null);
        if (deprecatedSamplingInterval != null) {
            return deprecatedSamplingInterval;
        }
        Integer selectorAlgorithm = BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"selectorAlgorithm"}).map(Long::intValue).orElse(null);
        if (selectorAlgorithm != null) {
            switch (selectorAlgorithm) {
                case 0: {
                    return null;
                }
                case 1: {
                    Double samplingInterval = BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"samplingFlowInterval"}).map(Long::doubleValue).orElse(1.0);
                    Double samplingSpacing = BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"samplingFlowSpacing"}).map(Long::doubleValue).orElse(0.0);
                    return (samplingInterval + samplingSpacing) / samplingInterval;
                }
                case 2: {
                    Double flowSamplingTimeInterval = BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"flowSamplingTimeInterval"}).map(Long::doubleValue).orElse(1.0);
                    Double flowSamplingTimeSpacing = BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"flowSamplingTimeSpacing"}).map(Long::doubleValue).orElse(0.0);
                    return (flowSamplingTimeInterval + flowSamplingTimeSpacing) / flowSamplingTimeInterval;
                }
                case 3: {
                    Double samplingSize = BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"samplingSize"}).map(Long::doubleValue).orElse(1.0);
                    Double samplingPopulation = BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"samplingPopulation"}).map(Long::doubleValue).orElse(1.0);
                    return samplingPopulation / samplingSize;
                }
                case 4: {
                    Double samplingProbability = BsonUtils.getDouble((BsonDocument)this.document, (String[])new String[]{"samplingProbability"}).orElse(1.0);
                    return 1.0 / samplingProbability;
                }
                case 5: 
                case 6: 
                case 7: {
                    UnsignedLong hashSelectedRangeMin = BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"hashSelectedRangeMin"}).map(UnsignedLong::fromLongBits).orElse(UnsignedLong.ZERO);
                    UnsignedLong hashSelectedRangeMax = BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"hashSelectedRangeMax"}).map(UnsignedLong::fromLongBits).orElse(UnsignedLong.MAX_VALUE);
                    UnsignedLong hashOutputRangeMin = BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"hashOutputRangeMin"}).map(UnsignedLong::fromLongBits).orElse(UnsignedLong.ZERO);
                    UnsignedLong hashOutputRangeMax = BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"hashOutputRangeMax"}).map(UnsignedLong::fromLongBits).orElse(UnsignedLong.MAX_VALUE);
                    return hashOutputRangeMax.minus(hashOutputRangeMin).dividedBy(hashSelectedRangeMax.minus(hashSelectedRangeMin)).doubleValue();
                }
            }
            LOG.warn("Unsupported sampling algorithm: {}", (Object)selectorAlgorithm);
            return Double.NaN;
        }
        return 1.0;
    }

    public String getSrcAddr() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"sourceIPv6Address", "address"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"sourceIPv4Address", "address"})}).orElse(null);
    }

    public Optional<String> getSrcAddrHostname() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"sourceIPv6Address", "hostname"}), BsonUtils.getString((BsonDocument)this.document, (String[])new String[]{"sourceIPv4Address", "hostname"})});
    }

    public Long getSrcAs() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"bgpSourceAsNumber"}).orElse(null);
    }

    public Integer getSrcMaskLen() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"sourceIPv6PrefixLength"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"sourceIPv4PrefixLength"})}).map(Long::intValue).orElse(null);
    }

    public Integer getSrcPort() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"sourceTransportPort"}).map(Long::intValue).orElse(null);
    }

    public Integer getTcpFlags() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"tcpControlBits"}).map(Long::intValue).orElse(null);
    }

    public Integer getTos() {
        return BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"ipClassOfService"}).map(Long::intValue).orElse(null);
    }

    public Flow.NetflowVersion getNetflowVersion() {
        return Flow.NetflowVersion.IPFIX;
    }

    public Integer getVlan() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"vlanId"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"postVlanId"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"dot1qVlanId"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"dot1qCustomerVlanId"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"postDot1qVlanId"}), BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"postDot1qCustomerVlanId"})}).map(Long::intValue).orElse(null);
    }

    @Override
    public Optional<UpdatingFlow.Timeout> getTimeout() {
        Optional<Long> active = BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"flowActiveTimeout"}).map(t -> t * 1000L);
        Optional<Long> inactive = BsonUtils.getInt64((BsonDocument)this.document, (String[])new String[]{"flowInactiveTimeout"}).map(t -> t * 1000L);
        if (active.isPresent() && inactive.isPresent()) {
            return Optional.of(new UpdatingFlow.Timeout(active.get(), inactive.get()));
        }
        return Optional.empty();
    }
}

