/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.adapter;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.BmpMessageHandler;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.Context;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.proto.Message;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.proto.Type;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.proto.records.BaseAttribute;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.proto.records.Collector;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.proto.records.Peer;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.proto.records.Router;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.proto.records.UnicastPrefix;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpAsnPathAnalysis;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpAsnPathAnalysisDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpBaseAttribute;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpBaseAttributeDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpCollector;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpCollectorDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpGlobalIpRibDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpIpRibLog;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpIpRibLogDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpPeer;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpPeerDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpRouter;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpRouterDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpUnicastPrefix;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpUnicastPrefixDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BmpMessagePersister
implements BmpMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BmpMessagePersister.class);
    @Autowired
    private BmpCollectorDao bmpCollectorDao;
    @Autowired
    private BmpRouterDao bmpRouterDao;
    @Autowired
    private BmpPeerDao bmpPeerDao;
    @Autowired
    private BmpBaseAttributeDao bmpBaseAttributeDao;
    @Autowired
    private BmpUnicastPrefixDao bmpUnicastPrefixDao;
    @Autowired
    private BmpGlobalIpRibDao bmpGlobalIpRibDao;
    @Autowired
    private BmpAsnPathAnalysisDao bmpAsnPathAnalysisDao;
    @Autowired
    private BmpIpRibLogDao bmpIpRibLogDao;
    @Autowired
    private SessionUtils sessionUtils;

    @Override
    public void handle(Message message, Context context) {
        this.sessionUtils.withTransaction(() -> {
            switch (message.getType()) {
                case COLLECTOR: {
                    List<BmpCollector> bmpCollectors = this.buildBmpCollectors(message);
                    bmpCollectors.forEach(collector -> {
                        try {
                            this.bmpCollectorDao.saveOrUpdate(collector);
                        }
                        catch (Exception e) {
                            LOG.error("Exception while persisting BMP collector {}", collector, (Object)e);
                        }
                    });
                    break;
                }
                case ROUTER: {
                    List<BmpRouter> bmpRouters = this.buildBmpRouters(message);
                    bmpRouters.forEach(router -> {
                        boolean state;
                        Integer connections = router.getConnectionCount();
                        boolean bl = state = !router.getAction().equals(Router.Action.TERM.value);
                        if (connections == 0 && state) {
                            router.getBmpPeers().forEach(bmpPeer -> {
                                if (bmpPeer.getTimestamp().getTime() < router.getTimestamp().getTime()) {
                                    bmpPeer.setState(State.DOWN);
                                }
                            });
                        }
                        Integer count = state ? (connections = Integer.valueOf(connections + 1)) : (connections = Integer.valueOf(connections - 1));
                        router.setConnectionCount(count);
                        try {
                            this.bmpRouterDao.saveOrUpdate(router);
                        }
                        catch (Exception e) {
                            LOG.error("Exception while persisting BMP router {}", router, (Object)e);
                        }
                    });
                    break;
                }
                case PEER: {
                    List<BmpPeer> bmpPeers = this.buildBmpPeers(message);
                    bmpPeers.forEach(peer -> {
                        Set unicastPrefixes = peer.getBmpUnicastPrefixes().stream().filter(bmpUnicastPrefix -> bmpUnicastPrefix.getTimestamp().getTime() > peer.getTimestamp().getTime()).collect(Collectors.toSet());
                        peer.setBmpUnicastPrefixes(unicastPrefixes);
                        try {
                            this.bmpPeerDao.saveOrUpdate(peer);
                        }
                        catch (Exception e) {
                            LOG.error("Exception while persisting BMP peer {}", peer, (Object)e);
                        }
                    });
                    break;
                }
                case BASE_ATTRIBUTE: {
                    List<BmpBaseAttribute> bmpBaseAttributes = BmpMessagePersister.buildBmpBaseAttributes(message);
                    bmpBaseAttributes.forEach(bmpBaseAttribute -> {
                        try {
                            this.bmpBaseAttributeDao.saveOrUpdate(bmpBaseAttribute);
                        }
                        catch (Exception e) {
                            LOG.error("Exception while persisting BMP base attribute {}", bmpBaseAttribute, (Object)e);
                        }
                        String asPath = bmpBaseAttribute.getAsPath();
                        List<BmpAsnPathAnalysis> asnPaths = this.buildBmpAsnPath(asPath);
                        asnPaths.forEach(asnPath -> {
                            try {
                                this.bmpAsnPathAnalysisDao.saveOrUpdate(asnPath);
                            }
                            catch (Exception e) {
                                LOG.error("Exception while persisting BMP asn path {}", asnPath, (Object)e);
                            }
                        });
                    });
                    break;
                }
                case UNICAST_PREFIX: {
                    List<BmpUnicastPrefix> bmpUnicastPrefixes = this.buildBmpUnicastPrefix(message);
                    bmpUnicastPrefixes.forEach(unicastPrefix -> {
                        try {
                            this.updateStats((BmpUnicastPrefix)unicastPrefix, context.location);
                            this.bmpUnicastPrefixDao.saveOrUpdate(unicastPrefix);
                        }
                        catch (Exception e) {
                            LOG.error("Exception while persisting BMP unicast prefix {}", unicastPrefix, (Object)e);
                        }
                    });
                }
            }
        });
    }

    private void updateStats(BmpUnicastPrefix unicastPrefix, String location) {
        if (unicastPrefix.getId() == null || unicastPrefix.isWithDrawn() != unicastPrefix.isPrevWithDrawnState() || !unicastPrefix.isWithDrawn() && !unicastPrefix.getBaseAttrHashId().equals(unicastPrefix.getPrevBaseAttrHashId())) {
            String peerHashId = unicastPrefix.getBmpPeer().getHashId();
            BmpIpRibLog bmpIpRibLog = new BmpIpRibLog();
            bmpIpRibLog.setPeerHashId(peerHashId);
            bmpIpRibLog.setBaseAttrHashId(unicastPrefix.getBaseAttrHashId());
            bmpIpRibLog.setPrefix(unicastPrefix.getPrefix());
            bmpIpRibLog.setPrefixLen(unicastPrefix.getPrefixLen());
            bmpIpRibLog.setOriginAs(unicastPrefix.getOriginAs());
            bmpIpRibLog.setTimestamp(new Date());
            bmpIpRibLog.setWithDrawn(unicastPrefix.isWithDrawn());
            this.bmpIpRibLogDao.saveOrUpdate((Object)bmpIpRibLog);
        }
    }

    @Override
    public void close() {
    }

    private List<BmpCollector> buildBmpCollectors(Message message) {
        ArrayList<BmpCollector> bmpCollectors = new ArrayList<BmpCollector>();
        message.getRecords().forEach(record -> {
            if (record.getType().equals((Object)Type.COLLECTOR)) {
                Collector collector = (Collector)record;
                try {
                    BmpCollector collectorEntity = this.bmpCollectorDao.findByCollectorHashId(collector.hash);
                    if (collectorEntity == null) {
                        collectorEntity = new BmpCollector();
                    }
                    collectorEntity.setAction(collector.action.value);
                    collectorEntity.setAdminId(collector.adminId);
                    collectorEntity.setHashId(collector.hash);
                    String routers = collector.routers != null ? Joiner.on((char)',').join(Iterables.transform(collector.routers, InetAddressUtils::str)) : "";
                    collectorEntity.setRouters(routers);
                    int routerCount = collector.routers != null ? collector.routers.size() : 0;
                    collectorEntity.setRoutersCount(Integer.valueOf(routerCount));
                    State state = !collector.action.equals((Object)Collector.Action.STOPPED) ? State.UP : State.DOWN;
                    collectorEntity.setState(state);
                    collectorEntity.setTimestamp(Date.from(collector.timestamp));
                    bmpCollectors.add(collectorEntity);
                }
                catch (Exception e) {
                    LOG.error("Exception while mapping collector with admin Id {} to Collector entity", (Object)collector.adminId, (Object)e);
                }
            }
        });
        return bmpCollectors;
    }

    private List<BmpRouter> buildBmpRouters(Message message) {
        ArrayList<BmpRouter> bmpRouters = new ArrayList<BmpRouter>();
        message.getRecords().forEach(record -> {
            if (record.getType().equals((Object)Type.ROUTER)) {
                Router router = (Router)record;
                try {
                    BmpRouter bmpRouterEntity = this.bmpRouterDao.findByRouterHashId(router.hash);
                    if (bmpRouterEntity == null) {
                        bmpRouterEntity = new BmpRouter();
                    }
                    bmpRouterEntity.setCollectorHashId(message.getCollectorHashId());
                    bmpRouterEntity.setHashId(router.hash);
                    bmpRouterEntity.setName(router.name);
                    bmpRouterEntity.setIpAddress(InetAddressUtils.str((InetAddress)router.ipAddress));
                    bmpRouterEntity.setTimestamp(Date.from(router.timestamp));
                    bmpRouterEntity.setTermReasonText(router.termReason);
                    bmpRouterEntity.setTermReasonCode(router.termCode);
                    bmpRouterEntity.setTermData(router.termData);
                    bmpRouterEntity.setBgpId(InetAddressUtils.str((InetAddress)router.bgpId));
                    bmpRouterEntity.setDescription(router.description);
                    bmpRouterEntity.setInitData(router.initData);
                    State state = !router.action.equals((Object)Router.Action.TERM) ? State.UP : State.DOWN;
                    bmpRouterEntity.setAction(router.action.value);
                    bmpRouterEntity.setState(state);
                    bmpRouters.add(bmpRouterEntity);
                }
                catch (Exception e) {
                    LOG.error("Exception while mapping Router with IpAddress '{}' to Router entity", (Object)InetAddressUtils.str((InetAddress)router.ipAddress), (Object)e);
                }
            }
        });
        return bmpRouters;
    }

    private List<BmpPeer> buildBmpPeers(Message message) {
        ArrayList<BmpPeer> bmpPeers = new ArrayList<BmpPeer>();
        message.getRecords().forEach(record -> {
            if (record.getType().equals((Object)Type.PEER)) {
                Peer peer = (Peer)record;
                try {
                    BmpRouter bmpRouter;
                    BmpPeer peerEntity = this.bmpPeerDao.findByPeerHashId(peer.hash);
                    if (peerEntity == null) {
                        peerEntity = new BmpPeer();
                        bmpRouter = this.bmpRouterDao.findByRouterHashId(peer.routerHash);
                    } else {
                        bmpRouter = peerEntity.getBmpRouter();
                    }
                    peerEntity.setBmpRouter(bmpRouter);
                    peerEntity.setHashId(peer.hash);
                    peerEntity.setPeerRd(peer.peerRd);
                    peerEntity.setIpv4(peer.ipv4);
                    peerEntity.setPeerAddr(InetAddressUtils.str((InetAddress)peer.remoteIp));
                    peerEntity.setName(peer.name);
                    peerEntity.setPeerBgpId(InetAddressUtils.str((InetAddress)peer.remoteBgpId));
                    peerEntity.setPeerAsn(peer.remoteAsn);
                    State state = !peer.action.equals((Object)Peer.Action.DOWN) ? State.UP : State.DOWN;
                    peerEntity.setState(state);
                    peerEntity.setL3VPNPeer(peer.l3vpn);
                    peerEntity.setTimestamp(Date.from(peer.timestamp));
                    peerEntity.setPrePolicy(peer.prePolicy);
                    peerEntity.setLocalIp(InetAddressUtils.str((InetAddress)peer.localIp));
                    peerEntity.setLocalBgpId(InetAddressUtils.str((InetAddress)peer.localBgpId));
                    peerEntity.setLocalPort(peer.localPort);
                    peerEntity.setLocalHoldTime(peer.advertisedHolddown);
                    peerEntity.setLocalAsn(peer.localAsn);
                    peerEntity.setRemotePort(peer.remotePort);
                    peerEntity.setRemoteHoldTime(peer.remoteHolddown);
                    peerEntity.setSentCapabilities(peer.advertisedCapabilities);
                    peerEntity.setReceivedCapabilities(peer.receivedCapabilities);
                    peerEntity.setBmpReason(peer.bmpReason);
                    peerEntity.setBgpErrCode(peer.bgpErrorCode);
                    peerEntity.setBgpErrSubCode(peer.bgpErrorSubcode);
                    peerEntity.setErrorText(peer.errorText);
                    peerEntity.setLocRib(peer.locRib);
                    peerEntity.setLocRibFiltered(peer.locRibFiltered);
                    peerEntity.setTableName(peer.tableName);
                    bmpPeers.add(peerEntity);
                }
                catch (Exception e) {
                    LOG.error("Exception while mapping Peer with peer addr '{}' to Peer entity", (Object)InetAddressUtils.str((InetAddress)peer.remoteIp), (Object)e);
                }
            }
        });
        return bmpPeers;
    }

    private static List<BmpBaseAttribute> buildBmpBaseAttributes(Message message) {
        ArrayList<BmpBaseAttribute> bmpBaseAttributes = new ArrayList<BmpBaseAttribute>();
        message.getRecords().forEach(record -> {
            if (record.getType().equals((Object)Type.BASE_ATTRIBUTE)) {
                BaseAttribute baseAttribute = (BaseAttribute)record;
                try {
                    BmpBaseAttribute bmpBaseAttribute = new BmpBaseAttribute();
                    bmpBaseAttribute.setHashId(baseAttribute.hash);
                    bmpBaseAttribute.setPeerHashId(baseAttribute.peerHash);
                    bmpBaseAttribute.setOrigin(baseAttribute.origin);
                    bmpBaseAttribute.setAsPath(baseAttribute.asPath);
                    bmpBaseAttribute.setAsPathCount(baseAttribute.asPathCount);
                    bmpBaseAttribute.setOriginAs(baseAttribute.originAs);
                    bmpBaseAttribute.setNextHop(InetAddressUtils.str((InetAddress)baseAttribute.nextHop));
                    bmpBaseAttribute.setMed(baseAttribute.med);
                    bmpBaseAttribute.setLocalPref(baseAttribute.localPref);
                    bmpBaseAttribute.setAggregator(baseAttribute.aggregator);
                    bmpBaseAttribute.setCommunityList(baseAttribute.communityList);
                    bmpBaseAttribute.setExtCommunityList(baseAttribute.extCommunityList);
                    bmpBaseAttribute.setLargeCommunityList(baseAttribute.largeCommunityList);
                    bmpBaseAttribute.setClusterList(baseAttribute.clusterList);
                    bmpBaseAttribute.setAtomicAgg(baseAttribute.atomicAgg);
                    bmpBaseAttribute.setNextHopIpv4(baseAttribute.nextHopIpv4);
                    bmpBaseAttribute.setTimestamp(Date.from(baseAttribute.timestamp));
                    bmpBaseAttribute.setOriginatorId(baseAttribute.originatorId);
                    bmpBaseAttributes.add(bmpBaseAttribute);
                }
                catch (Exception e) {
                    LOG.error("Exception while mapping base attribute with hashId {} to BaseAttribute entity", (Object)baseAttribute.hash, (Object)e);
                }
            }
        });
        return bmpBaseAttributes;
    }

    private List<BmpUnicastPrefix> buildBmpUnicastPrefix(Message message) {
        ArrayList<BmpUnicastPrefix> bmpUnicastPrefixes = new ArrayList<BmpUnicastPrefix>();
        message.getRecords().forEach(record -> {
            if (record.getType().equals((Object)Type.UNICAST_PREFIX)) {
                UnicastPrefix unicastPrefix = (UnicastPrefix)record;
                try {
                    BmpPeer bmpPeer;
                    BmpUnicastPrefix bmpUnicastPrefix = this.bmpUnicastPrefixDao.findByHashId(unicastPrefix.hash);
                    if (bmpUnicastPrefix == null) {
                        bmpUnicastPrefix = new BmpUnicastPrefix();
                        bmpUnicastPrefix.setFirstAddedTimestamp(Date.from(unicastPrefix.timestamp));
                        bmpPeer = this.bmpPeerDao.findByPeerHashId(unicastPrefix.peerHash);
                    } else {
                        bmpUnicastPrefix.setPrevBaseAttrHashId(bmpUnicastPrefix.getBaseAttrHashId());
                        bmpUnicastPrefix.setPrevWithDrawnState(bmpUnicastPrefix.isWithDrawn());
                        bmpPeer = bmpUnicastPrefix.getBmpPeer();
                    }
                    if (bmpPeer == null) {
                        LOG.warn("Peer entity with hashId '{}' doesn't exist yet", (Object)unicastPrefix.peerHash);
                        return;
                    }
                    bmpUnicastPrefix.setBmpPeer(bmpPeer);
                    bmpUnicastPrefix.setHashId(unicastPrefix.hash);
                    bmpUnicastPrefix.setBaseAttrHashId(unicastPrefix.baseAttrHash);
                    bmpUnicastPrefix.setIpv4(unicastPrefix.ipv4);
                    bmpUnicastPrefix.setOriginAs(unicastPrefix.originAs);
                    bmpUnicastPrefix.setPrefix(InetAddressUtils.str((InetAddress)unicastPrefix.prefix));
                    bmpUnicastPrefix.setPrefixLen(unicastPrefix.length);
                    bmpUnicastPrefix.setTimestamp(Date.from(unicastPrefix.timestamp));
                    boolean withDrawn = !unicastPrefix.action.equals((Object)UnicastPrefix.Action.ADD);
                    bmpUnicastPrefix.setWithDrawn(withDrawn);
                    bmpUnicastPrefix.setPathId(unicastPrefix.pathId);
                    bmpUnicastPrefix.setLabels(unicastPrefix.labels);
                    bmpUnicastPrefix.setPrePolicy(unicastPrefix.prePolicy);
                    bmpUnicastPrefix.setAdjRibIn(unicastPrefix.adjIn);
                    bmpUnicastPrefixes.add(bmpUnicastPrefix);
                }
                catch (Exception e) {
                    LOG.error("Exception while mapping Unicast prefix with prefix {} to UnicastPrefix entity", (Object)InetAddressUtils.str((InetAddress)unicastPrefix.prefix), (Object)e);
                }
            }
        });
        return bmpUnicastPrefixes;
    }

    List<BmpAsnPathAnalysis> buildBmpAsnPath(String asnPath) {
        ArrayList<BmpAsnPathAnalysis> bmpAsnPathAnalyses = new ArrayList<BmpAsnPathAnalysis>();
        String[] asnStringArray = asnPath.split(" ");
        long[] asnArray = BmpMessagePersister.getLongArrayFromStringArray(asnStringArray);
        if (asnArray.length == 0) {
            return new ArrayList<BmpAsnPathAnalysis>();
        }
        Long leftAsn = 0L;
        Long rightAsn = 0L;
        Long asn = 0L;
        for (int i = 0; i < asnArray.length; ++i) {
            BmpAsnPathAnalysis bmpAsnPathAnalysis;
            asn = asnArray[i];
            if (asn <= 0L) continue;
            if (i + 1 < asnArray.length) {
                rightAsn = asnArray[i + 1];
                if (rightAsn.equals(asn)) continue;
                Boolean isPeeringAsn = i == 0 || i == 1 ? Boolean.TRUE : Boolean.FALSE;
                bmpAsnPathAnalysis = this.bmpAsnPathAnalysisDao.findByAsnPath(asn, leftAsn, rightAsn, isPeeringAsn.booleanValue());
                if (bmpAsnPathAnalysis == null) {
                    bmpAsnPathAnalysis = new BmpAsnPathAnalysis();
                    bmpAsnPathAnalysis.setAsn(asn);
                    bmpAsnPathAnalysis.setAsnLeft(leftAsn);
                    bmpAsnPathAnalysis.setAsnRight(rightAsn);
                    bmpAsnPathAnalysis.setAsnLeftPeering(isPeeringAsn.booleanValue());
                }
            } else {
                BmpAsnPathAnalysis bmpAsnPathAnalysis2 = this.bmpAsnPathAnalysisDao.findByAsnPath(asn, leftAsn, Long.valueOf(0L), false);
                if (bmpAsnPathAnalysis2 == null) {
                    bmpAsnPathAnalysis2 = new BmpAsnPathAnalysis();
                    bmpAsnPathAnalysis2.setAsn(asn);
                    bmpAsnPathAnalysis2.setAsnLeft(leftAsn);
                    bmpAsnPathAnalysis2.setAsnRight(Long.valueOf(0L));
                    bmpAsnPathAnalysis2.setAsnLeftPeering(false);
                }
                bmpAsnPathAnalysis2.setLastUpdated(Date.from(Instant.now()));
                bmpAsnPathAnalyses.add(bmpAsnPathAnalysis2);
                break;
            }
            bmpAsnPathAnalysis.setLastUpdated(Date.from(Instant.now()));
            bmpAsnPathAnalyses.add(bmpAsnPathAnalysis);
            leftAsn = asn;
        }
        return bmpAsnPathAnalyses;
    }

    static long[] getLongArrayFromStringArray(String[] asnArray) {
        long[] emptyArray = new long[]{};
        try {
            return Stream.of(asnArray).mapToLong(Long::parseLong).toArray();
        }
        catch (NumberFormatException numberFormatException) {
            return emptyArray;
        }
    }

    public BmpCollectorDao getBmpCollectorDao() {
        return this.bmpCollectorDao;
    }

    public void setBmpCollectorDao(BmpCollectorDao bmpCollectorDao) {
        this.bmpCollectorDao = bmpCollectorDao;
    }

    public BmpRouterDao getBmpRouterDao() {
        return this.bmpRouterDao;
    }

    public void setBmpRouterDao(BmpRouterDao bmpRouterDao) {
        this.bmpRouterDao = bmpRouterDao;
    }

    public BmpPeerDao getBmpPeerDao() {
        return this.bmpPeerDao;
    }

    public void setBmpPeerDao(BmpPeerDao bmpPeerDao) {
        this.bmpPeerDao = bmpPeerDao;
    }

    public BmpBaseAttributeDao getBmpBaseAttributeDao() {
        return this.bmpBaseAttributeDao;
    }

    public void setBmpBaseAttributeDao(BmpBaseAttributeDao bmpBaseAttributeDao) {
        this.bmpBaseAttributeDao = bmpBaseAttributeDao;
    }

    public BmpUnicastPrefixDao getBmpUnicastPrefixDao() {
        return this.bmpUnicastPrefixDao;
    }

    public void setBmpUnicastPrefixDao(BmpUnicastPrefixDao bmpUnicastPrefixDao) {
        this.bmpUnicastPrefixDao = bmpUnicastPrefixDao;
    }

    public BmpGlobalIpRibDao getBmpGlobalIpRibDao() {
        return this.bmpGlobalIpRibDao;
    }

    public void setBmpGlobalIpRibDao(BmpGlobalIpRibDao bmpGlobalIpRibDao) {
        this.bmpGlobalIpRibDao = bmpGlobalIpRibDao;
    }

    public BmpAsnPathAnalysisDao getBmpAsnPathAnalysisDao() {
        return this.bmpAsnPathAnalysisDao;
    }

    public void setBmpAsnPathAnalysisDao(BmpAsnPathAnalysisDao bmpAsnPathAnalysisDao) {
        this.bmpAsnPathAnalysisDao = bmpAsnPathAnalysisDao;
    }

    public BmpIpRibLogDao getBmpIpRibLogDao() {
        return this.bmpIpRibLogDao;
    }

    public void setBmpIpRibLogDao(BmpIpRibLogDao bmpIpRibLogDao) {
        this.bmpIpRibLogDao = bmpIpRibLogDao;
    }

    public SessionUtils getSessionUtils() {
        return this.sessionUtils;
    }

    public void setSessionUtils(SessionUtils sessionUtils) {
        this.sessionUtils = sessionUtils;
    }
}

