/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2019 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2019 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp;

import java.util.Map;
import java.util.Optional;

import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.telemetry.api.adapter.Adapter;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.protocols.collection.AbstractAdapterFactory;
import org.osgi.framework.BundleContext;

import com.google.common.collect.Maps;

public class BmpIntegrationAdapterFactory extends AbstractAdapterFactory {

    public BmpIntegrationAdapterFactory() {
        super(null);
    }

    public BmpIntegrationAdapterFactory(final BundleContext bundleContext) {
        super(bundleContext);
    }

    @Override
    public Class<? extends Adapter> getBeanClass() {
        return BmpIntegrationAdapter.class;
    }

    @Override
    public Adapter createBean(final AdapterDefinition adapterConfig) {
        // Find topic prefix
        final String topicPrefix = adapterConfig.getParameterMap().remove("topicPrefix");

        // Extract kafka producer config
        final Map<String, Object> kafkaConfig = Maps.newHashMap();
        adapterConfig.getParameterMap().entrySet().removeIf(e -> {
            final Optional<String> prefix = StringUtils.truncatePrefix(e.getKey(), "kafka.");
            prefix.ifPresent(k -> kafkaConfig.put(k, e.getValue()));
            return prefix.isPresent();
        });

        return new BmpIntegrationAdapter(adapterConfig,
                                         this.getTelemetryRegistry().getMetricRegistry(),
                                         new BmpKafkaProducer(topicPrefix, kafkaConfig));
    }
}
