/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.adapter;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.opennms.core.rpc.utils.mate.ContextKey;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.DeferredGenericTypeResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.BmpAdapterTools;
import org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport;
import org.opennms.netmgt.telemetry.protocols.collection.AbstractCollectionAdapter;
import org.opennms.netmgt.telemetry.protocols.collection.CollectionSetWithAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class BmpTelemetryAdapter
extends AbstractCollectionAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(BmpTelemetryAdapter.class);
    private CollectionAgentFactory collectionAgentFactory;
    private InterfaceToNodeCache interfaceToNodeCache;
    private String metaDataNodeLookup;
    private ContextKey contextKey;
    private NodeDao nodeDao;
    private TransactionTemplate transactionTemplate;

    public BmpTelemetryAdapter(AdapterDefinition adapterConfig, MetricRegistry metricRegistry, NodeDao nodeDao, TransactionTemplate transactionTemplate) {
        super(adapterConfig, metricRegistry);
        this.nodeDao = nodeDao;
        this.transactionTemplate = transactionTemplate;
    }

    public Stream<CollectionSetWithAgent> handleCollectionMessage(TelemetryMessageLogEntry messageLogEntry, TelemetryMessageLog messageLog) {
        Transport.Message message;
        LOG.trace("Parsing packet: {}", (Object)messageLogEntry);
        try {
            message = Transport.Message.parseFrom((byte[])messageLogEntry.getByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Invalid message", (Throwable)e);
            return Stream.empty();
        }
        if (!message.hasStatisticsReport()) {
            return Stream.empty();
        }
        Transport.StatisticsReportPacket stats = message.getStatisticsReport();
        InetAddress exporterAddress = InetAddressUtils.getInetAddress((String)messageLog.getSourceAddress());
        Optional<Integer> exporterNodeId = this.interfaceToNodeCache.getFirstNodeId(messageLog.getLocation(), exporterAddress);
        if (!exporterNodeId.isPresent()) {
            LOG.warn("Unable to find node for exporter address: {}", (Object)exporterAddress);
            if (message.hasBgpId()) {
                final InetAddress bgpId = BmpAdapterTools.address(message.getBgpId());
                ExporterInfo exporterInfo = (ExporterInfo)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<ExporterInfo>(){

                    public ExporterInfo doInTransaction(TransactionStatus transactionStatus) {
                        List nodes = BmpTelemetryAdapter.this.nodeDao.findNodeWithMetaData(BmpTelemetryAdapter.this.contextKey.getContext(), BmpTelemetryAdapter.this.contextKey.getKey(), InetAddressUtils.toIpAddrString((InetAddress)bgpId));
                        if (!nodes.isEmpty()) {
                            OnmsNode firstNode;
                            if (nodes.size() > 1) {
                                LOG.warn("More that one node match bgpId: {}", (Object)bgpId);
                            }
                            if ((firstNode = (OnmsNode)nodes.get(0)).containsInterface(bgpId)) {
                                return new ExporterInfo(firstNode.getId(), bgpId);
                            }
                            return new ExporterInfo(firstNode.getId(), firstNode.getPrimaryInterface().getIpAddress());
                        }
                        LOG.warn("Unable to find node for bgpId: {}", (Object)bgpId);
                        return null;
                    }
                });
                if (exporterAddress == null) {
                    return Stream.empty();
                }
                exporterNodeId = Optional.of(exporterInfo.nodeId);
                exporterAddress = exporterInfo.nodeAddress;
            } else {
                return Stream.empty();
            }
        }
        CollectionAgent agent = this.collectionAgentFactory.createCollectionAgent(Integer.toString((Integer)exporterNodeId.get()), exporterAddress);
        String peerAddress = InetAddressUtils.str((InetAddress)BmpAdapterTools.address(stats.getPeer().getAddress()));
        NodeLevelResource nodeResource = new NodeLevelResource(agent.getNodeId());
        DeferredGenericTypeResource peerResource = new DeferredGenericTypeResource(nodeResource, "bmp", peerAddress);
        CollectionSetBuilder builder = new CollectionSetBuilder(agent);
        builder.withTimestamp(Date.from(BmpAdapterTools.timestamp(stats.getPeer().getTimestamp())));
        builder.withStringAttribute((Resource)peerResource, "bmp", "address", peerAddress);
        builder.withStringAttribute((Resource)peerResource, "bmp", "as", Long.toString(stats.getPeer().getAs()));
        builder.withStringAttribute((Resource)peerResource, "bmp", "id", BmpAdapterTools.addressAsStr(stats.getPeer().getId()));
        Function<String, Consumer> addCounter = name -> counter -> {
            String identifier = String.format("bmp_%s_%s", peerAddress, name);
            builder.withIdentifiedNumericAttribute((Resource)peerResource, "bmp", name, (Number)counter.getCount(), AttributeType.COUNTER, identifier);
        };
        Function<String, Consumer> addGauge = name -> gauge -> {
            String identifier = String.format("bmp_%s_%s", peerAddress, name);
            builder.withIdentifiedNumericAttribute((Resource)peerResource, "bmp", name, (Number)gauge.getValue(), AttributeType.COUNTER, identifier);
        };
        Optional.ofNullable(stats.getRejected()).ifPresent(addCounter.apply("rejected"));
        Optional.ofNullable(stats.getDuplicatePrefix()).ifPresent(addCounter.apply("duplicate_prefix"));
        Optional.ofNullable(stats.getDuplicateWithdraw()).ifPresent(addCounter.apply("duplicate_withdraw"));
        Optional.ofNullable(stats.getInvalidUpdateDueToAsConfedLoop()).ifPresent(addCounter.apply("inv_as_confed_loop"));
        Optional.ofNullable(stats.getInvalidUpdateDueToAsPathLoop()).ifPresent(addCounter.apply("inv_as_path_loop"));
        Optional.ofNullable(stats.getInvalidUpdateDueToClusterListLoop()).ifPresent(addCounter.apply("inv_cl_loop"));
        Optional.ofNullable(stats.getInvalidUpdateDueToOriginatorId()).ifPresent(addCounter.apply("inv_originator_id"));
        Optional.ofNullable(stats.getAdjRibIn()).ifPresent(addGauge.apply("adj_rib_in"));
        Optional.ofNullable(stats.getAdjRibOut()).ifPresent(addGauge.apply("adj_rib_out"));
        Optional.ofNullable(stats.getPerAfiAdjRibInMap()).ifPresent(m -> m.entrySet().stream().forEach(e -> addGauge.apply("adj_r_in_" + ((String)e.getKey()).replace(":", "_"))));
        Optional.ofNullable(stats.getUpdateTreatAsWithdraw()).ifPresent(addCounter.apply("update_withdraw"));
        Optional.ofNullable(stats.getPrefixTreatAsWithdraw()).ifPresent(addCounter.apply("prefix_withdraw"));
        Optional.ofNullable(stats.getDuplicateUpdate()).ifPresent(addCounter.apply("duplicate_update"));
        Optional.ofNullable(stats.getLocalRib()).ifPresent(addGauge.apply("local_rib"));
        Optional.ofNullable(stats.getExportRib()).ifPresent(addGauge.apply("export_rib"));
        Optional.ofNullable(stats.getPerAfiExportRibMap()).ifPresent(m -> m.entrySet().stream().forEach(e -> addGauge.apply("exp_r_" + ((String)e.getKey()).replace(":", "_"))));
        return Stream.of(new CollectionSetWithAgent(agent, (CollectionSet)builder.build()));
    }

    public void setCollectionAgentFactory(CollectionAgentFactory collectionAgentFactory) {
        this.collectionAgentFactory = collectionAgentFactory;
    }

    public void setInterfaceToNodeCache(InterfaceToNodeCache interfaceToNodeCache) {
        this.interfaceToNodeCache = interfaceToNodeCache;
    }

    public String getMetaDataNodeLookup() {
        return this.metaDataNodeLookup;
    }

    public void setMetaDataNodeLookup(String metaDataNodeLookup) {
        this.metaDataNodeLookup = metaDataNodeLookup;
        this.contextKey = !Strings.isNullOrEmpty((String)this.metaDataNodeLookup) ? new ContextKey(metaDataNodeLookup) : null;
    }

    private static class ExporterInfo {
        public final int nodeId;
        public final InetAddress nodeAddress;

        public ExporterInfo(int nodeId, InetAddress nodeAddress) {
            this.nodeId = nodeId;
            this.nodeAddress = nodeAddress;
        }
    }
}

