/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.distributed.common;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.config.api.PackageDefinition;
import org.opennms.netmgt.telemetry.config.model.PackageConfig;
import org.opennms.netmgt.telemetry.distributed.common.PropertyTree;

public class MapBasedAdapterDef
implements AdapterDefinition {
    private final String name;
    private final String className;
    private final Map<String, String> parameters;

    protected MapBasedAdapterDef(Map<String, String> properties) {
        this(PropertyTree.from(Objects.requireNonNull(properties)));
    }

    public MapBasedAdapterDef(PropertyTree definition) {
        this.name = definition.getRequiredString("name");
        this.className = definition.getRequiredString("class-name");
        this.parameters = definition.getFlatMap("parameters");
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getParameterMap() {
        return this.parameters;
    }

    public String getName() {
        return this.name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<? extends PackageDefinition> getPackages() {
        try (InputStream inputStream = this.getClass().getResourceAsStream("/package.xml");){
            PackageConfig pkg = (PackageConfig)JaxbUtils.unmarshal(PackageConfig.class, (InputStream)inputStream);
            ArrayList arrayList = Lists.newArrayList((Object[])new PackageConfig[]{pkg});
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading package.xml", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapBasedAdapterDef that = (MapBasedAdapterDef)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.className, that.className) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.className, this.parameters);
    }
}

