/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.telemetry.adapters.registry.impl;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.opennms.core.soa.lookup.ServiceLookupBuilder;
import org.opennms.features.telemetry.adapters.registry.api.TelemetryAdapterRegistry;
import org.opennms.netmgt.telemetry.adapters.api.Adapter;
import org.opennms.netmgt.telemetry.adapters.api.AdapterFactory;
import org.opennms.netmgt.telemetry.config.api.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

public class TelemetryAdapterRegistryImpl
implements TelemetryAdapterRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryAdapterRegistry.class);
    private static final ServiceLoader<AdapterFactory> s_adapterFactoryLoader = ServiceLoader.load(AdapterFactory.class);
    private static final String TYPE = "type";
    private final Map<String, AdapterFactoryRegistration> m_adapterFactoryByClassName = new HashMap<String, AdapterFactoryRegistration>();
    @Autowired
    private ApplicationContext applicationContext;

    public TelemetryAdapterRegistryImpl() {
        for (AdapterFactory adapterFactory : s_adapterFactoryLoader) {
            String className = adapterFactory.getAdapterClass().getCanonicalName();
            this.m_adapterFactoryByClassName.put(className, new AdapterFactoryRegistration(className, adapterFactory, true));
        }
    }

    public synchronized void onBind(AdapterFactory adapterFactory, Map properties) {
        LOG.debug("Bind called with {}: {}", (Object)adapterFactory, (Object)properties);
        if (adapterFactory != null) {
            String className = TelemetryAdapterRegistryImpl.getClassName(properties);
            if (className == null) {
                LOG.warn("Unable to determine the class name for AdapterFactory: {}, with properties: {}. The adapter will not be registered.", (Object)adapterFactory, (Object)properties);
                return;
            }
            this.m_adapterFactoryByClassName.put(className, new AdapterFactoryRegistration(className, adapterFactory, false));
        }
    }

    public synchronized void onUnbind(AdapterFactory adapterFactory, Map properties) {
        LOG.debug("Unbind called with {}: {}", (Object)adapterFactory, (Object)properties);
        if (adapterFactory != null) {
            String className = TelemetryAdapterRegistryImpl.getClassName(properties);
            if (className == null) {
                LOG.warn("Unable to determine the class name for AdapterFactory: {}, with properties: {}. The adapter will not be unregistered.", (Object)adapterFactory, (Object)properties);
                return;
            }
            this.m_adapterFactoryByClassName.remove(className);
        }
    }

    @Override
    public Adapter getAdapter(String className, Protocol protocol, Map<String, String> properties) {
        AdapterFactoryRegistration registration = this.m_adapterFactoryByClassName.get(className);
        long waitUntil = System.currentTimeMillis() + ServiceLookupBuilder.WAIT_PERIOD_MS;
        while (registration == null && ManagementFactory.getRuntimeMXBean().getUptime() < ServiceLookupBuilder.GRACE_PERIOD_MS && System.currentTimeMillis() < waitUntil) {
            try {
                Thread.sleep(ServiceLookupBuilder.LOOKUP_DELAY_MS);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting for adapter factory to become available in the service registry. Aborting.");
                return null;
            }
            registration = this.m_adapterFactoryByClassName.get(className);
        }
        Adapter adapter = null;
        if (registration != null) {
            adapter = registration.getAdapterFactory().createAdapter(protocol, properties);
            if (registration.shouldAutowire()) {
                AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
                beanFactory.autowireBean((Object)adapter);
                beanFactory.initializeBean((Object)adapter, "adapter");
            }
        }
        return adapter;
    }

    private static String getClassName(Map<?, ?> properties) {
        Object type = properties.get(TYPE);
        if (type != null && type instanceof String) {
            return (String)type;
        }
        return null;
    }

    private static class AdapterFactoryRegistration {
        private final String clazz;
        private final AdapterFactory factory;
        private final boolean autowire;

        public AdapterFactoryRegistration(String clazz, AdapterFactory factory, boolean autowire) {
            this.clazz = Objects.requireNonNull(clazz);
            this.factory = Objects.requireNonNull(factory);
            this.autowire = autowire;
        }

        public String getAdapterClass() {
            return this.clazz;
        }

        public AdapterFactory getAdapterFactory() {
            return this.factory;
        }

        public boolean shouldAutowire() {
            return this.autowire;
        }
    }
}

