/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.adapters.netflow.v5;

import java.util.Objects;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.telemetry.adapters.netflow.v5.proto.NetflowPacket;
import org.opennms.netmgt.telemetry.adapters.netflow.v5.proto.NetflowRecord;

class Netflow5Flow
implements Flow {
    private final NetflowPacket packet;
    private final NetflowRecord record;

    public Netflow5Flow(NetflowPacket packet, NetflowRecord record) {
        this.packet = Objects.requireNonNull(packet);
        this.record = Objects.requireNonNull(record);
    }

    public long getTimestamp() {
        return this.packet.getUnixSecs() * 1000L + this.packet.getUnixNSecs() / 1000L / 1000L;
    }

    public Long getBytes() {
        return this.record.getDOctets();
    }

    public Flow.Direction getDirection() {
        return this.record.isEgress() ? Flow.Direction.EGRESS : Flow.Direction.INGRESS;
    }

    public String getDstAddr() {
        return this.record.getDstAddr();
    }

    public Integer getDstAs() {
        return this.record.getDstAs();
    }

    public Integer getDstMaskLen() {
        return this.record.getDstMask();
    }

    public Integer getDstPort() {
        return this.record.getDstPort();
    }

    public Integer getEngineId() {
        return this.packet.getEngineId();
    }

    public Integer getEngineType() {
        return this.packet.getEngineType();
    }

    public Long getFirstSwitched() {
        return Netflow5Flow.getSwitched(this.getTimestamp(), this.packet.getSysUptime(), this.record.getFirst());
    }

    public int getFlowRecords() {
        return this.packet.getCount();
    }

    public long getFlowSeqNum() {
        return this.packet.getFlowSequence();
    }

    public Integer getInputSnmp() {
        return this.record.getInput();
    }

    public Integer getIpProtocolVersion() {
        return 4;
    }

    public Long getLastSwitched() {
        return Netflow5Flow.getSwitched(this.getTimestamp(), this.packet.getSysUptime(), this.record.getLast());
    }

    public String getNextHop() {
        return this.record.getNextHop();
    }

    public Integer getOutputSnmp() {
        return this.record.getOutput();
    }

    public Long getPackets() {
        return this.record.getDPkts();
    }

    public Integer getProtocol() {
        return this.record.getProt();
    }

    public Flow.SamplingAlgorithm getSamplingAlgorithm() {
        if (this.packet.getSamplingAlgorithm() == 1) {
            return Flow.SamplingAlgorithm.SystematicCountBasedSampling;
        }
        if (this.packet.getSamplingAlgorithm() == 2) {
            return Flow.SamplingAlgorithm.RandomNoutOfNSampling;
        }
        return Flow.SamplingAlgorithm.Unassigned;
    }

    public Double getSamplingInterval() {
        return this.packet.getSamplingInterval();
    }

    public String getSrcAddr() {
        return this.record.getSrcAddr();
    }

    public Integer getSrcAs() {
        return this.record.getSrcAs();
    }

    public Integer getSrcMaskLen() {
        return this.record.getSrcMask();
    }

    public Integer getSrcPort() {
        return this.record.getSrcPort();
    }

    public Integer getTcpFlags() {
        return this.record.getTcpFlags();
    }

    public Integer getTos() {
        return this.record.getToS();
    }

    public Flow.NetflowVersion getNetflowVersion() {
        return Flow.NetflowVersion.V5;
    }

    public Integer getVlan() {
        return null;
    }

    private static long getSwitched(long timestampMs, long sysUptimeMs, long switchedUptimeMs) {
        long deltaMs = sysUptimeMs - switchedUptimeMs;
        return timestampMs - deltaMs;
    }
}

