/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.adapters.netflow.v5;

import com.codahale.metrics.MetricRegistry;
import org.opennms.netmgt.flows.api.FlowRepository;
import org.opennms.netmgt.telemetry.adapters.api.TelemetryMessage;
import org.opennms.netmgt.telemetry.adapters.netflow.AbstractAdapter;
import org.opennms.netmgt.telemetry.adapters.netflow.v5.Netflow5Converter;
import org.opennms.netmgt.telemetry.adapters.netflow.v5.proto.NetflowPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Netflow5Adapter
extends AbstractAdapter<NetflowPacket> {
    private static final Logger LOG = LoggerFactory.getLogger(Netflow5Adapter.class);

    public Netflow5Adapter(MetricRegistry metricRegistry, FlowRepository flowRepository) {
        super(metricRegistry, flowRepository, new Netflow5Converter());
    }

    @Override
    protected NetflowPacket parse(TelemetryMessage message) {
        NetflowPacket flowPacket = new NetflowPacket(message.getByteArray());
        if (flowPacket.getVersion() != 5) {
            LOG.warn("Invalid Version. Expected {}, received {}. Dropping flow packet.", (Object)5, (Object)flowPacket.getVersion());
            return null;
        }
        if (flowPacket.getCount() == 0) {
            LOG.warn("Received packet has no content. Dropping flow packet.");
            return null;
        }
        if (!flowPacket.isValid()) {
            LOG.warn("Received packet is not valid. Dropping flow packet.");
            return null;
        }
        return flowPacket;
    }
}

