/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.adapters.netflow.ipfix;

import com.google.common.primitives.UnsignedLong;
import java.time.Instant;
import java.util.Objects;
import org.bson.BsonDocument;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.telemetry.adapters.netflow.BsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IpfixFlow
implements Flow {
    private static final Logger LOG = LoggerFactory.getLogger(IpfixFlow.class);
    private final BsonDocument document;

    public IpfixFlow(BsonDocument document) {
        this.document = Objects.requireNonNull(document);
    }

    public long getTimestamp() {
        return BsonUtils.getInt64(this.document, "@exportTime").get() * 1000L;
    }

    public Long getBytes() {
        return BsonUtils.first(BsonUtils.getInt64(this.document, "octetDeltaCount"), BsonUtils.getInt64(this.document, "postOctetDeltaCount"), BsonUtils.getInt64(this.document, "layer2OctetDeltaCount"), BsonUtils.getInt64(this.document, "postLayer2OctetDeltaCount"), BsonUtils.getInt64(this.document, "transportOctetDeltaCount")).orElse(null);
    }

    public Flow.Direction getDirection() {
        return BsonUtils.getInt64(this.document, "flowDirection").map(v -> v == 0L ? Flow.Direction.INGRESS : (v == 1L ? Flow.Direction.EGRESS : null)).orElse(null);
    }

    public String getDstAddr() {
        return BsonUtils.first(BsonUtils.getString(this.document, "destinationIPv6Address"), BsonUtils.getString(this.document, "destinationIPv4Address")).orElse(null);
    }

    public Integer getDstAs() {
        return BsonUtils.getInt64(this.document, "bgpDestinationAsNumber").map(Long::intValue).orElse(null);
    }

    public Integer getDstMaskLen() {
        return BsonUtils.first(BsonUtils.getInt64(this.document, "destinationIPv6PrefixLength"), BsonUtils.getInt64(this.document, "destinationIPv4PrefixLength")).map(Long::intValue).orElse(null);
    }

    public Integer getDstPort() {
        return BsonUtils.getInt64(this.document, "destinationTransportPort").map(Long::intValue).orElse(null);
    }

    public Integer getEngineId() {
        return BsonUtils.getInt64(this.document, "engineId").map(Long::intValue).orElse(null);
    }

    public Integer getEngineType() {
        return BsonUtils.getInt64(this.document, "engineType").map(Long::intValue).orElse(null);
    }

    public Long getFirstSwitched() {
        return BsonUtils.first(BsonUtils.first(BsonUtils.getTime(this.document, "flowStartSeconds"), BsonUtils.getTime(this.document, "flowStartMilliseconds"), BsonUtils.getTime(this.document, "flowStartMicroseconds"), BsonUtils.getTime(this.document, "flowStartNanoseconds")).map(Instant::toEpochMilli), BsonUtils.getInt64(this.document, "flowStartDeltaMicroseconds").map(t -> this.getTimestamp() + t), BsonUtils.getInt64(this.document, "flowStartSysUpTime").flatMap(t -> BsonUtils.getTime(this.document, "systemInitTimeMilliseconds").map(ts -> ts.toEpochMilli() + t))).orElse(null);
    }

    public int getFlowRecords() {
        return BsonUtils.getInt64(this.document, "@recordCount").map(Long::intValue).orElse(0);
    }

    public long getFlowSeqNum() {
        return BsonUtils.getInt64(this.document, "@sequenceNumber").orElse(0L);
    }

    public Integer getInputSnmp() {
        return BsonUtils.getInt64(this.document, "ingressInterface").map(Long::intValue).orElse(null);
    }

    public Integer getIpProtocolVersion() {
        return BsonUtils.getInt64(this.document, "ipVersion").map(Long::intValue).orElse(null);
    }

    public Long getLastSwitched() {
        return BsonUtils.first(BsonUtils.first(BsonUtils.getTime(this.document, "flowEndSeconds"), BsonUtils.getTime(this.document, "flowEndMilliseconds"), BsonUtils.getTime(this.document, "flowEndMicroseconds"), BsonUtils.getTime(this.document, "flowEndNanoseconds")).map(Instant::toEpochMilli), BsonUtils.getInt64(this.document, "flowEndDeltaMicroseconds").map(t -> this.getTimestamp() + t), BsonUtils.getInt64(this.document, "flowEndSysUpTime").flatMap(t -> BsonUtils.getTime(this.document, "systemInitTimeMilliseconds").map(ts -> ts.toEpochMilli() + t))).orElse(null);
    }

    public String getNextHop() {
        return BsonUtils.first(BsonUtils.getString(this.document, "ipNextHopIPv6Address"), BsonUtils.getString(this.document, "ipNextHopIPv4Address"), BsonUtils.getString(this.document, "bgpNextHopIPv6Address"), BsonUtils.getString(this.document, "bgpNextHopIPv4Address")).orElse(null);
    }

    public Integer getOutputSnmp() {
        return BsonUtils.getInt64(this.document, "egressInterface").map(Long::intValue).orElse(null);
    }

    public Long getPackets() {
        return BsonUtils.first(BsonUtils.getInt64(this.document, "packetDeltaCount"), BsonUtils.getInt64(this.document, "postPacketDeltaCount"), BsonUtils.getInt64(this.document, "transportPacketDeltaCount")).orElse(null);
    }

    public Integer getProtocol() {
        return BsonUtils.getInt64(this.document, "protocolIdentifier").map(Long::intValue).orElse(null);
    }

    public Flow.SamplingAlgorithm getSamplingAlgorithm() {
        Integer selectorAlgorithm;
        Integer deprecatedSamplingAlgorithm = BsonUtils.first(BsonUtils.getInt64(this.document, "samplingAlgorithm"), BsonUtils.getInt64(this.document, "samplerMode")).map(Long::intValue).orElse(null);
        if (deprecatedSamplingAlgorithm != null) {
            if (deprecatedSamplingAlgorithm == 1) {
                return Flow.SamplingAlgorithm.SystematicCountBasedSampling;
            }
            if (deprecatedSamplingAlgorithm == 2) {
                return Flow.SamplingAlgorithm.RandomNoutOfNSampling;
            }
        }
        if ((selectorAlgorithm = (Integer)BsonUtils.getInt64(this.document, "selectorAlgorithm").map(Long::intValue).orElse(null)) != null) {
            switch (selectorAlgorithm) {
                case 0: {
                    return Flow.SamplingAlgorithm.Unassigned;
                }
                case 1: {
                    return Flow.SamplingAlgorithm.SystematicCountBasedSampling;
                }
                case 2: {
                    return Flow.SamplingAlgorithm.SystematicTimeBasedSampling;
                }
                case 3: {
                    return Flow.SamplingAlgorithm.RandomNoutOfNSampling;
                }
                case 4: {
                    return Flow.SamplingAlgorithm.UniformProbabilisticSampling;
                }
                case 5: {
                    return Flow.SamplingAlgorithm.PropertyMatchFiltering;
                }
                case 6: 
                case 7: 
                case 8: {
                    return Flow.SamplingAlgorithm.HashBasedFiltering;
                }
                case 9: {
                    return Flow.SamplingAlgorithm.FlowStateDependentIntermediateFlowSelectionProcess;
                }
            }
            LOG.warn("Unknown selector algorithm: {}", (Object)selectorAlgorithm);
        }
        return Flow.SamplingAlgorithm.Unassigned;
    }

    public Double getSamplingInterval() {
        Double deprecatedSamplingInterval = BsonUtils.first(BsonUtils.getInt64(this.document, "samplingInterval"), BsonUtils.getInt64(this.document, "samplerRandomInterval")).map(Long::doubleValue).orElse(null);
        if (deprecatedSamplingInterval != null) {
            return deprecatedSamplingInterval;
        }
        Integer selectorAlgorithm = BsonUtils.getInt64(this.document, "selectorAlgorithm").map(Long::intValue).orElse(null);
        if (selectorAlgorithm != null) {
            switch (selectorAlgorithm) {
                case 0: {
                    return null;
                }
                case 1: {
                    Double samplingInterval = BsonUtils.getInt64(this.document, "samplingFlowInterval").map(Long::doubleValue).orElse(1.0);
                    Double samplingSpacing = BsonUtils.getInt64(this.document, "samplingFlowSpacing").map(Long::doubleValue).orElse(0.0);
                    return (samplingInterval + samplingSpacing) / samplingInterval;
                }
                case 2: {
                    Double flowSamplingTimeInterval = BsonUtils.getInt64(this.document, "flowSamplingTimeInterval").map(Long::doubleValue).orElse(1.0);
                    Double flowSamplingTimeSpacing = BsonUtils.getInt64(this.document, "flowSamplingTimeSpacing").map(Long::doubleValue).orElse(0.0);
                    return (flowSamplingTimeInterval + flowSamplingTimeSpacing) / flowSamplingTimeInterval;
                }
                case 3: {
                    Double samplingSize = BsonUtils.getInt64(this.document, "samplingSize").map(Long::doubleValue).orElse(1.0);
                    Double samplingPopulation = BsonUtils.getInt64(this.document, "samplingPopulation").map(Long::doubleValue).orElse(1.0);
                    return samplingPopulation / samplingSize;
                }
                case 4: {
                    Double samplingProbability = BsonUtils.getDouble(this.document, "samplingProbability").orElse(1.0);
                    return 1.0 / samplingProbability;
                }
                case 5: 
                case 6: 
                case 7: {
                    UnsignedLong hashSelectedRangeMin = BsonUtils.getInt64(this.document, "hashSelectedRangeMin").map(UnsignedLong::fromLongBits).orElse(UnsignedLong.ZERO);
                    UnsignedLong hashSelectedRangeMax = BsonUtils.getInt64(this.document, "hashSelectedRangeMax").map(UnsignedLong::fromLongBits).orElse(UnsignedLong.MAX_VALUE);
                    UnsignedLong hashOutputRangeMin = BsonUtils.getInt64(this.document, "hashOutputRangeMin").map(UnsignedLong::fromLongBits).orElse(UnsignedLong.ZERO);
                    UnsignedLong hashOutputRangeMax = BsonUtils.getInt64(this.document, "hashOutputRangeMax").map(UnsignedLong::fromLongBits).orElse(UnsignedLong.MAX_VALUE);
                    return hashOutputRangeMax.minus(hashOutputRangeMin).dividedBy(hashSelectedRangeMax.minus(hashSelectedRangeMin)).doubleValue();
                }
            }
            LOG.warn("Unsupported sampling algorithm: {}", (Object)selectorAlgorithm);
            return Double.NaN;
        }
        return 1.0;
    }

    public String getSrcAddr() {
        return BsonUtils.first(BsonUtils.getString(this.document, "sourceIPv6Address"), BsonUtils.getString(this.document, "sourceIPv4Address")).orElse(null);
    }

    public Integer getSrcAs() {
        return BsonUtils.getInt64(this.document, "bgpSourceAsNumber").map(Long::intValue).orElse(null);
    }

    public Integer getSrcMaskLen() {
        return BsonUtils.first(BsonUtils.getInt64(this.document, "sourceIPv6PrefixLength"), BsonUtils.getInt64(this.document, "sourceIPv4PrefixLength")).map(Long::intValue).orElse(null);
    }

    public Integer getSrcPort() {
        return BsonUtils.getInt64(this.document, "sourceTransportPort").map(Long::intValue).orElse(null);
    }

    public Integer getTcpFlags() {
        return BsonUtils.getInt64(this.document, "tcpControlBits").map(Long::intValue).orElse(null);
    }

    public Integer getTos() {
        return BsonUtils.getInt64(this.document, "ipClassOfService").map(Long::intValue).orElse(null);
    }

    public Flow.NetflowVersion getNetflowVersion() {
        return Flow.NetflowVersion.IPFIX;
    }

    public Integer getVlan() {
        return BsonUtils.first(BsonUtils.getInt64(this.document, "vlanId"), BsonUtils.getInt64(this.document, "postVlanId"), BsonUtils.getInt64(this.document, "dot1qVlanId"), BsonUtils.getInt64(this.document, "dot1qCustomerVlanId"), BsonUtils.getInt64(this.document, "postDot1qVlanId"), BsonUtils.getInt64(this.document, "postDot1qCustomerVlanId")).map(Long::intValue).orElse(null);
    }
}

