/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2017-2017 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2017 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/
package org.opennms.netmgt.telemetry.adapters.jti.proto;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: port.proto

public final class Port {
  private Port() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registry.add(Port.jnprInterfaceExt);
  }
  public interface GPortOrBuilder extends
      // @@protoc_insertion_point(interface_extends:GPort)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .InterfaceInfos interface_stats = 1;</code>
     */
    java.util.List<Port.InterfaceInfos> 
        getInterfaceStatsList();
    /**
     * <code>repeated .InterfaceInfos interface_stats = 1;</code>
     */
    Port.InterfaceInfos getInterfaceStats(int index);
    /**
     * <code>repeated .InterfaceInfos interface_stats = 1;</code>
     */
    int getInterfaceStatsCount();
    /**
     * <code>repeated .InterfaceInfos interface_stats = 1;</code>
     */
    java.util.List<? extends Port.InterfaceInfosOrBuilder> 
        getInterfaceStatsOrBuilderList();
    /**
     * <code>repeated .InterfaceInfos interface_stats = 1;</code>
     */
    Port.InterfaceInfosOrBuilder getInterfaceStatsOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code GPort}
   */
  public static final class GPort extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:GPort)
      GPortOrBuilder {
    // Use GPort.newBuilder() to construct.
    private GPort(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private GPort(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final GPort defaultInstance;
    public static GPort getDefaultInstance() {
      return defaultInstance;
    }

    public GPort getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private GPort(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                interfaceStats_ = new java.util.ArrayList<Port.InterfaceInfos>();
                mutable_bitField0_ |= 0x00000001;
              }
              interfaceStats_.add(input.readMessage(Port.InterfaceInfos.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          interfaceStats_ = java.util.Collections.unmodifiableList(interfaceStats_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return Port.internal_static_GPort_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return Port.internal_static_GPort_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              Port.GPort.class, Port.GPort.Builder.class);
    }

    public static com.google.protobuf.Parser<GPort> PARSER =
        new com.google.protobuf.AbstractParser<GPort>() {
      public GPort parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new GPort(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<GPort> getParserForType() {
      return PARSER;
    }

    public static final int INTERFACE_STATS_FIELD_NUMBER = 1;
    private java.util.List<Port.InterfaceInfos> interfaceStats_;
    /**
     * <code>repeated .InterfaceInfos interface_stats = 1;</code>
     */
    public java.util.List<Port.InterfaceInfos> getInterfaceStatsList() {
      return interfaceStats_;
    }
    /**
     * <code>repeated .InterfaceInfos interface_stats = 1;</code>
     */
    public java.util.List<? extends Port.InterfaceInfosOrBuilder> 
        getInterfaceStatsOrBuilderList() {
      return interfaceStats_;
    }
    /**
     * <code>repeated .InterfaceInfos interface_stats = 1;</code>
     */
    public int getInterfaceStatsCount() {
      return interfaceStats_.size();
    }
    /**
     * <code>repeated .InterfaceInfos interface_stats = 1;</code>
     */
    public Port.InterfaceInfos getInterfaceStats(int index) {
      return interfaceStats_.get(index);
    }
    /**
     * <code>repeated .InterfaceInfos interface_stats = 1;</code>
     */
    public Port.InterfaceInfosOrBuilder getInterfaceStatsOrBuilder(
        int index) {
      return interfaceStats_.get(index);
    }

    private void initFields() {
      interfaceStats_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getInterfaceStatsCount(); i++) {
        if (!getInterfaceStats(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < interfaceStats_.size(); i++) {
        output.writeMessage(1, interfaceStats_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < interfaceStats_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, interfaceStats_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static Port.GPort parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Port.GPort parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Port.GPort parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Port.GPort parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Port.GPort parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Port.GPort parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static Port.GPort parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static Port.GPort parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static Port.GPort parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Port.GPort parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(Port.GPort prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code GPort}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:GPort)
        Port.GPortOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return Port.internal_static_GPort_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return Port.internal_static_GPort_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                Port.GPort.class, Port.GPort.Builder.class);
      }

      // Construct using Port.GPort.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getInterfaceStatsFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (interfaceStatsBuilder_ == null) {
          interfaceStats_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          interfaceStatsBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return Port.internal_static_GPort_descriptor;
      }

      public Port.GPort getDefaultInstanceForType() {
        return Port.GPort.getDefaultInstance();
      }

      public Port.GPort build() {
        Port.GPort result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public Port.GPort buildPartial() {
        Port.GPort result = new Port.GPort(this);
        int from_bitField0_ = bitField0_;
        if (interfaceStatsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            interfaceStats_ = java.util.Collections.unmodifiableList(interfaceStats_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.interfaceStats_ = interfaceStats_;
        } else {
          result.interfaceStats_ = interfaceStatsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof Port.GPort) {
          return mergeFrom((Port.GPort)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(Port.GPort other) {
        if (other == Port.GPort.getDefaultInstance()) return this;
        if (interfaceStatsBuilder_ == null) {
          if (!other.interfaceStats_.isEmpty()) {
            if (interfaceStats_.isEmpty()) {
              interfaceStats_ = other.interfaceStats_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureInterfaceStatsIsMutable();
              interfaceStats_.addAll(other.interfaceStats_);
            }
            onChanged();
          }
        } else {
          if (!other.interfaceStats_.isEmpty()) {
            if (interfaceStatsBuilder_.isEmpty()) {
              interfaceStatsBuilder_.dispose();
              interfaceStatsBuilder_ = null;
              interfaceStats_ = other.interfaceStats_;
              bitField0_ = (bitField0_ & ~0x00000001);
              interfaceStatsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getInterfaceStatsFieldBuilder() : null;
            } else {
              interfaceStatsBuilder_.addAllMessages(other.interfaceStats_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getInterfaceStatsCount(); i++) {
          if (!getInterfaceStats(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        Port.GPort parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (Port.GPort) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<Port.InterfaceInfos> interfaceStats_ =
        java.util.Collections.emptyList();
      private void ensureInterfaceStatsIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          interfaceStats_ = new java.util.ArrayList<Port.InterfaceInfos>(interfaceStats_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          Port.InterfaceInfos, Port.InterfaceInfos.Builder, Port.InterfaceInfosOrBuilder> interfaceStatsBuilder_;

      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public java.util.List<Port.InterfaceInfos> getInterfaceStatsList() {
        if (interfaceStatsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(interfaceStats_);
        } else {
          return interfaceStatsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public int getInterfaceStatsCount() {
        if (interfaceStatsBuilder_ == null) {
          return interfaceStats_.size();
        } else {
          return interfaceStatsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public Port.InterfaceInfos getInterfaceStats(int index) {
        if (interfaceStatsBuilder_ == null) {
          return interfaceStats_.get(index);
        } else {
          return interfaceStatsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public Builder setInterfaceStats(
          int index, Port.InterfaceInfos value) {
        if (interfaceStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInterfaceStatsIsMutable();
          interfaceStats_.set(index, value);
          onChanged();
        } else {
          interfaceStatsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public Builder setInterfaceStats(
          int index, Port.InterfaceInfos.Builder builderForValue) {
        if (interfaceStatsBuilder_ == null) {
          ensureInterfaceStatsIsMutable();
          interfaceStats_.set(index, builderForValue.build());
          onChanged();
        } else {
          interfaceStatsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public Builder addInterfaceStats(Port.InterfaceInfos value) {
        if (interfaceStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInterfaceStatsIsMutable();
          interfaceStats_.add(value);
          onChanged();
        } else {
          interfaceStatsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public Builder addInterfaceStats(
          int index, Port.InterfaceInfos value) {
        if (interfaceStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInterfaceStatsIsMutable();
          interfaceStats_.add(index, value);
          onChanged();
        } else {
          interfaceStatsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public Builder addInterfaceStats(
          Port.InterfaceInfos.Builder builderForValue) {
        if (interfaceStatsBuilder_ == null) {
          ensureInterfaceStatsIsMutable();
          interfaceStats_.add(builderForValue.build());
          onChanged();
        } else {
          interfaceStatsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public Builder addInterfaceStats(
          int index, Port.InterfaceInfos.Builder builderForValue) {
        if (interfaceStatsBuilder_ == null) {
          ensureInterfaceStatsIsMutable();
          interfaceStats_.add(index, builderForValue.build());
          onChanged();
        } else {
          interfaceStatsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public Builder addAllInterfaceStats(
          java.lang.Iterable<? extends Port.InterfaceInfos> values) {
        if (interfaceStatsBuilder_ == null) {
          ensureInterfaceStatsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, interfaceStats_);
          onChanged();
        } else {
          interfaceStatsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public Builder clearInterfaceStats() {
        if (interfaceStatsBuilder_ == null) {
          interfaceStats_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          interfaceStatsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public Builder removeInterfaceStats(int index) {
        if (interfaceStatsBuilder_ == null) {
          ensureInterfaceStatsIsMutable();
          interfaceStats_.remove(index);
          onChanged();
        } else {
          interfaceStatsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public Port.InterfaceInfos.Builder getInterfaceStatsBuilder(
          int index) {
        return getInterfaceStatsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public Port.InterfaceInfosOrBuilder getInterfaceStatsOrBuilder(
          int index) {
        if (interfaceStatsBuilder_ == null) {
          return interfaceStats_.get(index);  } else {
          return interfaceStatsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public java.util.List<? extends Port.InterfaceInfosOrBuilder> 
           getInterfaceStatsOrBuilderList() {
        if (interfaceStatsBuilder_ != null) {
          return interfaceStatsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(interfaceStats_);
        }
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public Port.InterfaceInfos.Builder addInterfaceStatsBuilder() {
        return getInterfaceStatsFieldBuilder().addBuilder(
            Port.InterfaceInfos.getDefaultInstance());
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public Port.InterfaceInfos.Builder addInterfaceStatsBuilder(
          int index) {
        return getInterfaceStatsFieldBuilder().addBuilder(
            index, Port.InterfaceInfos.getDefaultInstance());
      }
      /**
       * <code>repeated .InterfaceInfos interface_stats = 1;</code>
       */
      public java.util.List<Port.InterfaceInfos.Builder> 
           getInterfaceStatsBuilderList() {
        return getInterfaceStatsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          Port.InterfaceInfos, Port.InterfaceInfos.Builder, Port.InterfaceInfosOrBuilder> 
          getInterfaceStatsFieldBuilder() {
        if (interfaceStatsBuilder_ == null) {
          interfaceStatsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              Port.InterfaceInfos, Port.InterfaceInfos.Builder, Port.InterfaceInfosOrBuilder>(
                  interfaceStats_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          interfaceStats_ = null;
        }
        return interfaceStatsBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:GPort)
    }

    static {
      defaultInstance = new GPort(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:GPort)
  }

  public interface InterfaceInfosOrBuilder extends
      // @@protoc_insertion_point(interface_extends:InterfaceInfos)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string if_name = 1;</code>
     *
     * <pre>
     * e.g., xe-0/0/0
     * </pre>
     */
    boolean hasIfName();
    /**
     * <code>required string if_name = 1;</code>
     *
     * <pre>
     * e.g., xe-0/0/0
     * </pre>
     */
    java.lang.String getIfName();
    /**
     * <code>required string if_name = 1;</code>
     *
     * <pre>
     * e.g., xe-0/0/0
     * </pre>
     */
    com.google.protobuf.ByteString
        getIfNameBytes();

    /**
     * <code>required uint64 init_time = 2;</code>
     *
     * <pre>
     * time when if/stats last reset
     * </pre>
     */
    boolean hasInitTime();
    /**
     * <code>required uint64 init_time = 2;</code>
     *
     * <pre>
     * time when if/stats last reset
     * </pre>
     */
    long getInitTime();

    /**
     * <code>optional uint32 snmp_if_index = 3;</code>
     *
     * <pre>
     * Global Index
     * </pre>
     */
    boolean hasSnmpIfIndex();
    /**
     * <code>optional uint32 snmp_if_index = 3;</code>
     *
     * <pre>
     * Global Index
     * </pre>
     */
    int getSnmpIfIndex();

    /**
     * <code>optional string parent_ae_name = 4;</code>
     *
     * <pre>
     * name of parent for ae interface, if applicable
     * </pre>
     */
    boolean hasParentAeName();
    /**
     * <code>optional string parent_ae_name = 4;</code>
     *
     * <pre>
     * name of parent for ae interface, if applicable
     * </pre>
     */
    java.lang.String getParentAeName();
    /**
     * <code>optional string parent_ae_name = 4;</code>
     *
     * <pre>
     * name of parent for ae interface, if applicable
     * </pre>
     */
    com.google.protobuf.ByteString
        getParentAeNameBytes();

    /**
     * <code>repeated .QueueStats egress_queue_info = 5;</code>
     *
     * <pre>
     * egress queue information
     * </pre>
     */
    java.util.List<Port.QueueStats> 
        getEgressQueueInfoList();
    /**
     * <code>repeated .QueueStats egress_queue_info = 5;</code>
     *
     * <pre>
     * egress queue information
     * </pre>
     */
    Port.QueueStats getEgressQueueInfo(int index);
    /**
     * <code>repeated .QueueStats egress_queue_info = 5;</code>
     *
     * <pre>
     * egress queue information
     * </pre>
     */
    int getEgressQueueInfoCount();
    /**
     * <code>repeated .QueueStats egress_queue_info = 5;</code>
     *
     * <pre>
     * egress queue information
     * </pre>
     */
    java.util.List<? extends Port.QueueStatsOrBuilder> 
        getEgressQueueInfoOrBuilderList();
    /**
     * <code>repeated .QueueStats egress_queue_info = 5;</code>
     *
     * <pre>
     * egress queue information
     * </pre>
     */
    Port.QueueStatsOrBuilder getEgressQueueInfoOrBuilder(
        int index);

    /**
     * <code>repeated .QueueStats ingress_queue_info = 6;</code>
     *
     * <pre>
     * ingress queue information
     * </pre>
     */
    java.util.List<Port.QueueStats> 
        getIngressQueueInfoList();
    /**
     * <code>repeated .QueueStats ingress_queue_info = 6;</code>
     *
     * <pre>
     * ingress queue information
     * </pre>
     */
    Port.QueueStats getIngressQueueInfo(int index);
    /**
     * <code>repeated .QueueStats ingress_queue_info = 6;</code>
     *
     * <pre>
     * ingress queue information
     * </pre>
     */
    int getIngressQueueInfoCount();
    /**
     * <code>repeated .QueueStats ingress_queue_info = 6;</code>
     *
     * <pre>
     * ingress queue information
     * </pre>
     */
    java.util.List<? extends Port.QueueStatsOrBuilder> 
        getIngressQueueInfoOrBuilderList();
    /**
     * <code>repeated .QueueStats ingress_queue_info = 6;</code>
     *
     * <pre>
     * ingress queue information
     * </pre>
     */
    Port.QueueStatsOrBuilder getIngressQueueInfoOrBuilder(
        int index);

    /**
     * <code>optional .InterfaceStats ingress_stats = 7;</code>
     *
     * <pre>
     * inbound traffic stats
     * </pre>
     */
    boolean hasIngressStats();
    /**
     * <code>optional .InterfaceStats ingress_stats = 7;</code>
     *
     * <pre>
     * inbound traffic stats
     * </pre>
     */
    Port.InterfaceStats getIngressStats();
    /**
     * <code>optional .InterfaceStats ingress_stats = 7;</code>
     *
     * <pre>
     * inbound traffic stats
     * </pre>
     */
    Port.InterfaceStatsOrBuilder getIngressStatsOrBuilder();

    /**
     * <code>optional .InterfaceStats egress_stats = 8;</code>
     *
     * <pre>
     * outbound traffic stats
     * </pre>
     */
    boolean hasEgressStats();
    /**
     * <code>optional .InterfaceStats egress_stats = 8;</code>
     *
     * <pre>
     * outbound traffic stats
     * </pre>
     */
    Port.InterfaceStats getEgressStats();
    /**
     * <code>optional .InterfaceStats egress_stats = 8;</code>
     *
     * <pre>
     * outbound traffic stats
     * </pre>
     */
    Port.InterfaceStatsOrBuilder getEgressStatsOrBuilder();

    /**
     * <code>optional .IngressInterfaceErrors ingress_errors = 9;</code>
     *
     * <pre>
     * inbound traffic errors
     * </pre>
     */
    boolean hasIngressErrors();
    /**
     * <code>optional .IngressInterfaceErrors ingress_errors = 9;</code>
     *
     * <pre>
     * inbound traffic errors
     * </pre>
     */
    Port.IngressInterfaceErrors getIngressErrors();
    /**
     * <code>optional .IngressInterfaceErrors ingress_errors = 9;</code>
     *
     * <pre>
     * inbound traffic errors
     * </pre>
     */
    Port.IngressInterfaceErrorsOrBuilder getIngressErrorsOrBuilder();
  }
  /**
   * Protobuf type {@code InterfaceInfos}
   */
  public static final class InterfaceInfos extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:InterfaceInfos)
      InterfaceInfosOrBuilder {
    // Use InterfaceInfos.newBuilder() to construct.
    private InterfaceInfos(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private InterfaceInfos(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final InterfaceInfos defaultInstance;
    public static InterfaceInfos getDefaultInstance() {
      return defaultInstance;
    }

    public InterfaceInfos getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private InterfaceInfos(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              ifName_ = bs;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              initTime_ = input.readUInt64();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              snmpIfIndex_ = input.readUInt32();
              break;
            }
            case 34: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000008;
              parentAeName_ = bs;
              break;
            }
            case 42: {
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                egressQueueInfo_ = new java.util.ArrayList<Port.QueueStats>();
                mutable_bitField0_ |= 0x00000010;
              }
              egressQueueInfo_.add(input.readMessage(Port.QueueStats.PARSER, extensionRegistry));
              break;
            }
            case 50: {
              if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
                ingressQueueInfo_ = new java.util.ArrayList<Port.QueueStats>();
                mutable_bitField0_ |= 0x00000020;
              }
              ingressQueueInfo_.add(input.readMessage(Port.QueueStats.PARSER, extensionRegistry));
              break;
            }
            case 58: {
              Port.InterfaceStats.Builder subBuilder = null;
              if (((bitField0_ & 0x00000010) == 0x00000010)) {
                subBuilder = ingressStats_.toBuilder();
              }
              ingressStats_ = input.readMessage(Port.InterfaceStats.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(ingressStats_);
                ingressStats_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000010;
              break;
            }
            case 66: {
              Port.InterfaceStats.Builder subBuilder = null;
              if (((bitField0_ & 0x00000020) == 0x00000020)) {
                subBuilder = egressStats_.toBuilder();
              }
              egressStats_ = input.readMessage(Port.InterfaceStats.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(egressStats_);
                egressStats_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000020;
              break;
            }
            case 74: {
              Port.IngressInterfaceErrors.Builder subBuilder = null;
              if (((bitField0_ & 0x00000040) == 0x00000040)) {
                subBuilder = ingressErrors_.toBuilder();
              }
              ingressErrors_ = input.readMessage(Port.IngressInterfaceErrors.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(ingressErrors_);
                ingressErrors_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000040;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
          egressQueueInfo_ = java.util.Collections.unmodifiableList(egressQueueInfo_);
        }
        if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
          ingressQueueInfo_ = java.util.Collections.unmodifiableList(ingressQueueInfo_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return Port.internal_static_InterfaceInfos_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return Port.internal_static_InterfaceInfos_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              Port.InterfaceInfos.class, Port.InterfaceInfos.Builder.class);
    }

    public static com.google.protobuf.Parser<InterfaceInfos> PARSER =
        new com.google.protobuf.AbstractParser<InterfaceInfos>() {
      public InterfaceInfos parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new InterfaceInfos(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<InterfaceInfos> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int IF_NAME_FIELD_NUMBER = 1;
    private java.lang.Object ifName_;
    /**
     * <code>required string if_name = 1;</code>
     *
     * <pre>
     * e.g., xe-0/0/0
     * </pre>
     */
    public boolean hasIfName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string if_name = 1;</code>
     *
     * <pre>
     * e.g., xe-0/0/0
     * </pre>
     */
    public java.lang.String getIfName() {
      java.lang.Object ref = ifName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          ifName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string if_name = 1;</code>
     *
     * <pre>
     * e.g., xe-0/0/0
     * </pre>
     */
    public com.google.protobuf.ByteString
        getIfNameBytes() {
      java.lang.Object ref = ifName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        ifName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INIT_TIME_FIELD_NUMBER = 2;
    private long initTime_;
    /**
     * <code>required uint64 init_time = 2;</code>
     *
     * <pre>
     * time when if/stats last reset
     * </pre>
     */
    public boolean hasInitTime() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required uint64 init_time = 2;</code>
     *
     * <pre>
     * time when if/stats last reset
     * </pre>
     */
    public long getInitTime() {
      return initTime_;
    }

    public static final int SNMP_IF_INDEX_FIELD_NUMBER = 3;
    private int snmpIfIndex_;
    /**
     * <code>optional uint32 snmp_if_index = 3;</code>
     *
     * <pre>
     * Global Index
     * </pre>
     */
    public boolean hasSnmpIfIndex() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint32 snmp_if_index = 3;</code>
     *
     * <pre>
     * Global Index
     * </pre>
     */
    public int getSnmpIfIndex() {
      return snmpIfIndex_;
    }

    public static final int PARENT_AE_NAME_FIELD_NUMBER = 4;
    private java.lang.Object parentAeName_;
    /**
     * <code>optional string parent_ae_name = 4;</code>
     *
     * <pre>
     * name of parent for ae interface, if applicable
     * </pre>
     */
    public boolean hasParentAeName() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional string parent_ae_name = 4;</code>
     *
     * <pre>
     * name of parent for ae interface, if applicable
     * </pre>
     */
    public java.lang.String getParentAeName() {
      java.lang.Object ref = parentAeName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          parentAeName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string parent_ae_name = 4;</code>
     *
     * <pre>
     * name of parent for ae interface, if applicable
     * </pre>
     */
    public com.google.protobuf.ByteString
        getParentAeNameBytes() {
      java.lang.Object ref = parentAeName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        parentAeName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EGRESS_QUEUE_INFO_FIELD_NUMBER = 5;
    private java.util.List<Port.QueueStats> egressQueueInfo_;
    /**
     * <code>repeated .QueueStats egress_queue_info = 5;</code>
     *
     * <pre>
     * egress queue information
     * </pre>
     */
    public java.util.List<Port.QueueStats> getEgressQueueInfoList() {
      return egressQueueInfo_;
    }
    /**
     * <code>repeated .QueueStats egress_queue_info = 5;</code>
     *
     * <pre>
     * egress queue information
     * </pre>
     */
    public java.util.List<? extends Port.QueueStatsOrBuilder> 
        getEgressQueueInfoOrBuilderList() {
      return egressQueueInfo_;
    }
    /**
     * <code>repeated .QueueStats egress_queue_info = 5;</code>
     *
     * <pre>
     * egress queue information
     * </pre>
     */
    public int getEgressQueueInfoCount() {
      return egressQueueInfo_.size();
    }
    /**
     * <code>repeated .QueueStats egress_queue_info = 5;</code>
     *
     * <pre>
     * egress queue information
     * </pre>
     */
    public Port.QueueStats getEgressQueueInfo(int index) {
      return egressQueueInfo_.get(index);
    }
    /**
     * <code>repeated .QueueStats egress_queue_info = 5;</code>
     *
     * <pre>
     * egress queue information
     * </pre>
     */
    public Port.QueueStatsOrBuilder getEgressQueueInfoOrBuilder(
        int index) {
      return egressQueueInfo_.get(index);
    }

    public static final int INGRESS_QUEUE_INFO_FIELD_NUMBER = 6;
    private java.util.List<Port.QueueStats> ingressQueueInfo_;
    /**
     * <code>repeated .QueueStats ingress_queue_info = 6;</code>
     *
     * <pre>
     * ingress queue information
     * </pre>
     */
    public java.util.List<Port.QueueStats> getIngressQueueInfoList() {
      return ingressQueueInfo_;
    }
    /**
     * <code>repeated .QueueStats ingress_queue_info = 6;</code>
     *
     * <pre>
     * ingress queue information
     * </pre>
     */
    public java.util.List<? extends Port.QueueStatsOrBuilder> 
        getIngressQueueInfoOrBuilderList() {
      return ingressQueueInfo_;
    }
    /**
     * <code>repeated .QueueStats ingress_queue_info = 6;</code>
     *
     * <pre>
     * ingress queue information
     * </pre>
     */
    public int getIngressQueueInfoCount() {
      return ingressQueueInfo_.size();
    }
    /**
     * <code>repeated .QueueStats ingress_queue_info = 6;</code>
     *
     * <pre>
     * ingress queue information
     * </pre>
     */
    public Port.QueueStats getIngressQueueInfo(int index) {
      return ingressQueueInfo_.get(index);
    }
    /**
     * <code>repeated .QueueStats ingress_queue_info = 6;</code>
     *
     * <pre>
     * ingress queue information
     * </pre>
     */
    public Port.QueueStatsOrBuilder getIngressQueueInfoOrBuilder(
        int index) {
      return ingressQueueInfo_.get(index);
    }

    public static final int INGRESS_STATS_FIELD_NUMBER = 7;
    private Port.InterfaceStats ingressStats_;
    /**
     * <code>optional .InterfaceStats ingress_stats = 7;</code>
     *
     * <pre>
     * inbound traffic stats
     * </pre>
     */
    public boolean hasIngressStats() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional .InterfaceStats ingress_stats = 7;</code>
     *
     * <pre>
     * inbound traffic stats
     * </pre>
     */
    public Port.InterfaceStats getIngressStats() {
      return ingressStats_;
    }
    /**
     * <code>optional .InterfaceStats ingress_stats = 7;</code>
     *
     * <pre>
     * inbound traffic stats
     * </pre>
     */
    public Port.InterfaceStatsOrBuilder getIngressStatsOrBuilder() {
      return ingressStats_;
    }

    public static final int EGRESS_STATS_FIELD_NUMBER = 8;
    private Port.InterfaceStats egressStats_;
    /**
     * <code>optional .InterfaceStats egress_stats = 8;</code>
     *
     * <pre>
     * outbound traffic stats
     * </pre>
     */
    public boolean hasEgressStats() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional .InterfaceStats egress_stats = 8;</code>
     *
     * <pre>
     * outbound traffic stats
     * </pre>
     */
    public Port.InterfaceStats getEgressStats() {
      return egressStats_;
    }
    /**
     * <code>optional .InterfaceStats egress_stats = 8;</code>
     *
     * <pre>
     * outbound traffic stats
     * </pre>
     */
    public Port.InterfaceStatsOrBuilder getEgressStatsOrBuilder() {
      return egressStats_;
    }

    public static final int INGRESS_ERRORS_FIELD_NUMBER = 9;
    private Port.IngressInterfaceErrors ingressErrors_;
    /**
     * <code>optional .IngressInterfaceErrors ingress_errors = 9;</code>
     *
     * <pre>
     * inbound traffic errors
     * </pre>
     */
    public boolean hasIngressErrors() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional .IngressInterfaceErrors ingress_errors = 9;</code>
     *
     * <pre>
     * inbound traffic errors
     * </pre>
     */
    public Port.IngressInterfaceErrors getIngressErrors() {
      return ingressErrors_;
    }
    /**
     * <code>optional .IngressInterfaceErrors ingress_errors = 9;</code>
     *
     * <pre>
     * inbound traffic errors
     * </pre>
     */
    public Port.IngressInterfaceErrorsOrBuilder getIngressErrorsOrBuilder() {
      return ingressErrors_;
    }

    private void initFields() {
      ifName_ = "";
      initTime_ = 0L;
      snmpIfIndex_ = 0;
      parentAeName_ = "";
      egressQueueInfo_ = java.util.Collections.emptyList();
      ingressQueueInfo_ = java.util.Collections.emptyList();
      ingressStats_ = Port.InterfaceStats.getDefaultInstance();
      egressStats_ = Port.InterfaceStats.getDefaultInstance();
      ingressErrors_ = Port.IngressInterfaceErrors.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasIfName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasInitTime()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasIngressStats()) {
        if (!getIngressStats().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasEgressStats()) {
        if (!getEgressStats().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getIfNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, initTime_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt32(3, snmpIfIndex_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeBytes(4, getParentAeNameBytes());
      }
      for (int i = 0; i < egressQueueInfo_.size(); i++) {
        output.writeMessage(5, egressQueueInfo_.get(i));
      }
      for (int i = 0; i < ingressQueueInfo_.size(); i++) {
        output.writeMessage(6, ingressQueueInfo_.get(i));
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeMessage(7, ingressStats_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeMessage(8, egressStats_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeMessage(9, ingressErrors_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getIfNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, initTime_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(3, snmpIfIndex_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(4, getParentAeNameBytes());
      }
      for (int i = 0; i < egressQueueInfo_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, egressQueueInfo_.get(i));
      }
      for (int i = 0; i < ingressQueueInfo_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, ingressQueueInfo_.get(i));
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, ingressStats_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, egressStats_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(9, ingressErrors_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static Port.InterfaceInfos parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Port.InterfaceInfos parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Port.InterfaceInfos parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Port.InterfaceInfos parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Port.InterfaceInfos parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Port.InterfaceInfos parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static Port.InterfaceInfos parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static Port.InterfaceInfos parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static Port.InterfaceInfos parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Port.InterfaceInfos parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(Port.InterfaceInfos prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code InterfaceInfos}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:InterfaceInfos)
        Port.InterfaceInfosOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return Port.internal_static_InterfaceInfos_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return Port.internal_static_InterfaceInfos_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                Port.InterfaceInfos.class, Port.InterfaceInfos.Builder.class);
      }

      // Construct using Port.InterfaceInfos.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getEgressQueueInfoFieldBuilder();
          getIngressQueueInfoFieldBuilder();
          getIngressStatsFieldBuilder();
          getEgressStatsFieldBuilder();
          getIngressErrorsFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        ifName_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        initTime_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        snmpIfIndex_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        parentAeName_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        if (egressQueueInfoBuilder_ == null) {
          egressQueueInfo_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          egressQueueInfoBuilder_.clear();
        }
        if (ingressQueueInfoBuilder_ == null) {
          ingressQueueInfo_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ingressQueueInfoBuilder_.clear();
        }
        if (ingressStatsBuilder_ == null) {
          ingressStats_ = Port.InterfaceStats.getDefaultInstance();
        } else {
          ingressStatsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        if (egressStatsBuilder_ == null) {
          egressStats_ = Port.InterfaceStats.getDefaultInstance();
        } else {
          egressStatsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        if (ingressErrorsBuilder_ == null) {
          ingressErrors_ = Port.IngressInterfaceErrors.getDefaultInstance();
        } else {
          ingressErrorsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return Port.internal_static_InterfaceInfos_descriptor;
      }

      public Port.InterfaceInfos getDefaultInstanceForType() {
        return Port.InterfaceInfos.getDefaultInstance();
      }

      public Port.InterfaceInfos build() {
        Port.InterfaceInfos result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public Port.InterfaceInfos buildPartial() {
        Port.InterfaceInfos result = new Port.InterfaceInfos(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.ifName_ = ifName_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.initTime_ = initTime_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.snmpIfIndex_ = snmpIfIndex_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.parentAeName_ = parentAeName_;
        if (egressQueueInfoBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010)) {
            egressQueueInfo_ = java.util.Collections.unmodifiableList(egressQueueInfo_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.egressQueueInfo_ = egressQueueInfo_;
        } else {
          result.egressQueueInfo_ = egressQueueInfoBuilder_.build();
        }
        if (ingressQueueInfoBuilder_ == null) {
          if (((bitField0_ & 0x00000020) == 0x00000020)) {
            ingressQueueInfo_ = java.util.Collections.unmodifiableList(ingressQueueInfo_);
            bitField0_ = (bitField0_ & ~0x00000020);
          }
          result.ingressQueueInfo_ = ingressQueueInfo_;
        } else {
          result.ingressQueueInfo_ = ingressQueueInfoBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000010;
        }
        if (ingressStatsBuilder_ == null) {
          result.ingressStats_ = ingressStats_;
        } else {
          result.ingressStats_ = ingressStatsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000020;
        }
        if (egressStatsBuilder_ == null) {
          result.egressStats_ = egressStats_;
        } else {
          result.egressStats_ = egressStatsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000040;
        }
        if (ingressErrorsBuilder_ == null) {
          result.ingressErrors_ = ingressErrors_;
        } else {
          result.ingressErrors_ = ingressErrorsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof Port.InterfaceInfos) {
          return mergeFrom((Port.InterfaceInfos)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(Port.InterfaceInfos other) {
        if (other == Port.InterfaceInfos.getDefaultInstance()) return this;
        if (other.hasIfName()) {
          bitField0_ |= 0x00000001;
          ifName_ = other.ifName_;
          onChanged();
        }
        if (other.hasInitTime()) {
          setInitTime(other.getInitTime());
        }
        if (other.hasSnmpIfIndex()) {
          setSnmpIfIndex(other.getSnmpIfIndex());
        }
        if (other.hasParentAeName()) {
          bitField0_ |= 0x00000008;
          parentAeName_ = other.parentAeName_;
          onChanged();
        }
        if (egressQueueInfoBuilder_ == null) {
          if (!other.egressQueueInfo_.isEmpty()) {
            if (egressQueueInfo_.isEmpty()) {
              egressQueueInfo_ = other.egressQueueInfo_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureEgressQueueInfoIsMutable();
              egressQueueInfo_.addAll(other.egressQueueInfo_);
            }
            onChanged();
          }
        } else {
          if (!other.egressQueueInfo_.isEmpty()) {
            if (egressQueueInfoBuilder_.isEmpty()) {
              egressQueueInfoBuilder_.dispose();
              egressQueueInfoBuilder_ = null;
              egressQueueInfo_ = other.egressQueueInfo_;
              bitField0_ = (bitField0_ & ~0x00000010);
              egressQueueInfoBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getEgressQueueInfoFieldBuilder() : null;
            } else {
              egressQueueInfoBuilder_.addAllMessages(other.egressQueueInfo_);
            }
          }
        }
        if (ingressQueueInfoBuilder_ == null) {
          if (!other.ingressQueueInfo_.isEmpty()) {
            if (ingressQueueInfo_.isEmpty()) {
              ingressQueueInfo_ = other.ingressQueueInfo_;
              bitField0_ = (bitField0_ & ~0x00000020);
            } else {
              ensureIngressQueueInfoIsMutable();
              ingressQueueInfo_.addAll(other.ingressQueueInfo_);
            }
            onChanged();
          }
        } else {
          if (!other.ingressQueueInfo_.isEmpty()) {
            if (ingressQueueInfoBuilder_.isEmpty()) {
              ingressQueueInfoBuilder_.dispose();
              ingressQueueInfoBuilder_ = null;
              ingressQueueInfo_ = other.ingressQueueInfo_;
              bitField0_ = (bitField0_ & ~0x00000020);
              ingressQueueInfoBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getIngressQueueInfoFieldBuilder() : null;
            } else {
              ingressQueueInfoBuilder_.addAllMessages(other.ingressQueueInfo_);
            }
          }
        }
        if (other.hasIngressStats()) {
          mergeIngressStats(other.getIngressStats());
        }
        if (other.hasEgressStats()) {
          mergeEgressStats(other.getEgressStats());
        }
        if (other.hasIngressErrors()) {
          mergeIngressErrors(other.getIngressErrors());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasIfName()) {
          
          return false;
        }
        if (!hasInitTime()) {
          
          return false;
        }
        if (hasIngressStats()) {
          if (!getIngressStats().isInitialized()) {
            
            return false;
          }
        }
        if (hasEgressStats()) {
          if (!getEgressStats().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        Port.InterfaceInfos parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (Port.InterfaceInfos) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object ifName_ = "";
      /**
       * <code>required string if_name = 1;</code>
       *
       * <pre>
       * e.g., xe-0/0/0
       * </pre>
       */
      public boolean hasIfName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string if_name = 1;</code>
       *
       * <pre>
       * e.g., xe-0/0/0
       * </pre>
       */
      public java.lang.String getIfName() {
        java.lang.Object ref = ifName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            ifName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string if_name = 1;</code>
       *
       * <pre>
       * e.g., xe-0/0/0
       * </pre>
       */
      public com.google.protobuf.ByteString
          getIfNameBytes() {
        java.lang.Object ref = ifName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          ifName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string if_name = 1;</code>
       *
       * <pre>
       * e.g., xe-0/0/0
       * </pre>
       */
      public Builder setIfName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        ifName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string if_name = 1;</code>
       *
       * <pre>
       * e.g., xe-0/0/0
       * </pre>
       */
      public Builder clearIfName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        ifName_ = getDefaultInstance().getIfName();
        onChanged();
        return this;
      }
      /**
       * <code>required string if_name = 1;</code>
       *
       * <pre>
       * e.g., xe-0/0/0
       * </pre>
       */
      public Builder setIfNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        ifName_ = value;
        onChanged();
        return this;
      }

      private long initTime_ ;
      /**
       * <code>required uint64 init_time = 2;</code>
       *
       * <pre>
       * time when if/stats last reset
       * </pre>
       */
      public boolean hasInitTime() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required uint64 init_time = 2;</code>
       *
       * <pre>
       * time when if/stats last reset
       * </pre>
       */
      public long getInitTime() {
        return initTime_;
      }
      /**
       * <code>required uint64 init_time = 2;</code>
       *
       * <pre>
       * time when if/stats last reset
       * </pre>
       */
      public Builder setInitTime(long value) {
        bitField0_ |= 0x00000002;
        initTime_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 init_time = 2;</code>
       *
       * <pre>
       * time when if/stats last reset
       * </pre>
       */
      public Builder clearInitTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        initTime_ = 0L;
        onChanged();
        return this;
      }

      private int snmpIfIndex_ ;
      /**
       * <code>optional uint32 snmp_if_index = 3;</code>
       *
       * <pre>
       * Global Index
       * </pre>
       */
      public boolean hasSnmpIfIndex() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint32 snmp_if_index = 3;</code>
       *
       * <pre>
       * Global Index
       * </pre>
       */
      public int getSnmpIfIndex() {
        return snmpIfIndex_;
      }
      /**
       * <code>optional uint32 snmp_if_index = 3;</code>
       *
       * <pre>
       * Global Index
       * </pre>
       */
      public Builder setSnmpIfIndex(int value) {
        bitField0_ |= 0x00000004;
        snmpIfIndex_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 snmp_if_index = 3;</code>
       *
       * <pre>
       * Global Index
       * </pre>
       */
      public Builder clearSnmpIfIndex() {
        bitField0_ = (bitField0_ & ~0x00000004);
        snmpIfIndex_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object parentAeName_ = "";
      /**
       * <code>optional string parent_ae_name = 4;</code>
       *
       * <pre>
       * name of parent for ae interface, if applicable
       * </pre>
       */
      public boolean hasParentAeName() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional string parent_ae_name = 4;</code>
       *
       * <pre>
       * name of parent for ae interface, if applicable
       * </pre>
       */
      public java.lang.String getParentAeName() {
        java.lang.Object ref = parentAeName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            parentAeName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string parent_ae_name = 4;</code>
       *
       * <pre>
       * name of parent for ae interface, if applicable
       * </pre>
       */
      public com.google.protobuf.ByteString
          getParentAeNameBytes() {
        java.lang.Object ref = parentAeName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          parentAeName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string parent_ae_name = 4;</code>
       *
       * <pre>
       * name of parent for ae interface, if applicable
       * </pre>
       */
      public Builder setParentAeName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        parentAeName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string parent_ae_name = 4;</code>
       *
       * <pre>
       * name of parent for ae interface, if applicable
       * </pre>
       */
      public Builder clearParentAeName() {
        bitField0_ = (bitField0_ & ~0x00000008);
        parentAeName_ = getDefaultInstance().getParentAeName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string parent_ae_name = 4;</code>
       *
       * <pre>
       * name of parent for ae interface, if applicable
       * </pre>
       */
      public Builder setParentAeNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        parentAeName_ = value;
        onChanged();
        return this;
      }

      private java.util.List<Port.QueueStats> egressQueueInfo_ =
        java.util.Collections.emptyList();
      private void ensureEgressQueueInfoIsMutable() {
        if (!((bitField0_ & 0x00000010) == 0x00000010)) {
          egressQueueInfo_ = new java.util.ArrayList<Port.QueueStats>(egressQueueInfo_);
          bitField0_ |= 0x00000010;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          Port.QueueStats, Port.QueueStats.Builder, Port.QueueStatsOrBuilder> egressQueueInfoBuilder_;

      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public java.util.List<Port.QueueStats> getEgressQueueInfoList() {
        if (egressQueueInfoBuilder_ == null) {
          return java.util.Collections.unmodifiableList(egressQueueInfo_);
        } else {
          return egressQueueInfoBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public int getEgressQueueInfoCount() {
        if (egressQueueInfoBuilder_ == null) {
          return egressQueueInfo_.size();
        } else {
          return egressQueueInfoBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public Port.QueueStats getEgressQueueInfo(int index) {
        if (egressQueueInfoBuilder_ == null) {
          return egressQueueInfo_.get(index);
        } else {
          return egressQueueInfoBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public Builder setEgressQueueInfo(
          int index, Port.QueueStats value) {
        if (egressQueueInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEgressQueueInfoIsMutable();
          egressQueueInfo_.set(index, value);
          onChanged();
        } else {
          egressQueueInfoBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public Builder setEgressQueueInfo(
          int index, Port.QueueStats.Builder builderForValue) {
        if (egressQueueInfoBuilder_ == null) {
          ensureEgressQueueInfoIsMutable();
          egressQueueInfo_.set(index, builderForValue.build());
          onChanged();
        } else {
          egressQueueInfoBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public Builder addEgressQueueInfo(Port.QueueStats value) {
        if (egressQueueInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEgressQueueInfoIsMutable();
          egressQueueInfo_.add(value);
          onChanged();
        } else {
          egressQueueInfoBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public Builder addEgressQueueInfo(
          int index, Port.QueueStats value) {
        if (egressQueueInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEgressQueueInfoIsMutable();
          egressQueueInfo_.add(index, value);
          onChanged();
        } else {
          egressQueueInfoBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public Builder addEgressQueueInfo(
          Port.QueueStats.Builder builderForValue) {
        if (egressQueueInfoBuilder_ == null) {
          ensureEgressQueueInfoIsMutable();
          egressQueueInfo_.add(builderForValue.build());
          onChanged();
        } else {
          egressQueueInfoBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public Builder addEgressQueueInfo(
          int index, Port.QueueStats.Builder builderForValue) {
        if (egressQueueInfoBuilder_ == null) {
          ensureEgressQueueInfoIsMutable();
          egressQueueInfo_.add(index, builderForValue.build());
          onChanged();
        } else {
          egressQueueInfoBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public Builder addAllEgressQueueInfo(
          java.lang.Iterable<? extends Port.QueueStats> values) {
        if (egressQueueInfoBuilder_ == null) {
          ensureEgressQueueInfoIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, egressQueueInfo_);
          onChanged();
        } else {
          egressQueueInfoBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public Builder clearEgressQueueInfo() {
        if (egressQueueInfoBuilder_ == null) {
          egressQueueInfo_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          egressQueueInfoBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public Builder removeEgressQueueInfo(int index) {
        if (egressQueueInfoBuilder_ == null) {
          ensureEgressQueueInfoIsMutable();
          egressQueueInfo_.remove(index);
          onChanged();
        } else {
          egressQueueInfoBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public Port.QueueStats.Builder getEgressQueueInfoBuilder(
          int index) {
        return getEgressQueueInfoFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public Port.QueueStatsOrBuilder getEgressQueueInfoOrBuilder(
          int index) {
        if (egressQueueInfoBuilder_ == null) {
          return egressQueueInfo_.get(index);  } else {
          return egressQueueInfoBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public java.util.List<? extends Port.QueueStatsOrBuilder> 
           getEgressQueueInfoOrBuilderList() {
        if (egressQueueInfoBuilder_ != null) {
          return egressQueueInfoBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(egressQueueInfo_);
        }
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public Port.QueueStats.Builder addEgressQueueInfoBuilder() {
        return getEgressQueueInfoFieldBuilder().addBuilder(
            Port.QueueStats.getDefaultInstance());
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public Port.QueueStats.Builder addEgressQueueInfoBuilder(
          int index) {
        return getEgressQueueInfoFieldBuilder().addBuilder(
            index, Port.QueueStats.getDefaultInstance());
      }
      /**
       * <code>repeated .QueueStats egress_queue_info = 5;</code>
       *
       * <pre>
       * egress queue information
       * </pre>
       */
      public java.util.List<Port.QueueStats.Builder> 
           getEgressQueueInfoBuilderList() {
        return getEgressQueueInfoFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          Port.QueueStats, Port.QueueStats.Builder, Port.QueueStatsOrBuilder> 
          getEgressQueueInfoFieldBuilder() {
        if (egressQueueInfoBuilder_ == null) {
          egressQueueInfoBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              Port.QueueStats, Port.QueueStats.Builder, Port.QueueStatsOrBuilder>(
                  egressQueueInfo_,
                  ((bitField0_ & 0x00000010) == 0x00000010),
                  getParentForChildren(),
                  isClean());
          egressQueueInfo_ = null;
        }
        return egressQueueInfoBuilder_;
      }

      private java.util.List<Port.QueueStats> ingressQueueInfo_ =
        java.util.Collections.emptyList();
      private void ensureIngressQueueInfoIsMutable() {
        if (!((bitField0_ & 0x00000020) == 0x00000020)) {
          ingressQueueInfo_ = new java.util.ArrayList<Port.QueueStats>(ingressQueueInfo_);
          bitField0_ |= 0x00000020;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          Port.QueueStats, Port.QueueStats.Builder, Port.QueueStatsOrBuilder> ingressQueueInfoBuilder_;

      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public java.util.List<Port.QueueStats> getIngressQueueInfoList() {
        if (ingressQueueInfoBuilder_ == null) {
          return java.util.Collections.unmodifiableList(ingressQueueInfo_);
        } else {
          return ingressQueueInfoBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public int getIngressQueueInfoCount() {
        if (ingressQueueInfoBuilder_ == null) {
          return ingressQueueInfo_.size();
        } else {
          return ingressQueueInfoBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public Port.QueueStats getIngressQueueInfo(int index) {
        if (ingressQueueInfoBuilder_ == null) {
          return ingressQueueInfo_.get(index);
        } else {
          return ingressQueueInfoBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public Builder setIngressQueueInfo(
          int index, Port.QueueStats value) {
        if (ingressQueueInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIngressQueueInfoIsMutable();
          ingressQueueInfo_.set(index, value);
          onChanged();
        } else {
          ingressQueueInfoBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public Builder setIngressQueueInfo(
          int index, Port.QueueStats.Builder builderForValue) {
        if (ingressQueueInfoBuilder_ == null) {
          ensureIngressQueueInfoIsMutable();
          ingressQueueInfo_.set(index, builderForValue.build());
          onChanged();
        } else {
          ingressQueueInfoBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public Builder addIngressQueueInfo(Port.QueueStats value) {
        if (ingressQueueInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIngressQueueInfoIsMutable();
          ingressQueueInfo_.add(value);
          onChanged();
        } else {
          ingressQueueInfoBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public Builder addIngressQueueInfo(
          int index, Port.QueueStats value) {
        if (ingressQueueInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIngressQueueInfoIsMutable();
          ingressQueueInfo_.add(index, value);
          onChanged();
        } else {
          ingressQueueInfoBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public Builder addIngressQueueInfo(
          Port.QueueStats.Builder builderForValue) {
        if (ingressQueueInfoBuilder_ == null) {
          ensureIngressQueueInfoIsMutable();
          ingressQueueInfo_.add(builderForValue.build());
          onChanged();
        } else {
          ingressQueueInfoBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public Builder addIngressQueueInfo(
          int index, Port.QueueStats.Builder builderForValue) {
        if (ingressQueueInfoBuilder_ == null) {
          ensureIngressQueueInfoIsMutable();
          ingressQueueInfo_.add(index, builderForValue.build());
          onChanged();
        } else {
          ingressQueueInfoBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public Builder addAllIngressQueueInfo(
          java.lang.Iterable<? extends Port.QueueStats> values) {
        if (ingressQueueInfoBuilder_ == null) {
          ensureIngressQueueInfoIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, ingressQueueInfo_);
          onChanged();
        } else {
          ingressQueueInfoBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public Builder clearIngressQueueInfo() {
        if (ingressQueueInfoBuilder_ == null) {
          ingressQueueInfo_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
        } else {
          ingressQueueInfoBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public Builder removeIngressQueueInfo(int index) {
        if (ingressQueueInfoBuilder_ == null) {
          ensureIngressQueueInfoIsMutable();
          ingressQueueInfo_.remove(index);
          onChanged();
        } else {
          ingressQueueInfoBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public Port.QueueStats.Builder getIngressQueueInfoBuilder(
          int index) {
        return getIngressQueueInfoFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public Port.QueueStatsOrBuilder getIngressQueueInfoOrBuilder(
          int index) {
        if (ingressQueueInfoBuilder_ == null) {
          return ingressQueueInfo_.get(index);  } else {
          return ingressQueueInfoBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public java.util.List<? extends Port.QueueStatsOrBuilder> 
           getIngressQueueInfoOrBuilderList() {
        if (ingressQueueInfoBuilder_ != null) {
          return ingressQueueInfoBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(ingressQueueInfo_);
        }
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public Port.QueueStats.Builder addIngressQueueInfoBuilder() {
        return getIngressQueueInfoFieldBuilder().addBuilder(
            Port.QueueStats.getDefaultInstance());
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public Port.QueueStats.Builder addIngressQueueInfoBuilder(
          int index) {
        return getIngressQueueInfoFieldBuilder().addBuilder(
            index, Port.QueueStats.getDefaultInstance());
      }
      /**
       * <code>repeated .QueueStats ingress_queue_info = 6;</code>
       *
       * <pre>
       * ingress queue information
       * </pre>
       */
      public java.util.List<Port.QueueStats.Builder> 
           getIngressQueueInfoBuilderList() {
        return getIngressQueueInfoFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          Port.QueueStats, Port.QueueStats.Builder, Port.QueueStatsOrBuilder> 
          getIngressQueueInfoFieldBuilder() {
        if (ingressQueueInfoBuilder_ == null) {
          ingressQueueInfoBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              Port.QueueStats, Port.QueueStats.Builder, Port.QueueStatsOrBuilder>(
                  ingressQueueInfo_,
                  ((bitField0_ & 0x00000020) == 0x00000020),
                  getParentForChildren(),
                  isClean());
          ingressQueueInfo_ = null;
        }
        return ingressQueueInfoBuilder_;
      }

      private Port.InterfaceStats ingressStats_ = Port.InterfaceStats.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          Port.InterfaceStats, Port.InterfaceStats.Builder, Port.InterfaceStatsOrBuilder> ingressStatsBuilder_;
      /**
       * <code>optional .InterfaceStats ingress_stats = 7;</code>
       *
       * <pre>
       * inbound traffic stats
       * </pre>
       */
      public boolean hasIngressStats() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional .InterfaceStats ingress_stats = 7;</code>
       *
       * <pre>
       * inbound traffic stats
       * </pre>
       */
      public Port.InterfaceStats getIngressStats() {
        if (ingressStatsBuilder_ == null) {
          return ingressStats_;
        } else {
          return ingressStatsBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .InterfaceStats ingress_stats = 7;</code>
       *
       * <pre>
       * inbound traffic stats
       * </pre>
       */
      public Builder setIngressStats(Port.InterfaceStats value) {
        if (ingressStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ingressStats_ = value;
          onChanged();
        } else {
          ingressStatsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <code>optional .InterfaceStats ingress_stats = 7;</code>
       *
       * <pre>
       * inbound traffic stats
       * </pre>
       */
      public Builder setIngressStats(
          Port.InterfaceStats.Builder builderForValue) {
        if (ingressStatsBuilder_ == null) {
          ingressStats_ = builderForValue.build();
          onChanged();
        } else {
          ingressStatsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <code>optional .InterfaceStats ingress_stats = 7;</code>
       *
       * <pre>
       * inbound traffic stats
       * </pre>
       */
      public Builder mergeIngressStats(Port.InterfaceStats value) {
        if (ingressStatsBuilder_ == null) {
          if (((bitField0_ & 0x00000040) == 0x00000040) &&
              ingressStats_ != Port.InterfaceStats.getDefaultInstance()) {
            ingressStats_ =
              Port.InterfaceStats.newBuilder(ingressStats_).mergeFrom(value).buildPartial();
          } else {
            ingressStats_ = value;
          }
          onChanged();
        } else {
          ingressStatsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <code>optional .InterfaceStats ingress_stats = 7;</code>
       *
       * <pre>
       * inbound traffic stats
       * </pre>
       */
      public Builder clearIngressStats() {
        if (ingressStatsBuilder_ == null) {
          ingressStats_ = Port.InterfaceStats.getDefaultInstance();
          onChanged();
        } else {
          ingressStatsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }
      /**
       * <code>optional .InterfaceStats ingress_stats = 7;</code>
       *
       * <pre>
       * inbound traffic stats
       * </pre>
       */
      public Port.InterfaceStats.Builder getIngressStatsBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getIngressStatsFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .InterfaceStats ingress_stats = 7;</code>
       *
       * <pre>
       * inbound traffic stats
       * </pre>
       */
      public Port.InterfaceStatsOrBuilder getIngressStatsOrBuilder() {
        if (ingressStatsBuilder_ != null) {
          return ingressStatsBuilder_.getMessageOrBuilder();
        } else {
          return ingressStats_;
        }
      }
      /**
       * <code>optional .InterfaceStats ingress_stats = 7;</code>
       *
       * <pre>
       * inbound traffic stats
       * </pre>
       */
      private com.google.protobuf.SingleFieldBuilder<
          Port.InterfaceStats, Port.InterfaceStats.Builder, Port.InterfaceStatsOrBuilder> 
          getIngressStatsFieldBuilder() {
        if (ingressStatsBuilder_ == null) {
          ingressStatsBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              Port.InterfaceStats, Port.InterfaceStats.Builder, Port.InterfaceStatsOrBuilder>(
                  getIngressStats(),
                  getParentForChildren(),
                  isClean());
          ingressStats_ = null;
        }
        return ingressStatsBuilder_;
      }

      private Port.InterfaceStats egressStats_ = Port.InterfaceStats.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          Port.InterfaceStats, Port.InterfaceStats.Builder, Port.InterfaceStatsOrBuilder> egressStatsBuilder_;
      /**
       * <code>optional .InterfaceStats egress_stats = 8;</code>
       *
       * <pre>
       * outbound traffic stats
       * </pre>
       */
      public boolean hasEgressStats() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional .InterfaceStats egress_stats = 8;</code>
       *
       * <pre>
       * outbound traffic stats
       * </pre>
       */
      public Port.InterfaceStats getEgressStats() {
        if (egressStatsBuilder_ == null) {
          return egressStats_;
        } else {
          return egressStatsBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .InterfaceStats egress_stats = 8;</code>
       *
       * <pre>
       * outbound traffic stats
       * </pre>
       */
      public Builder setEgressStats(Port.InterfaceStats value) {
        if (egressStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          egressStats_ = value;
          onChanged();
        } else {
          egressStatsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .InterfaceStats egress_stats = 8;</code>
       *
       * <pre>
       * outbound traffic stats
       * </pre>
       */
      public Builder setEgressStats(
          Port.InterfaceStats.Builder builderForValue) {
        if (egressStatsBuilder_ == null) {
          egressStats_ = builderForValue.build();
          onChanged();
        } else {
          egressStatsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .InterfaceStats egress_stats = 8;</code>
       *
       * <pre>
       * outbound traffic stats
       * </pre>
       */
      public Builder mergeEgressStats(Port.InterfaceStats value) {
        if (egressStatsBuilder_ == null) {
          if (((bitField0_ & 0x00000080) == 0x00000080) &&
              egressStats_ != Port.InterfaceStats.getDefaultInstance()) {
            egressStats_ =
              Port.InterfaceStats.newBuilder(egressStats_).mergeFrom(value).buildPartial();
          } else {
            egressStats_ = value;
          }
          onChanged();
        } else {
          egressStatsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .InterfaceStats egress_stats = 8;</code>
       *
       * <pre>
       * outbound traffic stats
       * </pre>
       */
      public Builder clearEgressStats() {
        if (egressStatsBuilder_ == null) {
          egressStats_ = Port.InterfaceStats.getDefaultInstance();
          onChanged();
        } else {
          egressStatsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }
      /**
       * <code>optional .InterfaceStats egress_stats = 8;</code>
       *
       * <pre>
       * outbound traffic stats
       * </pre>
       */
      public Port.InterfaceStats.Builder getEgressStatsBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getEgressStatsFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .InterfaceStats egress_stats = 8;</code>
       *
       * <pre>
       * outbound traffic stats
       * </pre>
       */
      public Port.InterfaceStatsOrBuilder getEgressStatsOrBuilder() {
        if (egressStatsBuilder_ != null) {
          return egressStatsBuilder_.getMessageOrBuilder();
        } else {
          return egressStats_;
        }
      }
      /**
       * <code>optional .InterfaceStats egress_stats = 8;</code>
       *
       * <pre>
       * outbound traffic stats
       * </pre>
       */
      private com.google.protobuf.SingleFieldBuilder<
          Port.InterfaceStats, Port.InterfaceStats.Builder, Port.InterfaceStatsOrBuilder> 
          getEgressStatsFieldBuilder() {
        if (egressStatsBuilder_ == null) {
          egressStatsBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              Port.InterfaceStats, Port.InterfaceStats.Builder, Port.InterfaceStatsOrBuilder>(
                  getEgressStats(),
                  getParentForChildren(),
                  isClean());
          egressStats_ = null;
        }
        return egressStatsBuilder_;
      }

      private Port.IngressInterfaceErrors ingressErrors_ = Port.IngressInterfaceErrors.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          Port.IngressInterfaceErrors, Port.IngressInterfaceErrors.Builder, Port.IngressInterfaceErrorsOrBuilder> ingressErrorsBuilder_;
      /**
       * <code>optional .IngressInterfaceErrors ingress_errors = 9;</code>
       *
       * <pre>
       * inbound traffic errors
       * </pre>
       */
      public boolean hasIngressErrors() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       * <code>optional .IngressInterfaceErrors ingress_errors = 9;</code>
       *
       * <pre>
       * inbound traffic errors
       * </pre>
       */
      public Port.IngressInterfaceErrors getIngressErrors() {
        if (ingressErrorsBuilder_ == null) {
          return ingressErrors_;
        } else {
          return ingressErrorsBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .IngressInterfaceErrors ingress_errors = 9;</code>
       *
       * <pre>
       * inbound traffic errors
       * </pre>
       */
      public Builder setIngressErrors(Port.IngressInterfaceErrors value) {
        if (ingressErrorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ingressErrors_ = value;
          onChanged();
        } else {
          ingressErrorsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .IngressInterfaceErrors ingress_errors = 9;</code>
       *
       * <pre>
       * inbound traffic errors
       * </pre>
       */
      public Builder setIngressErrors(
          Port.IngressInterfaceErrors.Builder builderForValue) {
        if (ingressErrorsBuilder_ == null) {
          ingressErrors_ = builderForValue.build();
          onChanged();
        } else {
          ingressErrorsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .IngressInterfaceErrors ingress_errors = 9;</code>
       *
       * <pre>
       * inbound traffic errors
       * </pre>
       */
      public Builder mergeIngressErrors(Port.IngressInterfaceErrors value) {
        if (ingressErrorsBuilder_ == null) {
          if (((bitField0_ & 0x00000100) == 0x00000100) &&
              ingressErrors_ != Port.IngressInterfaceErrors.getDefaultInstance()) {
            ingressErrors_ =
              Port.IngressInterfaceErrors.newBuilder(ingressErrors_).mergeFrom(value).buildPartial();
          } else {
            ingressErrors_ = value;
          }
          onChanged();
        } else {
          ingressErrorsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .IngressInterfaceErrors ingress_errors = 9;</code>
       *
       * <pre>
       * inbound traffic errors
       * </pre>
       */
      public Builder clearIngressErrors() {
        if (ingressErrorsBuilder_ == null) {
          ingressErrors_ = Port.IngressInterfaceErrors.getDefaultInstance();
          onChanged();
        } else {
          ingressErrorsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }
      /**
       * <code>optional .IngressInterfaceErrors ingress_errors = 9;</code>
       *
       * <pre>
       * inbound traffic errors
       * </pre>
       */
      public Port.IngressInterfaceErrors.Builder getIngressErrorsBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getIngressErrorsFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .IngressInterfaceErrors ingress_errors = 9;</code>
       *
       * <pre>
       * inbound traffic errors
       * </pre>
       */
      public Port.IngressInterfaceErrorsOrBuilder getIngressErrorsOrBuilder() {
        if (ingressErrorsBuilder_ != null) {
          return ingressErrorsBuilder_.getMessageOrBuilder();
        } else {
          return ingressErrors_;
        }
      }
      /**
       * <code>optional .IngressInterfaceErrors ingress_errors = 9;</code>
       *
       * <pre>
       * inbound traffic errors
       * </pre>
       */
      private com.google.protobuf.SingleFieldBuilder<
          Port.IngressInterfaceErrors, Port.IngressInterfaceErrors.Builder, Port.IngressInterfaceErrorsOrBuilder> 
          getIngressErrorsFieldBuilder() {
        if (ingressErrorsBuilder_ == null) {
          ingressErrorsBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              Port.IngressInterfaceErrors, Port.IngressInterfaceErrors.Builder, Port.IngressInterfaceErrorsOrBuilder>(
                  getIngressErrors(),
                  getParentForChildren(),
                  isClean());
          ingressErrors_ = null;
        }
        return ingressErrorsBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:InterfaceInfos)
    }

    static {
      defaultInstance = new InterfaceInfos(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:InterfaceInfos)
  }

  public interface InterfaceStatsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:InterfaceStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required uint64 if_pkts = 1;</code>
     *
     * <pre>
     * Counter: the total number of packets sent/rcvd by this interface
     * </pre>
     */
    boolean hasIfPkts();
    /**
     * <code>required uint64 if_pkts = 1;</code>
     *
     * <pre>
     * Counter: the total number of packets sent/rcvd by this interface
     * </pre>
     */
    long getIfPkts();

    /**
     * <code>required uint64 if_octets = 2;</code>
     *
     * <pre>
     * Counter: the total number of bytes sent/rcvd by this interface
     * </pre>
     */
    boolean hasIfOctets();
    /**
     * <code>required uint64 if_octets = 2;</code>
     *
     * <pre>
     * Counter: the total number of bytes sent/rcvd by this interface
     * </pre>
     */
    long getIfOctets();

    /**
     * <code>required uint64 if_1sec_pkts = 3;</code>
     *
     * <pre>
     * Rate: the rate at which packets are sent/rcvd by this interface (in packets/sec)
     * </pre>
     */
    boolean hasIf1SecPkts();
    /**
     * <code>required uint64 if_1sec_pkts = 3;</code>
     *
     * <pre>
     * Rate: the rate at which packets are sent/rcvd by this interface (in packets/sec)
     * </pre>
     */
    long getIf1SecPkts();

    /**
     * <code>required uint64 if_1sec_octets = 4;</code>
     *
     * <pre>
     * Rate: the rate at which bytes are sent/rcvd by this interface
     * </pre>
     */
    boolean hasIf1SecOctets();
    /**
     * <code>required uint64 if_1sec_octets = 4;</code>
     *
     * <pre>
     * Rate: the rate at which bytes are sent/rcvd by this interface
     * </pre>
     */
    long getIf1SecOctets();

    /**
     * <code>required uint64 if_uc_pkts = 5;</code>
     *
     * <pre>
     * Counter: total no of unicast packets sent/rcvd by this interface
     * </pre>
     */
    boolean hasIfUcPkts();
    /**
     * <code>required uint64 if_uc_pkts = 5;</code>
     *
     * <pre>
     * Counter: total no of unicast packets sent/rcvd by this interface
     * </pre>
     */
    long getIfUcPkts();

    /**
     * <code>required uint64 if_mc_pkts = 6;</code>
     *
     * <pre>
     * Counter: total no of multicast packets sent/rcvd by this interface
     * </pre>
     */
    boolean hasIfMcPkts();
    /**
     * <code>required uint64 if_mc_pkts = 6;</code>
     *
     * <pre>
     * Counter: total no of multicast packets sent/rcvd by this interface
     * </pre>
     */
    long getIfMcPkts();

    /**
     * <code>required uint64 if_bc_pkts = 7;</code>
     *
     * <pre>
     * Counter: total no of broadcast packets sent/rcvd by this interface
     * </pre>
     */
    boolean hasIfBcPkts();
    /**
     * <code>required uint64 if_bc_pkts = 7;</code>
     *
     * <pre>
     * Counter: total no of broadcast packets sent/rcvd by this interface
     * </pre>
     */
    long getIfBcPkts();
  }
  /**
   * Protobuf type {@code InterfaceStats}
   */
  public static final class InterfaceStats extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:InterfaceStats)
      InterfaceStatsOrBuilder {
    // Use InterfaceStats.newBuilder() to construct.
    private InterfaceStats(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private InterfaceStats(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final InterfaceStats defaultInstance;
    public static InterfaceStats getDefaultInstance() {
      return defaultInstance;
    }

    public InterfaceStats getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private InterfaceStats(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              ifPkts_ = input.readUInt64();
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              ifOctets_ = input.readUInt64();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              if1SecPkts_ = input.readUInt64();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              if1SecOctets_ = input.readUInt64();
              break;
            }
            case 40: {
              bitField0_ |= 0x00000010;
              ifUcPkts_ = input.readUInt64();
              break;
            }
            case 48: {
              bitField0_ |= 0x00000020;
              ifMcPkts_ = input.readUInt64();
              break;
            }
            case 56: {
              bitField0_ |= 0x00000040;
              ifBcPkts_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return Port.internal_static_InterfaceStats_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return Port.internal_static_InterfaceStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              Port.InterfaceStats.class, Port.InterfaceStats.Builder.class);
    }

    public static com.google.protobuf.Parser<InterfaceStats> PARSER =
        new com.google.protobuf.AbstractParser<InterfaceStats>() {
      public InterfaceStats parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new InterfaceStats(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<InterfaceStats> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int IF_PKTS_FIELD_NUMBER = 1;
    private long ifPkts_;
    /**
     * <code>required uint64 if_pkts = 1;</code>
     *
     * <pre>
     * Counter: the total number of packets sent/rcvd by this interface
     * </pre>
     */
    public boolean hasIfPkts() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required uint64 if_pkts = 1;</code>
     *
     * <pre>
     * Counter: the total number of packets sent/rcvd by this interface
     * </pre>
     */
    public long getIfPkts() {
      return ifPkts_;
    }

    public static final int IF_OCTETS_FIELD_NUMBER = 2;
    private long ifOctets_;
    /**
     * <code>required uint64 if_octets = 2;</code>
     *
     * <pre>
     * Counter: the total number of bytes sent/rcvd by this interface
     * </pre>
     */
    public boolean hasIfOctets() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required uint64 if_octets = 2;</code>
     *
     * <pre>
     * Counter: the total number of bytes sent/rcvd by this interface
     * </pre>
     */
    public long getIfOctets() {
      return ifOctets_;
    }

    public static final int IF_1SEC_PKTS_FIELD_NUMBER = 3;
    private long if1SecPkts_;
    /**
     * <code>required uint64 if_1sec_pkts = 3;</code>
     *
     * <pre>
     * Rate: the rate at which packets are sent/rcvd by this interface (in packets/sec)
     * </pre>
     */
    public boolean hasIf1SecPkts() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>required uint64 if_1sec_pkts = 3;</code>
     *
     * <pre>
     * Rate: the rate at which packets are sent/rcvd by this interface (in packets/sec)
     * </pre>
     */
    public long getIf1SecPkts() {
      return if1SecPkts_;
    }

    public static final int IF_1SEC_OCTETS_FIELD_NUMBER = 4;
    private long if1SecOctets_;
    /**
     * <code>required uint64 if_1sec_octets = 4;</code>
     *
     * <pre>
     * Rate: the rate at which bytes are sent/rcvd by this interface
     * </pre>
     */
    public boolean hasIf1SecOctets() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>required uint64 if_1sec_octets = 4;</code>
     *
     * <pre>
     * Rate: the rate at which bytes are sent/rcvd by this interface
     * </pre>
     */
    public long getIf1SecOctets() {
      return if1SecOctets_;
    }

    public static final int IF_UC_PKTS_FIELD_NUMBER = 5;
    private long ifUcPkts_;
    /**
     * <code>required uint64 if_uc_pkts = 5;</code>
     *
     * <pre>
     * Counter: total no of unicast packets sent/rcvd by this interface
     * </pre>
     */
    public boolean hasIfUcPkts() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>required uint64 if_uc_pkts = 5;</code>
     *
     * <pre>
     * Counter: total no of unicast packets sent/rcvd by this interface
     * </pre>
     */
    public long getIfUcPkts() {
      return ifUcPkts_;
    }

    public static final int IF_MC_PKTS_FIELD_NUMBER = 6;
    private long ifMcPkts_;
    /**
     * <code>required uint64 if_mc_pkts = 6;</code>
     *
     * <pre>
     * Counter: total no of multicast packets sent/rcvd by this interface
     * </pre>
     */
    public boolean hasIfMcPkts() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>required uint64 if_mc_pkts = 6;</code>
     *
     * <pre>
     * Counter: total no of multicast packets sent/rcvd by this interface
     * </pre>
     */
    public long getIfMcPkts() {
      return ifMcPkts_;
    }

    public static final int IF_BC_PKTS_FIELD_NUMBER = 7;
    private long ifBcPkts_;
    /**
     * <code>required uint64 if_bc_pkts = 7;</code>
     *
     * <pre>
     * Counter: total no of broadcast packets sent/rcvd by this interface
     * </pre>
     */
    public boolean hasIfBcPkts() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>required uint64 if_bc_pkts = 7;</code>
     *
     * <pre>
     * Counter: total no of broadcast packets sent/rcvd by this interface
     * </pre>
     */
    public long getIfBcPkts() {
      return ifBcPkts_;
    }

    private void initFields() {
      ifPkts_ = 0L;
      ifOctets_ = 0L;
      if1SecPkts_ = 0L;
      if1SecOctets_ = 0L;
      ifUcPkts_ = 0L;
      ifMcPkts_ = 0L;
      ifBcPkts_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasIfPkts()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasIfOctets()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasIf1SecPkts()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasIf1SecOctets()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasIfUcPkts()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasIfMcPkts()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasIfBcPkts()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeUInt64(1, ifPkts_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, ifOctets_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt64(3, if1SecPkts_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeUInt64(4, if1SecOctets_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeUInt64(5, ifUcPkts_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeUInt64(6, ifMcPkts_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeUInt64(7, ifBcPkts_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, ifPkts_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, ifOctets_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, if1SecPkts_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(4, if1SecOctets_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(5, ifUcPkts_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(6, ifMcPkts_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(7, ifBcPkts_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static Port.InterfaceStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Port.InterfaceStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Port.InterfaceStats parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Port.InterfaceStats parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Port.InterfaceStats parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Port.InterfaceStats parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static Port.InterfaceStats parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static Port.InterfaceStats parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static Port.InterfaceStats parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Port.InterfaceStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(Port.InterfaceStats prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code InterfaceStats}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:InterfaceStats)
        Port.InterfaceStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return Port.internal_static_InterfaceStats_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return Port.internal_static_InterfaceStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                Port.InterfaceStats.class, Port.InterfaceStats.Builder.class);
      }

      // Construct using Port.InterfaceStats.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        ifPkts_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        ifOctets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        if1SecPkts_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        if1SecOctets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000008);
        ifUcPkts_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000010);
        ifMcPkts_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000020);
        ifBcPkts_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return Port.internal_static_InterfaceStats_descriptor;
      }

      public Port.InterfaceStats getDefaultInstanceForType() {
        return Port.InterfaceStats.getDefaultInstance();
      }

      public Port.InterfaceStats build() {
        Port.InterfaceStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public Port.InterfaceStats buildPartial() {
        Port.InterfaceStats result = new Port.InterfaceStats(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.ifPkts_ = ifPkts_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.ifOctets_ = ifOctets_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.if1SecPkts_ = if1SecPkts_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.if1SecOctets_ = if1SecOctets_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.ifUcPkts_ = ifUcPkts_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.ifMcPkts_ = ifMcPkts_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.ifBcPkts_ = ifBcPkts_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof Port.InterfaceStats) {
          return mergeFrom((Port.InterfaceStats)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(Port.InterfaceStats other) {
        if (other == Port.InterfaceStats.getDefaultInstance()) return this;
        if (other.hasIfPkts()) {
          setIfPkts(other.getIfPkts());
        }
        if (other.hasIfOctets()) {
          setIfOctets(other.getIfOctets());
        }
        if (other.hasIf1SecPkts()) {
          setIf1SecPkts(other.getIf1SecPkts());
        }
        if (other.hasIf1SecOctets()) {
          setIf1SecOctets(other.getIf1SecOctets());
        }
        if (other.hasIfUcPkts()) {
          setIfUcPkts(other.getIfUcPkts());
        }
        if (other.hasIfMcPkts()) {
          setIfMcPkts(other.getIfMcPkts());
        }
        if (other.hasIfBcPkts()) {
          setIfBcPkts(other.getIfBcPkts());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasIfPkts()) {
          
          return false;
        }
        if (!hasIfOctets()) {
          
          return false;
        }
        if (!hasIf1SecPkts()) {
          
          return false;
        }
        if (!hasIf1SecOctets()) {
          
          return false;
        }
        if (!hasIfUcPkts()) {
          
          return false;
        }
        if (!hasIfMcPkts()) {
          
          return false;
        }
        if (!hasIfBcPkts()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        Port.InterfaceStats parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (Port.InterfaceStats) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long ifPkts_ ;
      /**
       * <code>required uint64 if_pkts = 1;</code>
       *
       * <pre>
       * Counter: the total number of packets sent/rcvd by this interface
       * </pre>
       */
      public boolean hasIfPkts() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required uint64 if_pkts = 1;</code>
       *
       * <pre>
       * Counter: the total number of packets sent/rcvd by this interface
       * </pre>
       */
      public long getIfPkts() {
        return ifPkts_;
      }
      /**
       * <code>required uint64 if_pkts = 1;</code>
       *
       * <pre>
       * Counter: the total number of packets sent/rcvd by this interface
       * </pre>
       */
      public Builder setIfPkts(long value) {
        bitField0_ |= 0x00000001;
        ifPkts_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 if_pkts = 1;</code>
       *
       * <pre>
       * Counter: the total number of packets sent/rcvd by this interface
       * </pre>
       */
      public Builder clearIfPkts() {
        bitField0_ = (bitField0_ & ~0x00000001);
        ifPkts_ = 0L;
        onChanged();
        return this;
      }

      private long ifOctets_ ;
      /**
       * <code>required uint64 if_octets = 2;</code>
       *
       * <pre>
       * Counter: the total number of bytes sent/rcvd by this interface
       * </pre>
       */
      public boolean hasIfOctets() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required uint64 if_octets = 2;</code>
       *
       * <pre>
       * Counter: the total number of bytes sent/rcvd by this interface
       * </pre>
       */
      public long getIfOctets() {
        return ifOctets_;
      }
      /**
       * <code>required uint64 if_octets = 2;</code>
       *
       * <pre>
       * Counter: the total number of bytes sent/rcvd by this interface
       * </pre>
       */
      public Builder setIfOctets(long value) {
        bitField0_ |= 0x00000002;
        ifOctets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 if_octets = 2;</code>
       *
       * <pre>
       * Counter: the total number of bytes sent/rcvd by this interface
       * </pre>
       */
      public Builder clearIfOctets() {
        bitField0_ = (bitField0_ & ~0x00000002);
        ifOctets_ = 0L;
        onChanged();
        return this;
      }

      private long if1SecPkts_ ;
      /**
       * <code>required uint64 if_1sec_pkts = 3;</code>
       *
       * <pre>
       * Rate: the rate at which packets are sent/rcvd by this interface (in packets/sec)
       * </pre>
       */
      public boolean hasIf1SecPkts() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>required uint64 if_1sec_pkts = 3;</code>
       *
       * <pre>
       * Rate: the rate at which packets are sent/rcvd by this interface (in packets/sec)
       * </pre>
       */
      public long getIf1SecPkts() {
        return if1SecPkts_;
      }
      /**
       * <code>required uint64 if_1sec_pkts = 3;</code>
       *
       * <pre>
       * Rate: the rate at which packets are sent/rcvd by this interface (in packets/sec)
       * </pre>
       */
      public Builder setIf1SecPkts(long value) {
        bitField0_ |= 0x00000004;
        if1SecPkts_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 if_1sec_pkts = 3;</code>
       *
       * <pre>
       * Rate: the rate at which packets are sent/rcvd by this interface (in packets/sec)
       * </pre>
       */
      public Builder clearIf1SecPkts() {
        bitField0_ = (bitField0_ & ~0x00000004);
        if1SecPkts_ = 0L;
        onChanged();
        return this;
      }

      private long if1SecOctets_ ;
      /**
       * <code>required uint64 if_1sec_octets = 4;</code>
       *
       * <pre>
       * Rate: the rate at which bytes are sent/rcvd by this interface
       * </pre>
       */
      public boolean hasIf1SecOctets() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>required uint64 if_1sec_octets = 4;</code>
       *
       * <pre>
       * Rate: the rate at which bytes are sent/rcvd by this interface
       * </pre>
       */
      public long getIf1SecOctets() {
        return if1SecOctets_;
      }
      /**
       * <code>required uint64 if_1sec_octets = 4;</code>
       *
       * <pre>
       * Rate: the rate at which bytes are sent/rcvd by this interface
       * </pre>
       */
      public Builder setIf1SecOctets(long value) {
        bitField0_ |= 0x00000008;
        if1SecOctets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 if_1sec_octets = 4;</code>
       *
       * <pre>
       * Rate: the rate at which bytes are sent/rcvd by this interface
       * </pre>
       */
      public Builder clearIf1SecOctets() {
        bitField0_ = (bitField0_ & ~0x00000008);
        if1SecOctets_ = 0L;
        onChanged();
        return this;
      }

      private long ifUcPkts_ ;
      /**
       * <code>required uint64 if_uc_pkts = 5;</code>
       *
       * <pre>
       * Counter: total no of unicast packets sent/rcvd by this interface
       * </pre>
       */
      public boolean hasIfUcPkts() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>required uint64 if_uc_pkts = 5;</code>
       *
       * <pre>
       * Counter: total no of unicast packets sent/rcvd by this interface
       * </pre>
       */
      public long getIfUcPkts() {
        return ifUcPkts_;
      }
      /**
       * <code>required uint64 if_uc_pkts = 5;</code>
       *
       * <pre>
       * Counter: total no of unicast packets sent/rcvd by this interface
       * </pre>
       */
      public Builder setIfUcPkts(long value) {
        bitField0_ |= 0x00000010;
        ifUcPkts_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 if_uc_pkts = 5;</code>
       *
       * <pre>
       * Counter: total no of unicast packets sent/rcvd by this interface
       * </pre>
       */
      public Builder clearIfUcPkts() {
        bitField0_ = (bitField0_ & ~0x00000010);
        ifUcPkts_ = 0L;
        onChanged();
        return this;
      }

      private long ifMcPkts_ ;
      /**
       * <code>required uint64 if_mc_pkts = 6;</code>
       *
       * <pre>
       * Counter: total no of multicast packets sent/rcvd by this interface
       * </pre>
       */
      public boolean hasIfMcPkts() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>required uint64 if_mc_pkts = 6;</code>
       *
       * <pre>
       * Counter: total no of multicast packets sent/rcvd by this interface
       * </pre>
       */
      public long getIfMcPkts() {
        return ifMcPkts_;
      }
      /**
       * <code>required uint64 if_mc_pkts = 6;</code>
       *
       * <pre>
       * Counter: total no of multicast packets sent/rcvd by this interface
       * </pre>
       */
      public Builder setIfMcPkts(long value) {
        bitField0_ |= 0x00000020;
        ifMcPkts_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 if_mc_pkts = 6;</code>
       *
       * <pre>
       * Counter: total no of multicast packets sent/rcvd by this interface
       * </pre>
       */
      public Builder clearIfMcPkts() {
        bitField0_ = (bitField0_ & ~0x00000020);
        ifMcPkts_ = 0L;
        onChanged();
        return this;
      }

      private long ifBcPkts_ ;
      /**
       * <code>required uint64 if_bc_pkts = 7;</code>
       *
       * <pre>
       * Counter: total no of broadcast packets sent/rcvd by this interface
       * </pre>
       */
      public boolean hasIfBcPkts() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>required uint64 if_bc_pkts = 7;</code>
       *
       * <pre>
       * Counter: total no of broadcast packets sent/rcvd by this interface
       * </pre>
       */
      public long getIfBcPkts() {
        return ifBcPkts_;
      }
      /**
       * <code>required uint64 if_bc_pkts = 7;</code>
       *
       * <pre>
       * Counter: total no of broadcast packets sent/rcvd by this interface
       * </pre>
       */
      public Builder setIfBcPkts(long value) {
        bitField0_ |= 0x00000040;
        ifBcPkts_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 if_bc_pkts = 7;</code>
       *
       * <pre>
       * Counter: total no of broadcast packets sent/rcvd by this interface
       * </pre>
       */
      public Builder clearIfBcPkts() {
        bitField0_ = (bitField0_ & ~0x00000040);
        ifBcPkts_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:InterfaceStats)
    }

    static {
      defaultInstance = new InterfaceStats(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:InterfaceStats)
  }

  public interface IngressInterfaceErrorsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:IngressInterfaceErrors)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional uint64 if_in_errors = 1;</code>
     *
     * <pre>
     * Counter: the number of packets that contained errors
     * </pre>
     */
    boolean hasIfInErrors();
    /**
     * <code>optional uint64 if_in_errors = 1;</code>
     *
     * <pre>
     * Counter: the number of packets that contained errors
     * </pre>
     */
    long getIfInErrors();

    /**
     * <code>optional uint64 if_in_qdrops = 2;</code>
     *
     * <pre>
     * Counter: the number of packets dropped by the input queue of the I/O Manager ASIC
     * </pre>
     */
    boolean hasIfInQdrops();
    /**
     * <code>optional uint64 if_in_qdrops = 2;</code>
     *
     * <pre>
     * Counter: the number of packets dropped by the input queue of the I/O Manager ASIC
     * </pre>
     */
    long getIfInQdrops();

    /**
     * <code>optional uint64 if_in_frame_errors = 3;</code>
     *
     * <pre>
     * Counter: the number of packets which were misaligned
     * </pre>
     */
    boolean hasIfInFrameErrors();
    /**
     * <code>optional uint64 if_in_frame_errors = 3;</code>
     *
     * <pre>
     * Counter: the number of packets which were misaligned
     * </pre>
     */
    long getIfInFrameErrors();

    /**
     * <code>optional uint64 if_in_discards = 4;</code>
     *
     * <pre>
     * Counter: the number of non-errorpackets which were chosen to be discarded
     * </pre>
     */
    boolean hasIfInDiscards();
    /**
     * <code>optional uint64 if_in_discards = 4;</code>
     *
     * <pre>
     * Counter: the number of non-errorpackets which were chosen to be discarded
     * </pre>
     */
    long getIfInDiscards();

    /**
     * <code>optional uint64 if_in_runts = 5;</code>
     *
     * <pre>
     * Counter: the number of runt packets
     * </pre>
     */
    boolean hasIfInRunts();
    /**
     * <code>optional uint64 if_in_runts = 5;</code>
     *
     * <pre>
     * Counter: the number of runt packets
     * </pre>
     */
    long getIfInRunts();

    /**
     * <code>optional uint64 if_in_l3_incompletes = 6;</code>
     *
     * <pre>
     * Counter: the number of packets that fail Layer 3 sanity checks of the header
     * </pre>
     */
    boolean hasIfInL3Incompletes();
    /**
     * <code>optional uint64 if_in_l3_incompletes = 6;</code>
     *
     * <pre>
     * Counter: the number of packets that fail Layer 3 sanity checks of the header
     * </pre>
     */
    long getIfInL3Incompletes();

    /**
     * <code>optional uint64 if_in_l2chan_errors = 7;</code>
     *
     * <pre>
     * Counter: the number of packets for which the software could not find a valid logical interface
     * </pre>
     */
    boolean hasIfInL2ChanErrors();
    /**
     * <code>optional uint64 if_in_l2chan_errors = 7;</code>
     *
     * <pre>
     * Counter: the number of packets for which the software could not find a valid logical interface
     * </pre>
     */
    long getIfInL2ChanErrors();

    /**
     * <code>optional uint64 if_in_l2_mismatch_timeouts = 8;</code>
     *
     * <pre>
     * Counter: the number of malform or short packets
     * </pre>
     */
    boolean hasIfInL2MismatchTimeouts();
    /**
     * <code>optional uint64 if_in_l2_mismatch_timeouts = 8;</code>
     *
     * <pre>
     * Counter: the number of malform or short packets
     * </pre>
     */
    long getIfInL2MismatchTimeouts();

    /**
     * <code>optional uint64 if_in_fifo_errors = 9;</code>
     *
     * <pre>
     * Counter: the number of FIFO errors
     * </pre>
     */
    boolean hasIfInFifoErrors();
    /**
     * <code>optional uint64 if_in_fifo_errors = 9;</code>
     *
     * <pre>
     * Counter: the number of FIFO errors
     * </pre>
     */
    long getIfInFifoErrors();

    /**
     * <code>optional uint64 if_in_resource_errors = 10;</code>
     *
     * <pre>
     * Counter: the number of resourceerrors
     * </pre>
     */
    boolean hasIfInResourceErrors();
    /**
     * <code>optional uint64 if_in_resource_errors = 10;</code>
     *
     * <pre>
     * Counter: the number of resourceerrors
     * </pre>
     */
    long getIfInResourceErrors();
  }
  /**
   * Protobuf type {@code IngressInterfaceErrors}
   */
  public static final class IngressInterfaceErrors extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:IngressInterfaceErrors)
      IngressInterfaceErrorsOrBuilder {
    // Use IngressInterfaceErrors.newBuilder() to construct.
    private IngressInterfaceErrors(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private IngressInterfaceErrors(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final IngressInterfaceErrors defaultInstance;
    public static IngressInterfaceErrors getDefaultInstance() {
      return defaultInstance;
    }

    public IngressInterfaceErrors getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private IngressInterfaceErrors(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              ifInErrors_ = input.readUInt64();
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              ifInQdrops_ = input.readUInt64();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              ifInFrameErrors_ = input.readUInt64();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              ifInDiscards_ = input.readUInt64();
              break;
            }
            case 40: {
              bitField0_ |= 0x00000010;
              ifInRunts_ = input.readUInt64();
              break;
            }
            case 48: {
              bitField0_ |= 0x00000020;
              ifInL3Incompletes_ = input.readUInt64();
              break;
            }
            case 56: {
              bitField0_ |= 0x00000040;
              ifInL2ChanErrors_ = input.readUInt64();
              break;
            }
            case 64: {
              bitField0_ |= 0x00000080;
              ifInL2MismatchTimeouts_ = input.readUInt64();
              break;
            }
            case 72: {
              bitField0_ |= 0x00000100;
              ifInFifoErrors_ = input.readUInt64();
              break;
            }
            case 80: {
              bitField0_ |= 0x00000200;
              ifInResourceErrors_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return Port.internal_static_IngressInterfaceErrors_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return Port.internal_static_IngressInterfaceErrors_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              Port.IngressInterfaceErrors.class, Port.IngressInterfaceErrors.Builder.class);
    }

    public static com.google.protobuf.Parser<IngressInterfaceErrors> PARSER =
        new com.google.protobuf.AbstractParser<IngressInterfaceErrors>() {
      public IngressInterfaceErrors parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new IngressInterfaceErrors(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<IngressInterfaceErrors> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int IF_IN_ERRORS_FIELD_NUMBER = 1;
    private long ifInErrors_;
    /**
     * <code>optional uint64 if_in_errors = 1;</code>
     *
     * <pre>
     * Counter: the number of packets that contained errors
     * </pre>
     */
    public boolean hasIfInErrors() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional uint64 if_in_errors = 1;</code>
     *
     * <pre>
     * Counter: the number of packets that contained errors
     * </pre>
     */
    public long getIfInErrors() {
      return ifInErrors_;
    }

    public static final int IF_IN_QDROPS_FIELD_NUMBER = 2;
    private long ifInQdrops_;
    /**
     * <code>optional uint64 if_in_qdrops = 2;</code>
     *
     * <pre>
     * Counter: the number of packets dropped by the input queue of the I/O Manager ASIC
     * </pre>
     */
    public boolean hasIfInQdrops() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional uint64 if_in_qdrops = 2;</code>
     *
     * <pre>
     * Counter: the number of packets dropped by the input queue of the I/O Manager ASIC
     * </pre>
     */
    public long getIfInQdrops() {
      return ifInQdrops_;
    }

    public static final int IF_IN_FRAME_ERRORS_FIELD_NUMBER = 3;
    private long ifInFrameErrors_;
    /**
     * <code>optional uint64 if_in_frame_errors = 3;</code>
     *
     * <pre>
     * Counter: the number of packets which were misaligned
     * </pre>
     */
    public boolean hasIfInFrameErrors() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint64 if_in_frame_errors = 3;</code>
     *
     * <pre>
     * Counter: the number of packets which were misaligned
     * </pre>
     */
    public long getIfInFrameErrors() {
      return ifInFrameErrors_;
    }

    public static final int IF_IN_DISCARDS_FIELD_NUMBER = 4;
    private long ifInDiscards_;
    /**
     * <code>optional uint64 if_in_discards = 4;</code>
     *
     * <pre>
     * Counter: the number of non-errorpackets which were chosen to be discarded
     * </pre>
     */
    public boolean hasIfInDiscards() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional uint64 if_in_discards = 4;</code>
     *
     * <pre>
     * Counter: the number of non-errorpackets which were chosen to be discarded
     * </pre>
     */
    public long getIfInDiscards() {
      return ifInDiscards_;
    }

    public static final int IF_IN_RUNTS_FIELD_NUMBER = 5;
    private long ifInRunts_;
    /**
     * <code>optional uint64 if_in_runts = 5;</code>
     *
     * <pre>
     * Counter: the number of runt packets
     * </pre>
     */
    public boolean hasIfInRunts() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional uint64 if_in_runts = 5;</code>
     *
     * <pre>
     * Counter: the number of runt packets
     * </pre>
     */
    public long getIfInRunts() {
      return ifInRunts_;
    }

    public static final int IF_IN_L3_INCOMPLETES_FIELD_NUMBER = 6;
    private long ifInL3Incompletes_;
    /**
     * <code>optional uint64 if_in_l3_incompletes = 6;</code>
     *
     * <pre>
     * Counter: the number of packets that fail Layer 3 sanity checks of the header
     * </pre>
     */
    public boolean hasIfInL3Incompletes() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional uint64 if_in_l3_incompletes = 6;</code>
     *
     * <pre>
     * Counter: the number of packets that fail Layer 3 sanity checks of the header
     * </pre>
     */
    public long getIfInL3Incompletes() {
      return ifInL3Incompletes_;
    }

    public static final int IF_IN_L2CHAN_ERRORS_FIELD_NUMBER = 7;
    private long ifInL2ChanErrors_;
    /**
     * <code>optional uint64 if_in_l2chan_errors = 7;</code>
     *
     * <pre>
     * Counter: the number of packets for which the software could not find a valid logical interface
     * </pre>
     */
    public boolean hasIfInL2ChanErrors() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional uint64 if_in_l2chan_errors = 7;</code>
     *
     * <pre>
     * Counter: the number of packets for which the software could not find a valid logical interface
     * </pre>
     */
    public long getIfInL2ChanErrors() {
      return ifInL2ChanErrors_;
    }

    public static final int IF_IN_L2_MISMATCH_TIMEOUTS_FIELD_NUMBER = 8;
    private long ifInL2MismatchTimeouts_;
    /**
     * <code>optional uint64 if_in_l2_mismatch_timeouts = 8;</code>
     *
     * <pre>
     * Counter: the number of malform or short packets
     * </pre>
     */
    public boolean hasIfInL2MismatchTimeouts() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     * <code>optional uint64 if_in_l2_mismatch_timeouts = 8;</code>
     *
     * <pre>
     * Counter: the number of malform or short packets
     * </pre>
     */
    public long getIfInL2MismatchTimeouts() {
      return ifInL2MismatchTimeouts_;
    }

    public static final int IF_IN_FIFO_ERRORS_FIELD_NUMBER = 9;
    private long ifInFifoErrors_;
    /**
     * <code>optional uint64 if_in_fifo_errors = 9;</code>
     *
     * <pre>
     * Counter: the number of FIFO errors
     * </pre>
     */
    public boolean hasIfInFifoErrors() {
      return ((bitField0_ & 0x00000100) == 0x00000100);
    }
    /**
     * <code>optional uint64 if_in_fifo_errors = 9;</code>
     *
     * <pre>
     * Counter: the number of FIFO errors
     * </pre>
     */
    public long getIfInFifoErrors() {
      return ifInFifoErrors_;
    }

    public static final int IF_IN_RESOURCE_ERRORS_FIELD_NUMBER = 10;
    private long ifInResourceErrors_;
    /**
     * <code>optional uint64 if_in_resource_errors = 10;</code>
     *
     * <pre>
     * Counter: the number of resourceerrors
     * </pre>
     */
    public boolean hasIfInResourceErrors() {
      return ((bitField0_ & 0x00000200) == 0x00000200);
    }
    /**
     * <code>optional uint64 if_in_resource_errors = 10;</code>
     *
     * <pre>
     * Counter: the number of resourceerrors
     * </pre>
     */
    public long getIfInResourceErrors() {
      return ifInResourceErrors_;
    }

    private void initFields() {
      ifInErrors_ = 0L;
      ifInQdrops_ = 0L;
      ifInFrameErrors_ = 0L;
      ifInDiscards_ = 0L;
      ifInRunts_ = 0L;
      ifInL3Incompletes_ = 0L;
      ifInL2ChanErrors_ = 0L;
      ifInL2MismatchTimeouts_ = 0L;
      ifInFifoErrors_ = 0L;
      ifInResourceErrors_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeUInt64(1, ifInErrors_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, ifInQdrops_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt64(3, ifInFrameErrors_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeUInt64(4, ifInDiscards_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeUInt64(5, ifInRunts_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeUInt64(6, ifInL3Incompletes_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeUInt64(7, ifInL2ChanErrors_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeUInt64(8, ifInL2MismatchTimeouts_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        output.writeUInt64(9, ifInFifoErrors_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        output.writeUInt64(10, ifInResourceErrors_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, ifInErrors_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, ifInQdrops_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, ifInFrameErrors_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(4, ifInDiscards_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(5, ifInRunts_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(6, ifInL3Incompletes_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(7, ifInL2ChanErrors_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(8, ifInL2MismatchTimeouts_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(9, ifInFifoErrors_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(10, ifInResourceErrors_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static Port.IngressInterfaceErrors parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Port.IngressInterfaceErrors parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Port.IngressInterfaceErrors parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Port.IngressInterfaceErrors parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Port.IngressInterfaceErrors parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Port.IngressInterfaceErrors parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static Port.IngressInterfaceErrors parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static Port.IngressInterfaceErrors parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static Port.IngressInterfaceErrors parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Port.IngressInterfaceErrors parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(Port.IngressInterfaceErrors prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code IngressInterfaceErrors}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:IngressInterfaceErrors)
        Port.IngressInterfaceErrorsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return Port.internal_static_IngressInterfaceErrors_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return Port.internal_static_IngressInterfaceErrors_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                Port.IngressInterfaceErrors.class, Port.IngressInterfaceErrors.Builder.class);
      }

      // Construct using Port.IngressInterfaceErrors.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        ifInErrors_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        ifInQdrops_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        ifInFrameErrors_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        ifInDiscards_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000008);
        ifInRunts_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000010);
        ifInL3Incompletes_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000020);
        ifInL2ChanErrors_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000040);
        ifInL2MismatchTimeouts_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000080);
        ifInFifoErrors_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000100);
        ifInResourceErrors_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000200);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return Port.internal_static_IngressInterfaceErrors_descriptor;
      }

      public Port.IngressInterfaceErrors getDefaultInstanceForType() {
        return Port.IngressInterfaceErrors.getDefaultInstance();
      }

      public Port.IngressInterfaceErrors build() {
        Port.IngressInterfaceErrors result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public Port.IngressInterfaceErrors buildPartial() {
        Port.IngressInterfaceErrors result = new Port.IngressInterfaceErrors(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.ifInErrors_ = ifInErrors_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.ifInQdrops_ = ifInQdrops_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.ifInFrameErrors_ = ifInFrameErrors_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.ifInDiscards_ = ifInDiscards_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.ifInRunts_ = ifInRunts_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.ifInL3Incompletes_ = ifInL3Incompletes_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.ifInL2ChanErrors_ = ifInL2ChanErrors_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000080;
        }
        result.ifInL2MismatchTimeouts_ = ifInL2MismatchTimeouts_;
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000100;
        }
        result.ifInFifoErrors_ = ifInFifoErrors_;
        if (((from_bitField0_ & 0x00000200) == 0x00000200)) {
          to_bitField0_ |= 0x00000200;
        }
        result.ifInResourceErrors_ = ifInResourceErrors_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof Port.IngressInterfaceErrors) {
          return mergeFrom((Port.IngressInterfaceErrors)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(Port.IngressInterfaceErrors other) {
        if (other == Port.IngressInterfaceErrors.getDefaultInstance()) return this;
        if (other.hasIfInErrors()) {
          setIfInErrors(other.getIfInErrors());
        }
        if (other.hasIfInQdrops()) {
          setIfInQdrops(other.getIfInQdrops());
        }
        if (other.hasIfInFrameErrors()) {
          setIfInFrameErrors(other.getIfInFrameErrors());
        }
        if (other.hasIfInDiscards()) {
          setIfInDiscards(other.getIfInDiscards());
        }
        if (other.hasIfInRunts()) {
          setIfInRunts(other.getIfInRunts());
        }
        if (other.hasIfInL3Incompletes()) {
          setIfInL3Incompletes(other.getIfInL3Incompletes());
        }
        if (other.hasIfInL2ChanErrors()) {
          setIfInL2ChanErrors(other.getIfInL2ChanErrors());
        }
        if (other.hasIfInL2MismatchTimeouts()) {
          setIfInL2MismatchTimeouts(other.getIfInL2MismatchTimeouts());
        }
        if (other.hasIfInFifoErrors()) {
          setIfInFifoErrors(other.getIfInFifoErrors());
        }
        if (other.hasIfInResourceErrors()) {
          setIfInResourceErrors(other.getIfInResourceErrors());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        Port.IngressInterfaceErrors parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (Port.IngressInterfaceErrors) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long ifInErrors_ ;
      /**
       * <code>optional uint64 if_in_errors = 1;</code>
       *
       * <pre>
       * Counter: the number of packets that contained errors
       * </pre>
       */
      public boolean hasIfInErrors() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional uint64 if_in_errors = 1;</code>
       *
       * <pre>
       * Counter: the number of packets that contained errors
       * </pre>
       */
      public long getIfInErrors() {
        return ifInErrors_;
      }
      /**
       * <code>optional uint64 if_in_errors = 1;</code>
       *
       * <pre>
       * Counter: the number of packets that contained errors
       * </pre>
       */
      public Builder setIfInErrors(long value) {
        bitField0_ |= 0x00000001;
        ifInErrors_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 if_in_errors = 1;</code>
       *
       * <pre>
       * Counter: the number of packets that contained errors
       * </pre>
       */
      public Builder clearIfInErrors() {
        bitField0_ = (bitField0_ & ~0x00000001);
        ifInErrors_ = 0L;
        onChanged();
        return this;
      }

      private long ifInQdrops_ ;
      /**
       * <code>optional uint64 if_in_qdrops = 2;</code>
       *
       * <pre>
       * Counter: the number of packets dropped by the input queue of the I/O Manager ASIC
       * </pre>
       */
      public boolean hasIfInQdrops() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint64 if_in_qdrops = 2;</code>
       *
       * <pre>
       * Counter: the number of packets dropped by the input queue of the I/O Manager ASIC
       * </pre>
       */
      public long getIfInQdrops() {
        return ifInQdrops_;
      }
      /**
       * <code>optional uint64 if_in_qdrops = 2;</code>
       *
       * <pre>
       * Counter: the number of packets dropped by the input queue of the I/O Manager ASIC
       * </pre>
       */
      public Builder setIfInQdrops(long value) {
        bitField0_ |= 0x00000002;
        ifInQdrops_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 if_in_qdrops = 2;</code>
       *
       * <pre>
       * Counter: the number of packets dropped by the input queue of the I/O Manager ASIC
       * </pre>
       */
      public Builder clearIfInQdrops() {
        bitField0_ = (bitField0_ & ~0x00000002);
        ifInQdrops_ = 0L;
        onChanged();
        return this;
      }

      private long ifInFrameErrors_ ;
      /**
       * <code>optional uint64 if_in_frame_errors = 3;</code>
       *
       * <pre>
       * Counter: the number of packets which were misaligned
       * </pre>
       */
      public boolean hasIfInFrameErrors() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint64 if_in_frame_errors = 3;</code>
       *
       * <pre>
       * Counter: the number of packets which were misaligned
       * </pre>
       */
      public long getIfInFrameErrors() {
        return ifInFrameErrors_;
      }
      /**
       * <code>optional uint64 if_in_frame_errors = 3;</code>
       *
       * <pre>
       * Counter: the number of packets which were misaligned
       * </pre>
       */
      public Builder setIfInFrameErrors(long value) {
        bitField0_ |= 0x00000004;
        ifInFrameErrors_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 if_in_frame_errors = 3;</code>
       *
       * <pre>
       * Counter: the number of packets which were misaligned
       * </pre>
       */
      public Builder clearIfInFrameErrors() {
        bitField0_ = (bitField0_ & ~0x00000004);
        ifInFrameErrors_ = 0L;
        onChanged();
        return this;
      }

      private long ifInDiscards_ ;
      /**
       * <code>optional uint64 if_in_discards = 4;</code>
       *
       * <pre>
       * Counter: the number of non-errorpackets which were chosen to be discarded
       * </pre>
       */
      public boolean hasIfInDiscards() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional uint64 if_in_discards = 4;</code>
       *
       * <pre>
       * Counter: the number of non-errorpackets which were chosen to be discarded
       * </pre>
       */
      public long getIfInDiscards() {
        return ifInDiscards_;
      }
      /**
       * <code>optional uint64 if_in_discards = 4;</code>
       *
       * <pre>
       * Counter: the number of non-errorpackets which were chosen to be discarded
       * </pre>
       */
      public Builder setIfInDiscards(long value) {
        bitField0_ |= 0x00000008;
        ifInDiscards_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 if_in_discards = 4;</code>
       *
       * <pre>
       * Counter: the number of non-errorpackets which were chosen to be discarded
       * </pre>
       */
      public Builder clearIfInDiscards() {
        bitField0_ = (bitField0_ & ~0x00000008);
        ifInDiscards_ = 0L;
        onChanged();
        return this;
      }

      private long ifInRunts_ ;
      /**
       * <code>optional uint64 if_in_runts = 5;</code>
       *
       * <pre>
       * Counter: the number of runt packets
       * </pre>
       */
      public boolean hasIfInRunts() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional uint64 if_in_runts = 5;</code>
       *
       * <pre>
       * Counter: the number of runt packets
       * </pre>
       */
      public long getIfInRunts() {
        return ifInRunts_;
      }
      /**
       * <code>optional uint64 if_in_runts = 5;</code>
       *
       * <pre>
       * Counter: the number of runt packets
       * </pre>
       */
      public Builder setIfInRunts(long value) {
        bitField0_ |= 0x00000010;
        ifInRunts_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 if_in_runts = 5;</code>
       *
       * <pre>
       * Counter: the number of runt packets
       * </pre>
       */
      public Builder clearIfInRunts() {
        bitField0_ = (bitField0_ & ~0x00000010);
        ifInRunts_ = 0L;
        onChanged();
        return this;
      }

      private long ifInL3Incompletes_ ;
      /**
       * <code>optional uint64 if_in_l3_incompletes = 6;</code>
       *
       * <pre>
       * Counter: the number of packets that fail Layer 3 sanity checks of the header
       * </pre>
       */
      public boolean hasIfInL3Incompletes() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional uint64 if_in_l3_incompletes = 6;</code>
       *
       * <pre>
       * Counter: the number of packets that fail Layer 3 sanity checks of the header
       * </pre>
       */
      public long getIfInL3Incompletes() {
        return ifInL3Incompletes_;
      }
      /**
       * <code>optional uint64 if_in_l3_incompletes = 6;</code>
       *
       * <pre>
       * Counter: the number of packets that fail Layer 3 sanity checks of the header
       * </pre>
       */
      public Builder setIfInL3Incompletes(long value) {
        bitField0_ |= 0x00000020;
        ifInL3Incompletes_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 if_in_l3_incompletes = 6;</code>
       *
       * <pre>
       * Counter: the number of packets that fail Layer 3 sanity checks of the header
       * </pre>
       */
      public Builder clearIfInL3Incompletes() {
        bitField0_ = (bitField0_ & ~0x00000020);
        ifInL3Incompletes_ = 0L;
        onChanged();
        return this;
      }

      private long ifInL2ChanErrors_ ;
      /**
       * <code>optional uint64 if_in_l2chan_errors = 7;</code>
       *
       * <pre>
       * Counter: the number of packets for which the software could not find a valid logical interface
       * </pre>
       */
      public boolean hasIfInL2ChanErrors() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional uint64 if_in_l2chan_errors = 7;</code>
       *
       * <pre>
       * Counter: the number of packets for which the software could not find a valid logical interface
       * </pre>
       */
      public long getIfInL2ChanErrors() {
        return ifInL2ChanErrors_;
      }
      /**
       * <code>optional uint64 if_in_l2chan_errors = 7;</code>
       *
       * <pre>
       * Counter: the number of packets for which the software could not find a valid logical interface
       * </pre>
       */
      public Builder setIfInL2ChanErrors(long value) {
        bitField0_ |= 0x00000040;
        ifInL2ChanErrors_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 if_in_l2chan_errors = 7;</code>
       *
       * <pre>
       * Counter: the number of packets for which the software could not find a valid logical interface
       * </pre>
       */
      public Builder clearIfInL2ChanErrors() {
        bitField0_ = (bitField0_ & ~0x00000040);
        ifInL2ChanErrors_ = 0L;
        onChanged();
        return this;
      }

      private long ifInL2MismatchTimeouts_ ;
      /**
       * <code>optional uint64 if_in_l2_mismatch_timeouts = 8;</code>
       *
       * <pre>
       * Counter: the number of malform or short packets
       * </pre>
       */
      public boolean hasIfInL2MismatchTimeouts() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional uint64 if_in_l2_mismatch_timeouts = 8;</code>
       *
       * <pre>
       * Counter: the number of malform or short packets
       * </pre>
       */
      public long getIfInL2MismatchTimeouts() {
        return ifInL2MismatchTimeouts_;
      }
      /**
       * <code>optional uint64 if_in_l2_mismatch_timeouts = 8;</code>
       *
       * <pre>
       * Counter: the number of malform or short packets
       * </pre>
       */
      public Builder setIfInL2MismatchTimeouts(long value) {
        bitField0_ |= 0x00000080;
        ifInL2MismatchTimeouts_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 if_in_l2_mismatch_timeouts = 8;</code>
       *
       * <pre>
       * Counter: the number of malform or short packets
       * </pre>
       */
      public Builder clearIfInL2MismatchTimeouts() {
        bitField0_ = (bitField0_ & ~0x00000080);
        ifInL2MismatchTimeouts_ = 0L;
        onChanged();
        return this;
      }

      private long ifInFifoErrors_ ;
      /**
       * <code>optional uint64 if_in_fifo_errors = 9;</code>
       *
       * <pre>
       * Counter: the number of FIFO errors
       * </pre>
       */
      public boolean hasIfInFifoErrors() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       * <code>optional uint64 if_in_fifo_errors = 9;</code>
       *
       * <pre>
       * Counter: the number of FIFO errors
       * </pre>
       */
      public long getIfInFifoErrors() {
        return ifInFifoErrors_;
      }
      /**
       * <code>optional uint64 if_in_fifo_errors = 9;</code>
       *
       * <pre>
       * Counter: the number of FIFO errors
       * </pre>
       */
      public Builder setIfInFifoErrors(long value) {
        bitField0_ |= 0x00000100;
        ifInFifoErrors_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 if_in_fifo_errors = 9;</code>
       *
       * <pre>
       * Counter: the number of FIFO errors
       * </pre>
       */
      public Builder clearIfInFifoErrors() {
        bitField0_ = (bitField0_ & ~0x00000100);
        ifInFifoErrors_ = 0L;
        onChanged();
        return this;
      }

      private long ifInResourceErrors_ ;
      /**
       * <code>optional uint64 if_in_resource_errors = 10;</code>
       *
       * <pre>
       * Counter: the number of resourceerrors
       * </pre>
       */
      public boolean hasIfInResourceErrors() {
        return ((bitField0_ & 0x00000200) == 0x00000200);
      }
      /**
       * <code>optional uint64 if_in_resource_errors = 10;</code>
       *
       * <pre>
       * Counter: the number of resourceerrors
       * </pre>
       */
      public long getIfInResourceErrors() {
        return ifInResourceErrors_;
      }
      /**
       * <code>optional uint64 if_in_resource_errors = 10;</code>
       *
       * <pre>
       * Counter: the number of resourceerrors
       * </pre>
       */
      public Builder setIfInResourceErrors(long value) {
        bitField0_ |= 0x00000200;
        ifInResourceErrors_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 if_in_resource_errors = 10;</code>
       *
       * <pre>
       * Counter: the number of resourceerrors
       * </pre>
       */
      public Builder clearIfInResourceErrors() {
        bitField0_ = (bitField0_ & ~0x00000200);
        ifInResourceErrors_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:IngressInterfaceErrors)
    }

    static {
      defaultInstance = new IngressInterfaceErrors(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:IngressInterfaceErrors)
  }

  public interface QueueStatsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:QueueStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional uint32 queue_number = 1;</code>
     */
    boolean hasQueueNumber();
    /**
     * <code>optional uint32 queue_number = 1;</code>
     */
    int getQueueNumber();

    /**
     * <code>optional uint64 packets = 2;</code>
     *
     * <pre>
     * Counter: the total number of packets that have been added to this queue
     * </pre>
     */
    boolean hasPackets();
    /**
     * <code>optional uint64 packets = 2;</code>
     *
     * <pre>
     * Counter: the total number of packets that have been added to this queue
     * </pre>
     */
    long getPackets();

    /**
     * <code>optional uint64 bytes = 3;</code>
     *
     * <pre>
     * Counter: the total number of bytes that have been added to this queue
     * </pre>
     */
    boolean hasBytes();
    /**
     * <code>optional uint64 bytes = 3;</code>
     *
     * <pre>
     * Counter: the total number of bytes that have been added to this queue
     * </pre>
     */
    long getBytes();

    /**
     * <code>optional uint64 tail_drop_packets = 4;</code>
     *
     * <pre>
     * Counter: the total number of tail dropped packets
     * </pre>
     */
    boolean hasTailDropPackets();
    /**
     * <code>optional uint64 tail_drop_packets = 4;</code>
     *
     * <pre>
     * Counter: the total number of tail dropped packets
     * </pre>
     */
    long getTailDropPackets();

    /**
     * <code>optional uint64 rl_drop_packets = 5;</code>
     *
     * <pre>
     * Counter: the total number of rate-limitd packets
     * </pre>
     */
    boolean hasRlDropPackets();
    /**
     * <code>optional uint64 rl_drop_packets = 5;</code>
     *
     * <pre>
     * Counter: the total number of rate-limitd packets
     * </pre>
     */
    long getRlDropPackets();

    /**
     * <code>optional uint64 rl_drop_bytes = 6;</code>
     *
     * <pre>
     * Counter: the total number of rate-limited bytes
     * </pre>
     */
    boolean hasRlDropBytes();
    /**
     * <code>optional uint64 rl_drop_bytes = 6;</code>
     *
     * <pre>
     * Counter: the total number of rate-limited bytes
     * </pre>
     */
    long getRlDropBytes();

    /**
     * <code>optional uint64 red_drop_packets = 7;</code>
     *
     * <pre>
     * Counter: the total number of red-dropped packets
     * </pre>
     */
    boolean hasRedDropPackets();
    /**
     * <code>optional uint64 red_drop_packets = 7;</code>
     *
     * <pre>
     * Counter: the total number of red-dropped packets
     * </pre>
     */
    long getRedDropPackets();

    /**
     * <code>optional uint64 red_drop_bytes = 8;</code>
     *
     * <pre>
     * Counter: the total number of red-dropped bytes
     * </pre>
     */
    boolean hasRedDropBytes();
    /**
     * <code>optional uint64 red_drop_bytes = 8;</code>
     *
     * <pre>
     * Counter: the total number of red-dropped bytes
     * </pre>
     */
    long getRedDropBytes();

    /**
     * <code>optional uint64 avg_buffer_occupancy = 9;</code>
     *
     * <pre>
     * Average: avg queue depth,TAQL:time-average-queue-len, in packets, details TBD
     * </pre>
     */
    boolean hasAvgBufferOccupancy();
    /**
     * <code>optional uint64 avg_buffer_occupancy = 9;</code>
     *
     * <pre>
     * Average: avg queue depth,TAQL:time-average-queue-len, in packets, details TBD
     * </pre>
     */
    long getAvgBufferOccupancy();

    /**
     * <code>optional uint64 cur_buffer_occupancy = 10;</code>
     *
     * <pre>
     * Gauge: current queue depth, in packets
     * </pre>
     */
    boolean hasCurBufferOccupancy();
    /**
     * <code>optional uint64 cur_buffer_occupancy = 10;</code>
     *
     * <pre>
     * Gauge: current queue depth, in packets
     * </pre>
     */
    long getCurBufferOccupancy();

    /**
     * <code>optional uint64 peak_buffer_occupancy = 11;</code>
     *
     * <pre>
     * Peak: the max measured queue depth, in packets, across all measurements since bo ot.
     * </pre>
     */
    boolean hasPeakBufferOccupancy();
    /**
     * <code>optional uint64 peak_buffer_occupancy = 11;</code>
     *
     * <pre>
     * Peak: the max measured queue depth, in packets, across all measurements since bo ot.
     * </pre>
     */
    long getPeakBufferOccupancy();

    /**
     * <code>optional uint64 allocated_buffer_size = 12;</code>
     *
     * <pre>
     * allocated buffer size
     * </pre>
     */
    boolean hasAllocatedBufferSize();
    /**
     * <code>optional uint64 allocated_buffer_size = 12;</code>
     *
     * <pre>
     * allocated buffer size
     * </pre>
     */
    long getAllocatedBufferSize();
  }
  /**
   * Protobuf type {@code QueueStats}
   */
  public static final class QueueStats extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:QueueStats)
      QueueStatsOrBuilder {
    // Use QueueStats.newBuilder() to construct.
    private QueueStats(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private QueueStats(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final QueueStats defaultInstance;
    public static QueueStats getDefaultInstance() {
      return defaultInstance;
    }

    public QueueStats getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private QueueStats(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              queueNumber_ = input.readUInt32();
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              packets_ = input.readUInt64();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              bytes_ = input.readUInt64();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              tailDropPackets_ = input.readUInt64();
              break;
            }
            case 40: {
              bitField0_ |= 0x00000010;
              rlDropPackets_ = input.readUInt64();
              break;
            }
            case 48: {
              bitField0_ |= 0x00000020;
              rlDropBytes_ = input.readUInt64();
              break;
            }
            case 56: {
              bitField0_ |= 0x00000040;
              redDropPackets_ = input.readUInt64();
              break;
            }
            case 64: {
              bitField0_ |= 0x00000080;
              redDropBytes_ = input.readUInt64();
              break;
            }
            case 72: {
              bitField0_ |= 0x00000100;
              avgBufferOccupancy_ = input.readUInt64();
              break;
            }
            case 80: {
              bitField0_ |= 0x00000200;
              curBufferOccupancy_ = input.readUInt64();
              break;
            }
            case 88: {
              bitField0_ |= 0x00000400;
              peakBufferOccupancy_ = input.readUInt64();
              break;
            }
            case 96: {
              bitField0_ |= 0x00000800;
              allocatedBufferSize_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return Port.internal_static_QueueStats_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return Port.internal_static_QueueStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              Port.QueueStats.class, Port.QueueStats.Builder.class);
    }

    public static com.google.protobuf.Parser<QueueStats> PARSER =
        new com.google.protobuf.AbstractParser<QueueStats>() {
      public QueueStats parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new QueueStats(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<QueueStats> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int QUEUE_NUMBER_FIELD_NUMBER = 1;
    private int queueNumber_;
    /**
     * <code>optional uint32 queue_number = 1;</code>
     */
    public boolean hasQueueNumber() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional uint32 queue_number = 1;</code>
     */
    public int getQueueNumber() {
      return queueNumber_;
    }

    public static final int PACKETS_FIELD_NUMBER = 2;
    private long packets_;
    /**
     * <code>optional uint64 packets = 2;</code>
     *
     * <pre>
     * Counter: the total number of packets that have been added to this queue
     * </pre>
     */
    public boolean hasPackets() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional uint64 packets = 2;</code>
     *
     * <pre>
     * Counter: the total number of packets that have been added to this queue
     * </pre>
     */
    public long getPackets() {
      return packets_;
    }

    public static final int BYTES_FIELD_NUMBER = 3;
    private long bytes_;
    /**
     * <code>optional uint64 bytes = 3;</code>
     *
     * <pre>
     * Counter: the total number of bytes that have been added to this queue
     * </pre>
     */
    public boolean hasBytes() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint64 bytes = 3;</code>
     *
     * <pre>
     * Counter: the total number of bytes that have been added to this queue
     * </pre>
     */
    public long getBytes() {
      return bytes_;
    }

    public static final int TAIL_DROP_PACKETS_FIELD_NUMBER = 4;
    private long tailDropPackets_;
    /**
     * <code>optional uint64 tail_drop_packets = 4;</code>
     *
     * <pre>
     * Counter: the total number of tail dropped packets
     * </pre>
     */
    public boolean hasTailDropPackets() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional uint64 tail_drop_packets = 4;</code>
     *
     * <pre>
     * Counter: the total number of tail dropped packets
     * </pre>
     */
    public long getTailDropPackets() {
      return tailDropPackets_;
    }

    public static final int RL_DROP_PACKETS_FIELD_NUMBER = 5;
    private long rlDropPackets_;
    /**
     * <code>optional uint64 rl_drop_packets = 5;</code>
     *
     * <pre>
     * Counter: the total number of rate-limitd packets
     * </pre>
     */
    public boolean hasRlDropPackets() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional uint64 rl_drop_packets = 5;</code>
     *
     * <pre>
     * Counter: the total number of rate-limitd packets
     * </pre>
     */
    public long getRlDropPackets() {
      return rlDropPackets_;
    }

    public static final int RL_DROP_BYTES_FIELD_NUMBER = 6;
    private long rlDropBytes_;
    /**
     * <code>optional uint64 rl_drop_bytes = 6;</code>
     *
     * <pre>
     * Counter: the total number of rate-limited bytes
     * </pre>
     */
    public boolean hasRlDropBytes() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional uint64 rl_drop_bytes = 6;</code>
     *
     * <pre>
     * Counter: the total number of rate-limited bytes
     * </pre>
     */
    public long getRlDropBytes() {
      return rlDropBytes_;
    }

    public static final int RED_DROP_PACKETS_FIELD_NUMBER = 7;
    private long redDropPackets_;
    /**
     * <code>optional uint64 red_drop_packets = 7;</code>
     *
     * <pre>
     * Counter: the total number of red-dropped packets
     * </pre>
     */
    public boolean hasRedDropPackets() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional uint64 red_drop_packets = 7;</code>
     *
     * <pre>
     * Counter: the total number of red-dropped packets
     * </pre>
     */
    public long getRedDropPackets() {
      return redDropPackets_;
    }

    public static final int RED_DROP_BYTES_FIELD_NUMBER = 8;
    private long redDropBytes_;
    /**
     * <code>optional uint64 red_drop_bytes = 8;</code>
     *
     * <pre>
     * Counter: the total number of red-dropped bytes
     * </pre>
     */
    public boolean hasRedDropBytes() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     * <code>optional uint64 red_drop_bytes = 8;</code>
     *
     * <pre>
     * Counter: the total number of red-dropped bytes
     * </pre>
     */
    public long getRedDropBytes() {
      return redDropBytes_;
    }

    public static final int AVG_BUFFER_OCCUPANCY_FIELD_NUMBER = 9;
    private long avgBufferOccupancy_;
    /**
     * <code>optional uint64 avg_buffer_occupancy = 9;</code>
     *
     * <pre>
     * Average: avg queue depth,TAQL:time-average-queue-len, in packets, details TBD
     * </pre>
     */
    public boolean hasAvgBufferOccupancy() {
      return ((bitField0_ & 0x00000100) == 0x00000100);
    }
    /**
     * <code>optional uint64 avg_buffer_occupancy = 9;</code>
     *
     * <pre>
     * Average: avg queue depth,TAQL:time-average-queue-len, in packets, details TBD
     * </pre>
     */
    public long getAvgBufferOccupancy() {
      return avgBufferOccupancy_;
    }

    public static final int CUR_BUFFER_OCCUPANCY_FIELD_NUMBER = 10;
    private long curBufferOccupancy_;
    /**
     * <code>optional uint64 cur_buffer_occupancy = 10;</code>
     *
     * <pre>
     * Gauge: current queue depth, in packets
     * </pre>
     */
    public boolean hasCurBufferOccupancy() {
      return ((bitField0_ & 0x00000200) == 0x00000200);
    }
    /**
     * <code>optional uint64 cur_buffer_occupancy = 10;</code>
     *
     * <pre>
     * Gauge: current queue depth, in packets
     * </pre>
     */
    public long getCurBufferOccupancy() {
      return curBufferOccupancy_;
    }

    public static final int PEAK_BUFFER_OCCUPANCY_FIELD_NUMBER = 11;
    private long peakBufferOccupancy_;
    /**
     * <code>optional uint64 peak_buffer_occupancy = 11;</code>
     *
     * <pre>
     * Peak: the max measured queue depth, in packets, across all measurements since bo ot.
     * </pre>
     */
    public boolean hasPeakBufferOccupancy() {
      return ((bitField0_ & 0x00000400) == 0x00000400);
    }
    /**
     * <code>optional uint64 peak_buffer_occupancy = 11;</code>
     *
     * <pre>
     * Peak: the max measured queue depth, in packets, across all measurements since bo ot.
     * </pre>
     */
    public long getPeakBufferOccupancy() {
      return peakBufferOccupancy_;
    }

    public static final int ALLOCATED_BUFFER_SIZE_FIELD_NUMBER = 12;
    private long allocatedBufferSize_;
    /**
     * <code>optional uint64 allocated_buffer_size = 12;</code>
     *
     * <pre>
     * allocated buffer size
     * </pre>
     */
    public boolean hasAllocatedBufferSize() {
      return ((bitField0_ & 0x00000800) == 0x00000800);
    }
    /**
     * <code>optional uint64 allocated_buffer_size = 12;</code>
     *
     * <pre>
     * allocated buffer size
     * </pre>
     */
    public long getAllocatedBufferSize() {
      return allocatedBufferSize_;
    }

    private void initFields() {
      queueNumber_ = 0;
      packets_ = 0L;
      bytes_ = 0L;
      tailDropPackets_ = 0L;
      rlDropPackets_ = 0L;
      rlDropBytes_ = 0L;
      redDropPackets_ = 0L;
      redDropBytes_ = 0L;
      avgBufferOccupancy_ = 0L;
      curBufferOccupancy_ = 0L;
      peakBufferOccupancy_ = 0L;
      allocatedBufferSize_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeUInt32(1, queueNumber_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, packets_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt64(3, bytes_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeUInt64(4, tailDropPackets_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeUInt64(5, rlDropPackets_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeUInt64(6, rlDropBytes_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeUInt64(7, redDropPackets_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeUInt64(8, redDropBytes_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        output.writeUInt64(9, avgBufferOccupancy_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        output.writeUInt64(10, curBufferOccupancy_);
      }
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        output.writeUInt64(11, peakBufferOccupancy_);
      }
      if (((bitField0_ & 0x00000800) == 0x00000800)) {
        output.writeUInt64(12, allocatedBufferSize_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, queueNumber_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, packets_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, bytes_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(4, tailDropPackets_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(5, rlDropPackets_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(6, rlDropBytes_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(7, redDropPackets_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(8, redDropBytes_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(9, avgBufferOccupancy_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(10, curBufferOccupancy_);
      }
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(11, peakBufferOccupancy_);
      }
      if (((bitField0_ & 0x00000800) == 0x00000800)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(12, allocatedBufferSize_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static Port.QueueStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Port.QueueStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Port.QueueStats parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Port.QueueStats parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Port.QueueStats parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Port.QueueStats parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static Port.QueueStats parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static Port.QueueStats parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static Port.QueueStats parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Port.QueueStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(Port.QueueStats prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code QueueStats}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:QueueStats)
        Port.QueueStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return Port.internal_static_QueueStats_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return Port.internal_static_QueueStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                Port.QueueStats.class, Port.QueueStats.Builder.class);
      }

      // Construct using Port.QueueStats.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        queueNumber_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        packets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        bytes_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        tailDropPackets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000008);
        rlDropPackets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000010);
        rlDropBytes_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000020);
        redDropPackets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000040);
        redDropBytes_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000080);
        avgBufferOccupancy_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000100);
        curBufferOccupancy_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000200);
        peakBufferOccupancy_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000400);
        allocatedBufferSize_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000800);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return Port.internal_static_QueueStats_descriptor;
      }

      public Port.QueueStats getDefaultInstanceForType() {
        return Port.QueueStats.getDefaultInstance();
      }

      public Port.QueueStats build() {
        Port.QueueStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public Port.QueueStats buildPartial() {
        Port.QueueStats result = new Port.QueueStats(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.queueNumber_ = queueNumber_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.packets_ = packets_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.bytes_ = bytes_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.tailDropPackets_ = tailDropPackets_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.rlDropPackets_ = rlDropPackets_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.rlDropBytes_ = rlDropBytes_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.redDropPackets_ = redDropPackets_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000080;
        }
        result.redDropBytes_ = redDropBytes_;
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000100;
        }
        result.avgBufferOccupancy_ = avgBufferOccupancy_;
        if (((from_bitField0_ & 0x00000200) == 0x00000200)) {
          to_bitField0_ |= 0x00000200;
        }
        result.curBufferOccupancy_ = curBufferOccupancy_;
        if (((from_bitField0_ & 0x00000400) == 0x00000400)) {
          to_bitField0_ |= 0x00000400;
        }
        result.peakBufferOccupancy_ = peakBufferOccupancy_;
        if (((from_bitField0_ & 0x00000800) == 0x00000800)) {
          to_bitField0_ |= 0x00000800;
        }
        result.allocatedBufferSize_ = allocatedBufferSize_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof Port.QueueStats) {
          return mergeFrom((Port.QueueStats)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(Port.QueueStats other) {
        if (other == Port.QueueStats.getDefaultInstance()) return this;
        if (other.hasQueueNumber()) {
          setQueueNumber(other.getQueueNumber());
        }
        if (other.hasPackets()) {
          setPackets(other.getPackets());
        }
        if (other.hasBytes()) {
          setBytes(other.getBytes());
        }
        if (other.hasTailDropPackets()) {
          setTailDropPackets(other.getTailDropPackets());
        }
        if (other.hasRlDropPackets()) {
          setRlDropPackets(other.getRlDropPackets());
        }
        if (other.hasRlDropBytes()) {
          setRlDropBytes(other.getRlDropBytes());
        }
        if (other.hasRedDropPackets()) {
          setRedDropPackets(other.getRedDropPackets());
        }
        if (other.hasRedDropBytes()) {
          setRedDropBytes(other.getRedDropBytes());
        }
        if (other.hasAvgBufferOccupancy()) {
          setAvgBufferOccupancy(other.getAvgBufferOccupancy());
        }
        if (other.hasCurBufferOccupancy()) {
          setCurBufferOccupancy(other.getCurBufferOccupancy());
        }
        if (other.hasPeakBufferOccupancy()) {
          setPeakBufferOccupancy(other.getPeakBufferOccupancy());
        }
        if (other.hasAllocatedBufferSize()) {
          setAllocatedBufferSize(other.getAllocatedBufferSize());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        Port.QueueStats parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (Port.QueueStats) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private int queueNumber_ ;
      /**
       * <code>optional uint32 queue_number = 1;</code>
       */
      public boolean hasQueueNumber() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional uint32 queue_number = 1;</code>
       */
      public int getQueueNumber() {
        return queueNumber_;
      }
      /**
       * <code>optional uint32 queue_number = 1;</code>
       */
      public Builder setQueueNumber(int value) {
        bitField0_ |= 0x00000001;
        queueNumber_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 queue_number = 1;</code>
       */
      public Builder clearQueueNumber() {
        bitField0_ = (bitField0_ & ~0x00000001);
        queueNumber_ = 0;
        onChanged();
        return this;
      }

      private long packets_ ;
      /**
       * <code>optional uint64 packets = 2;</code>
       *
       * <pre>
       * Counter: the total number of packets that have been added to this queue
       * </pre>
       */
      public boolean hasPackets() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint64 packets = 2;</code>
       *
       * <pre>
       * Counter: the total number of packets that have been added to this queue
       * </pre>
       */
      public long getPackets() {
        return packets_;
      }
      /**
       * <code>optional uint64 packets = 2;</code>
       *
       * <pre>
       * Counter: the total number of packets that have been added to this queue
       * </pre>
       */
      public Builder setPackets(long value) {
        bitField0_ |= 0x00000002;
        packets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 packets = 2;</code>
       *
       * <pre>
       * Counter: the total number of packets that have been added to this queue
       * </pre>
       */
      public Builder clearPackets() {
        bitField0_ = (bitField0_ & ~0x00000002);
        packets_ = 0L;
        onChanged();
        return this;
      }

      private long bytes_ ;
      /**
       * <code>optional uint64 bytes = 3;</code>
       *
       * <pre>
       * Counter: the total number of bytes that have been added to this queue
       * </pre>
       */
      public boolean hasBytes() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint64 bytes = 3;</code>
       *
       * <pre>
       * Counter: the total number of bytes that have been added to this queue
       * </pre>
       */
      public long getBytes() {
        return bytes_;
      }
      /**
       * <code>optional uint64 bytes = 3;</code>
       *
       * <pre>
       * Counter: the total number of bytes that have been added to this queue
       * </pre>
       */
      public Builder setBytes(long value) {
        bitField0_ |= 0x00000004;
        bytes_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 bytes = 3;</code>
       *
       * <pre>
       * Counter: the total number of bytes that have been added to this queue
       * </pre>
       */
      public Builder clearBytes() {
        bitField0_ = (bitField0_ & ~0x00000004);
        bytes_ = 0L;
        onChanged();
        return this;
      }

      private long tailDropPackets_ ;
      /**
       * <code>optional uint64 tail_drop_packets = 4;</code>
       *
       * <pre>
       * Counter: the total number of tail dropped packets
       * </pre>
       */
      public boolean hasTailDropPackets() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional uint64 tail_drop_packets = 4;</code>
       *
       * <pre>
       * Counter: the total number of tail dropped packets
       * </pre>
       */
      public long getTailDropPackets() {
        return tailDropPackets_;
      }
      /**
       * <code>optional uint64 tail_drop_packets = 4;</code>
       *
       * <pre>
       * Counter: the total number of tail dropped packets
       * </pre>
       */
      public Builder setTailDropPackets(long value) {
        bitField0_ |= 0x00000008;
        tailDropPackets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 tail_drop_packets = 4;</code>
       *
       * <pre>
       * Counter: the total number of tail dropped packets
       * </pre>
       */
      public Builder clearTailDropPackets() {
        bitField0_ = (bitField0_ & ~0x00000008);
        tailDropPackets_ = 0L;
        onChanged();
        return this;
      }

      private long rlDropPackets_ ;
      /**
       * <code>optional uint64 rl_drop_packets = 5;</code>
       *
       * <pre>
       * Counter: the total number of rate-limitd packets
       * </pre>
       */
      public boolean hasRlDropPackets() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional uint64 rl_drop_packets = 5;</code>
       *
       * <pre>
       * Counter: the total number of rate-limitd packets
       * </pre>
       */
      public long getRlDropPackets() {
        return rlDropPackets_;
      }
      /**
       * <code>optional uint64 rl_drop_packets = 5;</code>
       *
       * <pre>
       * Counter: the total number of rate-limitd packets
       * </pre>
       */
      public Builder setRlDropPackets(long value) {
        bitField0_ |= 0x00000010;
        rlDropPackets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 rl_drop_packets = 5;</code>
       *
       * <pre>
       * Counter: the total number of rate-limitd packets
       * </pre>
       */
      public Builder clearRlDropPackets() {
        bitField0_ = (bitField0_ & ~0x00000010);
        rlDropPackets_ = 0L;
        onChanged();
        return this;
      }

      private long rlDropBytes_ ;
      /**
       * <code>optional uint64 rl_drop_bytes = 6;</code>
       *
       * <pre>
       * Counter: the total number of rate-limited bytes
       * </pre>
       */
      public boolean hasRlDropBytes() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional uint64 rl_drop_bytes = 6;</code>
       *
       * <pre>
       * Counter: the total number of rate-limited bytes
       * </pre>
       */
      public long getRlDropBytes() {
        return rlDropBytes_;
      }
      /**
       * <code>optional uint64 rl_drop_bytes = 6;</code>
       *
       * <pre>
       * Counter: the total number of rate-limited bytes
       * </pre>
       */
      public Builder setRlDropBytes(long value) {
        bitField0_ |= 0x00000020;
        rlDropBytes_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 rl_drop_bytes = 6;</code>
       *
       * <pre>
       * Counter: the total number of rate-limited bytes
       * </pre>
       */
      public Builder clearRlDropBytes() {
        bitField0_ = (bitField0_ & ~0x00000020);
        rlDropBytes_ = 0L;
        onChanged();
        return this;
      }

      private long redDropPackets_ ;
      /**
       * <code>optional uint64 red_drop_packets = 7;</code>
       *
       * <pre>
       * Counter: the total number of red-dropped packets
       * </pre>
       */
      public boolean hasRedDropPackets() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional uint64 red_drop_packets = 7;</code>
       *
       * <pre>
       * Counter: the total number of red-dropped packets
       * </pre>
       */
      public long getRedDropPackets() {
        return redDropPackets_;
      }
      /**
       * <code>optional uint64 red_drop_packets = 7;</code>
       *
       * <pre>
       * Counter: the total number of red-dropped packets
       * </pre>
       */
      public Builder setRedDropPackets(long value) {
        bitField0_ |= 0x00000040;
        redDropPackets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 red_drop_packets = 7;</code>
       *
       * <pre>
       * Counter: the total number of red-dropped packets
       * </pre>
       */
      public Builder clearRedDropPackets() {
        bitField0_ = (bitField0_ & ~0x00000040);
        redDropPackets_ = 0L;
        onChanged();
        return this;
      }

      private long redDropBytes_ ;
      /**
       * <code>optional uint64 red_drop_bytes = 8;</code>
       *
       * <pre>
       * Counter: the total number of red-dropped bytes
       * </pre>
       */
      public boolean hasRedDropBytes() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional uint64 red_drop_bytes = 8;</code>
       *
       * <pre>
       * Counter: the total number of red-dropped bytes
       * </pre>
       */
      public long getRedDropBytes() {
        return redDropBytes_;
      }
      /**
       * <code>optional uint64 red_drop_bytes = 8;</code>
       *
       * <pre>
       * Counter: the total number of red-dropped bytes
       * </pre>
       */
      public Builder setRedDropBytes(long value) {
        bitField0_ |= 0x00000080;
        redDropBytes_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 red_drop_bytes = 8;</code>
       *
       * <pre>
       * Counter: the total number of red-dropped bytes
       * </pre>
       */
      public Builder clearRedDropBytes() {
        bitField0_ = (bitField0_ & ~0x00000080);
        redDropBytes_ = 0L;
        onChanged();
        return this;
      }

      private long avgBufferOccupancy_ ;
      /**
       * <code>optional uint64 avg_buffer_occupancy = 9;</code>
       *
       * <pre>
       * Average: avg queue depth,TAQL:time-average-queue-len, in packets, details TBD
       * </pre>
       */
      public boolean hasAvgBufferOccupancy() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       * <code>optional uint64 avg_buffer_occupancy = 9;</code>
       *
       * <pre>
       * Average: avg queue depth,TAQL:time-average-queue-len, in packets, details TBD
       * </pre>
       */
      public long getAvgBufferOccupancy() {
        return avgBufferOccupancy_;
      }
      /**
       * <code>optional uint64 avg_buffer_occupancy = 9;</code>
       *
       * <pre>
       * Average: avg queue depth,TAQL:time-average-queue-len, in packets, details TBD
       * </pre>
       */
      public Builder setAvgBufferOccupancy(long value) {
        bitField0_ |= 0x00000100;
        avgBufferOccupancy_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 avg_buffer_occupancy = 9;</code>
       *
       * <pre>
       * Average: avg queue depth,TAQL:time-average-queue-len, in packets, details TBD
       * </pre>
       */
      public Builder clearAvgBufferOccupancy() {
        bitField0_ = (bitField0_ & ~0x00000100);
        avgBufferOccupancy_ = 0L;
        onChanged();
        return this;
      }

      private long curBufferOccupancy_ ;
      /**
       * <code>optional uint64 cur_buffer_occupancy = 10;</code>
       *
       * <pre>
       * Gauge: current queue depth, in packets
       * </pre>
       */
      public boolean hasCurBufferOccupancy() {
        return ((bitField0_ & 0x00000200) == 0x00000200);
      }
      /**
       * <code>optional uint64 cur_buffer_occupancy = 10;</code>
       *
       * <pre>
       * Gauge: current queue depth, in packets
       * </pre>
       */
      public long getCurBufferOccupancy() {
        return curBufferOccupancy_;
      }
      /**
       * <code>optional uint64 cur_buffer_occupancy = 10;</code>
       *
       * <pre>
       * Gauge: current queue depth, in packets
       * </pre>
       */
      public Builder setCurBufferOccupancy(long value) {
        bitField0_ |= 0x00000200;
        curBufferOccupancy_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 cur_buffer_occupancy = 10;</code>
       *
       * <pre>
       * Gauge: current queue depth, in packets
       * </pre>
       */
      public Builder clearCurBufferOccupancy() {
        bitField0_ = (bitField0_ & ~0x00000200);
        curBufferOccupancy_ = 0L;
        onChanged();
        return this;
      }

      private long peakBufferOccupancy_ ;
      /**
       * <code>optional uint64 peak_buffer_occupancy = 11;</code>
       *
       * <pre>
       * Peak: the max measured queue depth, in packets, across all measurements since bo ot.
       * </pre>
       */
      public boolean hasPeakBufferOccupancy() {
        return ((bitField0_ & 0x00000400) == 0x00000400);
      }
      /**
       * <code>optional uint64 peak_buffer_occupancy = 11;</code>
       *
       * <pre>
       * Peak: the max measured queue depth, in packets, across all measurements since bo ot.
       * </pre>
       */
      public long getPeakBufferOccupancy() {
        return peakBufferOccupancy_;
      }
      /**
       * <code>optional uint64 peak_buffer_occupancy = 11;</code>
       *
       * <pre>
       * Peak: the max measured queue depth, in packets, across all measurements since bo ot.
       * </pre>
       */
      public Builder setPeakBufferOccupancy(long value) {
        bitField0_ |= 0x00000400;
        peakBufferOccupancy_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 peak_buffer_occupancy = 11;</code>
       *
       * <pre>
       * Peak: the max measured queue depth, in packets, across all measurements since bo ot.
       * </pre>
       */
      public Builder clearPeakBufferOccupancy() {
        bitField0_ = (bitField0_ & ~0x00000400);
        peakBufferOccupancy_ = 0L;
        onChanged();
        return this;
      }

      private long allocatedBufferSize_ ;
      /**
       * <code>optional uint64 allocated_buffer_size = 12;</code>
       *
       * <pre>
       * allocated buffer size
       * </pre>
       */
      public boolean hasAllocatedBufferSize() {
        return ((bitField0_ & 0x00000800) == 0x00000800);
      }
      /**
       * <code>optional uint64 allocated_buffer_size = 12;</code>
       *
       * <pre>
       * allocated buffer size
       * </pre>
       */
      public long getAllocatedBufferSize() {
        return allocatedBufferSize_;
      }
      /**
       * <code>optional uint64 allocated_buffer_size = 12;</code>
       *
       * <pre>
       * allocated buffer size
       * </pre>
       */
      public Builder setAllocatedBufferSize(long value) {
        bitField0_ |= 0x00000800;
        allocatedBufferSize_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 allocated_buffer_size = 12;</code>
       *
       * <pre>
       * allocated buffer size
       * </pre>
       */
      public Builder clearAllocatedBufferSize() {
        bitField0_ = (bitField0_ & ~0x00000800);
        allocatedBufferSize_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:QueueStats)
    }

    static {
      defaultInstance = new QueueStats(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:QueueStats)
  }

  public static final int JNPR_INTERFACE_EXT_FIELD_NUMBER = 3;
  /**
   * <code>extend .JuniperNetworksSensors { ... }</code>
   */
  public static final
    com.google.protobuf.GeneratedMessage.GeneratedExtension<
      TelemetryTop.JuniperNetworksSensors,
      Port.GPort> jnprInterfaceExt = com.google.protobuf.GeneratedMessage
          .newFileScopedGeneratedExtension(
        Port.GPort.class,
        Port.GPort.getDefaultInstance());
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_GPort_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_GPort_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_InterfaceInfos_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_InterfaceInfos_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_InterfaceStats_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_InterfaceStats_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_IngressInterfaceErrors_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_IngressInterfaceErrors_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_QueueStats_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_QueueStats_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\nport.proto\032\023telemetry_top.proto\"1\n\005GPo" +
      "rt\022(\n\017interface_stats\030\001 \003(\0132\017.InterfaceI" +
      "nfos\"\273\002\n\016InterfaceInfos\022\026\n\007if_name\030\001 \002(\t" +
      "B\005\202@\002\010\001\022\021\n\tinit_time\030\002 \002(\004\022\025\n\rsnmp_if_in" +
      "dex\030\003 \001(\r\022\026\n\016parent_ae_name\030\004 \001(\t\022&\n\021egr" +
      "ess_queue_info\030\005 \003(\0132\013.QueueStats\022\'\n\022ing" +
      "ress_queue_info\030\006 \003(\0132\013.QueueStats\022&\n\rin" +
      "gress_stats\030\007 \001(\0132\017.InterfaceStats\022%\n\014eg" +
      "ress_stats\030\010 \001(\0132\017.InterfaceStats\022/\n\016ing" +
      "ress_errors\030\t \001(\0132\027.IngressInterfaceErro",
      "rs\"\317\001\n\016InterfaceStats\022\026\n\007if_pkts\030\001 \002(\004B\005" +
      "\202@\002\030\001\022\030\n\tif_octets\030\002 \002(\004B\005\202@\002\030\001\022\033\n\014if_1s" +
      "ec_pkts\030\003 \002(\004B\005\202@\002 \001\022\035\n\016if_1sec_octets\030\004" +
      " \002(\004B\005\202@\002 \001\022\031\n\nif_uc_pkts\030\005 \002(\004B\005\202@\002\030\001\022\031" +
      "\n\nif_mc_pkts\030\006 \002(\004B\005\202@\002\030\001\022\031\n\nif_bc_pkts\030" +
      "\007 \002(\004B\005\202@\002\030\001\"\354\002\n\026IngressInterfaceErrors\022" +
      "\033\n\014if_in_errors\030\001 \001(\004B\005\202@\002\030\001\022\033\n\014if_in_qd" +
      "rops\030\002 \001(\004B\005\202@\002\030\001\022!\n\022if_in_frame_errors\030" +
      "\003 \001(\004B\005\202@\002\030\001\022\035\n\016if_in_discards\030\004 \001(\004B\005\202@" +
      "\002\030\001\022\032\n\013if_in_runts\030\005 \001(\004B\005\202@\002\030\001\022#\n\024if_in",
      "_l3_incompletes\030\006 \001(\004B\005\202@\002\030\001\022\"\n\023if_in_l2" +
      "chan_errors\030\007 \001(\004B\005\202@\002\030\001\022)\n\032if_in_l2_mis" +
      "match_timeouts\030\010 \001(\004B\005\202@\002\030\001\022 \n\021if_in_fif" +
      "o_errors\030\t \001(\004B\005\202@\002\030\001\022$\n\025if_in_resource_" +
      "errors\030\n \001(\004B\005\202@\002\030\001\"\215\003\n\nQueueStats\022\033\n\014qu" +
      "eue_number\030\001 \001(\rB\005\202@\002\010\001\022\026\n\007packets\030\002 \001(\004" +
      "B\005\202@\002\030\001\022\024\n\005bytes\030\003 \001(\004B\005\202@\002\030\001\022 \n\021tail_dr" +
      "op_packets\030\004 \001(\004B\005\202@\002\030\001\022\036\n\017rl_drop_packe" +
      "ts\030\005 \001(\004B\005\202@\002\030\001\022\034\n\rrl_drop_bytes\030\006 \001(\004B\005" +
      "\202@\002\030\001\022\037\n\020red_drop_packets\030\007 \001(\004B\005\202@\002\030\001\022\035",
      "\n\016red_drop_bytes\030\010 \001(\004B\005\202@\002\030\001\022#\n\024avg_buf" +
      "fer_occupancy\030\t \001(\004B\005\202@\002 \001\022#\n\024cur_buffer" +
      "_occupancy\030\n \001(\004B\005\202@\002 \001\022$\n\025peak_buffer_o" +
      "ccupancy\030\013 \001(\004B\005\202@\002 \001\022$\n\025allocated_buffe" +
      "r_size\030\014 \001(\004B\005\202@\002 \001:;\n\022jnpr_interface_ex" +
      "t\022\027.JuniperNetworksSensors\030\003 \001(\0132\006.GPort"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          TelemetryTop.getDescriptor(),
        }, assigner);
    internal_static_GPort_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_GPort_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_GPort_descriptor,
        new java.lang.String[] { "InterfaceStats", });
    internal_static_InterfaceInfos_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_InterfaceInfos_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_InterfaceInfos_descriptor,
        new java.lang.String[] { "IfName", "InitTime", "SnmpIfIndex", "ParentAeName", "EgressQueueInfo", "IngressQueueInfo", "IngressStats", "EgressStats", "IngressErrors", });
    internal_static_InterfaceStats_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_InterfaceStats_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_InterfaceStats_descriptor,
        new java.lang.String[] { "IfPkts", "IfOctets", "If1SecPkts", "If1SecOctets", "IfUcPkts", "IfMcPkts", "IfBcPkts", });
    internal_static_IngressInterfaceErrors_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_IngressInterfaceErrors_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_IngressInterfaceErrors_descriptor,
        new java.lang.String[] { "IfInErrors", "IfInQdrops", "IfInFrameErrors", "IfInDiscards", "IfInRunts", "IfInL3Incompletes", "IfInL2ChanErrors", "IfInL2MismatchTimeouts", "IfInFifoErrors", "IfInResourceErrors", });
    internal_static_QueueStats_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_QueueStats_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_QueueStats_descriptor,
        new java.lang.String[] { "QueueNumber", "Packets", "Bytes", "TailDropPackets", "RlDropPackets", "RlDropBytes", "RedDropPackets", "RedDropBytes", "AvgBufferOccupancy", "CurBufferOccupancy", "PeakBufferOccupancy", "AllocatedBufferSize", });
    jnprInterfaceExt.internalInit(descriptor.getExtensions().get(0));
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    TelemetryTop.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
