/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2017-2017 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2017 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/
package org.opennms.netmgt.telemetry.adapters.jti.proto;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: lsp_mon.proto

public final class LspMon {
  private LspMon() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }
  /**
   * Protobuf enum {@code lsp_event}
   *
   * <pre>
   * List of events currently available
   * New events can be added to this list
   * </pre>
   */
  public enum lsp_event
      implements com.google.protobuf.Internal.EnumLite {
    /**
     * <code>INITIATED = 0;</code>
     */
    INITIATED(0, 0),
    /**
     * <code>CONCLUDED_UP = 1;</code>
     */
    CONCLUDED_UP(1, 1),
    /**
     * <code>CONCLUDED_TORN_DOWN = 2;</code>
     */
    CONCLUDED_TORN_DOWN(2, 2),
    /**
     * <code>PROTECTION_AVAILABLE = 3;</code>
     */
    PROTECTION_AVAILABLE(3, 3),
    /**
     * <code>PROTECTION_UNAVAILABLE = 4;</code>
     */
    PROTECTION_UNAVAILABLE(4, 4),
    /**
     * <code>AUTOBW_SUCCESS = 5;</code>
     */
    AUTOBW_SUCCESS(5, 5),
    /**
     * <code>AUTOBW_FAIL = 6;</code>
     */
    AUTOBW_FAIL(6, 6),
    /**
     * <code>RESV_TEAR_RECEIVED = 7;</code>
     */
    RESV_TEAR_RECEIVED(7, 7),
    /**
     * <code>DESELECT_ACTIVE_PATH = 8;</code>
     */
    DESELECT_ACTIVE_PATH(8, 8),
    /**
     * <code>CHANGE_ACTIVE_PATH = 9;</code>
     */
    CHANGE_ACTIVE_PATH(9, 9),
    /**
     * <code>DETOUR_UP = 10;</code>
     */
    DETOUR_UP(10, 10),
    /**
     * <code>DETOUR_DOWN = 11;</code>
     */
    DETOUR_DOWN(11, 11),
    /**
     * <code>ORIGINATE_MBB = 12;</code>
     */
    ORIGINATE_MBB(12, 12),
    /**
     * <code>SELECT_ACTIVE_PATH = 13;</code>
     */
    SELECT_ACTIVE_PATH(13, 13),
    /**
     * <code>CSPF_NO_ROUTE = 14;</code>
     */
    CSPF_NO_ROUTE(14, 14),
    /**
     * <code>CSPF_SUCCESS = 15;</code>
     */
    CSPF_SUCCESS(15, 15),
    /**
     * <code>RESTART_RECOVERY_FAIL = 16;</code>
     */
    RESTART_RECOVERY_FAIL(16, 16),
    /**
     * <code>PATHERR_RECEIVED = 17;</code>
     */
    PATHERR_RECEIVED(17, 17),
    /**
     * <code>PATH_MTU_CHANGE = 18;</code>
     */
    PATH_MTU_CHANGE(18, 18),
    /**
     * <code>TUNNEL_LOCAL_REPAIRED = 19;</code>
     */
    TUNNEL_LOCAL_REPAIRED(19, 19),
    ;

    /**
     * <code>INITIATED = 0;</code>
     */
    public static final int INITIATED_VALUE = 0;
    /**
     * <code>CONCLUDED_UP = 1;</code>
     */
    public static final int CONCLUDED_UP_VALUE = 1;
    /**
     * <code>CONCLUDED_TORN_DOWN = 2;</code>
     */
    public static final int CONCLUDED_TORN_DOWN_VALUE = 2;
    /**
     * <code>PROTECTION_AVAILABLE = 3;</code>
     */
    public static final int PROTECTION_AVAILABLE_VALUE = 3;
    /**
     * <code>PROTECTION_UNAVAILABLE = 4;</code>
     */
    public static final int PROTECTION_UNAVAILABLE_VALUE = 4;
    /**
     * <code>AUTOBW_SUCCESS = 5;</code>
     */
    public static final int AUTOBW_SUCCESS_VALUE = 5;
    /**
     * <code>AUTOBW_FAIL = 6;</code>
     */
    public static final int AUTOBW_FAIL_VALUE = 6;
    /**
     * <code>RESV_TEAR_RECEIVED = 7;</code>
     */
    public static final int RESV_TEAR_RECEIVED_VALUE = 7;
    /**
     * <code>DESELECT_ACTIVE_PATH = 8;</code>
     */
    public static final int DESELECT_ACTIVE_PATH_VALUE = 8;
    /**
     * <code>CHANGE_ACTIVE_PATH = 9;</code>
     */
    public static final int CHANGE_ACTIVE_PATH_VALUE = 9;
    /**
     * <code>DETOUR_UP = 10;</code>
     */
    public static final int DETOUR_UP_VALUE = 10;
    /**
     * <code>DETOUR_DOWN = 11;</code>
     */
    public static final int DETOUR_DOWN_VALUE = 11;
    /**
     * <code>ORIGINATE_MBB = 12;</code>
     */
    public static final int ORIGINATE_MBB_VALUE = 12;
    /**
     * <code>SELECT_ACTIVE_PATH = 13;</code>
     */
    public static final int SELECT_ACTIVE_PATH_VALUE = 13;
    /**
     * <code>CSPF_NO_ROUTE = 14;</code>
     */
    public static final int CSPF_NO_ROUTE_VALUE = 14;
    /**
     * <code>CSPF_SUCCESS = 15;</code>
     */
    public static final int CSPF_SUCCESS_VALUE = 15;
    /**
     * <code>RESTART_RECOVERY_FAIL = 16;</code>
     */
    public static final int RESTART_RECOVERY_FAIL_VALUE = 16;
    /**
     * <code>PATHERR_RECEIVED = 17;</code>
     */
    public static final int PATHERR_RECEIVED_VALUE = 17;
    /**
     * <code>PATH_MTU_CHANGE = 18;</code>
     */
    public static final int PATH_MTU_CHANGE_VALUE = 18;
    /**
     * <code>TUNNEL_LOCAL_REPAIRED = 19;</code>
     */
    public static final int TUNNEL_LOCAL_REPAIRED_VALUE = 19;


    public final int getNumber() { return value; }

    public static lsp_event valueOf(int value) {
      switch (value) {
        case 0: return INITIATED;
        case 1: return CONCLUDED_UP;
        case 2: return CONCLUDED_TORN_DOWN;
        case 3: return PROTECTION_AVAILABLE;
        case 4: return PROTECTION_UNAVAILABLE;
        case 5: return AUTOBW_SUCCESS;
        case 6: return AUTOBW_FAIL;
        case 7: return RESV_TEAR_RECEIVED;
        case 8: return DESELECT_ACTIVE_PATH;
        case 9: return CHANGE_ACTIVE_PATH;
        case 10: return DETOUR_UP;
        case 11: return DETOUR_DOWN;
        case 12: return ORIGINATE_MBB;
        case 13: return SELECT_ACTIVE_PATH;
        case 14: return CSPF_NO_ROUTE;
        case 15: return CSPF_SUCCESS;
        case 16: return RESTART_RECOVERY_FAIL;
        case 17: return PATHERR_RECEIVED;
        case 18: return PATH_MTU_CHANGE;
        case 19: return TUNNEL_LOCAL_REPAIRED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<lsp_event>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<lsp_event>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<lsp_event>() {
            public lsp_event findValueByNumber(int number) {
              return lsp_event.valueOf(number);
            }
          };

    private final int value;

    private lsp_event(int index, int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:lsp_event)
  }

  /**
   * Protobuf enum {@code event_subcode}
   */
  public enum event_subcode
      implements com.google.protobuf.Internal.EnumLite {
    /**
     * <code>ADMISSION_CONTROL_FAILURE = 1;</code>
     */
    ADMISSION_CONTROL_FAILURE(0, 1),
    /**
     * <code>SESSION_PREEMPTED = 2;</code>
     */
    SESSION_PREEMPTED(1, 2),
    /**
     * <code>BAD_LOOSE_ROUTE = 3;</code>
     */
    BAD_LOOSE_ROUTE(2, 3),
    /**
     * <code>BAD_STRICT_ROUTE = 4;</code>
     */
    BAD_STRICT_ROUTE(3, 4),
    /**
     * <code>LABEL_ALLOCATION_FAILURE = 5;</code>
     */
    LABEL_ALLOCATION_FAILURE(4, 5),
    /**
     * <code>NON_RSVP_CAPABLE_ROUTER = 6;</code>
     */
    NON_RSVP_CAPABLE_ROUTER(5, 6),
    /**
     * <code>TTL_EXPIRED = 7;</code>
     */
    TTL_EXPIRED(6, 7),
    /**
     * <code>ROUTING_LOOP_DETECTED = 8;</code>
     */
    ROUTING_LOOP_DETECTED(7, 8),
    /**
     * <code>REQUESTED_BANDWIDTH_UNAVAILABLE = 9;</code>
     */
    REQUESTED_BANDWIDTH_UNAVAILABLE(8, 9),
    ;

    /**
     * <code>ADMISSION_CONTROL_FAILURE = 1;</code>
     */
    public static final int ADMISSION_CONTROL_FAILURE_VALUE = 1;
    /**
     * <code>SESSION_PREEMPTED = 2;</code>
     */
    public static final int SESSION_PREEMPTED_VALUE = 2;
    /**
     * <code>BAD_LOOSE_ROUTE = 3;</code>
     */
    public static final int BAD_LOOSE_ROUTE_VALUE = 3;
    /**
     * <code>BAD_STRICT_ROUTE = 4;</code>
     */
    public static final int BAD_STRICT_ROUTE_VALUE = 4;
    /**
     * <code>LABEL_ALLOCATION_FAILURE = 5;</code>
     */
    public static final int LABEL_ALLOCATION_FAILURE_VALUE = 5;
    /**
     * <code>NON_RSVP_CAPABLE_ROUTER = 6;</code>
     */
    public static final int NON_RSVP_CAPABLE_ROUTER_VALUE = 6;
    /**
     * <code>TTL_EXPIRED = 7;</code>
     */
    public static final int TTL_EXPIRED_VALUE = 7;
    /**
     * <code>ROUTING_LOOP_DETECTED = 8;</code>
     */
    public static final int ROUTING_LOOP_DETECTED_VALUE = 8;
    /**
     * <code>REQUESTED_BANDWIDTH_UNAVAILABLE = 9;</code>
     */
    public static final int REQUESTED_BANDWIDTH_UNAVAILABLE_VALUE = 9;


    public final int getNumber() { return value; }

    public static event_subcode valueOf(int value) {
      switch (value) {
        case 1: return ADMISSION_CONTROL_FAILURE;
        case 2: return SESSION_PREEMPTED;
        case 3: return BAD_LOOSE_ROUTE;
        case 4: return BAD_STRICT_ROUTE;
        case 5: return LABEL_ALLOCATION_FAILURE;
        case 6: return NON_RSVP_CAPABLE_ROUTER;
        case 7: return TTL_EXPIRED;
        case 8: return ROUTING_LOOP_DETECTED;
        case 9: return REQUESTED_BANDWIDTH_UNAVAILABLE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<event_subcode>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<event_subcode>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<event_subcode>() {
            public event_subcode findValueByNumber(int number) {
              return event_subcode.valueOf(number);
            }
          };

    private final int value;

    private event_subcode(int index, int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:event_subcode)
  }

  public interface keyOrBuilder extends
      // @@protoc_insertion_point(interface_extends:key)
      com.google.protobuf.MessageLiteOrBuilder {

    /**
     * <code>required string name = 1;</code>
     */
    boolean hasName();
    /**
     * <code>required string name = 1;</code>
     */
    java.lang.String getName();
    /**
     * <code>required string name = 1;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>required int32 instance_identifier = 2;</code>
     */
    boolean hasInstanceIdentifier();
    /**
     * <code>required int32 instance_identifier = 2;</code>
     */
    int getInstanceIdentifier();

    /**
     * <code>required uint64 time_stampg = 3;</code>
     */
    boolean hasTimeStampg();
    /**
     * <code>required uint64 time_stampg = 3;</code>
     */
    long getTimeStampg();
  }
  /**
   * Protobuf type {@code key}
   *
   * <pre>
   * Schema for key for GPB msg receiver
   * </pre>
   */
  public static final class key extends
      com.google.protobuf.GeneratedMessageLite implements
      // @@protoc_insertion_point(message_implements:key)
      keyOrBuilder {
    // Use key.newBuilder() to construct.
    private key(com.google.protobuf.GeneratedMessageLite.Builder builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private key(boolean noInit) { this.unknownFields = com.google.protobuf.ByteString.EMPTY;}

    private static final key defaultInstance;
    public static key getDefaultInstance() {
      return defaultInstance;
    }

    public key getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.ByteString unknownFields;
    private key(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.ByteString.Output unknownFieldsOutput =
          com.google.protobuf.ByteString.newOutput();
      com.google.protobuf.CodedOutputStream unknownFieldsCodedOutput =
          com.google.protobuf.CodedOutputStream.newInstance(
              unknownFieldsOutput);
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFieldsCodedOutput,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              name_ = bs;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              instanceIdentifier_ = input.readInt32();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              timeStampg_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        try {
          unknownFieldsCodedOutput.flush();
        } catch (java.io.IOException e) {
        // Should not happen
        } finally {
          unknownFields = unknownFieldsOutput.toByteString();
        }
        makeExtensionsImmutable();
      }
    }
    public static com.google.protobuf.Parser<key> PARSER =
        new com.google.protobuf.AbstractParser<key>() {
      public key parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new key(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<key> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private java.lang.Object name_;
    /**
     * <code>required string name = 1;</code>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INSTANCE_IDENTIFIER_FIELD_NUMBER = 2;
    private int instanceIdentifier_;
    /**
     * <code>required int32 instance_identifier = 2;</code>
     */
    public boolean hasInstanceIdentifier() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required int32 instance_identifier = 2;</code>
     */
    public int getInstanceIdentifier() {
      return instanceIdentifier_;
    }

    public static final int TIME_STAMPG_FIELD_NUMBER = 3;
    private long timeStampg_;
    /**
     * <code>required uint64 time_stampg = 3;</code>
     */
    public boolean hasTimeStampg() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>required uint64 time_stampg = 3;</code>
     */
    public long getTimeStampg() {
      return timeStampg_;
    }

    private void initFields() {
      name_ = "";
      instanceIdentifier_ = 0;
      timeStampg_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasInstanceIdentifier()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasTimeStampg()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt32(2, instanceIdentifier_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt64(3, timeStampg_);
      }
      output.writeRawBytes(unknownFields);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, instanceIdentifier_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, timeStampg_);
      }
      size += unknownFields.size();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LspMon.key parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.key parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.key parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.key parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.key parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.key parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LspMon.key parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LspMon.key parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LspMon.key parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.key parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LspMon.key prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    /**
     * Protobuf type {@code key}
     *
     * <pre>
     * Schema for key for GPB msg receiver
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageLite.Builder<
          LspMon.key, Builder>
        implements
        // @@protoc_insertion_point(builder_implements:key)
        LspMon.keyOrBuilder {
      // Construct using LspMon.key.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        instanceIdentifier_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        timeStampg_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public LspMon.key getDefaultInstanceForType() {
        return LspMon.key.getDefaultInstance();
      }

      public LspMon.key build() {
        LspMon.key result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LspMon.key buildPartial() {
        LspMon.key result = new LspMon.key(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.instanceIdentifier_ = instanceIdentifier_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.timeStampg_ = timeStampg_;
        result.bitField0_ = to_bitField0_;
        return result;
      }

      public Builder mergeFrom(LspMon.key other) {
        if (other == LspMon.key.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          
        }
        if (other.hasInstanceIdentifier()) {
          setInstanceIdentifier(other.getInstanceIdentifier());
        }
        if (other.hasTimeStampg()) {
          setTimeStampg(other.getTimeStampg());
        }
        setUnknownFields(
            getUnknownFields().concat(other.unknownFields));
        return this;
      }

      public final boolean isInitialized() {
        if (!hasName()) {
          
          return false;
        }
        if (!hasInstanceIdentifier()) {
          
          return false;
        }
        if (!hasTimeStampg()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LspMon.key parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LspMon.key) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <code>required string name = 1;</code>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string name = 1;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        
        return this;
      }

      private int instanceIdentifier_ ;
      /**
       * <code>required int32 instance_identifier = 2;</code>
       */
      public boolean hasInstanceIdentifier() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required int32 instance_identifier = 2;</code>
       */
      public int getInstanceIdentifier() {
        return instanceIdentifier_;
      }
      /**
       * <code>required int32 instance_identifier = 2;</code>
       */
      public Builder setInstanceIdentifier(int value) {
        bitField0_ |= 0x00000002;
        instanceIdentifier_ = value;
        
        return this;
      }
      /**
       * <code>required int32 instance_identifier = 2;</code>
       */
      public Builder clearInstanceIdentifier() {
        bitField0_ = (bitField0_ & ~0x00000002);
        instanceIdentifier_ = 0;
        
        return this;
      }

      private long timeStampg_ ;
      /**
       * <code>required uint64 time_stampg = 3;</code>
       */
      public boolean hasTimeStampg() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>required uint64 time_stampg = 3;</code>
       */
      public long getTimeStampg() {
        return timeStampg_;
      }
      /**
       * <code>required uint64 time_stampg = 3;</code>
       */
      public Builder setTimeStampg(long value) {
        bitField0_ |= 0x00000004;
        timeStampg_ = value;
        
        return this;
      }
      /**
       * <code>required uint64 time_stampg = 3;</code>
       */
      public Builder clearTimeStampg() {
        bitField0_ = (bitField0_ & ~0x00000004);
        timeStampg_ = 0L;
        
        return this;
      }

      // @@protoc_insertion_point(builder_scope:key)
    }

    static {
      defaultInstance = new key(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:key)
  }

  public interface lsp_monitor_data_eventOrBuilder extends
      // @@protoc_insertion_point(interface_extends:lsp_monitor_data_event)
      com.google.protobuf.MessageLiteOrBuilder {

    /**
     * <code>required .lsp_event event_identifier = 1;</code>
     */
    boolean hasEventIdentifier();
    /**
     * <code>required .lsp_event event_identifier = 1;</code>
     */
    LspMon.lsp_event getEventIdentifier();

    /**
     * <code>optional .event_subcode subcode = 2;</code>
     */
    boolean hasSubcode();
    /**
     * <code>optional .event_subcode subcode = 2;</code>
     */
    LspMon.event_subcode getSubcode();
  }
  /**
   * Protobuf type {@code lsp_monitor_data_event}
   *
   * <pre>
   * Schema for communicating lsp events
   * </pre>
   */
  public static final class lsp_monitor_data_event extends
      com.google.protobuf.GeneratedMessageLite implements
      // @@protoc_insertion_point(message_implements:lsp_monitor_data_event)
      lsp_monitor_data_eventOrBuilder {
    // Use lsp_monitor_data_event.newBuilder() to construct.
    private lsp_monitor_data_event(com.google.protobuf.GeneratedMessageLite.Builder builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private lsp_monitor_data_event(boolean noInit) { this.unknownFields = com.google.protobuf.ByteString.EMPTY;}

    private static final lsp_monitor_data_event defaultInstance;
    public static lsp_monitor_data_event getDefaultInstance() {
      return defaultInstance;
    }

    public lsp_monitor_data_event getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.ByteString unknownFields;
    private lsp_monitor_data_event(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.ByteString.Output unknownFieldsOutput =
          com.google.protobuf.ByteString.newOutput();
      com.google.protobuf.CodedOutputStream unknownFieldsCodedOutput =
          com.google.protobuf.CodedOutputStream.newInstance(
              unknownFieldsOutput);
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFieldsCodedOutput,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              LspMon.lsp_event value = LspMon.lsp_event.valueOf(rawValue);
              if (value == null) {
                unknownFieldsCodedOutput.writeRawVarint32(tag);
                unknownFieldsCodedOutput.writeRawVarint32(rawValue);
              } else {
                bitField0_ |= 0x00000001;
                eventIdentifier_ = value;
              }
              break;
            }
            case 16: {
              int rawValue = input.readEnum();
              LspMon.event_subcode value = LspMon.event_subcode.valueOf(rawValue);
              if (value == null) {
                unknownFieldsCodedOutput.writeRawVarint32(tag);
                unknownFieldsCodedOutput.writeRawVarint32(rawValue);
              } else {
                bitField0_ |= 0x00000002;
                subcode_ = value;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        try {
          unknownFieldsCodedOutput.flush();
        } catch (java.io.IOException e) {
        // Should not happen
        } finally {
          unknownFields = unknownFieldsOutput.toByteString();
        }
        makeExtensionsImmutable();
      }
    }
    public static com.google.protobuf.Parser<lsp_monitor_data_event> PARSER =
        new com.google.protobuf.AbstractParser<lsp_monitor_data_event>() {
      public lsp_monitor_data_event parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new lsp_monitor_data_event(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<lsp_monitor_data_event> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int EVENT_IDENTIFIER_FIELD_NUMBER = 1;
    private LspMon.lsp_event eventIdentifier_;
    /**
     * <code>required .lsp_event event_identifier = 1;</code>
     */
    public boolean hasEventIdentifier() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .lsp_event event_identifier = 1;</code>
     */
    public LspMon.lsp_event getEventIdentifier() {
      return eventIdentifier_;
    }

    public static final int SUBCODE_FIELD_NUMBER = 2;
    private LspMon.event_subcode subcode_;
    /**
     * <code>optional .event_subcode subcode = 2;</code>
     */
    public boolean hasSubcode() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .event_subcode subcode = 2;</code>
     */
    public LspMon.event_subcode getSubcode() {
      return subcode_;
    }

    private void initFields() {
      eventIdentifier_ = LspMon.lsp_event.INITIATED;
      subcode_ = LspMon.event_subcode.ADMISSION_CONTROL_FAILURE;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasEventIdentifier()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, eventIdentifier_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeEnum(2, subcode_.getNumber());
      }
      output.writeRawBytes(unknownFields);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, eventIdentifier_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, subcode_.getNumber());
      }
      size += unknownFields.size();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LspMon.lsp_monitor_data_event parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.lsp_monitor_data_event parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.lsp_monitor_data_event parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.lsp_monitor_data_event parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.lsp_monitor_data_event parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.lsp_monitor_data_event parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LspMon.lsp_monitor_data_event parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LspMon.lsp_monitor_data_event parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LspMon.lsp_monitor_data_event parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.lsp_monitor_data_event parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LspMon.lsp_monitor_data_event prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    /**
     * Protobuf type {@code lsp_monitor_data_event}
     *
     * <pre>
     * Schema for communicating lsp events
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageLite.Builder<
          LspMon.lsp_monitor_data_event, Builder>
        implements
        // @@protoc_insertion_point(builder_implements:lsp_monitor_data_event)
        LspMon.lsp_monitor_data_eventOrBuilder {
      // Construct using LspMon.lsp_monitor_data_event.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        eventIdentifier_ = LspMon.lsp_event.INITIATED;
        bitField0_ = (bitField0_ & ~0x00000001);
        subcode_ = LspMon.event_subcode.ADMISSION_CONTROL_FAILURE;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public LspMon.lsp_monitor_data_event getDefaultInstanceForType() {
        return LspMon.lsp_monitor_data_event.getDefaultInstance();
      }

      public LspMon.lsp_monitor_data_event build() {
        LspMon.lsp_monitor_data_event result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LspMon.lsp_monitor_data_event buildPartial() {
        LspMon.lsp_monitor_data_event result = new LspMon.lsp_monitor_data_event(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.eventIdentifier_ = eventIdentifier_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.subcode_ = subcode_;
        result.bitField0_ = to_bitField0_;
        return result;
      }

      public Builder mergeFrom(LspMon.lsp_monitor_data_event other) {
        if (other == LspMon.lsp_monitor_data_event.getDefaultInstance()) return this;
        if (other.hasEventIdentifier()) {
          setEventIdentifier(other.getEventIdentifier());
        }
        if (other.hasSubcode()) {
          setSubcode(other.getSubcode());
        }
        setUnknownFields(
            getUnknownFields().concat(other.unknownFields));
        return this;
      }

      public final boolean isInitialized() {
        if (!hasEventIdentifier()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LspMon.lsp_monitor_data_event parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LspMon.lsp_monitor_data_event) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private LspMon.lsp_event eventIdentifier_ = LspMon.lsp_event.INITIATED;
      /**
       * <code>required .lsp_event event_identifier = 1;</code>
       */
      public boolean hasEventIdentifier() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .lsp_event event_identifier = 1;</code>
       */
      public LspMon.lsp_event getEventIdentifier() {
        return eventIdentifier_;
      }
      /**
       * <code>required .lsp_event event_identifier = 1;</code>
       */
      public Builder setEventIdentifier(LspMon.lsp_event value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        eventIdentifier_ = value;
        
        return this;
      }
      /**
       * <code>required .lsp_event event_identifier = 1;</code>
       */
      public Builder clearEventIdentifier() {
        bitField0_ = (bitField0_ & ~0x00000001);
        eventIdentifier_ = LspMon.lsp_event.INITIATED;
        
        return this;
      }

      private LspMon.event_subcode subcode_ = LspMon.event_subcode.ADMISSION_CONTROL_FAILURE;
      /**
       * <code>optional .event_subcode subcode = 2;</code>
       */
      public boolean hasSubcode() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .event_subcode subcode = 2;</code>
       */
      public LspMon.event_subcode getSubcode() {
        return subcode_;
      }
      /**
       * <code>optional .event_subcode subcode = 2;</code>
       */
      public Builder setSubcode(LspMon.event_subcode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        subcode_ = value;
        
        return this;
      }
      /**
       * <code>optional .event_subcode subcode = 2;</code>
       */
      public Builder clearSubcode() {
        bitField0_ = (bitField0_ & ~0x00000002);
        subcode_ = LspMon.event_subcode.ADMISSION_CONTROL_FAILURE;
        
        return this;
      }

      // @@protoc_insertion_point(builder_scope:lsp_monitor_data_event)
    }

    static {
      defaultInstance = new lsp_monitor_data_event(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:lsp_monitor_data_event)
  }

  public interface ero_type_entryOrBuilder extends
      // @@protoc_insertion_point(interface_extends:ero_type_entry)
      com.google.protobuf.MessageLiteOrBuilder {

    /**
     * <code>required uint32 ip = 1;</code>
     */
    boolean hasIp();
    /**
     * <code>required uint32 ip = 1;</code>
     */
    int getIp();

    /**
     * <code>optional string flags = 2;</code>
     */
    boolean hasFlags();
    /**
     * <code>optional string flags = 2;</code>
     */
    java.lang.String getFlags();
    /**
     * <code>optional string flags = 2;</code>
     */
    com.google.protobuf.ByteString
        getFlagsBytes();
  }
  /**
   * Protobuf type {@code ero_type_entry}
   */
  public static final class ero_type_entry extends
      com.google.protobuf.GeneratedMessageLite implements
      // @@protoc_insertion_point(message_implements:ero_type_entry)
      ero_type_entryOrBuilder {
    // Use ero_type_entry.newBuilder() to construct.
    private ero_type_entry(com.google.protobuf.GeneratedMessageLite.Builder builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private ero_type_entry(boolean noInit) { this.unknownFields = com.google.protobuf.ByteString.EMPTY;}

    private static final ero_type_entry defaultInstance;
    public static ero_type_entry getDefaultInstance() {
      return defaultInstance;
    }

    public ero_type_entry getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.ByteString unknownFields;
    private ero_type_entry(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.ByteString.Output unknownFieldsOutput =
          com.google.protobuf.ByteString.newOutput();
      com.google.protobuf.CodedOutputStream unknownFieldsCodedOutput =
          com.google.protobuf.CodedOutputStream.newInstance(
              unknownFieldsOutput);
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFieldsCodedOutput,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              ip_ = input.readUInt32();
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              flags_ = bs;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        try {
          unknownFieldsCodedOutput.flush();
        } catch (java.io.IOException e) {
        // Should not happen
        } finally {
          unknownFields = unknownFieldsOutput.toByteString();
        }
        makeExtensionsImmutable();
      }
    }
    public static com.google.protobuf.Parser<ero_type_entry> PARSER =
        new com.google.protobuf.AbstractParser<ero_type_entry>() {
      public ero_type_entry parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ero_type_entry(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<ero_type_entry> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int IP_FIELD_NUMBER = 1;
    private int ip_;
    /**
     * <code>required uint32 ip = 1;</code>
     */
    public boolean hasIp() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required uint32 ip = 1;</code>
     */
    public int getIp() {
      return ip_;
    }

    public static final int FLAGS_FIELD_NUMBER = 2;
    private java.lang.Object flags_;
    /**
     * <code>optional string flags = 2;</code>
     */
    public boolean hasFlags() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string flags = 2;</code>
     */
    public java.lang.String getFlags() {
      java.lang.Object ref = flags_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          flags_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string flags = 2;</code>
     */
    public com.google.protobuf.ByteString
        getFlagsBytes() {
      java.lang.Object ref = flags_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        flags_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      ip_ = 0;
      flags_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasIp()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeUInt32(1, ip_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getFlagsBytes());
      }
      output.writeRawBytes(unknownFields);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, ip_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getFlagsBytes());
      }
      size += unknownFields.size();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LspMon.ero_type_entry parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.ero_type_entry parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.ero_type_entry parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.ero_type_entry parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.ero_type_entry parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.ero_type_entry parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LspMon.ero_type_entry parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LspMon.ero_type_entry parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LspMon.ero_type_entry parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.ero_type_entry parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LspMon.ero_type_entry prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    /**
     * Protobuf type {@code ero_type_entry}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageLite.Builder<
          LspMon.ero_type_entry, Builder>
        implements
        // @@protoc_insertion_point(builder_implements:ero_type_entry)
        LspMon.ero_type_entryOrBuilder {
      // Construct using LspMon.ero_type_entry.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        ip_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        flags_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public LspMon.ero_type_entry getDefaultInstanceForType() {
        return LspMon.ero_type_entry.getDefaultInstance();
      }

      public LspMon.ero_type_entry build() {
        LspMon.ero_type_entry result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LspMon.ero_type_entry buildPartial() {
        LspMon.ero_type_entry result = new LspMon.ero_type_entry(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.ip_ = ip_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.flags_ = flags_;
        result.bitField0_ = to_bitField0_;
        return result;
      }

      public Builder mergeFrom(LspMon.ero_type_entry other) {
        if (other == LspMon.ero_type_entry.getDefaultInstance()) return this;
        if (other.hasIp()) {
          setIp(other.getIp());
        }
        if (other.hasFlags()) {
          bitField0_ |= 0x00000002;
          flags_ = other.flags_;
          
        }
        setUnknownFields(
            getUnknownFields().concat(other.unknownFields));
        return this;
      }

      public final boolean isInitialized() {
        if (!hasIp()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LspMon.ero_type_entry parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LspMon.ero_type_entry) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private int ip_ ;
      /**
       * <code>required uint32 ip = 1;</code>
       */
      public boolean hasIp() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required uint32 ip = 1;</code>
       */
      public int getIp() {
        return ip_;
      }
      /**
       * <code>required uint32 ip = 1;</code>
       */
      public Builder setIp(int value) {
        bitField0_ |= 0x00000001;
        ip_ = value;
        
        return this;
      }
      /**
       * <code>required uint32 ip = 1;</code>
       */
      public Builder clearIp() {
        bitField0_ = (bitField0_ & ~0x00000001);
        ip_ = 0;
        
        return this;
      }

      private java.lang.Object flags_ = "";
      /**
       * <code>optional string flags = 2;</code>
       */
      public boolean hasFlags() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string flags = 2;</code>
       */
      public java.lang.String getFlags() {
        java.lang.Object ref = flags_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            flags_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string flags = 2;</code>
       */
      public com.google.protobuf.ByteString
          getFlagsBytes() {
        java.lang.Object ref = flags_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          flags_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string flags = 2;</code>
       */
      public Builder setFlags(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        flags_ = value;
        
        return this;
      }
      /**
       * <code>optional string flags = 2;</code>
       */
      public Builder clearFlags() {
        bitField0_ = (bitField0_ & ~0x00000002);
        flags_ = getDefaultInstance().getFlags();
        
        return this;
      }
      /**
       * <code>optional string flags = 2;</code>
       */
      public Builder setFlagsBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        flags_ = value;
        
        return this;
      }

      // @@protoc_insertion_point(builder_scope:ero_type_entry)
    }

    static {
      defaultInstance = new ero_type_entry(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:ero_type_entry)
  }

  public interface ero_ipv4_typeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:ero_ipv4_type)
      com.google.protobuf.MessageLiteOrBuilder {

    /**
     * <code>repeated .ero_type_entry entry = 1;</code>
     */
    java.util.List<LspMon.ero_type_entry> 
        getEntryList();
    /**
     * <code>repeated .ero_type_entry entry = 1;</code>
     */
    LspMon.ero_type_entry getEntry(int index);
    /**
     * <code>repeated .ero_type_entry entry = 1;</code>
     */
    int getEntryCount();
  }
  /**
   * Protobuf type {@code ero_ipv4_type}
   */
  public static final class ero_ipv4_type extends
      com.google.protobuf.GeneratedMessageLite implements
      // @@protoc_insertion_point(message_implements:ero_ipv4_type)
      ero_ipv4_typeOrBuilder {
    // Use ero_ipv4_type.newBuilder() to construct.
    private ero_ipv4_type(com.google.protobuf.GeneratedMessageLite.Builder builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private ero_ipv4_type(boolean noInit) { this.unknownFields = com.google.protobuf.ByteString.EMPTY;}

    private static final ero_ipv4_type defaultInstance;
    public static ero_ipv4_type getDefaultInstance() {
      return defaultInstance;
    }

    public ero_ipv4_type getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.ByteString unknownFields;
    private ero_ipv4_type(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.ByteString.Output unknownFieldsOutput =
          com.google.protobuf.ByteString.newOutput();
      com.google.protobuf.CodedOutputStream unknownFieldsCodedOutput =
          com.google.protobuf.CodedOutputStream.newInstance(
              unknownFieldsOutput);
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFieldsCodedOutput,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                entry_ = new java.util.ArrayList<LspMon.ero_type_entry>();
                mutable_bitField0_ |= 0x00000001;
              }
              entry_.add(input.readMessage(LspMon.ero_type_entry.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          entry_ = java.util.Collections.unmodifiableList(entry_);
        }
        try {
          unknownFieldsCodedOutput.flush();
        } catch (java.io.IOException e) {
        // Should not happen
        } finally {
          unknownFields = unknownFieldsOutput.toByteString();
        }
        makeExtensionsImmutable();
      }
    }
    public static com.google.protobuf.Parser<ero_ipv4_type> PARSER =
        new com.google.protobuf.AbstractParser<ero_ipv4_type>() {
      public ero_ipv4_type parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ero_ipv4_type(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<ero_ipv4_type> getParserForType() {
      return PARSER;
    }

    public static final int ENTRY_FIELD_NUMBER = 1;
    private java.util.List<LspMon.ero_type_entry> entry_;
    /**
     * <code>repeated .ero_type_entry entry = 1;</code>
     */
    public java.util.List<LspMon.ero_type_entry> getEntryList() {
      return entry_;
    }
    /**
     * <code>repeated .ero_type_entry entry = 1;</code>
     */
    public java.util.List<? extends LspMon.ero_type_entryOrBuilder> 
        getEntryOrBuilderList() {
      return entry_;
    }
    /**
     * <code>repeated .ero_type_entry entry = 1;</code>
     */
    public int getEntryCount() {
      return entry_.size();
    }
    /**
     * <code>repeated .ero_type_entry entry = 1;</code>
     */
    public LspMon.ero_type_entry getEntry(int index) {
      return entry_.get(index);
    }
    /**
     * <code>repeated .ero_type_entry entry = 1;</code>
     */
    public LspMon.ero_type_entryOrBuilder getEntryOrBuilder(
        int index) {
      return entry_.get(index);
    }

    private void initFields() {
      entry_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getEntryCount(); i++) {
        if (!getEntry(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < entry_.size(); i++) {
        output.writeMessage(1, entry_.get(i));
      }
      output.writeRawBytes(unknownFields);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < entry_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, entry_.get(i));
      }
      size += unknownFields.size();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LspMon.ero_ipv4_type parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.ero_ipv4_type parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.ero_ipv4_type parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.ero_ipv4_type parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.ero_ipv4_type parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.ero_ipv4_type parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LspMon.ero_ipv4_type parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LspMon.ero_ipv4_type parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LspMon.ero_ipv4_type parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.ero_ipv4_type parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LspMon.ero_ipv4_type prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    /**
     * Protobuf type {@code ero_ipv4_type}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageLite.Builder<
          LspMon.ero_ipv4_type, Builder>
        implements
        // @@protoc_insertion_point(builder_implements:ero_ipv4_type)
        LspMon.ero_ipv4_typeOrBuilder {
      // Construct using LspMon.ero_ipv4_type.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        entry_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public LspMon.ero_ipv4_type getDefaultInstanceForType() {
        return LspMon.ero_ipv4_type.getDefaultInstance();
      }

      public LspMon.ero_ipv4_type build() {
        LspMon.ero_ipv4_type result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LspMon.ero_ipv4_type buildPartial() {
        LspMon.ero_ipv4_type result = new LspMon.ero_ipv4_type(this);
        int from_bitField0_ = bitField0_;
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          entry_ = java.util.Collections.unmodifiableList(entry_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.entry_ = entry_;
        return result;
      }

      public Builder mergeFrom(LspMon.ero_ipv4_type other) {
        if (other == LspMon.ero_ipv4_type.getDefaultInstance()) return this;
        if (!other.entry_.isEmpty()) {
          if (entry_.isEmpty()) {
            entry_ = other.entry_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureEntryIsMutable();
            entry_.addAll(other.entry_);
          }
          
        }
        setUnknownFields(
            getUnknownFields().concat(other.unknownFields));
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getEntryCount(); i++) {
          if (!getEntry(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LspMon.ero_ipv4_type parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LspMon.ero_ipv4_type) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<LspMon.ero_type_entry> entry_ =
        java.util.Collections.emptyList();
      private void ensureEntryIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          entry_ = new java.util.ArrayList<LspMon.ero_type_entry>(entry_);
          bitField0_ |= 0x00000001;
         }
      }

      /**
       * <code>repeated .ero_type_entry entry = 1;</code>
       */
      public java.util.List<LspMon.ero_type_entry> getEntryList() {
        return java.util.Collections.unmodifiableList(entry_);
      }
      /**
       * <code>repeated .ero_type_entry entry = 1;</code>
       */
      public int getEntryCount() {
        return entry_.size();
      }
      /**
       * <code>repeated .ero_type_entry entry = 1;</code>
       */
      public LspMon.ero_type_entry getEntry(int index) {
        return entry_.get(index);
      }
      /**
       * <code>repeated .ero_type_entry entry = 1;</code>
       */
      public Builder setEntry(
          int index, LspMon.ero_type_entry value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntryIsMutable();
        entry_.set(index, value);

        return this;
      }
      /**
       * <code>repeated .ero_type_entry entry = 1;</code>
       */
      public Builder setEntry(
          int index, LspMon.ero_type_entry.Builder builderForValue) {
        ensureEntryIsMutable();
        entry_.set(index, builderForValue.build());

        return this;
      }
      /**
       * <code>repeated .ero_type_entry entry = 1;</code>
       */
      public Builder addEntry(LspMon.ero_type_entry value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntryIsMutable();
        entry_.add(value);

        return this;
      }
      /**
       * <code>repeated .ero_type_entry entry = 1;</code>
       */
      public Builder addEntry(
          int index, LspMon.ero_type_entry value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntryIsMutable();
        entry_.add(index, value);

        return this;
      }
      /**
       * <code>repeated .ero_type_entry entry = 1;</code>
       */
      public Builder addEntry(
          LspMon.ero_type_entry.Builder builderForValue) {
        ensureEntryIsMutable();
        entry_.add(builderForValue.build());

        return this;
      }
      /**
       * <code>repeated .ero_type_entry entry = 1;</code>
       */
      public Builder addEntry(
          int index, LspMon.ero_type_entry.Builder builderForValue) {
        ensureEntryIsMutable();
        entry_.add(index, builderForValue.build());

        return this;
      }
      /**
       * <code>repeated .ero_type_entry entry = 1;</code>
       */
      public Builder addAllEntry(
          java.lang.Iterable<? extends LspMon.ero_type_entry> values) {
        ensureEntryIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, entry_);

        return this;
      }
      /**
       * <code>repeated .ero_type_entry entry = 1;</code>
       */
      public Builder clearEntry() {
        entry_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);

        return this;
      }
      /**
       * <code>repeated .ero_type_entry entry = 1;</code>
       */
      public Builder removeEntry(int index) {
        ensureEntryIsMutable();
        entry_.remove(index);

        return this;
      }

      // @@protoc_insertion_point(builder_scope:ero_ipv4_type)
    }

    static {
      defaultInstance = new ero_ipv4_type(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:ero_ipv4_type)
  }

  public interface rro_type_entryOrBuilder extends
      // @@protoc_insertion_point(interface_extends:rro_type_entry)
      com.google.protobuf.MessageLiteOrBuilder {

    /**
     * <code>optional uint32 nodeid = 1;</code>
     *
     * <pre>
     * node-id or loopback
     * </pre>
     */
    boolean hasNodeid();
    /**
     * <code>optional uint32 nodeid = 1;</code>
     *
     * <pre>
     * node-id or loopback
     * </pre>
     */
    int getNodeid();

    /**
     * <code>optional uint32 flags = 2;</code>
     *
     * <pre>
     * contains flags
     * </pre>
     */
    boolean hasFlags();
    /**
     * <code>optional uint32 flags = 2;</code>
     *
     * <pre>
     * contains flags
     * </pre>
     */
    int getFlags();

    /**
     * <code>optional uint32 intf_addr = 3;</code>
     *
     * <pre>
     * interface-ip
     * </pre>
     */
    boolean hasIntfAddr();
    /**
     * <code>optional uint32 intf_addr = 3;</code>
     *
     * <pre>
     * interface-ip
     * </pre>
     */
    int getIntfAddr();

    /**
     * <code>optional uint32 label = 4;</code>
     *
     * <pre>
     * may be using PHP
     * </pre>
     */
    boolean hasLabel();
    /**
     * <code>optional uint32 label = 4;</code>
     *
     * <pre>
     * may be using PHP
     * </pre>
     */
    int getLabel();
  }
  /**
   * Protobuf type {@code rro_type_entry}
   */
  public static final class rro_type_entry extends
      com.google.protobuf.GeneratedMessageLite implements
      // @@protoc_insertion_point(message_implements:rro_type_entry)
      rro_type_entryOrBuilder {
    // Use rro_type_entry.newBuilder() to construct.
    private rro_type_entry(com.google.protobuf.GeneratedMessageLite.Builder builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private rro_type_entry(boolean noInit) { this.unknownFields = com.google.protobuf.ByteString.EMPTY;}

    private static final rro_type_entry defaultInstance;
    public static rro_type_entry getDefaultInstance() {
      return defaultInstance;
    }

    public rro_type_entry getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.ByteString unknownFields;
    private rro_type_entry(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.ByteString.Output unknownFieldsOutput =
          com.google.protobuf.ByteString.newOutput();
      com.google.protobuf.CodedOutputStream unknownFieldsCodedOutput =
          com.google.protobuf.CodedOutputStream.newInstance(
              unknownFieldsOutput);
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFieldsCodedOutput,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              nodeid_ = input.readUInt32();
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              flags_ = input.readUInt32();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              intfAddr_ = input.readUInt32();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              label_ = input.readUInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        try {
          unknownFieldsCodedOutput.flush();
        } catch (java.io.IOException e) {
        // Should not happen
        } finally {
          unknownFields = unknownFieldsOutput.toByteString();
        }
        makeExtensionsImmutable();
      }
    }
    public static com.google.protobuf.Parser<rro_type_entry> PARSER =
        new com.google.protobuf.AbstractParser<rro_type_entry>() {
      public rro_type_entry parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new rro_type_entry(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<rro_type_entry> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NODEID_FIELD_NUMBER = 1;
    private int nodeid_;
    /**
     * <code>optional uint32 nodeid = 1;</code>
     *
     * <pre>
     * node-id or loopback
     * </pre>
     */
    public boolean hasNodeid() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional uint32 nodeid = 1;</code>
     *
     * <pre>
     * node-id or loopback
     * </pre>
     */
    public int getNodeid() {
      return nodeid_;
    }

    public static final int FLAGS_FIELD_NUMBER = 2;
    private int flags_;
    /**
     * <code>optional uint32 flags = 2;</code>
     *
     * <pre>
     * contains flags
     * </pre>
     */
    public boolean hasFlags() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional uint32 flags = 2;</code>
     *
     * <pre>
     * contains flags
     * </pre>
     */
    public int getFlags() {
      return flags_;
    }

    public static final int INTF_ADDR_FIELD_NUMBER = 3;
    private int intfAddr_;
    /**
     * <code>optional uint32 intf_addr = 3;</code>
     *
     * <pre>
     * interface-ip
     * </pre>
     */
    public boolean hasIntfAddr() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint32 intf_addr = 3;</code>
     *
     * <pre>
     * interface-ip
     * </pre>
     */
    public int getIntfAddr() {
      return intfAddr_;
    }

    public static final int LABEL_FIELD_NUMBER = 4;
    private int label_;
    /**
     * <code>optional uint32 label = 4;</code>
     *
     * <pre>
     * may be using PHP
     * </pre>
     */
    public boolean hasLabel() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional uint32 label = 4;</code>
     *
     * <pre>
     * may be using PHP
     * </pre>
     */
    public int getLabel() {
      return label_;
    }

    private void initFields() {
      nodeid_ = 0;
      flags_ = 0;
      intfAddr_ = 0;
      label_ = 0;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeUInt32(1, nodeid_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt32(2, flags_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt32(3, intfAddr_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeUInt32(4, label_);
      }
      output.writeRawBytes(unknownFields);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, nodeid_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, flags_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(3, intfAddr_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(4, label_);
      }
      size += unknownFields.size();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LspMon.rro_type_entry parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.rro_type_entry parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.rro_type_entry parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.rro_type_entry parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.rro_type_entry parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.rro_type_entry parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LspMon.rro_type_entry parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LspMon.rro_type_entry parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LspMon.rro_type_entry parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.rro_type_entry parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LspMon.rro_type_entry prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    /**
     * Protobuf type {@code rro_type_entry}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageLite.Builder<
          LspMon.rro_type_entry, Builder>
        implements
        // @@protoc_insertion_point(builder_implements:rro_type_entry)
        LspMon.rro_type_entryOrBuilder {
      // Construct using LspMon.rro_type_entry.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        nodeid_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        flags_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        intfAddr_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        label_ = 0;
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public LspMon.rro_type_entry getDefaultInstanceForType() {
        return LspMon.rro_type_entry.getDefaultInstance();
      }

      public LspMon.rro_type_entry build() {
        LspMon.rro_type_entry result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LspMon.rro_type_entry buildPartial() {
        LspMon.rro_type_entry result = new LspMon.rro_type_entry(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.nodeid_ = nodeid_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.flags_ = flags_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.intfAddr_ = intfAddr_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.label_ = label_;
        result.bitField0_ = to_bitField0_;
        return result;
      }

      public Builder mergeFrom(LspMon.rro_type_entry other) {
        if (other == LspMon.rro_type_entry.getDefaultInstance()) return this;
        if (other.hasNodeid()) {
          setNodeid(other.getNodeid());
        }
        if (other.hasFlags()) {
          setFlags(other.getFlags());
        }
        if (other.hasIntfAddr()) {
          setIntfAddr(other.getIntfAddr());
        }
        if (other.hasLabel()) {
          setLabel(other.getLabel());
        }
        setUnknownFields(
            getUnknownFields().concat(other.unknownFields));
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LspMon.rro_type_entry parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LspMon.rro_type_entry) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private int nodeid_ ;
      /**
       * <code>optional uint32 nodeid = 1;</code>
       *
       * <pre>
       * node-id or loopback
       * </pre>
       */
      public boolean hasNodeid() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional uint32 nodeid = 1;</code>
       *
       * <pre>
       * node-id or loopback
       * </pre>
       */
      public int getNodeid() {
        return nodeid_;
      }
      /**
       * <code>optional uint32 nodeid = 1;</code>
       *
       * <pre>
       * node-id or loopback
       * </pre>
       */
      public Builder setNodeid(int value) {
        bitField0_ |= 0x00000001;
        nodeid_ = value;
        
        return this;
      }
      /**
       * <code>optional uint32 nodeid = 1;</code>
       *
       * <pre>
       * node-id or loopback
       * </pre>
       */
      public Builder clearNodeid() {
        bitField0_ = (bitField0_ & ~0x00000001);
        nodeid_ = 0;
        
        return this;
      }

      private int flags_ ;
      /**
       * <code>optional uint32 flags = 2;</code>
       *
       * <pre>
       * contains flags
       * </pre>
       */
      public boolean hasFlags() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint32 flags = 2;</code>
       *
       * <pre>
       * contains flags
       * </pre>
       */
      public int getFlags() {
        return flags_;
      }
      /**
       * <code>optional uint32 flags = 2;</code>
       *
       * <pre>
       * contains flags
       * </pre>
       */
      public Builder setFlags(int value) {
        bitField0_ |= 0x00000002;
        flags_ = value;
        
        return this;
      }
      /**
       * <code>optional uint32 flags = 2;</code>
       *
       * <pre>
       * contains flags
       * </pre>
       */
      public Builder clearFlags() {
        bitField0_ = (bitField0_ & ~0x00000002);
        flags_ = 0;
        
        return this;
      }

      private int intfAddr_ ;
      /**
       * <code>optional uint32 intf_addr = 3;</code>
       *
       * <pre>
       * interface-ip
       * </pre>
       */
      public boolean hasIntfAddr() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint32 intf_addr = 3;</code>
       *
       * <pre>
       * interface-ip
       * </pre>
       */
      public int getIntfAddr() {
        return intfAddr_;
      }
      /**
       * <code>optional uint32 intf_addr = 3;</code>
       *
       * <pre>
       * interface-ip
       * </pre>
       */
      public Builder setIntfAddr(int value) {
        bitField0_ |= 0x00000004;
        intfAddr_ = value;
        
        return this;
      }
      /**
       * <code>optional uint32 intf_addr = 3;</code>
       *
       * <pre>
       * interface-ip
       * </pre>
       */
      public Builder clearIntfAddr() {
        bitField0_ = (bitField0_ & ~0x00000004);
        intfAddr_ = 0;
        
        return this;
      }

      private int label_ ;
      /**
       * <code>optional uint32 label = 4;</code>
       *
       * <pre>
       * may be using PHP
       * </pre>
       */
      public boolean hasLabel() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional uint32 label = 4;</code>
       *
       * <pre>
       * may be using PHP
       * </pre>
       */
      public int getLabel() {
        return label_;
      }
      /**
       * <code>optional uint32 label = 4;</code>
       *
       * <pre>
       * may be using PHP
       * </pre>
       */
      public Builder setLabel(int value) {
        bitField0_ |= 0x00000008;
        label_ = value;
        
        return this;
      }
      /**
       * <code>optional uint32 label = 4;</code>
       *
       * <pre>
       * may be using PHP
       * </pre>
       */
      public Builder clearLabel() {
        bitField0_ = (bitField0_ & ~0x00000008);
        label_ = 0;
        
        return this;
      }

      // @@protoc_insertion_point(builder_scope:rro_type_entry)
    }

    static {
      defaultInstance = new rro_type_entry(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:rro_type_entry)
  }

  public interface rro_ipv4_typeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:rro_ipv4_type)
      com.google.protobuf.MessageLiteOrBuilder {

    /**
     * <code>repeated .rro_type_entry rro_entry = 1;</code>
     */
    java.util.List<LspMon.rro_type_entry> 
        getRroEntryList();
    /**
     * <code>repeated .rro_type_entry rro_entry = 1;</code>
     */
    LspMon.rro_type_entry getRroEntry(int index);
    /**
     * <code>repeated .rro_type_entry rro_entry = 1;</code>
     */
    int getRroEntryCount();
  }
  /**
   * Protobuf type {@code rro_ipv4_type}
   */
  public static final class rro_ipv4_type extends
      com.google.protobuf.GeneratedMessageLite implements
      // @@protoc_insertion_point(message_implements:rro_ipv4_type)
      rro_ipv4_typeOrBuilder {
    // Use rro_ipv4_type.newBuilder() to construct.
    private rro_ipv4_type(com.google.protobuf.GeneratedMessageLite.Builder builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private rro_ipv4_type(boolean noInit) { this.unknownFields = com.google.protobuf.ByteString.EMPTY;}

    private static final rro_ipv4_type defaultInstance;
    public static rro_ipv4_type getDefaultInstance() {
      return defaultInstance;
    }

    public rro_ipv4_type getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.ByteString unknownFields;
    private rro_ipv4_type(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.ByteString.Output unknownFieldsOutput =
          com.google.protobuf.ByteString.newOutput();
      com.google.protobuf.CodedOutputStream unknownFieldsCodedOutput =
          com.google.protobuf.CodedOutputStream.newInstance(
              unknownFieldsOutput);
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFieldsCodedOutput,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                rroEntry_ = new java.util.ArrayList<LspMon.rro_type_entry>();
                mutable_bitField0_ |= 0x00000001;
              }
              rroEntry_.add(input.readMessage(LspMon.rro_type_entry.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          rroEntry_ = java.util.Collections.unmodifiableList(rroEntry_);
        }
        try {
          unknownFieldsCodedOutput.flush();
        } catch (java.io.IOException e) {
        // Should not happen
        } finally {
          unknownFields = unknownFieldsOutput.toByteString();
        }
        makeExtensionsImmutable();
      }
    }
    public static com.google.protobuf.Parser<rro_ipv4_type> PARSER =
        new com.google.protobuf.AbstractParser<rro_ipv4_type>() {
      public rro_ipv4_type parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new rro_ipv4_type(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<rro_ipv4_type> getParserForType() {
      return PARSER;
    }

    public static final int RRO_ENTRY_FIELD_NUMBER = 1;
    private java.util.List<LspMon.rro_type_entry> rroEntry_;
    /**
     * <code>repeated .rro_type_entry rro_entry = 1;</code>
     */
    public java.util.List<LspMon.rro_type_entry> getRroEntryList() {
      return rroEntry_;
    }
    /**
     * <code>repeated .rro_type_entry rro_entry = 1;</code>
     */
    public java.util.List<? extends LspMon.rro_type_entryOrBuilder> 
        getRroEntryOrBuilderList() {
      return rroEntry_;
    }
    /**
     * <code>repeated .rro_type_entry rro_entry = 1;</code>
     */
    public int getRroEntryCount() {
      return rroEntry_.size();
    }
    /**
     * <code>repeated .rro_type_entry rro_entry = 1;</code>
     */
    public LspMon.rro_type_entry getRroEntry(int index) {
      return rroEntry_.get(index);
    }
    /**
     * <code>repeated .rro_type_entry rro_entry = 1;</code>
     */
    public LspMon.rro_type_entryOrBuilder getRroEntryOrBuilder(
        int index) {
      return rroEntry_.get(index);
    }

    private void initFields() {
      rroEntry_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < rroEntry_.size(); i++) {
        output.writeMessage(1, rroEntry_.get(i));
      }
      output.writeRawBytes(unknownFields);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < rroEntry_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, rroEntry_.get(i));
      }
      size += unknownFields.size();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LspMon.rro_ipv4_type parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.rro_ipv4_type parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.rro_ipv4_type parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.rro_ipv4_type parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.rro_ipv4_type parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.rro_ipv4_type parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LspMon.rro_ipv4_type parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LspMon.rro_ipv4_type parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LspMon.rro_ipv4_type parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.rro_ipv4_type parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LspMon.rro_ipv4_type prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    /**
     * Protobuf type {@code rro_ipv4_type}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageLite.Builder<
          LspMon.rro_ipv4_type, Builder>
        implements
        // @@protoc_insertion_point(builder_implements:rro_ipv4_type)
        LspMon.rro_ipv4_typeOrBuilder {
      // Construct using LspMon.rro_ipv4_type.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        rroEntry_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public LspMon.rro_ipv4_type getDefaultInstanceForType() {
        return LspMon.rro_ipv4_type.getDefaultInstance();
      }

      public LspMon.rro_ipv4_type build() {
        LspMon.rro_ipv4_type result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LspMon.rro_ipv4_type buildPartial() {
        LspMon.rro_ipv4_type result = new LspMon.rro_ipv4_type(this);
        int from_bitField0_ = bitField0_;
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          rroEntry_ = java.util.Collections.unmodifiableList(rroEntry_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.rroEntry_ = rroEntry_;
        return result;
      }

      public Builder mergeFrom(LspMon.rro_ipv4_type other) {
        if (other == LspMon.rro_ipv4_type.getDefaultInstance()) return this;
        if (!other.rroEntry_.isEmpty()) {
          if (rroEntry_.isEmpty()) {
            rroEntry_ = other.rroEntry_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRroEntryIsMutable();
            rroEntry_.addAll(other.rroEntry_);
          }
          
        }
        setUnknownFields(
            getUnknownFields().concat(other.unknownFields));
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LspMon.rro_ipv4_type parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LspMon.rro_ipv4_type) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<LspMon.rro_type_entry> rroEntry_ =
        java.util.Collections.emptyList();
      private void ensureRroEntryIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          rroEntry_ = new java.util.ArrayList<LspMon.rro_type_entry>(rroEntry_);
          bitField0_ |= 0x00000001;
         }
      }

      /**
       * <code>repeated .rro_type_entry rro_entry = 1;</code>
       */
      public java.util.List<LspMon.rro_type_entry> getRroEntryList() {
        return java.util.Collections.unmodifiableList(rroEntry_);
      }
      /**
       * <code>repeated .rro_type_entry rro_entry = 1;</code>
       */
      public int getRroEntryCount() {
        return rroEntry_.size();
      }
      /**
       * <code>repeated .rro_type_entry rro_entry = 1;</code>
       */
      public LspMon.rro_type_entry getRroEntry(int index) {
        return rroEntry_.get(index);
      }
      /**
       * <code>repeated .rro_type_entry rro_entry = 1;</code>
       */
      public Builder setRroEntry(
          int index, LspMon.rro_type_entry value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRroEntryIsMutable();
        rroEntry_.set(index, value);

        return this;
      }
      /**
       * <code>repeated .rro_type_entry rro_entry = 1;</code>
       */
      public Builder setRroEntry(
          int index, LspMon.rro_type_entry.Builder builderForValue) {
        ensureRroEntryIsMutable();
        rroEntry_.set(index, builderForValue.build());

        return this;
      }
      /**
       * <code>repeated .rro_type_entry rro_entry = 1;</code>
       */
      public Builder addRroEntry(LspMon.rro_type_entry value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRroEntryIsMutable();
        rroEntry_.add(value);

        return this;
      }
      /**
       * <code>repeated .rro_type_entry rro_entry = 1;</code>
       */
      public Builder addRroEntry(
          int index, LspMon.rro_type_entry value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRroEntryIsMutable();
        rroEntry_.add(index, value);

        return this;
      }
      /**
       * <code>repeated .rro_type_entry rro_entry = 1;</code>
       */
      public Builder addRroEntry(
          LspMon.rro_type_entry.Builder builderForValue) {
        ensureRroEntryIsMutable();
        rroEntry_.add(builderForValue.build());

        return this;
      }
      /**
       * <code>repeated .rro_type_entry rro_entry = 1;</code>
       */
      public Builder addRroEntry(
          int index, LspMon.rro_type_entry.Builder builderForValue) {
        ensureRroEntryIsMutable();
        rroEntry_.add(index, builderForValue.build());

        return this;
      }
      /**
       * <code>repeated .rro_type_entry rro_entry = 1;</code>
       */
      public Builder addAllRroEntry(
          java.lang.Iterable<? extends LspMon.rro_type_entry> values) {
        ensureRroEntryIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, rroEntry_);

        return this;
      }
      /**
       * <code>repeated .rro_type_entry rro_entry = 1;</code>
       */
      public Builder clearRroEntry() {
        rroEntry_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);

        return this;
      }
      /**
       * <code>repeated .rro_type_entry rro_entry = 1;</code>
       */
      public Builder removeRroEntry(int index) {
        ensureRroEntryIsMutable();
        rroEntry_.remove(index);

        return this;
      }

      // @@protoc_insertion_point(builder_scope:rro_ipv4_type)
    }

    static {
      defaultInstance = new rro_ipv4_type(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:rro_ipv4_type)
  }

  public interface lsp_monitor_data_propertyOrBuilder extends
      // @@protoc_insertion_point(interface_extends:lsp_monitor_data_property)
      com.google.protobuf.MessageLiteOrBuilder {

    /**
     * <code>optional uint64 bandwidth = 1;</code>
     */
    boolean hasBandwidth();
    /**
     * <code>optional uint64 bandwidth = 1;</code>
     */
    long getBandwidth();

    /**
     * <code>optional string path_name = 2;</code>
     */
    boolean hasPathName();
    /**
     * <code>optional string path_name = 2;</code>
     */
    java.lang.String getPathName();
    /**
     * <code>optional string path_name = 2;</code>
     */
    com.google.protobuf.ByteString
        getPathNameBytes();

    /**
     * <code>optional int32 metric = 3;</code>
     */
    boolean hasMetric();
    /**
     * <code>optional int32 metric = 3;</code>
     */
    int getMetric();

    /**
     * <code>optional float max_avg_bw = 4;</code>
     */
    boolean hasMaxAvgBw();
    /**
     * <code>optional float max_avg_bw = 4;</code>
     */
    float getMaxAvgBw();

    /**
     * <code>optional .ero_ipv4_type ero = 5;</code>
     */
    boolean hasEro();
    /**
     * <code>optional .ero_ipv4_type ero = 5;</code>
     */
    LspMon.ero_ipv4_type getEro();

    /**
     * <code>optional .rro_ipv4_type rro = 6;</code>
     */
    boolean hasRro();
    /**
     * <code>optional .rro_ipv4_type rro = 6;</code>
     */
    LspMon.rro_ipv4_type getRro();
  }
  /**
   * Protobuf type {@code lsp_monitor_data_property}
   *
   * <pre>
   * Schema for communicating properties of LSPs
   * </pre>
   */
  public static final class lsp_monitor_data_property extends
      com.google.protobuf.GeneratedMessageLite implements
      // @@protoc_insertion_point(message_implements:lsp_monitor_data_property)
      lsp_monitor_data_propertyOrBuilder {
    // Use lsp_monitor_data_property.newBuilder() to construct.
    private lsp_monitor_data_property(com.google.protobuf.GeneratedMessageLite.Builder builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private lsp_monitor_data_property(boolean noInit) { this.unknownFields = com.google.protobuf.ByteString.EMPTY;}

    private static final lsp_monitor_data_property defaultInstance;
    public static lsp_monitor_data_property getDefaultInstance() {
      return defaultInstance;
    }

    public lsp_monitor_data_property getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.ByteString unknownFields;
    private lsp_monitor_data_property(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.ByteString.Output unknownFieldsOutput =
          com.google.protobuf.ByteString.newOutput();
      com.google.protobuf.CodedOutputStream unknownFieldsCodedOutput =
          com.google.protobuf.CodedOutputStream.newInstance(
              unknownFieldsOutput);
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFieldsCodedOutput,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              bandwidth_ = input.readUInt64();
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              pathName_ = bs;
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              metric_ = input.readInt32();
              break;
            }
            case 37: {
              bitField0_ |= 0x00000008;
              maxAvgBw_ = input.readFloat();
              break;
            }
            case 42: {
              LspMon.ero_ipv4_type.Builder subBuilder = null;
              if (((bitField0_ & 0x00000010) == 0x00000010)) {
                subBuilder = ero_.toBuilder();
              }
              ero_ = input.readMessage(LspMon.ero_ipv4_type.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(ero_);
                ero_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000010;
              break;
            }
            case 50: {
              LspMon.rro_ipv4_type.Builder subBuilder = null;
              if (((bitField0_ & 0x00000020) == 0x00000020)) {
                subBuilder = rro_.toBuilder();
              }
              rro_ = input.readMessage(LspMon.rro_ipv4_type.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(rro_);
                rro_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000020;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        try {
          unknownFieldsCodedOutput.flush();
        } catch (java.io.IOException e) {
        // Should not happen
        } finally {
          unknownFields = unknownFieldsOutput.toByteString();
        }
        makeExtensionsImmutable();
      }
    }
    public static com.google.protobuf.Parser<lsp_monitor_data_property> PARSER =
        new com.google.protobuf.AbstractParser<lsp_monitor_data_property>() {
      public lsp_monitor_data_property parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new lsp_monitor_data_property(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<lsp_monitor_data_property> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int BANDWIDTH_FIELD_NUMBER = 1;
    private long bandwidth_;
    /**
     * <code>optional uint64 bandwidth = 1;</code>
     */
    public boolean hasBandwidth() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional uint64 bandwidth = 1;</code>
     */
    public long getBandwidth() {
      return bandwidth_;
    }

    public static final int PATH_NAME_FIELD_NUMBER = 2;
    private java.lang.Object pathName_;
    /**
     * <code>optional string path_name = 2;</code>
     */
    public boolean hasPathName() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string path_name = 2;</code>
     */
    public java.lang.String getPathName() {
      java.lang.Object ref = pathName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          pathName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string path_name = 2;</code>
     */
    public com.google.protobuf.ByteString
        getPathNameBytes() {
      java.lang.Object ref = pathName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        pathName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int METRIC_FIELD_NUMBER = 3;
    private int metric_;
    /**
     * <code>optional int32 metric = 3;</code>
     */
    public boolean hasMetric() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional int32 metric = 3;</code>
     */
    public int getMetric() {
      return metric_;
    }

    public static final int MAX_AVG_BW_FIELD_NUMBER = 4;
    private float maxAvgBw_;
    /**
     * <code>optional float max_avg_bw = 4;</code>
     */
    public boolean hasMaxAvgBw() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional float max_avg_bw = 4;</code>
     */
    public float getMaxAvgBw() {
      return maxAvgBw_;
    }

    public static final int ERO_FIELD_NUMBER = 5;
    private LspMon.ero_ipv4_type ero_;
    /**
     * <code>optional .ero_ipv4_type ero = 5;</code>
     */
    public boolean hasEro() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional .ero_ipv4_type ero = 5;</code>
     */
    public LspMon.ero_ipv4_type getEro() {
      return ero_;
    }

    public static final int RRO_FIELD_NUMBER = 6;
    private LspMon.rro_ipv4_type rro_;
    /**
     * <code>optional .rro_ipv4_type rro = 6;</code>
     */
    public boolean hasRro() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional .rro_ipv4_type rro = 6;</code>
     */
    public LspMon.rro_ipv4_type getRro() {
      return rro_;
    }

    private void initFields() {
      bandwidth_ = 0L;
      pathName_ = "";
      metric_ = 0;
      maxAvgBw_ = 0F;
      ero_ = LspMon.ero_ipv4_type.getDefaultInstance();
      rro_ = LspMon.rro_ipv4_type.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (hasEro()) {
        if (!getEro().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeUInt64(1, bandwidth_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getPathNameBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt32(3, metric_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeFloat(4, maxAvgBw_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeMessage(5, ero_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeMessage(6, rro_);
      }
      output.writeRawBytes(unknownFields);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, bandwidth_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getPathNameBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(3, metric_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeFloatSize(4, maxAvgBw_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, ero_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, rro_);
      }
      size += unknownFields.size();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LspMon.lsp_monitor_data_property parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.lsp_monitor_data_property parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.lsp_monitor_data_property parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.lsp_monitor_data_property parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.lsp_monitor_data_property parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.lsp_monitor_data_property parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LspMon.lsp_monitor_data_property parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LspMon.lsp_monitor_data_property parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LspMon.lsp_monitor_data_property parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.lsp_monitor_data_property parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LspMon.lsp_monitor_data_property prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    /**
     * Protobuf type {@code lsp_monitor_data_property}
     *
     * <pre>
     * Schema for communicating properties of LSPs
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageLite.Builder<
          LspMon.lsp_monitor_data_property, Builder>
        implements
        // @@protoc_insertion_point(builder_implements:lsp_monitor_data_property)
        LspMon.lsp_monitor_data_propertyOrBuilder {
      // Construct using LspMon.lsp_monitor_data_property.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        bandwidth_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        pathName_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        metric_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        maxAvgBw_ = 0F;
        bitField0_ = (bitField0_ & ~0x00000008);
        ero_ = LspMon.ero_ipv4_type.getDefaultInstance();
        bitField0_ = (bitField0_ & ~0x00000010);
        rro_ = LspMon.rro_ipv4_type.getDefaultInstance();
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public LspMon.lsp_monitor_data_property getDefaultInstanceForType() {
        return LspMon.lsp_monitor_data_property.getDefaultInstance();
      }

      public LspMon.lsp_monitor_data_property build() {
        LspMon.lsp_monitor_data_property result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LspMon.lsp_monitor_data_property buildPartial() {
        LspMon.lsp_monitor_data_property result = new LspMon.lsp_monitor_data_property(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.bandwidth_ = bandwidth_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.pathName_ = pathName_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.metric_ = metric_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.maxAvgBw_ = maxAvgBw_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.ero_ = ero_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.rro_ = rro_;
        result.bitField0_ = to_bitField0_;
        return result;
      }

      public Builder mergeFrom(LspMon.lsp_monitor_data_property other) {
        if (other == LspMon.lsp_monitor_data_property.getDefaultInstance()) return this;
        if (other.hasBandwidth()) {
          setBandwidth(other.getBandwidth());
        }
        if (other.hasPathName()) {
          bitField0_ |= 0x00000002;
          pathName_ = other.pathName_;
          
        }
        if (other.hasMetric()) {
          setMetric(other.getMetric());
        }
        if (other.hasMaxAvgBw()) {
          setMaxAvgBw(other.getMaxAvgBw());
        }
        if (other.hasEro()) {
          mergeEro(other.getEro());
        }
        if (other.hasRro()) {
          mergeRro(other.getRro());
        }
        setUnknownFields(
            getUnknownFields().concat(other.unknownFields));
        return this;
      }

      public final boolean isInitialized() {
        if (hasEro()) {
          if (!getEro().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LspMon.lsp_monitor_data_property parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LspMon.lsp_monitor_data_property) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long bandwidth_ ;
      /**
       * <code>optional uint64 bandwidth = 1;</code>
       */
      public boolean hasBandwidth() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional uint64 bandwidth = 1;</code>
       */
      public long getBandwidth() {
        return bandwidth_;
      }
      /**
       * <code>optional uint64 bandwidth = 1;</code>
       */
      public Builder setBandwidth(long value) {
        bitField0_ |= 0x00000001;
        bandwidth_ = value;
        
        return this;
      }
      /**
       * <code>optional uint64 bandwidth = 1;</code>
       */
      public Builder clearBandwidth() {
        bitField0_ = (bitField0_ & ~0x00000001);
        bandwidth_ = 0L;
        
        return this;
      }

      private java.lang.Object pathName_ = "";
      /**
       * <code>optional string path_name = 2;</code>
       */
      public boolean hasPathName() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string path_name = 2;</code>
       */
      public java.lang.String getPathName() {
        java.lang.Object ref = pathName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            pathName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string path_name = 2;</code>
       */
      public com.google.protobuf.ByteString
          getPathNameBytes() {
        java.lang.Object ref = pathName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          pathName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string path_name = 2;</code>
       */
      public Builder setPathName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        pathName_ = value;
        
        return this;
      }
      /**
       * <code>optional string path_name = 2;</code>
       */
      public Builder clearPathName() {
        bitField0_ = (bitField0_ & ~0x00000002);
        pathName_ = getDefaultInstance().getPathName();
        
        return this;
      }
      /**
       * <code>optional string path_name = 2;</code>
       */
      public Builder setPathNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        pathName_ = value;
        
        return this;
      }

      private int metric_ ;
      /**
       * <code>optional int32 metric = 3;</code>
       */
      public boolean hasMetric() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional int32 metric = 3;</code>
       */
      public int getMetric() {
        return metric_;
      }
      /**
       * <code>optional int32 metric = 3;</code>
       */
      public Builder setMetric(int value) {
        bitField0_ |= 0x00000004;
        metric_ = value;
        
        return this;
      }
      /**
       * <code>optional int32 metric = 3;</code>
       */
      public Builder clearMetric() {
        bitField0_ = (bitField0_ & ~0x00000004);
        metric_ = 0;
        
        return this;
      }

      private float maxAvgBw_ ;
      /**
       * <code>optional float max_avg_bw = 4;</code>
       */
      public boolean hasMaxAvgBw() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional float max_avg_bw = 4;</code>
       */
      public float getMaxAvgBw() {
        return maxAvgBw_;
      }
      /**
       * <code>optional float max_avg_bw = 4;</code>
       */
      public Builder setMaxAvgBw(float value) {
        bitField0_ |= 0x00000008;
        maxAvgBw_ = value;
        
        return this;
      }
      /**
       * <code>optional float max_avg_bw = 4;</code>
       */
      public Builder clearMaxAvgBw() {
        bitField0_ = (bitField0_ & ~0x00000008);
        maxAvgBw_ = 0F;
        
        return this;
      }

      private LspMon.ero_ipv4_type ero_ = LspMon.ero_ipv4_type.getDefaultInstance();
      /**
       * <code>optional .ero_ipv4_type ero = 5;</code>
       */
      public boolean hasEro() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional .ero_ipv4_type ero = 5;</code>
       */
      public LspMon.ero_ipv4_type getEro() {
        return ero_;
      }
      /**
       * <code>optional .ero_ipv4_type ero = 5;</code>
       */
      public Builder setEro(LspMon.ero_ipv4_type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ero_ = value;

        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .ero_ipv4_type ero = 5;</code>
       */
      public Builder setEro(
          LspMon.ero_ipv4_type.Builder builderForValue) {
        ero_ = builderForValue.build();

        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .ero_ipv4_type ero = 5;</code>
       */
      public Builder mergeEro(LspMon.ero_ipv4_type value) {
        if (((bitField0_ & 0x00000010) == 0x00000010) &&
            ero_ != LspMon.ero_ipv4_type.getDefaultInstance()) {
          ero_ =
            LspMon.ero_ipv4_type.newBuilder(ero_).mergeFrom(value).buildPartial();
        } else {
          ero_ = value;
        }

        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .ero_ipv4_type ero = 5;</code>
       */
      public Builder clearEro() {
        ero_ = LspMon.ero_ipv4_type.getDefaultInstance();

        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      private LspMon.rro_ipv4_type rro_ = LspMon.rro_ipv4_type.getDefaultInstance();
      /**
       * <code>optional .rro_ipv4_type rro = 6;</code>
       */
      public boolean hasRro() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional .rro_ipv4_type rro = 6;</code>
       */
      public LspMon.rro_ipv4_type getRro() {
        return rro_;
      }
      /**
       * <code>optional .rro_ipv4_type rro = 6;</code>
       */
      public Builder setRro(LspMon.rro_ipv4_type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        rro_ = value;

        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .rro_ipv4_type rro = 6;</code>
       */
      public Builder setRro(
          LspMon.rro_ipv4_type.Builder builderForValue) {
        rro_ = builderForValue.build();

        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .rro_ipv4_type rro = 6;</code>
       */
      public Builder mergeRro(LspMon.rro_ipv4_type value) {
        if (((bitField0_ & 0x00000020) == 0x00000020) &&
            rro_ != LspMon.rro_ipv4_type.getDefaultInstance()) {
          rro_ =
            LspMon.rro_ipv4_type.newBuilder(rro_).mergeFrom(value).buildPartial();
        } else {
          rro_ = value;
        }

        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .rro_ipv4_type rro = 6;</code>
       */
      public Builder clearRro() {
        rro_ = LspMon.rro_ipv4_type.getDefaultInstance();

        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }

      // @@protoc_insertion_point(builder_scope:lsp_monitor_data_property)
    }

    static {
      defaultInstance = new lsp_monitor_data_property(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:lsp_monitor_data_property)
  }

  public interface lsp_monOrBuilder extends
      // @@protoc_insertion_point(interface_extends:lsp_mon)
      com.google.protobuf.MessageLiteOrBuilder {

    /**
     * <code>required .key key_field = 1;</code>
     */
    boolean hasKeyField();
    /**
     * <code>required .key key_field = 1;</code>
     */
    LspMon.key getKeyField();

    /**
     * <code>optional .lsp_monitor_data_event event_field = 2;</code>
     */
    boolean hasEventField();
    /**
     * <code>optional .lsp_monitor_data_event event_field = 2;</code>
     */
    LspMon.lsp_monitor_data_event getEventField();

    /**
     * <code>optional .lsp_monitor_data_property property_field = 3;</code>
     */
    boolean hasPropertyField();
    /**
     * <code>optional .lsp_monitor_data_property property_field = 3;</code>
     */
    LspMon.lsp_monitor_data_property getPropertyField();
  }
  /**
   * Protobuf type {@code lsp_mon}
   */
  public static final class lsp_mon extends
      com.google.protobuf.GeneratedMessageLite implements
      // @@protoc_insertion_point(message_implements:lsp_mon)
      lsp_monOrBuilder {
    // Use lsp_mon.newBuilder() to construct.
    private lsp_mon(com.google.protobuf.GeneratedMessageLite.Builder builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private lsp_mon(boolean noInit) { this.unknownFields = com.google.protobuf.ByteString.EMPTY;}

    private static final lsp_mon defaultInstance;
    public static lsp_mon getDefaultInstance() {
      return defaultInstance;
    }

    public lsp_mon getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.ByteString unknownFields;
    private lsp_mon(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.ByteString.Output unknownFieldsOutput =
          com.google.protobuf.ByteString.newOutput();
      com.google.protobuf.CodedOutputStream unknownFieldsCodedOutput =
          com.google.protobuf.CodedOutputStream.newInstance(
              unknownFieldsOutput);
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFieldsCodedOutput,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              LspMon.key.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = keyField_.toBuilder();
              }
              keyField_ = input.readMessage(LspMon.key.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(keyField_);
                keyField_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 18: {
              LspMon.lsp_monitor_data_event.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = eventField_.toBuilder();
              }
              eventField_ = input.readMessage(LspMon.lsp_monitor_data_event.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(eventField_);
                eventField_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
            case 26: {
              LspMon.lsp_monitor_data_property.Builder subBuilder = null;
              if (((bitField0_ & 0x00000004) == 0x00000004)) {
                subBuilder = propertyField_.toBuilder();
              }
              propertyField_ = input.readMessage(LspMon.lsp_monitor_data_property.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(propertyField_);
                propertyField_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000004;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        try {
          unknownFieldsCodedOutput.flush();
        } catch (java.io.IOException e) {
        // Should not happen
        } finally {
          unknownFields = unknownFieldsOutput.toByteString();
        }
        makeExtensionsImmutable();
      }
    }
    public static com.google.protobuf.Parser<lsp_mon> PARSER =
        new com.google.protobuf.AbstractParser<lsp_mon>() {
      public lsp_mon parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new lsp_mon(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<lsp_mon> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int KEY_FIELD_FIELD_NUMBER = 1;
    private LspMon.key keyField_;
    /**
     * <code>required .key key_field = 1;</code>
     */
    public boolean hasKeyField() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .key key_field = 1;</code>
     */
    public LspMon.key getKeyField() {
      return keyField_;
    }

    public static final int EVENT_FIELD_FIELD_NUMBER = 2;
    private LspMon.lsp_monitor_data_event eventField_;
    /**
     * <code>optional .lsp_monitor_data_event event_field = 2;</code>
     */
    public boolean hasEventField() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .lsp_monitor_data_event event_field = 2;</code>
     */
    public LspMon.lsp_monitor_data_event getEventField() {
      return eventField_;
    }

    public static final int PROPERTY_FIELD_FIELD_NUMBER = 3;
    private LspMon.lsp_monitor_data_property propertyField_;
    /**
     * <code>optional .lsp_monitor_data_property property_field = 3;</code>
     */
    public boolean hasPropertyField() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .lsp_monitor_data_property property_field = 3;</code>
     */
    public LspMon.lsp_monitor_data_property getPropertyField() {
      return propertyField_;
    }

    private void initFields() {
      keyField_ = LspMon.key.getDefaultInstance();
      eventField_ = LspMon.lsp_monitor_data_event.getDefaultInstance();
      propertyField_ = LspMon.lsp_monitor_data_property.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasKeyField()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getKeyField().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasEventField()) {
        if (!getEventField().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasPropertyField()) {
        if (!getPropertyField().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, keyField_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, eventField_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, propertyField_);
      }
      output.writeRawBytes(unknownFields);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, keyField_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, eventField_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, propertyField_);
      }
      size += unknownFields.size();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LspMon.lsp_mon parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.lsp_mon parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.lsp_mon parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspMon.lsp_mon parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspMon.lsp_mon parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.lsp_mon parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LspMon.lsp_mon parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LspMon.lsp_mon parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LspMon.lsp_mon parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspMon.lsp_mon parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LspMon.lsp_mon prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    /**
     * Protobuf type {@code lsp_mon}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageLite.Builder<
          LspMon.lsp_mon, Builder>
        implements
        // @@protoc_insertion_point(builder_implements:lsp_mon)
        LspMon.lsp_monOrBuilder {
      // Construct using LspMon.lsp_mon.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        keyField_ = LspMon.key.getDefaultInstance();
        bitField0_ = (bitField0_ & ~0x00000001);
        eventField_ = LspMon.lsp_monitor_data_event.getDefaultInstance();
        bitField0_ = (bitField0_ & ~0x00000002);
        propertyField_ = LspMon.lsp_monitor_data_property.getDefaultInstance();
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public LspMon.lsp_mon getDefaultInstanceForType() {
        return LspMon.lsp_mon.getDefaultInstance();
      }

      public LspMon.lsp_mon build() {
        LspMon.lsp_mon result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LspMon.lsp_mon buildPartial() {
        LspMon.lsp_mon result = new LspMon.lsp_mon(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.keyField_ = keyField_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.eventField_ = eventField_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.propertyField_ = propertyField_;
        result.bitField0_ = to_bitField0_;
        return result;
      }

      public Builder mergeFrom(LspMon.lsp_mon other) {
        if (other == LspMon.lsp_mon.getDefaultInstance()) return this;
        if (other.hasKeyField()) {
          mergeKeyField(other.getKeyField());
        }
        if (other.hasEventField()) {
          mergeEventField(other.getEventField());
        }
        if (other.hasPropertyField()) {
          mergePropertyField(other.getPropertyField());
        }
        setUnknownFields(
            getUnknownFields().concat(other.unknownFields));
        return this;
      }

      public final boolean isInitialized() {
        if (!hasKeyField()) {
          
          return false;
        }
        if (!getKeyField().isInitialized()) {
          
          return false;
        }
        if (hasEventField()) {
          if (!getEventField().isInitialized()) {
            
            return false;
          }
        }
        if (hasPropertyField()) {
          if (!getPropertyField().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LspMon.lsp_mon parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LspMon.lsp_mon) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private LspMon.key keyField_ = LspMon.key.getDefaultInstance();
      /**
       * <code>required .key key_field = 1;</code>
       */
      public boolean hasKeyField() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .key key_field = 1;</code>
       */
      public LspMon.key getKeyField() {
        return keyField_;
      }
      /**
       * <code>required .key key_field = 1;</code>
       */
      public Builder setKeyField(LspMon.key value) {
        if (value == null) {
          throw new NullPointerException();
        }
        keyField_ = value;

        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .key key_field = 1;</code>
       */
      public Builder setKeyField(
          LspMon.key.Builder builderForValue) {
        keyField_ = builderForValue.build();

        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .key key_field = 1;</code>
       */
      public Builder mergeKeyField(LspMon.key value) {
        if (((bitField0_ & 0x00000001) == 0x00000001) &&
            keyField_ != LspMon.key.getDefaultInstance()) {
          keyField_ =
            LspMon.key.newBuilder(keyField_).mergeFrom(value).buildPartial();
        } else {
          keyField_ = value;
        }

        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .key key_field = 1;</code>
       */
      public Builder clearKeyField() {
        keyField_ = LspMon.key.getDefaultInstance();

        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      private LspMon.lsp_monitor_data_event eventField_ = LspMon.lsp_monitor_data_event.getDefaultInstance();
      /**
       * <code>optional .lsp_monitor_data_event event_field = 2;</code>
       */
      public boolean hasEventField() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .lsp_monitor_data_event event_field = 2;</code>
       */
      public LspMon.lsp_monitor_data_event getEventField() {
        return eventField_;
      }
      /**
       * <code>optional .lsp_monitor_data_event event_field = 2;</code>
       */
      public Builder setEventField(LspMon.lsp_monitor_data_event value) {
        if (value == null) {
          throw new NullPointerException();
        }
        eventField_ = value;

        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .lsp_monitor_data_event event_field = 2;</code>
       */
      public Builder setEventField(
          LspMon.lsp_monitor_data_event.Builder builderForValue) {
        eventField_ = builderForValue.build();

        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .lsp_monitor_data_event event_field = 2;</code>
       */
      public Builder mergeEventField(LspMon.lsp_monitor_data_event value) {
        if (((bitField0_ & 0x00000002) == 0x00000002) &&
            eventField_ != LspMon.lsp_monitor_data_event.getDefaultInstance()) {
          eventField_ =
            LspMon.lsp_monitor_data_event.newBuilder(eventField_).mergeFrom(value).buildPartial();
        } else {
          eventField_ = value;
        }

        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .lsp_monitor_data_event event_field = 2;</code>
       */
      public Builder clearEventField() {
        eventField_ = LspMon.lsp_monitor_data_event.getDefaultInstance();

        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      private LspMon.lsp_monitor_data_property propertyField_ = LspMon.lsp_monitor_data_property.getDefaultInstance();
      /**
       * <code>optional .lsp_monitor_data_property property_field = 3;</code>
       */
      public boolean hasPropertyField() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .lsp_monitor_data_property property_field = 3;</code>
       */
      public LspMon.lsp_monitor_data_property getPropertyField() {
        return propertyField_;
      }
      /**
       * <code>optional .lsp_monitor_data_property property_field = 3;</code>
       */
      public Builder setPropertyField(LspMon.lsp_monitor_data_property value) {
        if (value == null) {
          throw new NullPointerException();
        }
        propertyField_ = value;

        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .lsp_monitor_data_property property_field = 3;</code>
       */
      public Builder setPropertyField(
          LspMon.lsp_monitor_data_property.Builder builderForValue) {
        propertyField_ = builderForValue.build();

        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .lsp_monitor_data_property property_field = 3;</code>
       */
      public Builder mergePropertyField(LspMon.lsp_monitor_data_property value) {
        if (((bitField0_ & 0x00000004) == 0x00000004) &&
            propertyField_ != LspMon.lsp_monitor_data_property.getDefaultInstance()) {
          propertyField_ =
            LspMon.lsp_monitor_data_property.newBuilder(propertyField_).mergeFrom(value).buildPartial();
        } else {
          propertyField_ = value;
        }

        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .lsp_monitor_data_property property_field = 3;</code>
       */
      public Builder clearPropertyField() {
        propertyField_ = LspMon.lsp_monitor_data_property.getDefaultInstance();

        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      // @@protoc_insertion_point(builder_scope:lsp_mon)
    }

    static {
      defaultInstance = new lsp_mon(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:lsp_mon)
  }


  static {
  }

  // @@protoc_insertion_point(outer_class_scope)
}
