/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2017-2017 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2017 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/
package org.opennms.netmgt.telemetry.adapters.jti.proto;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: logical_port.proto

public final class LogicalPortOuterClass {
  private LogicalPortOuterClass() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registry.add(LogicalPortOuterClass.jnprLogicalInterfaceExt);
  }
  public interface LogicalPortOrBuilder extends
      // @@protoc_insertion_point(interface_extends:LogicalPort)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
     */
    java.util.List<LogicalPortOuterClass.LogicalInterfaceInfo> 
        getInterfaceInfoList();
    /**
     * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
     */
    LogicalPortOuterClass.LogicalInterfaceInfo getInterfaceInfo(int index);
    /**
     * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
     */
    int getInterfaceInfoCount();
    /**
     * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
     */
    java.util.List<? extends LogicalPortOuterClass.LogicalInterfaceInfoOrBuilder> 
        getInterfaceInfoOrBuilderList();
    /**
     * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
     */
    LogicalPortOuterClass.LogicalInterfaceInfoOrBuilder getInterfaceInfoOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code LogicalPort}
   *
   * <pre>
   * Top-level message
   * </pre>
   */
  public static final class LogicalPort extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:LogicalPort)
      LogicalPortOrBuilder {
    // Use LogicalPort.newBuilder() to construct.
    private LogicalPort(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private LogicalPort(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final LogicalPort defaultInstance;
    public static LogicalPort getDefaultInstance() {
      return defaultInstance;
    }

    public LogicalPort getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private LogicalPort(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                interfaceInfo_ = new java.util.ArrayList<LogicalPortOuterClass.LogicalInterfaceInfo>();
                mutable_bitField0_ |= 0x00000001;
              }
              interfaceInfo_.add(input.readMessage(LogicalPortOuterClass.LogicalInterfaceInfo.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          interfaceInfo_ = java.util.Collections.unmodifiableList(interfaceInfo_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return LogicalPortOuterClass.internal_static_LogicalPort_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return LogicalPortOuterClass.internal_static_LogicalPort_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              LogicalPortOuterClass.LogicalPort.class, LogicalPortOuterClass.LogicalPort.Builder.class);
    }

    public static com.google.protobuf.Parser<LogicalPort> PARSER =
        new com.google.protobuf.AbstractParser<LogicalPort>() {
      public LogicalPort parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new LogicalPort(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<LogicalPort> getParserForType() {
      return PARSER;
    }

    public static final int INTERFACE_INFO_FIELD_NUMBER = 1;
    private java.util.List<LogicalPortOuterClass.LogicalInterfaceInfo> interfaceInfo_;
    /**
     * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
     */
    public java.util.List<LogicalPortOuterClass.LogicalInterfaceInfo> getInterfaceInfoList() {
      return interfaceInfo_;
    }
    /**
     * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
     */
    public java.util.List<? extends LogicalPortOuterClass.LogicalInterfaceInfoOrBuilder> 
        getInterfaceInfoOrBuilderList() {
      return interfaceInfo_;
    }
    /**
     * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
     */
    public int getInterfaceInfoCount() {
      return interfaceInfo_.size();
    }
    /**
     * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
     */
    public LogicalPortOuterClass.LogicalInterfaceInfo getInterfaceInfo(int index) {
      return interfaceInfo_.get(index);
    }
    /**
     * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
     */
    public LogicalPortOuterClass.LogicalInterfaceInfoOrBuilder getInterfaceInfoOrBuilder(
        int index) {
      return interfaceInfo_.get(index);
    }

    private void initFields() {
      interfaceInfo_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getInterfaceInfoCount(); i++) {
        if (!getInterfaceInfo(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < interfaceInfo_.size(); i++) {
        output.writeMessage(1, interfaceInfo_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < interfaceInfo_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, interfaceInfo_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LogicalPortOuterClass.LogicalPort parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LogicalPortOuterClass.LogicalPort parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LogicalPortOuterClass.LogicalPort parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LogicalPortOuterClass.LogicalPort parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LogicalPortOuterClass.LogicalPort parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LogicalPortOuterClass.LogicalPort parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LogicalPortOuterClass.LogicalPort parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LogicalPortOuterClass.LogicalPort parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LogicalPortOuterClass.LogicalPort parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LogicalPortOuterClass.LogicalPort parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LogicalPortOuterClass.LogicalPort prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code LogicalPort}
     *
     * <pre>
     * Top-level message
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:LogicalPort)
        LogicalPortOuterClass.LogicalPortOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return LogicalPortOuterClass.internal_static_LogicalPort_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return LogicalPortOuterClass.internal_static_LogicalPort_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                LogicalPortOuterClass.LogicalPort.class, LogicalPortOuterClass.LogicalPort.Builder.class);
      }

      // Construct using LogicalPortOuterClass.LogicalPort.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getInterfaceInfoFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (interfaceInfoBuilder_ == null) {
          interfaceInfo_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          interfaceInfoBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return LogicalPortOuterClass.internal_static_LogicalPort_descriptor;
      }

      public LogicalPortOuterClass.LogicalPort getDefaultInstanceForType() {
        return LogicalPortOuterClass.LogicalPort.getDefaultInstance();
      }

      public LogicalPortOuterClass.LogicalPort build() {
        LogicalPortOuterClass.LogicalPort result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LogicalPortOuterClass.LogicalPort buildPartial() {
        LogicalPortOuterClass.LogicalPort result = new LogicalPortOuterClass.LogicalPort(this);
        int from_bitField0_ = bitField0_;
        if (interfaceInfoBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            interfaceInfo_ = java.util.Collections.unmodifiableList(interfaceInfo_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.interfaceInfo_ = interfaceInfo_;
        } else {
          result.interfaceInfo_ = interfaceInfoBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof LogicalPortOuterClass.LogicalPort) {
          return mergeFrom((LogicalPortOuterClass.LogicalPort)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(LogicalPortOuterClass.LogicalPort other) {
        if (other == LogicalPortOuterClass.LogicalPort.getDefaultInstance()) return this;
        if (interfaceInfoBuilder_ == null) {
          if (!other.interfaceInfo_.isEmpty()) {
            if (interfaceInfo_.isEmpty()) {
              interfaceInfo_ = other.interfaceInfo_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureInterfaceInfoIsMutable();
              interfaceInfo_.addAll(other.interfaceInfo_);
            }
            onChanged();
          }
        } else {
          if (!other.interfaceInfo_.isEmpty()) {
            if (interfaceInfoBuilder_.isEmpty()) {
              interfaceInfoBuilder_.dispose();
              interfaceInfoBuilder_ = null;
              interfaceInfo_ = other.interfaceInfo_;
              bitField0_ = (bitField0_ & ~0x00000001);
              interfaceInfoBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getInterfaceInfoFieldBuilder() : null;
            } else {
              interfaceInfoBuilder_.addAllMessages(other.interfaceInfo_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getInterfaceInfoCount(); i++) {
          if (!getInterfaceInfo(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LogicalPortOuterClass.LogicalPort parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LogicalPortOuterClass.LogicalPort) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<LogicalPortOuterClass.LogicalInterfaceInfo> interfaceInfo_ =
        java.util.Collections.emptyList();
      private void ensureInterfaceInfoIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          interfaceInfo_ = new java.util.ArrayList<LogicalPortOuterClass.LogicalInterfaceInfo>(interfaceInfo_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          LogicalPortOuterClass.LogicalInterfaceInfo, LogicalPortOuterClass.LogicalInterfaceInfo.Builder, LogicalPortOuterClass.LogicalInterfaceInfoOrBuilder> interfaceInfoBuilder_;

      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public java.util.List<LogicalPortOuterClass.LogicalInterfaceInfo> getInterfaceInfoList() {
        if (interfaceInfoBuilder_ == null) {
          return java.util.Collections.unmodifiableList(interfaceInfo_);
        } else {
          return interfaceInfoBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public int getInterfaceInfoCount() {
        if (interfaceInfoBuilder_ == null) {
          return interfaceInfo_.size();
        } else {
          return interfaceInfoBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public LogicalPortOuterClass.LogicalInterfaceInfo getInterfaceInfo(int index) {
        if (interfaceInfoBuilder_ == null) {
          return interfaceInfo_.get(index);
        } else {
          return interfaceInfoBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public Builder setInterfaceInfo(
          int index, LogicalPortOuterClass.LogicalInterfaceInfo value) {
        if (interfaceInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInterfaceInfoIsMutable();
          interfaceInfo_.set(index, value);
          onChanged();
        } else {
          interfaceInfoBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public Builder setInterfaceInfo(
          int index, LogicalPortOuterClass.LogicalInterfaceInfo.Builder builderForValue) {
        if (interfaceInfoBuilder_ == null) {
          ensureInterfaceInfoIsMutable();
          interfaceInfo_.set(index, builderForValue.build());
          onChanged();
        } else {
          interfaceInfoBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public Builder addInterfaceInfo(LogicalPortOuterClass.LogicalInterfaceInfo value) {
        if (interfaceInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInterfaceInfoIsMutable();
          interfaceInfo_.add(value);
          onChanged();
        } else {
          interfaceInfoBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public Builder addInterfaceInfo(
          int index, LogicalPortOuterClass.LogicalInterfaceInfo value) {
        if (interfaceInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInterfaceInfoIsMutable();
          interfaceInfo_.add(index, value);
          onChanged();
        } else {
          interfaceInfoBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public Builder addInterfaceInfo(
          LogicalPortOuterClass.LogicalInterfaceInfo.Builder builderForValue) {
        if (interfaceInfoBuilder_ == null) {
          ensureInterfaceInfoIsMutable();
          interfaceInfo_.add(builderForValue.build());
          onChanged();
        } else {
          interfaceInfoBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public Builder addInterfaceInfo(
          int index, LogicalPortOuterClass.LogicalInterfaceInfo.Builder builderForValue) {
        if (interfaceInfoBuilder_ == null) {
          ensureInterfaceInfoIsMutable();
          interfaceInfo_.add(index, builderForValue.build());
          onChanged();
        } else {
          interfaceInfoBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public Builder addAllInterfaceInfo(
          java.lang.Iterable<? extends LogicalPortOuterClass.LogicalInterfaceInfo> values) {
        if (interfaceInfoBuilder_ == null) {
          ensureInterfaceInfoIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, interfaceInfo_);
          onChanged();
        } else {
          interfaceInfoBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public Builder clearInterfaceInfo() {
        if (interfaceInfoBuilder_ == null) {
          interfaceInfo_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          interfaceInfoBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public Builder removeInterfaceInfo(int index) {
        if (interfaceInfoBuilder_ == null) {
          ensureInterfaceInfoIsMutable();
          interfaceInfo_.remove(index);
          onChanged();
        } else {
          interfaceInfoBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public LogicalPortOuterClass.LogicalInterfaceInfo.Builder getInterfaceInfoBuilder(
          int index) {
        return getInterfaceInfoFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public LogicalPortOuterClass.LogicalInterfaceInfoOrBuilder getInterfaceInfoOrBuilder(
          int index) {
        if (interfaceInfoBuilder_ == null) {
          return interfaceInfo_.get(index);  } else {
          return interfaceInfoBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public java.util.List<? extends LogicalPortOuterClass.LogicalInterfaceInfoOrBuilder> 
           getInterfaceInfoOrBuilderList() {
        if (interfaceInfoBuilder_ != null) {
          return interfaceInfoBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(interfaceInfo_);
        }
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public LogicalPortOuterClass.LogicalInterfaceInfo.Builder addInterfaceInfoBuilder() {
        return getInterfaceInfoFieldBuilder().addBuilder(
            LogicalPortOuterClass.LogicalInterfaceInfo.getDefaultInstance());
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public LogicalPortOuterClass.LogicalInterfaceInfo.Builder addInterfaceInfoBuilder(
          int index) {
        return getInterfaceInfoFieldBuilder().addBuilder(
            index, LogicalPortOuterClass.LogicalInterfaceInfo.getDefaultInstance());
      }
      /**
       * <code>repeated .LogicalInterfaceInfo interface_info = 1;</code>
       */
      public java.util.List<LogicalPortOuterClass.LogicalInterfaceInfo.Builder> 
           getInterfaceInfoBuilderList() {
        return getInterfaceInfoFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          LogicalPortOuterClass.LogicalInterfaceInfo, LogicalPortOuterClass.LogicalInterfaceInfo.Builder, LogicalPortOuterClass.LogicalInterfaceInfoOrBuilder> 
          getInterfaceInfoFieldBuilder() {
        if (interfaceInfoBuilder_ == null) {
          interfaceInfoBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              LogicalPortOuterClass.LogicalInterfaceInfo, LogicalPortOuterClass.LogicalInterfaceInfo.Builder, LogicalPortOuterClass.LogicalInterfaceInfoOrBuilder>(
                  interfaceInfo_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          interfaceInfo_ = null;
        }
        return interfaceInfoBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:LogicalPort)
    }

    static {
      defaultInstance = new LogicalPort(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:LogicalPort)
  }

  public interface LogicalInterfaceInfoOrBuilder extends
      // @@protoc_insertion_point(interface_extends:LogicalInterfaceInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string if_name = 1;</code>
     *
     * <pre>
     * Logical interface name (e.g. xe-0/0/0.0)
     * </pre>
     */
    boolean hasIfName();
    /**
     * <code>required string if_name = 1;</code>
     *
     * <pre>
     * Logical interface name (e.g. xe-0/0/0.0)
     * </pre>
     */
    java.lang.String getIfName();
    /**
     * <code>required string if_name = 1;</code>
     *
     * <pre>
     * Logical interface name (e.g. xe-0/0/0.0)
     * </pre>
     */
    com.google.protobuf.ByteString
        getIfNameBytes();

    /**
     * <code>required uint64 init_time = 2;</code>
     *
     * <pre>
     * Time reset
     * </pre>
     */
    boolean hasInitTime();
    /**
     * <code>required uint64 init_time = 2;</code>
     *
     * <pre>
     * Time reset
     * </pre>
     */
    long getInitTime();

    /**
     * <code>optional uint32 snmp_if_index = 3;</code>
     *
     * <pre>
     * Global Index
     * </pre>
     */
    boolean hasSnmpIfIndex();
    /**
     * <code>optional uint32 snmp_if_index = 3;</code>
     *
     * <pre>
     * Global Index
     * </pre>
     */
    int getSnmpIfIndex();

    /**
     * <code>optional string parent_ae_name = 4;</code>
     *
     * <pre>
     * Name of the aggregate bundle
     * </pre>
     */
    boolean hasParentAeName();
    /**
     * <code>optional string parent_ae_name = 4;</code>
     *
     * <pre>
     * Name of the aggregate bundle
     * </pre>
     */
    java.lang.String getParentAeName();
    /**
     * <code>optional string parent_ae_name = 4;</code>
     *
     * <pre>
     * Name of the aggregate bundle
     * </pre>
     */
    com.google.protobuf.ByteString
        getParentAeNameBytes();

    /**
     * <code>optional .IngressInterfaceStats ingress_stats = 5;</code>
     *
     * <pre>
     * Inbound traffic statistics
     * </pre>
     */
    boolean hasIngressStats();
    /**
     * <code>optional .IngressInterfaceStats ingress_stats = 5;</code>
     *
     * <pre>
     * Inbound traffic statistics
     * </pre>
     */
    LogicalPortOuterClass.IngressInterfaceStats getIngressStats();
    /**
     * <code>optional .IngressInterfaceStats ingress_stats = 5;</code>
     *
     * <pre>
     * Inbound traffic statistics
     * </pre>
     */
    LogicalPortOuterClass.IngressInterfaceStatsOrBuilder getIngressStatsOrBuilder();

    /**
     * <code>optional .EgressInterfaceStats egress_stats = 6;</code>
     *
     * <pre>
     * Outbound traffic statistics
     * </pre>
     */
    boolean hasEgressStats();
    /**
     * <code>optional .EgressInterfaceStats egress_stats = 6;</code>
     *
     * <pre>
     * Outbound traffic statistics
     * </pre>
     */
    LogicalPortOuterClass.EgressInterfaceStats getEgressStats();
    /**
     * <code>optional .EgressInterfaceStats egress_stats = 6;</code>
     *
     * <pre>
     * Outbound traffic statistics
     * </pre>
     */
    LogicalPortOuterClass.EgressInterfaceStatsOrBuilder getEgressStatsOrBuilder();

    /**
     * <code>optional .OperationalState op_state = 7;</code>
     *
     * <pre>
     * Link state UP&#92;DOWN etc.
     * </pre>
     */
    boolean hasOpState();
    /**
     * <code>optional .OperationalState op_state = 7;</code>
     *
     * <pre>
     * Link state UP&#92;DOWN etc.
     * </pre>
     */
    LogicalPortOuterClass.OperationalState getOpState();
    /**
     * <code>optional .OperationalState op_state = 7;</code>
     *
     * <pre>
     * Link state UP&#92;DOWN etc.
     * </pre>
     */
    LogicalPortOuterClass.OperationalStateOrBuilder getOpStateOrBuilder();
  }
  /**
   * Protobuf type {@code LogicalInterfaceInfo}
   *
   * <pre>
   * Logical Interaface information
   * </pre>
   */
  public static final class LogicalInterfaceInfo extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:LogicalInterfaceInfo)
      LogicalInterfaceInfoOrBuilder {
    // Use LogicalInterfaceInfo.newBuilder() to construct.
    private LogicalInterfaceInfo(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private LogicalInterfaceInfo(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final LogicalInterfaceInfo defaultInstance;
    public static LogicalInterfaceInfo getDefaultInstance() {
      return defaultInstance;
    }

    public LogicalInterfaceInfo getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private LogicalInterfaceInfo(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              ifName_ = bs;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              initTime_ = input.readUInt64();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              snmpIfIndex_ = input.readUInt32();
              break;
            }
            case 34: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000008;
              parentAeName_ = bs;
              break;
            }
            case 42: {
              LogicalPortOuterClass.IngressInterfaceStats.Builder subBuilder = null;
              if (((bitField0_ & 0x00000010) == 0x00000010)) {
                subBuilder = ingressStats_.toBuilder();
              }
              ingressStats_ = input.readMessage(LogicalPortOuterClass.IngressInterfaceStats.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(ingressStats_);
                ingressStats_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000010;
              break;
            }
            case 50: {
              LogicalPortOuterClass.EgressInterfaceStats.Builder subBuilder = null;
              if (((bitField0_ & 0x00000020) == 0x00000020)) {
                subBuilder = egressStats_.toBuilder();
              }
              egressStats_ = input.readMessage(LogicalPortOuterClass.EgressInterfaceStats.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(egressStats_);
                egressStats_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000020;
              break;
            }
            case 58: {
              LogicalPortOuterClass.OperationalState.Builder subBuilder = null;
              if (((bitField0_ & 0x00000040) == 0x00000040)) {
                subBuilder = opState_.toBuilder();
              }
              opState_ = input.readMessage(LogicalPortOuterClass.OperationalState.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(opState_);
                opState_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000040;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return LogicalPortOuterClass.internal_static_LogicalInterfaceInfo_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return LogicalPortOuterClass.internal_static_LogicalInterfaceInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              LogicalPortOuterClass.LogicalInterfaceInfo.class, LogicalPortOuterClass.LogicalInterfaceInfo.Builder.class);
    }

    public static com.google.protobuf.Parser<LogicalInterfaceInfo> PARSER =
        new com.google.protobuf.AbstractParser<LogicalInterfaceInfo>() {
      public LogicalInterfaceInfo parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new LogicalInterfaceInfo(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<LogicalInterfaceInfo> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int IF_NAME_FIELD_NUMBER = 1;
    private java.lang.Object ifName_;
    /**
     * <code>required string if_name = 1;</code>
     *
     * <pre>
     * Logical interface name (e.g. xe-0/0/0.0)
     * </pre>
     */
    public boolean hasIfName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string if_name = 1;</code>
     *
     * <pre>
     * Logical interface name (e.g. xe-0/0/0.0)
     * </pre>
     */
    public java.lang.String getIfName() {
      java.lang.Object ref = ifName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          ifName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string if_name = 1;</code>
     *
     * <pre>
     * Logical interface name (e.g. xe-0/0/0.0)
     * </pre>
     */
    public com.google.protobuf.ByteString
        getIfNameBytes() {
      java.lang.Object ref = ifName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        ifName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INIT_TIME_FIELD_NUMBER = 2;
    private long initTime_;
    /**
     * <code>required uint64 init_time = 2;</code>
     *
     * <pre>
     * Time reset
     * </pre>
     */
    public boolean hasInitTime() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required uint64 init_time = 2;</code>
     *
     * <pre>
     * Time reset
     * </pre>
     */
    public long getInitTime() {
      return initTime_;
    }

    public static final int SNMP_IF_INDEX_FIELD_NUMBER = 3;
    private int snmpIfIndex_;
    /**
     * <code>optional uint32 snmp_if_index = 3;</code>
     *
     * <pre>
     * Global Index
     * </pre>
     */
    public boolean hasSnmpIfIndex() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint32 snmp_if_index = 3;</code>
     *
     * <pre>
     * Global Index
     * </pre>
     */
    public int getSnmpIfIndex() {
      return snmpIfIndex_;
    }

    public static final int PARENT_AE_NAME_FIELD_NUMBER = 4;
    private java.lang.Object parentAeName_;
    /**
     * <code>optional string parent_ae_name = 4;</code>
     *
     * <pre>
     * Name of the aggregate bundle
     * </pre>
     */
    public boolean hasParentAeName() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional string parent_ae_name = 4;</code>
     *
     * <pre>
     * Name of the aggregate bundle
     * </pre>
     */
    public java.lang.String getParentAeName() {
      java.lang.Object ref = parentAeName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          parentAeName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string parent_ae_name = 4;</code>
     *
     * <pre>
     * Name of the aggregate bundle
     * </pre>
     */
    public com.google.protobuf.ByteString
        getParentAeNameBytes() {
      java.lang.Object ref = parentAeName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        parentAeName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INGRESS_STATS_FIELD_NUMBER = 5;
    private LogicalPortOuterClass.IngressInterfaceStats ingressStats_;
    /**
     * <code>optional .IngressInterfaceStats ingress_stats = 5;</code>
     *
     * <pre>
     * Inbound traffic statistics
     * </pre>
     */
    public boolean hasIngressStats() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional .IngressInterfaceStats ingress_stats = 5;</code>
     *
     * <pre>
     * Inbound traffic statistics
     * </pre>
     */
    public LogicalPortOuterClass.IngressInterfaceStats getIngressStats() {
      return ingressStats_;
    }
    /**
     * <code>optional .IngressInterfaceStats ingress_stats = 5;</code>
     *
     * <pre>
     * Inbound traffic statistics
     * </pre>
     */
    public LogicalPortOuterClass.IngressInterfaceStatsOrBuilder getIngressStatsOrBuilder() {
      return ingressStats_;
    }

    public static final int EGRESS_STATS_FIELD_NUMBER = 6;
    private LogicalPortOuterClass.EgressInterfaceStats egressStats_;
    /**
     * <code>optional .EgressInterfaceStats egress_stats = 6;</code>
     *
     * <pre>
     * Outbound traffic statistics
     * </pre>
     */
    public boolean hasEgressStats() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional .EgressInterfaceStats egress_stats = 6;</code>
     *
     * <pre>
     * Outbound traffic statistics
     * </pre>
     */
    public LogicalPortOuterClass.EgressInterfaceStats getEgressStats() {
      return egressStats_;
    }
    /**
     * <code>optional .EgressInterfaceStats egress_stats = 6;</code>
     *
     * <pre>
     * Outbound traffic statistics
     * </pre>
     */
    public LogicalPortOuterClass.EgressInterfaceStatsOrBuilder getEgressStatsOrBuilder() {
      return egressStats_;
    }

    public static final int OP_STATE_FIELD_NUMBER = 7;
    private LogicalPortOuterClass.OperationalState opState_;
    /**
     * <code>optional .OperationalState op_state = 7;</code>
     *
     * <pre>
     * Link state UP&#92;DOWN etc.
     * </pre>
     */
    public boolean hasOpState() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional .OperationalState op_state = 7;</code>
     *
     * <pre>
     * Link state UP&#92;DOWN etc.
     * </pre>
     */
    public LogicalPortOuterClass.OperationalState getOpState() {
      return opState_;
    }
    /**
     * <code>optional .OperationalState op_state = 7;</code>
     *
     * <pre>
     * Link state UP&#92;DOWN etc.
     * </pre>
     */
    public LogicalPortOuterClass.OperationalStateOrBuilder getOpStateOrBuilder() {
      return opState_;
    }

    private void initFields() {
      ifName_ = "";
      initTime_ = 0L;
      snmpIfIndex_ = 0;
      parentAeName_ = "";
      ingressStats_ = LogicalPortOuterClass.IngressInterfaceStats.getDefaultInstance();
      egressStats_ = LogicalPortOuterClass.EgressInterfaceStats.getDefaultInstance();
      opState_ = LogicalPortOuterClass.OperationalState.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasIfName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasInitTime()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasIngressStats()) {
        if (!getIngressStats().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasEgressStats()) {
        if (!getEgressStats().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getIfNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, initTime_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt32(3, snmpIfIndex_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeBytes(4, getParentAeNameBytes());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeMessage(5, ingressStats_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeMessage(6, egressStats_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeMessage(7, opState_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getIfNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, initTime_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(3, snmpIfIndex_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(4, getParentAeNameBytes());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, ingressStats_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, egressStats_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, opState_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LogicalPortOuterClass.LogicalInterfaceInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LogicalPortOuterClass.LogicalInterfaceInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LogicalPortOuterClass.LogicalInterfaceInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LogicalPortOuterClass.LogicalInterfaceInfo parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LogicalPortOuterClass.LogicalInterfaceInfo parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LogicalPortOuterClass.LogicalInterfaceInfo parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LogicalPortOuterClass.LogicalInterfaceInfo parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LogicalPortOuterClass.LogicalInterfaceInfo parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LogicalPortOuterClass.LogicalInterfaceInfo parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LogicalPortOuterClass.LogicalInterfaceInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LogicalPortOuterClass.LogicalInterfaceInfo prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code LogicalInterfaceInfo}
     *
     * <pre>
     * Logical Interaface information
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:LogicalInterfaceInfo)
        LogicalPortOuterClass.LogicalInterfaceInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return LogicalPortOuterClass.internal_static_LogicalInterfaceInfo_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return LogicalPortOuterClass.internal_static_LogicalInterfaceInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                LogicalPortOuterClass.LogicalInterfaceInfo.class, LogicalPortOuterClass.LogicalInterfaceInfo.Builder.class);
      }

      // Construct using LogicalPortOuterClass.LogicalInterfaceInfo.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getIngressStatsFieldBuilder();
          getEgressStatsFieldBuilder();
          getOpStateFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        ifName_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        initTime_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        snmpIfIndex_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        parentAeName_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        if (ingressStatsBuilder_ == null) {
          ingressStats_ = LogicalPortOuterClass.IngressInterfaceStats.getDefaultInstance();
        } else {
          ingressStatsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        if (egressStatsBuilder_ == null) {
          egressStats_ = LogicalPortOuterClass.EgressInterfaceStats.getDefaultInstance();
        } else {
          egressStatsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        if (opStateBuilder_ == null) {
          opState_ = LogicalPortOuterClass.OperationalState.getDefaultInstance();
        } else {
          opStateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return LogicalPortOuterClass.internal_static_LogicalInterfaceInfo_descriptor;
      }

      public LogicalPortOuterClass.LogicalInterfaceInfo getDefaultInstanceForType() {
        return LogicalPortOuterClass.LogicalInterfaceInfo.getDefaultInstance();
      }

      public LogicalPortOuterClass.LogicalInterfaceInfo build() {
        LogicalPortOuterClass.LogicalInterfaceInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LogicalPortOuterClass.LogicalInterfaceInfo buildPartial() {
        LogicalPortOuterClass.LogicalInterfaceInfo result = new LogicalPortOuterClass.LogicalInterfaceInfo(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.ifName_ = ifName_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.initTime_ = initTime_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.snmpIfIndex_ = snmpIfIndex_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.parentAeName_ = parentAeName_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        if (ingressStatsBuilder_ == null) {
          result.ingressStats_ = ingressStats_;
        } else {
          result.ingressStats_ = ingressStatsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        if (egressStatsBuilder_ == null) {
          result.egressStats_ = egressStats_;
        } else {
          result.egressStats_ = egressStatsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        if (opStateBuilder_ == null) {
          result.opState_ = opState_;
        } else {
          result.opState_ = opStateBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof LogicalPortOuterClass.LogicalInterfaceInfo) {
          return mergeFrom((LogicalPortOuterClass.LogicalInterfaceInfo)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(LogicalPortOuterClass.LogicalInterfaceInfo other) {
        if (other == LogicalPortOuterClass.LogicalInterfaceInfo.getDefaultInstance()) return this;
        if (other.hasIfName()) {
          bitField0_ |= 0x00000001;
          ifName_ = other.ifName_;
          onChanged();
        }
        if (other.hasInitTime()) {
          setInitTime(other.getInitTime());
        }
        if (other.hasSnmpIfIndex()) {
          setSnmpIfIndex(other.getSnmpIfIndex());
        }
        if (other.hasParentAeName()) {
          bitField0_ |= 0x00000008;
          parentAeName_ = other.parentAeName_;
          onChanged();
        }
        if (other.hasIngressStats()) {
          mergeIngressStats(other.getIngressStats());
        }
        if (other.hasEgressStats()) {
          mergeEgressStats(other.getEgressStats());
        }
        if (other.hasOpState()) {
          mergeOpState(other.getOpState());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasIfName()) {
          
          return false;
        }
        if (!hasInitTime()) {
          
          return false;
        }
        if (hasIngressStats()) {
          if (!getIngressStats().isInitialized()) {
            
            return false;
          }
        }
        if (hasEgressStats()) {
          if (!getEgressStats().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LogicalPortOuterClass.LogicalInterfaceInfo parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LogicalPortOuterClass.LogicalInterfaceInfo) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object ifName_ = "";
      /**
       * <code>required string if_name = 1;</code>
       *
       * <pre>
       * Logical interface name (e.g. xe-0/0/0.0)
       * </pre>
       */
      public boolean hasIfName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string if_name = 1;</code>
       *
       * <pre>
       * Logical interface name (e.g. xe-0/0/0.0)
       * </pre>
       */
      public java.lang.String getIfName() {
        java.lang.Object ref = ifName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            ifName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string if_name = 1;</code>
       *
       * <pre>
       * Logical interface name (e.g. xe-0/0/0.0)
       * </pre>
       */
      public com.google.protobuf.ByteString
          getIfNameBytes() {
        java.lang.Object ref = ifName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          ifName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string if_name = 1;</code>
       *
       * <pre>
       * Logical interface name (e.g. xe-0/0/0.0)
       * </pre>
       */
      public Builder setIfName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        ifName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string if_name = 1;</code>
       *
       * <pre>
       * Logical interface name (e.g. xe-0/0/0.0)
       * </pre>
       */
      public Builder clearIfName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        ifName_ = getDefaultInstance().getIfName();
        onChanged();
        return this;
      }
      /**
       * <code>required string if_name = 1;</code>
       *
       * <pre>
       * Logical interface name (e.g. xe-0/0/0.0)
       * </pre>
       */
      public Builder setIfNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        ifName_ = value;
        onChanged();
        return this;
      }

      private long initTime_ ;
      /**
       * <code>required uint64 init_time = 2;</code>
       *
       * <pre>
       * Time reset
       * </pre>
       */
      public boolean hasInitTime() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required uint64 init_time = 2;</code>
       *
       * <pre>
       * Time reset
       * </pre>
       */
      public long getInitTime() {
        return initTime_;
      }
      /**
       * <code>required uint64 init_time = 2;</code>
       *
       * <pre>
       * Time reset
       * </pre>
       */
      public Builder setInitTime(long value) {
        bitField0_ |= 0x00000002;
        initTime_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 init_time = 2;</code>
       *
       * <pre>
       * Time reset
       * </pre>
       */
      public Builder clearInitTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        initTime_ = 0L;
        onChanged();
        return this;
      }

      private int snmpIfIndex_ ;
      /**
       * <code>optional uint32 snmp_if_index = 3;</code>
       *
       * <pre>
       * Global Index
       * </pre>
       */
      public boolean hasSnmpIfIndex() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint32 snmp_if_index = 3;</code>
       *
       * <pre>
       * Global Index
       * </pre>
       */
      public int getSnmpIfIndex() {
        return snmpIfIndex_;
      }
      /**
       * <code>optional uint32 snmp_if_index = 3;</code>
       *
       * <pre>
       * Global Index
       * </pre>
       */
      public Builder setSnmpIfIndex(int value) {
        bitField0_ |= 0x00000004;
        snmpIfIndex_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 snmp_if_index = 3;</code>
       *
       * <pre>
       * Global Index
       * </pre>
       */
      public Builder clearSnmpIfIndex() {
        bitField0_ = (bitField0_ & ~0x00000004);
        snmpIfIndex_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object parentAeName_ = "";
      /**
       * <code>optional string parent_ae_name = 4;</code>
       *
       * <pre>
       * Name of the aggregate bundle
       * </pre>
       */
      public boolean hasParentAeName() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional string parent_ae_name = 4;</code>
       *
       * <pre>
       * Name of the aggregate bundle
       * </pre>
       */
      public java.lang.String getParentAeName() {
        java.lang.Object ref = parentAeName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            parentAeName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string parent_ae_name = 4;</code>
       *
       * <pre>
       * Name of the aggregate bundle
       * </pre>
       */
      public com.google.protobuf.ByteString
          getParentAeNameBytes() {
        java.lang.Object ref = parentAeName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          parentAeName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string parent_ae_name = 4;</code>
       *
       * <pre>
       * Name of the aggregate bundle
       * </pre>
       */
      public Builder setParentAeName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        parentAeName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string parent_ae_name = 4;</code>
       *
       * <pre>
       * Name of the aggregate bundle
       * </pre>
       */
      public Builder clearParentAeName() {
        bitField0_ = (bitField0_ & ~0x00000008);
        parentAeName_ = getDefaultInstance().getParentAeName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string parent_ae_name = 4;</code>
       *
       * <pre>
       * Name of the aggregate bundle
       * </pre>
       */
      public Builder setParentAeNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        parentAeName_ = value;
        onChanged();
        return this;
      }

      private LogicalPortOuterClass.IngressInterfaceStats ingressStats_ = LogicalPortOuterClass.IngressInterfaceStats.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          LogicalPortOuterClass.IngressInterfaceStats, LogicalPortOuterClass.IngressInterfaceStats.Builder, LogicalPortOuterClass.IngressInterfaceStatsOrBuilder> ingressStatsBuilder_;
      /**
       * <code>optional .IngressInterfaceStats ingress_stats = 5;</code>
       *
       * <pre>
       * Inbound traffic statistics
       * </pre>
       */
      public boolean hasIngressStats() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional .IngressInterfaceStats ingress_stats = 5;</code>
       *
       * <pre>
       * Inbound traffic statistics
       * </pre>
       */
      public LogicalPortOuterClass.IngressInterfaceStats getIngressStats() {
        if (ingressStatsBuilder_ == null) {
          return ingressStats_;
        } else {
          return ingressStatsBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .IngressInterfaceStats ingress_stats = 5;</code>
       *
       * <pre>
       * Inbound traffic statistics
       * </pre>
       */
      public Builder setIngressStats(LogicalPortOuterClass.IngressInterfaceStats value) {
        if (ingressStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ingressStats_ = value;
          onChanged();
        } else {
          ingressStatsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .IngressInterfaceStats ingress_stats = 5;</code>
       *
       * <pre>
       * Inbound traffic statistics
       * </pre>
       */
      public Builder setIngressStats(
          LogicalPortOuterClass.IngressInterfaceStats.Builder builderForValue) {
        if (ingressStatsBuilder_ == null) {
          ingressStats_ = builderForValue.build();
          onChanged();
        } else {
          ingressStatsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .IngressInterfaceStats ingress_stats = 5;</code>
       *
       * <pre>
       * Inbound traffic statistics
       * </pre>
       */
      public Builder mergeIngressStats(LogicalPortOuterClass.IngressInterfaceStats value) {
        if (ingressStatsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010) &&
              ingressStats_ != LogicalPortOuterClass.IngressInterfaceStats.getDefaultInstance()) {
            ingressStats_ =
              LogicalPortOuterClass.IngressInterfaceStats.newBuilder(ingressStats_).mergeFrom(value).buildPartial();
          } else {
            ingressStats_ = value;
          }
          onChanged();
        } else {
          ingressStatsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .IngressInterfaceStats ingress_stats = 5;</code>
       *
       * <pre>
       * Inbound traffic statistics
       * </pre>
       */
      public Builder clearIngressStats() {
        if (ingressStatsBuilder_ == null) {
          ingressStats_ = LogicalPortOuterClass.IngressInterfaceStats.getDefaultInstance();
          onChanged();
        } else {
          ingressStatsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }
      /**
       * <code>optional .IngressInterfaceStats ingress_stats = 5;</code>
       *
       * <pre>
       * Inbound traffic statistics
       * </pre>
       */
      public LogicalPortOuterClass.IngressInterfaceStats.Builder getIngressStatsBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getIngressStatsFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .IngressInterfaceStats ingress_stats = 5;</code>
       *
       * <pre>
       * Inbound traffic statistics
       * </pre>
       */
      public LogicalPortOuterClass.IngressInterfaceStatsOrBuilder getIngressStatsOrBuilder() {
        if (ingressStatsBuilder_ != null) {
          return ingressStatsBuilder_.getMessageOrBuilder();
        } else {
          return ingressStats_;
        }
      }
      /**
       * <code>optional .IngressInterfaceStats ingress_stats = 5;</code>
       *
       * <pre>
       * Inbound traffic statistics
       * </pre>
       */
      private com.google.protobuf.SingleFieldBuilder<
          LogicalPortOuterClass.IngressInterfaceStats, LogicalPortOuterClass.IngressInterfaceStats.Builder, LogicalPortOuterClass.IngressInterfaceStatsOrBuilder> 
          getIngressStatsFieldBuilder() {
        if (ingressStatsBuilder_ == null) {
          ingressStatsBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              LogicalPortOuterClass.IngressInterfaceStats, LogicalPortOuterClass.IngressInterfaceStats.Builder, LogicalPortOuterClass.IngressInterfaceStatsOrBuilder>(
                  getIngressStats(),
                  getParentForChildren(),
                  isClean());
          ingressStats_ = null;
        }
        return ingressStatsBuilder_;
      }

      private LogicalPortOuterClass.EgressInterfaceStats egressStats_ = LogicalPortOuterClass.EgressInterfaceStats.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          LogicalPortOuterClass.EgressInterfaceStats, LogicalPortOuterClass.EgressInterfaceStats.Builder, LogicalPortOuterClass.EgressInterfaceStatsOrBuilder> egressStatsBuilder_;
      /**
       * <code>optional .EgressInterfaceStats egress_stats = 6;</code>
       *
       * <pre>
       * Outbound traffic statistics
       * </pre>
       */
      public boolean hasEgressStats() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional .EgressInterfaceStats egress_stats = 6;</code>
       *
       * <pre>
       * Outbound traffic statistics
       * </pre>
       */
      public LogicalPortOuterClass.EgressInterfaceStats getEgressStats() {
        if (egressStatsBuilder_ == null) {
          return egressStats_;
        } else {
          return egressStatsBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .EgressInterfaceStats egress_stats = 6;</code>
       *
       * <pre>
       * Outbound traffic statistics
       * </pre>
       */
      public Builder setEgressStats(LogicalPortOuterClass.EgressInterfaceStats value) {
        if (egressStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          egressStats_ = value;
          onChanged();
        } else {
          egressStatsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .EgressInterfaceStats egress_stats = 6;</code>
       *
       * <pre>
       * Outbound traffic statistics
       * </pre>
       */
      public Builder setEgressStats(
          LogicalPortOuterClass.EgressInterfaceStats.Builder builderForValue) {
        if (egressStatsBuilder_ == null) {
          egressStats_ = builderForValue.build();
          onChanged();
        } else {
          egressStatsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .EgressInterfaceStats egress_stats = 6;</code>
       *
       * <pre>
       * Outbound traffic statistics
       * </pre>
       */
      public Builder mergeEgressStats(LogicalPortOuterClass.EgressInterfaceStats value) {
        if (egressStatsBuilder_ == null) {
          if (((bitField0_ & 0x00000020) == 0x00000020) &&
              egressStats_ != LogicalPortOuterClass.EgressInterfaceStats.getDefaultInstance()) {
            egressStats_ =
              LogicalPortOuterClass.EgressInterfaceStats.newBuilder(egressStats_).mergeFrom(value).buildPartial();
          } else {
            egressStats_ = value;
          }
          onChanged();
        } else {
          egressStatsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .EgressInterfaceStats egress_stats = 6;</code>
       *
       * <pre>
       * Outbound traffic statistics
       * </pre>
       */
      public Builder clearEgressStats() {
        if (egressStatsBuilder_ == null) {
          egressStats_ = LogicalPortOuterClass.EgressInterfaceStats.getDefaultInstance();
          onChanged();
        } else {
          egressStatsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }
      /**
       * <code>optional .EgressInterfaceStats egress_stats = 6;</code>
       *
       * <pre>
       * Outbound traffic statistics
       * </pre>
       */
      public LogicalPortOuterClass.EgressInterfaceStats.Builder getEgressStatsBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getEgressStatsFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .EgressInterfaceStats egress_stats = 6;</code>
       *
       * <pre>
       * Outbound traffic statistics
       * </pre>
       */
      public LogicalPortOuterClass.EgressInterfaceStatsOrBuilder getEgressStatsOrBuilder() {
        if (egressStatsBuilder_ != null) {
          return egressStatsBuilder_.getMessageOrBuilder();
        } else {
          return egressStats_;
        }
      }
      /**
       * <code>optional .EgressInterfaceStats egress_stats = 6;</code>
       *
       * <pre>
       * Outbound traffic statistics
       * </pre>
       */
      private com.google.protobuf.SingleFieldBuilder<
          LogicalPortOuterClass.EgressInterfaceStats, LogicalPortOuterClass.EgressInterfaceStats.Builder, LogicalPortOuterClass.EgressInterfaceStatsOrBuilder> 
          getEgressStatsFieldBuilder() {
        if (egressStatsBuilder_ == null) {
          egressStatsBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              LogicalPortOuterClass.EgressInterfaceStats, LogicalPortOuterClass.EgressInterfaceStats.Builder, LogicalPortOuterClass.EgressInterfaceStatsOrBuilder>(
                  getEgressStats(),
                  getParentForChildren(),
                  isClean());
          egressStats_ = null;
        }
        return egressStatsBuilder_;
      }

      private LogicalPortOuterClass.OperationalState opState_ = LogicalPortOuterClass.OperationalState.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          LogicalPortOuterClass.OperationalState, LogicalPortOuterClass.OperationalState.Builder, LogicalPortOuterClass.OperationalStateOrBuilder> opStateBuilder_;
      /**
       * <code>optional .OperationalState op_state = 7;</code>
       *
       * <pre>
       * Link state UP&#92;DOWN etc.
       * </pre>
       */
      public boolean hasOpState() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional .OperationalState op_state = 7;</code>
       *
       * <pre>
       * Link state UP&#92;DOWN etc.
       * </pre>
       */
      public LogicalPortOuterClass.OperationalState getOpState() {
        if (opStateBuilder_ == null) {
          return opState_;
        } else {
          return opStateBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .OperationalState op_state = 7;</code>
       *
       * <pre>
       * Link state UP&#92;DOWN etc.
       * </pre>
       */
      public Builder setOpState(LogicalPortOuterClass.OperationalState value) {
        if (opStateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          opState_ = value;
          onChanged();
        } else {
          opStateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <code>optional .OperationalState op_state = 7;</code>
       *
       * <pre>
       * Link state UP&#92;DOWN etc.
       * </pre>
       */
      public Builder setOpState(
          LogicalPortOuterClass.OperationalState.Builder builderForValue) {
        if (opStateBuilder_ == null) {
          opState_ = builderForValue.build();
          onChanged();
        } else {
          opStateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <code>optional .OperationalState op_state = 7;</code>
       *
       * <pre>
       * Link state UP&#92;DOWN etc.
       * </pre>
       */
      public Builder mergeOpState(LogicalPortOuterClass.OperationalState value) {
        if (opStateBuilder_ == null) {
          if (((bitField0_ & 0x00000040) == 0x00000040) &&
              opState_ != LogicalPortOuterClass.OperationalState.getDefaultInstance()) {
            opState_ =
              LogicalPortOuterClass.OperationalState.newBuilder(opState_).mergeFrom(value).buildPartial();
          } else {
            opState_ = value;
          }
          onChanged();
        } else {
          opStateBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <code>optional .OperationalState op_state = 7;</code>
       *
       * <pre>
       * Link state UP&#92;DOWN etc.
       * </pre>
       */
      public Builder clearOpState() {
        if (opStateBuilder_ == null) {
          opState_ = LogicalPortOuterClass.OperationalState.getDefaultInstance();
          onChanged();
        } else {
          opStateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }
      /**
       * <code>optional .OperationalState op_state = 7;</code>
       *
       * <pre>
       * Link state UP&#92;DOWN etc.
       * </pre>
       */
      public LogicalPortOuterClass.OperationalState.Builder getOpStateBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getOpStateFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .OperationalState op_state = 7;</code>
       *
       * <pre>
       * Link state UP&#92;DOWN etc.
       * </pre>
       */
      public LogicalPortOuterClass.OperationalStateOrBuilder getOpStateOrBuilder() {
        if (opStateBuilder_ != null) {
          return opStateBuilder_.getMessageOrBuilder();
        } else {
          return opState_;
        }
      }
      /**
       * <code>optional .OperationalState op_state = 7;</code>
       *
       * <pre>
       * Link state UP&#92;DOWN etc.
       * </pre>
       */
      private com.google.protobuf.SingleFieldBuilder<
          LogicalPortOuterClass.OperationalState, LogicalPortOuterClass.OperationalState.Builder, LogicalPortOuterClass.OperationalStateOrBuilder> 
          getOpStateFieldBuilder() {
        if (opStateBuilder_ == null) {
          opStateBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              LogicalPortOuterClass.OperationalState, LogicalPortOuterClass.OperationalState.Builder, LogicalPortOuterClass.OperationalStateOrBuilder>(
                  getOpState(),
                  getParentForChildren(),
                  isClean());
          opState_ = null;
        }
        return opStateBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:LogicalInterfaceInfo)
    }

    static {
      defaultInstance = new LogicalInterfaceInfo(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:LogicalInterfaceInfo)
  }

  public interface IngressInterfaceStatsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:IngressInterfaceStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required uint64 if_packets = 1;</code>
     *
     * <pre>
     * Count of packets
     * </pre>
     */
    boolean hasIfPackets();
    /**
     * <code>required uint64 if_packets = 1;</code>
     *
     * <pre>
     * Count of packets
     * </pre>
     */
    long getIfPackets();

    /**
     * <code>required uint64 if_octets = 2;</code>
     *
     * <pre>
     * Count of bytes
     * </pre>
     */
    boolean hasIfOctets();
    /**
     * <code>required uint64 if_octets = 2;</code>
     *
     * <pre>
     * Count of bytes
     * </pre>
     */
    long getIfOctets();

    /**
     * <code>optional uint64 if_ucast_packets = 3;</code>
     *
     * <pre>
     * Count of unicast packets
     * </pre>
     */
    boolean hasIfUcastPackets();
    /**
     * <code>optional uint64 if_ucast_packets = 3;</code>
     *
     * <pre>
     * Count of unicast packets
     * </pre>
     */
    long getIfUcastPackets();

    /**
     * <code>required uint64 if_mcast_packets = 4;</code>
     *
     * <pre>
     * Count of multicast packets
     * </pre>
     */
    boolean hasIfMcastPackets();
    /**
     * <code>required uint64 if_mcast_packets = 4;</code>
     *
     * <pre>
     * Count of multicast packets
     * </pre>
     */
    long getIfMcastPackets();

    /**
     * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
     */
    java.util.List<LogicalPortOuterClass.ForwardingClassAccounting> 
        getIfFcStatsList();
    /**
     * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
     */
    LogicalPortOuterClass.ForwardingClassAccounting getIfFcStats(int index);
    /**
     * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
     */
    int getIfFcStatsCount();
    /**
     * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
     */
    java.util.List<? extends LogicalPortOuterClass.ForwardingClassAccountingOrBuilder> 
        getIfFcStatsOrBuilderList();
    /**
     * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
     */
    LogicalPortOuterClass.ForwardingClassAccountingOrBuilder getIfFcStatsOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code IngressInterfaceStats}
   *
   * <pre>
   *  Interface inbound/Ingress traffic statistics
   * </pre>
   */
  public static final class IngressInterfaceStats extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:IngressInterfaceStats)
      IngressInterfaceStatsOrBuilder {
    // Use IngressInterfaceStats.newBuilder() to construct.
    private IngressInterfaceStats(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private IngressInterfaceStats(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final IngressInterfaceStats defaultInstance;
    public static IngressInterfaceStats getDefaultInstance() {
      return defaultInstance;
    }

    public IngressInterfaceStats getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private IngressInterfaceStats(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              ifPackets_ = input.readUInt64();
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              ifOctets_ = input.readUInt64();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              ifUcastPackets_ = input.readUInt64();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              ifMcastPackets_ = input.readUInt64();
              break;
            }
            case 42: {
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                ifFcStats_ = new java.util.ArrayList<LogicalPortOuterClass.ForwardingClassAccounting>();
                mutable_bitField0_ |= 0x00000010;
              }
              ifFcStats_.add(input.readMessage(LogicalPortOuterClass.ForwardingClassAccounting.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
          ifFcStats_ = java.util.Collections.unmodifiableList(ifFcStats_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return LogicalPortOuterClass.internal_static_IngressInterfaceStats_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return LogicalPortOuterClass.internal_static_IngressInterfaceStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              LogicalPortOuterClass.IngressInterfaceStats.class, LogicalPortOuterClass.IngressInterfaceStats.Builder.class);
    }

    public static com.google.protobuf.Parser<IngressInterfaceStats> PARSER =
        new com.google.protobuf.AbstractParser<IngressInterfaceStats>() {
      public IngressInterfaceStats parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new IngressInterfaceStats(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<IngressInterfaceStats> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int IF_PACKETS_FIELD_NUMBER = 1;
    private long ifPackets_;
    /**
     * <code>required uint64 if_packets = 1;</code>
     *
     * <pre>
     * Count of packets
     * </pre>
     */
    public boolean hasIfPackets() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required uint64 if_packets = 1;</code>
     *
     * <pre>
     * Count of packets
     * </pre>
     */
    public long getIfPackets() {
      return ifPackets_;
    }

    public static final int IF_OCTETS_FIELD_NUMBER = 2;
    private long ifOctets_;
    /**
     * <code>required uint64 if_octets = 2;</code>
     *
     * <pre>
     * Count of bytes
     * </pre>
     */
    public boolean hasIfOctets() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required uint64 if_octets = 2;</code>
     *
     * <pre>
     * Count of bytes
     * </pre>
     */
    public long getIfOctets() {
      return ifOctets_;
    }

    public static final int IF_UCAST_PACKETS_FIELD_NUMBER = 3;
    private long ifUcastPackets_;
    /**
     * <code>optional uint64 if_ucast_packets = 3;</code>
     *
     * <pre>
     * Count of unicast packets
     * </pre>
     */
    public boolean hasIfUcastPackets() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint64 if_ucast_packets = 3;</code>
     *
     * <pre>
     * Count of unicast packets
     * </pre>
     */
    public long getIfUcastPackets() {
      return ifUcastPackets_;
    }

    public static final int IF_MCAST_PACKETS_FIELD_NUMBER = 4;
    private long ifMcastPackets_;
    /**
     * <code>required uint64 if_mcast_packets = 4;</code>
     *
     * <pre>
     * Count of multicast packets
     * </pre>
     */
    public boolean hasIfMcastPackets() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>required uint64 if_mcast_packets = 4;</code>
     *
     * <pre>
     * Count of multicast packets
     * </pre>
     */
    public long getIfMcastPackets() {
      return ifMcastPackets_;
    }

    public static final int IF_FC_STATS_FIELD_NUMBER = 5;
    private java.util.List<LogicalPortOuterClass.ForwardingClassAccounting> ifFcStats_;
    /**
     * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
     */
    public java.util.List<LogicalPortOuterClass.ForwardingClassAccounting> getIfFcStatsList() {
      return ifFcStats_;
    }
    /**
     * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
     */
    public java.util.List<? extends LogicalPortOuterClass.ForwardingClassAccountingOrBuilder> 
        getIfFcStatsOrBuilderList() {
      return ifFcStats_;
    }
    /**
     * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
     */
    public int getIfFcStatsCount() {
      return ifFcStats_.size();
    }
    /**
     * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
     */
    public LogicalPortOuterClass.ForwardingClassAccounting getIfFcStats(int index) {
      return ifFcStats_.get(index);
    }
    /**
     * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
     */
    public LogicalPortOuterClass.ForwardingClassAccountingOrBuilder getIfFcStatsOrBuilder(
        int index) {
      return ifFcStats_.get(index);
    }

    private void initFields() {
      ifPackets_ = 0L;
      ifOctets_ = 0L;
      ifUcastPackets_ = 0L;
      ifMcastPackets_ = 0L;
      ifFcStats_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasIfPackets()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasIfOctets()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasIfMcastPackets()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeUInt64(1, ifPackets_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, ifOctets_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt64(3, ifUcastPackets_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeUInt64(4, ifMcastPackets_);
      }
      for (int i = 0; i < ifFcStats_.size(); i++) {
        output.writeMessage(5, ifFcStats_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, ifPackets_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, ifOctets_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, ifUcastPackets_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(4, ifMcastPackets_);
      }
      for (int i = 0; i < ifFcStats_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, ifFcStats_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LogicalPortOuterClass.IngressInterfaceStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LogicalPortOuterClass.IngressInterfaceStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LogicalPortOuterClass.IngressInterfaceStats parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LogicalPortOuterClass.IngressInterfaceStats parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LogicalPortOuterClass.IngressInterfaceStats parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LogicalPortOuterClass.IngressInterfaceStats parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LogicalPortOuterClass.IngressInterfaceStats parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LogicalPortOuterClass.IngressInterfaceStats parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LogicalPortOuterClass.IngressInterfaceStats parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LogicalPortOuterClass.IngressInterfaceStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LogicalPortOuterClass.IngressInterfaceStats prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code IngressInterfaceStats}
     *
     * <pre>
     *  Interface inbound/Ingress traffic statistics
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:IngressInterfaceStats)
        LogicalPortOuterClass.IngressInterfaceStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return LogicalPortOuterClass.internal_static_IngressInterfaceStats_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return LogicalPortOuterClass.internal_static_IngressInterfaceStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                LogicalPortOuterClass.IngressInterfaceStats.class, LogicalPortOuterClass.IngressInterfaceStats.Builder.class);
      }

      // Construct using LogicalPortOuterClass.IngressInterfaceStats.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getIfFcStatsFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        ifPackets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        ifOctets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        ifUcastPackets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        ifMcastPackets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000008);
        if (ifFcStatsBuilder_ == null) {
          ifFcStats_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ifFcStatsBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return LogicalPortOuterClass.internal_static_IngressInterfaceStats_descriptor;
      }

      public LogicalPortOuterClass.IngressInterfaceStats getDefaultInstanceForType() {
        return LogicalPortOuterClass.IngressInterfaceStats.getDefaultInstance();
      }

      public LogicalPortOuterClass.IngressInterfaceStats build() {
        LogicalPortOuterClass.IngressInterfaceStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LogicalPortOuterClass.IngressInterfaceStats buildPartial() {
        LogicalPortOuterClass.IngressInterfaceStats result = new LogicalPortOuterClass.IngressInterfaceStats(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.ifPackets_ = ifPackets_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.ifOctets_ = ifOctets_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.ifUcastPackets_ = ifUcastPackets_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.ifMcastPackets_ = ifMcastPackets_;
        if (ifFcStatsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010)) {
            ifFcStats_ = java.util.Collections.unmodifiableList(ifFcStats_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.ifFcStats_ = ifFcStats_;
        } else {
          result.ifFcStats_ = ifFcStatsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof LogicalPortOuterClass.IngressInterfaceStats) {
          return mergeFrom((LogicalPortOuterClass.IngressInterfaceStats)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(LogicalPortOuterClass.IngressInterfaceStats other) {
        if (other == LogicalPortOuterClass.IngressInterfaceStats.getDefaultInstance()) return this;
        if (other.hasIfPackets()) {
          setIfPackets(other.getIfPackets());
        }
        if (other.hasIfOctets()) {
          setIfOctets(other.getIfOctets());
        }
        if (other.hasIfUcastPackets()) {
          setIfUcastPackets(other.getIfUcastPackets());
        }
        if (other.hasIfMcastPackets()) {
          setIfMcastPackets(other.getIfMcastPackets());
        }
        if (ifFcStatsBuilder_ == null) {
          if (!other.ifFcStats_.isEmpty()) {
            if (ifFcStats_.isEmpty()) {
              ifFcStats_ = other.ifFcStats_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureIfFcStatsIsMutable();
              ifFcStats_.addAll(other.ifFcStats_);
            }
            onChanged();
          }
        } else {
          if (!other.ifFcStats_.isEmpty()) {
            if (ifFcStatsBuilder_.isEmpty()) {
              ifFcStatsBuilder_.dispose();
              ifFcStatsBuilder_ = null;
              ifFcStats_ = other.ifFcStats_;
              bitField0_ = (bitField0_ & ~0x00000010);
              ifFcStatsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getIfFcStatsFieldBuilder() : null;
            } else {
              ifFcStatsBuilder_.addAllMessages(other.ifFcStats_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasIfPackets()) {
          
          return false;
        }
        if (!hasIfOctets()) {
          
          return false;
        }
        if (!hasIfMcastPackets()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LogicalPortOuterClass.IngressInterfaceStats parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LogicalPortOuterClass.IngressInterfaceStats) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long ifPackets_ ;
      /**
       * <code>required uint64 if_packets = 1;</code>
       *
       * <pre>
       * Count of packets
       * </pre>
       */
      public boolean hasIfPackets() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required uint64 if_packets = 1;</code>
       *
       * <pre>
       * Count of packets
       * </pre>
       */
      public long getIfPackets() {
        return ifPackets_;
      }
      /**
       * <code>required uint64 if_packets = 1;</code>
       *
       * <pre>
       * Count of packets
       * </pre>
       */
      public Builder setIfPackets(long value) {
        bitField0_ |= 0x00000001;
        ifPackets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 if_packets = 1;</code>
       *
       * <pre>
       * Count of packets
       * </pre>
       */
      public Builder clearIfPackets() {
        bitField0_ = (bitField0_ & ~0x00000001);
        ifPackets_ = 0L;
        onChanged();
        return this;
      }

      private long ifOctets_ ;
      /**
       * <code>required uint64 if_octets = 2;</code>
       *
       * <pre>
       * Count of bytes
       * </pre>
       */
      public boolean hasIfOctets() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required uint64 if_octets = 2;</code>
       *
       * <pre>
       * Count of bytes
       * </pre>
       */
      public long getIfOctets() {
        return ifOctets_;
      }
      /**
       * <code>required uint64 if_octets = 2;</code>
       *
       * <pre>
       * Count of bytes
       * </pre>
       */
      public Builder setIfOctets(long value) {
        bitField0_ |= 0x00000002;
        ifOctets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 if_octets = 2;</code>
       *
       * <pre>
       * Count of bytes
       * </pre>
       */
      public Builder clearIfOctets() {
        bitField0_ = (bitField0_ & ~0x00000002);
        ifOctets_ = 0L;
        onChanged();
        return this;
      }

      private long ifUcastPackets_ ;
      /**
       * <code>optional uint64 if_ucast_packets = 3;</code>
       *
       * <pre>
       * Count of unicast packets
       * </pre>
       */
      public boolean hasIfUcastPackets() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint64 if_ucast_packets = 3;</code>
       *
       * <pre>
       * Count of unicast packets
       * </pre>
       */
      public long getIfUcastPackets() {
        return ifUcastPackets_;
      }
      /**
       * <code>optional uint64 if_ucast_packets = 3;</code>
       *
       * <pre>
       * Count of unicast packets
       * </pre>
       */
      public Builder setIfUcastPackets(long value) {
        bitField0_ |= 0x00000004;
        ifUcastPackets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 if_ucast_packets = 3;</code>
       *
       * <pre>
       * Count of unicast packets
       * </pre>
       */
      public Builder clearIfUcastPackets() {
        bitField0_ = (bitField0_ & ~0x00000004);
        ifUcastPackets_ = 0L;
        onChanged();
        return this;
      }

      private long ifMcastPackets_ ;
      /**
       * <code>required uint64 if_mcast_packets = 4;</code>
       *
       * <pre>
       * Count of multicast packets
       * </pre>
       */
      public boolean hasIfMcastPackets() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>required uint64 if_mcast_packets = 4;</code>
       *
       * <pre>
       * Count of multicast packets
       * </pre>
       */
      public long getIfMcastPackets() {
        return ifMcastPackets_;
      }
      /**
       * <code>required uint64 if_mcast_packets = 4;</code>
       *
       * <pre>
       * Count of multicast packets
       * </pre>
       */
      public Builder setIfMcastPackets(long value) {
        bitField0_ |= 0x00000008;
        ifMcastPackets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 if_mcast_packets = 4;</code>
       *
       * <pre>
       * Count of multicast packets
       * </pre>
       */
      public Builder clearIfMcastPackets() {
        bitField0_ = (bitField0_ & ~0x00000008);
        ifMcastPackets_ = 0L;
        onChanged();
        return this;
      }

      private java.util.List<LogicalPortOuterClass.ForwardingClassAccounting> ifFcStats_ =
        java.util.Collections.emptyList();
      private void ensureIfFcStatsIsMutable() {
        if (!((bitField0_ & 0x00000010) == 0x00000010)) {
          ifFcStats_ = new java.util.ArrayList<LogicalPortOuterClass.ForwardingClassAccounting>(ifFcStats_);
          bitField0_ |= 0x00000010;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          LogicalPortOuterClass.ForwardingClassAccounting, LogicalPortOuterClass.ForwardingClassAccounting.Builder, LogicalPortOuterClass.ForwardingClassAccountingOrBuilder> ifFcStatsBuilder_;

      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public java.util.List<LogicalPortOuterClass.ForwardingClassAccounting> getIfFcStatsList() {
        if (ifFcStatsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(ifFcStats_);
        } else {
          return ifFcStatsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public int getIfFcStatsCount() {
        if (ifFcStatsBuilder_ == null) {
          return ifFcStats_.size();
        } else {
          return ifFcStatsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public LogicalPortOuterClass.ForwardingClassAccounting getIfFcStats(int index) {
        if (ifFcStatsBuilder_ == null) {
          return ifFcStats_.get(index);
        } else {
          return ifFcStatsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public Builder setIfFcStats(
          int index, LogicalPortOuterClass.ForwardingClassAccounting value) {
        if (ifFcStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIfFcStatsIsMutable();
          ifFcStats_.set(index, value);
          onChanged();
        } else {
          ifFcStatsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public Builder setIfFcStats(
          int index, LogicalPortOuterClass.ForwardingClassAccounting.Builder builderForValue) {
        if (ifFcStatsBuilder_ == null) {
          ensureIfFcStatsIsMutable();
          ifFcStats_.set(index, builderForValue.build());
          onChanged();
        } else {
          ifFcStatsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public Builder addIfFcStats(LogicalPortOuterClass.ForwardingClassAccounting value) {
        if (ifFcStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIfFcStatsIsMutable();
          ifFcStats_.add(value);
          onChanged();
        } else {
          ifFcStatsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public Builder addIfFcStats(
          int index, LogicalPortOuterClass.ForwardingClassAccounting value) {
        if (ifFcStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIfFcStatsIsMutable();
          ifFcStats_.add(index, value);
          onChanged();
        } else {
          ifFcStatsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public Builder addIfFcStats(
          LogicalPortOuterClass.ForwardingClassAccounting.Builder builderForValue) {
        if (ifFcStatsBuilder_ == null) {
          ensureIfFcStatsIsMutable();
          ifFcStats_.add(builderForValue.build());
          onChanged();
        } else {
          ifFcStatsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public Builder addIfFcStats(
          int index, LogicalPortOuterClass.ForwardingClassAccounting.Builder builderForValue) {
        if (ifFcStatsBuilder_ == null) {
          ensureIfFcStatsIsMutable();
          ifFcStats_.add(index, builderForValue.build());
          onChanged();
        } else {
          ifFcStatsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public Builder addAllIfFcStats(
          java.lang.Iterable<? extends LogicalPortOuterClass.ForwardingClassAccounting> values) {
        if (ifFcStatsBuilder_ == null) {
          ensureIfFcStatsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, ifFcStats_);
          onChanged();
        } else {
          ifFcStatsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public Builder clearIfFcStats() {
        if (ifFcStatsBuilder_ == null) {
          ifFcStats_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          ifFcStatsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public Builder removeIfFcStats(int index) {
        if (ifFcStatsBuilder_ == null) {
          ensureIfFcStatsIsMutable();
          ifFcStats_.remove(index);
          onChanged();
        } else {
          ifFcStatsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public LogicalPortOuterClass.ForwardingClassAccounting.Builder getIfFcStatsBuilder(
          int index) {
        return getIfFcStatsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public LogicalPortOuterClass.ForwardingClassAccountingOrBuilder getIfFcStatsOrBuilder(
          int index) {
        if (ifFcStatsBuilder_ == null) {
          return ifFcStats_.get(index);  } else {
          return ifFcStatsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public java.util.List<? extends LogicalPortOuterClass.ForwardingClassAccountingOrBuilder> 
           getIfFcStatsOrBuilderList() {
        if (ifFcStatsBuilder_ != null) {
          return ifFcStatsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(ifFcStats_);
        }
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public LogicalPortOuterClass.ForwardingClassAccounting.Builder addIfFcStatsBuilder() {
        return getIfFcStatsFieldBuilder().addBuilder(
            LogicalPortOuterClass.ForwardingClassAccounting.getDefaultInstance());
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public LogicalPortOuterClass.ForwardingClassAccounting.Builder addIfFcStatsBuilder(
          int index) {
        return getIfFcStatsFieldBuilder().addBuilder(
            index, LogicalPortOuterClass.ForwardingClassAccounting.getDefaultInstance());
      }
      /**
       * <code>repeated .ForwardingClassAccounting if_fc_stats = 5;</code>
       */
      public java.util.List<LogicalPortOuterClass.ForwardingClassAccounting.Builder> 
           getIfFcStatsBuilderList() {
        return getIfFcStatsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          LogicalPortOuterClass.ForwardingClassAccounting, LogicalPortOuterClass.ForwardingClassAccounting.Builder, LogicalPortOuterClass.ForwardingClassAccountingOrBuilder> 
          getIfFcStatsFieldBuilder() {
        if (ifFcStatsBuilder_ == null) {
          ifFcStatsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              LogicalPortOuterClass.ForwardingClassAccounting, LogicalPortOuterClass.ForwardingClassAccounting.Builder, LogicalPortOuterClass.ForwardingClassAccountingOrBuilder>(
                  ifFcStats_,
                  ((bitField0_ & 0x00000010) == 0x00000010),
                  getParentForChildren(),
                  isClean());
          ifFcStats_ = null;
        }
        return ifFcStatsBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:IngressInterfaceStats)
    }

    static {
      defaultInstance = new IngressInterfaceStats(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:IngressInterfaceStats)
  }

  public interface EgressInterfaceStatsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:EgressInterfaceStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required uint64 if_packets = 1;</code>
     *
     * <pre>
     * Count of packets
     * </pre>
     */
    boolean hasIfPackets();
    /**
     * <code>required uint64 if_packets = 1;</code>
     *
     * <pre>
     * Count of packets
     * </pre>
     */
    long getIfPackets();

    /**
     * <code>required uint64 if_octets = 2;</code>
     *
     * <pre>
     * Count of bytes
     * </pre>
     */
    boolean hasIfOctets();
    /**
     * <code>required uint64 if_octets = 2;</code>
     *
     * <pre>
     * Count of bytes
     * </pre>
     */
    long getIfOctets();
  }
  /**
   * Protobuf type {@code EgressInterfaceStats}
   *
   * <pre>
   *  Interface outbound/Egress traffic statistics
   * </pre>
   */
  public static final class EgressInterfaceStats extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:EgressInterfaceStats)
      EgressInterfaceStatsOrBuilder {
    // Use EgressInterfaceStats.newBuilder() to construct.
    private EgressInterfaceStats(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private EgressInterfaceStats(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final EgressInterfaceStats defaultInstance;
    public static EgressInterfaceStats getDefaultInstance() {
      return defaultInstance;
    }

    public EgressInterfaceStats getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private EgressInterfaceStats(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              ifPackets_ = input.readUInt64();
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              ifOctets_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return LogicalPortOuterClass.internal_static_EgressInterfaceStats_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return LogicalPortOuterClass.internal_static_EgressInterfaceStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              LogicalPortOuterClass.EgressInterfaceStats.class, LogicalPortOuterClass.EgressInterfaceStats.Builder.class);
    }

    public static com.google.protobuf.Parser<EgressInterfaceStats> PARSER =
        new com.google.protobuf.AbstractParser<EgressInterfaceStats>() {
      public EgressInterfaceStats parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new EgressInterfaceStats(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<EgressInterfaceStats> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int IF_PACKETS_FIELD_NUMBER = 1;
    private long ifPackets_;
    /**
     * <code>required uint64 if_packets = 1;</code>
     *
     * <pre>
     * Count of packets
     * </pre>
     */
    public boolean hasIfPackets() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required uint64 if_packets = 1;</code>
     *
     * <pre>
     * Count of packets
     * </pre>
     */
    public long getIfPackets() {
      return ifPackets_;
    }

    public static final int IF_OCTETS_FIELD_NUMBER = 2;
    private long ifOctets_;
    /**
     * <code>required uint64 if_octets = 2;</code>
     *
     * <pre>
     * Count of bytes
     * </pre>
     */
    public boolean hasIfOctets() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required uint64 if_octets = 2;</code>
     *
     * <pre>
     * Count of bytes
     * </pre>
     */
    public long getIfOctets() {
      return ifOctets_;
    }

    private void initFields() {
      ifPackets_ = 0L;
      ifOctets_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasIfPackets()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasIfOctets()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeUInt64(1, ifPackets_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, ifOctets_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, ifPackets_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, ifOctets_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LogicalPortOuterClass.EgressInterfaceStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LogicalPortOuterClass.EgressInterfaceStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LogicalPortOuterClass.EgressInterfaceStats parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LogicalPortOuterClass.EgressInterfaceStats parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LogicalPortOuterClass.EgressInterfaceStats parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LogicalPortOuterClass.EgressInterfaceStats parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LogicalPortOuterClass.EgressInterfaceStats parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LogicalPortOuterClass.EgressInterfaceStats parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LogicalPortOuterClass.EgressInterfaceStats parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LogicalPortOuterClass.EgressInterfaceStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LogicalPortOuterClass.EgressInterfaceStats prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code EgressInterfaceStats}
     *
     * <pre>
     *  Interface outbound/Egress traffic statistics
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:EgressInterfaceStats)
        LogicalPortOuterClass.EgressInterfaceStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return LogicalPortOuterClass.internal_static_EgressInterfaceStats_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return LogicalPortOuterClass.internal_static_EgressInterfaceStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                LogicalPortOuterClass.EgressInterfaceStats.class, LogicalPortOuterClass.EgressInterfaceStats.Builder.class);
      }

      // Construct using LogicalPortOuterClass.EgressInterfaceStats.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        ifPackets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        ifOctets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return LogicalPortOuterClass.internal_static_EgressInterfaceStats_descriptor;
      }

      public LogicalPortOuterClass.EgressInterfaceStats getDefaultInstanceForType() {
        return LogicalPortOuterClass.EgressInterfaceStats.getDefaultInstance();
      }

      public LogicalPortOuterClass.EgressInterfaceStats build() {
        LogicalPortOuterClass.EgressInterfaceStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LogicalPortOuterClass.EgressInterfaceStats buildPartial() {
        LogicalPortOuterClass.EgressInterfaceStats result = new LogicalPortOuterClass.EgressInterfaceStats(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.ifPackets_ = ifPackets_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.ifOctets_ = ifOctets_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof LogicalPortOuterClass.EgressInterfaceStats) {
          return mergeFrom((LogicalPortOuterClass.EgressInterfaceStats)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(LogicalPortOuterClass.EgressInterfaceStats other) {
        if (other == LogicalPortOuterClass.EgressInterfaceStats.getDefaultInstance()) return this;
        if (other.hasIfPackets()) {
          setIfPackets(other.getIfPackets());
        }
        if (other.hasIfOctets()) {
          setIfOctets(other.getIfOctets());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasIfPackets()) {
          
          return false;
        }
        if (!hasIfOctets()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LogicalPortOuterClass.EgressInterfaceStats parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LogicalPortOuterClass.EgressInterfaceStats) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long ifPackets_ ;
      /**
       * <code>required uint64 if_packets = 1;</code>
       *
       * <pre>
       * Count of packets
       * </pre>
       */
      public boolean hasIfPackets() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required uint64 if_packets = 1;</code>
       *
       * <pre>
       * Count of packets
       * </pre>
       */
      public long getIfPackets() {
        return ifPackets_;
      }
      /**
       * <code>required uint64 if_packets = 1;</code>
       *
       * <pre>
       * Count of packets
       * </pre>
       */
      public Builder setIfPackets(long value) {
        bitField0_ |= 0x00000001;
        ifPackets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 if_packets = 1;</code>
       *
       * <pre>
       * Count of packets
       * </pre>
       */
      public Builder clearIfPackets() {
        bitField0_ = (bitField0_ & ~0x00000001);
        ifPackets_ = 0L;
        onChanged();
        return this;
      }

      private long ifOctets_ ;
      /**
       * <code>required uint64 if_octets = 2;</code>
       *
       * <pre>
       * Count of bytes
       * </pre>
       */
      public boolean hasIfOctets() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required uint64 if_octets = 2;</code>
       *
       * <pre>
       * Count of bytes
       * </pre>
       */
      public long getIfOctets() {
        return ifOctets_;
      }
      /**
       * <code>required uint64 if_octets = 2;</code>
       *
       * <pre>
       * Count of bytes
       * </pre>
       */
      public Builder setIfOctets(long value) {
        bitField0_ |= 0x00000002;
        ifOctets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 if_octets = 2;</code>
       *
       * <pre>
       * Count of bytes
       * </pre>
       */
      public Builder clearIfOctets() {
        bitField0_ = (bitField0_ & ~0x00000002);
        ifOctets_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:EgressInterfaceStats)
    }

    static {
      defaultInstance = new EgressInterfaceStats(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:EgressInterfaceStats)
  }

  public interface OperationalStateOrBuilder extends
      // @@protoc_insertion_point(interface_extends:OperationalState)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string operational_status = 1;</code>
     *
     * <pre>
     * If the link is up/down
     * </pre>
     */
    boolean hasOperationalStatus();
    /**
     * <code>optional string operational_status = 1;</code>
     *
     * <pre>
     * If the link is up/down
     * </pre>
     */
    java.lang.String getOperationalStatus();
    /**
     * <code>optional string operational_status = 1;</code>
     *
     * <pre>
     * If the link is up/down
     * </pre>
     */
    com.google.protobuf.ByteString
        getOperationalStatusBytes();
  }
  /**
   * Protobuf type {@code OperationalState}
   *
   * <pre>
   *  Interface operational State details
   * </pre>
   */
  public static final class OperationalState extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:OperationalState)
      OperationalStateOrBuilder {
    // Use OperationalState.newBuilder() to construct.
    private OperationalState(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private OperationalState(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final OperationalState defaultInstance;
    public static OperationalState getDefaultInstance() {
      return defaultInstance;
    }

    public OperationalState getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private OperationalState(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              operationalStatus_ = bs;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return LogicalPortOuterClass.internal_static_OperationalState_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return LogicalPortOuterClass.internal_static_OperationalState_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              LogicalPortOuterClass.OperationalState.class, LogicalPortOuterClass.OperationalState.Builder.class);
    }

    public static com.google.protobuf.Parser<OperationalState> PARSER =
        new com.google.protobuf.AbstractParser<OperationalState>() {
      public OperationalState parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new OperationalState(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<OperationalState> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int OPERATIONAL_STATUS_FIELD_NUMBER = 1;
    private java.lang.Object operationalStatus_;
    /**
     * <code>optional string operational_status = 1;</code>
     *
     * <pre>
     * If the link is up/down
     * </pre>
     */
    public boolean hasOperationalStatus() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string operational_status = 1;</code>
     *
     * <pre>
     * If the link is up/down
     * </pre>
     */
    public java.lang.String getOperationalStatus() {
      java.lang.Object ref = operationalStatus_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          operationalStatus_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string operational_status = 1;</code>
     *
     * <pre>
     * If the link is up/down
     * </pre>
     */
    public com.google.protobuf.ByteString
        getOperationalStatusBytes() {
      java.lang.Object ref = operationalStatus_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        operationalStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      operationalStatus_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getOperationalStatusBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getOperationalStatusBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LogicalPortOuterClass.OperationalState parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LogicalPortOuterClass.OperationalState parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LogicalPortOuterClass.OperationalState parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LogicalPortOuterClass.OperationalState parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LogicalPortOuterClass.OperationalState parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LogicalPortOuterClass.OperationalState parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LogicalPortOuterClass.OperationalState parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LogicalPortOuterClass.OperationalState parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LogicalPortOuterClass.OperationalState parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LogicalPortOuterClass.OperationalState parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LogicalPortOuterClass.OperationalState prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code OperationalState}
     *
     * <pre>
     *  Interface operational State details
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:OperationalState)
        LogicalPortOuterClass.OperationalStateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return LogicalPortOuterClass.internal_static_OperationalState_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return LogicalPortOuterClass.internal_static_OperationalState_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                LogicalPortOuterClass.OperationalState.class, LogicalPortOuterClass.OperationalState.Builder.class);
      }

      // Construct using LogicalPortOuterClass.OperationalState.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        operationalStatus_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return LogicalPortOuterClass.internal_static_OperationalState_descriptor;
      }

      public LogicalPortOuterClass.OperationalState getDefaultInstanceForType() {
        return LogicalPortOuterClass.OperationalState.getDefaultInstance();
      }

      public LogicalPortOuterClass.OperationalState build() {
        LogicalPortOuterClass.OperationalState result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LogicalPortOuterClass.OperationalState buildPartial() {
        LogicalPortOuterClass.OperationalState result = new LogicalPortOuterClass.OperationalState(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.operationalStatus_ = operationalStatus_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof LogicalPortOuterClass.OperationalState) {
          return mergeFrom((LogicalPortOuterClass.OperationalState)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(LogicalPortOuterClass.OperationalState other) {
        if (other == LogicalPortOuterClass.OperationalState.getDefaultInstance()) return this;
        if (other.hasOperationalStatus()) {
          bitField0_ |= 0x00000001;
          operationalStatus_ = other.operationalStatus_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LogicalPortOuterClass.OperationalState parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LogicalPortOuterClass.OperationalState) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object operationalStatus_ = "";
      /**
       * <code>optional string operational_status = 1;</code>
       *
       * <pre>
       * If the link is up/down
       * </pre>
       */
      public boolean hasOperationalStatus() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string operational_status = 1;</code>
       *
       * <pre>
       * If the link is up/down
       * </pre>
       */
      public java.lang.String getOperationalStatus() {
        java.lang.Object ref = operationalStatus_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            operationalStatus_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string operational_status = 1;</code>
       *
       * <pre>
       * If the link is up/down
       * </pre>
       */
      public com.google.protobuf.ByteString
          getOperationalStatusBytes() {
        java.lang.Object ref = operationalStatus_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          operationalStatus_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string operational_status = 1;</code>
       *
       * <pre>
       * If the link is up/down
       * </pre>
       */
      public Builder setOperationalStatus(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        operationalStatus_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string operational_status = 1;</code>
       *
       * <pre>
       * If the link is up/down
       * </pre>
       */
      public Builder clearOperationalStatus() {
        bitField0_ = (bitField0_ & ~0x00000001);
        operationalStatus_ = getDefaultInstance().getOperationalStatus();
        onChanged();
        return this;
      }
      /**
       * <code>optional string operational_status = 1;</code>
       *
       * <pre>
       * If the link is up/down
       * </pre>
       */
      public Builder setOperationalStatusBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        operationalStatus_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:OperationalState)
    }

    static {
      defaultInstance = new OperationalState(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:OperationalState)
  }

  public interface ForwardingClassAccountingOrBuilder extends
      // @@protoc_insertion_point(interface_extends:ForwardingClassAccounting)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string if_family = 1;</code>
     *
     * <pre>
     * Interface protocol
     * </pre>
     */
    boolean hasIfFamily();
    /**
     * <code>optional string if_family = 1;</code>
     *
     * <pre>
     * Interface protocol
     * </pre>
     */
    java.lang.String getIfFamily();
    /**
     * <code>optional string if_family = 1;</code>
     *
     * <pre>
     * Interface protocol
     * </pre>
     */
    com.google.protobuf.ByteString
        getIfFamilyBytes();

    /**
     * <code>optional uint32 fc_number = 2;</code>
     *
     * <pre>
     * Forwarding class number
     * </pre>
     */
    boolean hasFcNumber();
    /**
     * <code>optional uint32 fc_number = 2;</code>
     *
     * <pre>
     * Forwarding class number
     * </pre>
     */
    int getFcNumber();

    /**
     * <code>optional uint64 if_packets = 3;</code>
     *
     * <pre>
     * Count of packets
     * </pre>
     */
    boolean hasIfPackets();
    /**
     * <code>optional uint64 if_packets = 3;</code>
     *
     * <pre>
     * Count of packets
     * </pre>
     */
    long getIfPackets();

    /**
     * <code>optional uint64 if_octets = 4;</code>
     *
     * <pre>
     * Count of bytes
     * </pre>
     */
    boolean hasIfOctets();
    /**
     * <code>optional uint64 if_octets = 4;</code>
     *
     * <pre>
     * Count of bytes
     * </pre>
     */
    long getIfOctets();
  }
  /**
   * Protobuf type {@code ForwardingClassAccounting}
   *
   * <pre>
   *  Interface forwarding class accounting
   * </pre>
   */
  public static final class ForwardingClassAccounting extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:ForwardingClassAccounting)
      ForwardingClassAccountingOrBuilder {
    // Use ForwardingClassAccounting.newBuilder() to construct.
    private ForwardingClassAccounting(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private ForwardingClassAccounting(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final ForwardingClassAccounting defaultInstance;
    public static ForwardingClassAccounting getDefaultInstance() {
      return defaultInstance;
    }

    public ForwardingClassAccounting getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private ForwardingClassAccounting(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              ifFamily_ = bs;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              fcNumber_ = input.readUInt32();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              ifPackets_ = input.readUInt64();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              ifOctets_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return LogicalPortOuterClass.internal_static_ForwardingClassAccounting_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return LogicalPortOuterClass.internal_static_ForwardingClassAccounting_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              LogicalPortOuterClass.ForwardingClassAccounting.class, LogicalPortOuterClass.ForwardingClassAccounting.Builder.class);
    }

    public static com.google.protobuf.Parser<ForwardingClassAccounting> PARSER =
        new com.google.protobuf.AbstractParser<ForwardingClassAccounting>() {
      public ForwardingClassAccounting parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ForwardingClassAccounting(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<ForwardingClassAccounting> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int IF_FAMILY_FIELD_NUMBER = 1;
    private java.lang.Object ifFamily_;
    /**
     * <code>optional string if_family = 1;</code>
     *
     * <pre>
     * Interface protocol
     * </pre>
     */
    public boolean hasIfFamily() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string if_family = 1;</code>
     *
     * <pre>
     * Interface protocol
     * </pre>
     */
    public java.lang.String getIfFamily() {
      java.lang.Object ref = ifFamily_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          ifFamily_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string if_family = 1;</code>
     *
     * <pre>
     * Interface protocol
     * </pre>
     */
    public com.google.protobuf.ByteString
        getIfFamilyBytes() {
      java.lang.Object ref = ifFamily_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        ifFamily_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FC_NUMBER_FIELD_NUMBER = 2;
    private int fcNumber_;
    /**
     * <code>optional uint32 fc_number = 2;</code>
     *
     * <pre>
     * Forwarding class number
     * </pre>
     */
    public boolean hasFcNumber() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional uint32 fc_number = 2;</code>
     *
     * <pre>
     * Forwarding class number
     * </pre>
     */
    public int getFcNumber() {
      return fcNumber_;
    }

    public static final int IF_PACKETS_FIELD_NUMBER = 3;
    private long ifPackets_;
    /**
     * <code>optional uint64 if_packets = 3;</code>
     *
     * <pre>
     * Count of packets
     * </pre>
     */
    public boolean hasIfPackets() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint64 if_packets = 3;</code>
     *
     * <pre>
     * Count of packets
     * </pre>
     */
    public long getIfPackets() {
      return ifPackets_;
    }

    public static final int IF_OCTETS_FIELD_NUMBER = 4;
    private long ifOctets_;
    /**
     * <code>optional uint64 if_octets = 4;</code>
     *
     * <pre>
     * Count of bytes
     * </pre>
     */
    public boolean hasIfOctets() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional uint64 if_octets = 4;</code>
     *
     * <pre>
     * Count of bytes
     * </pre>
     */
    public long getIfOctets() {
      return ifOctets_;
    }

    private void initFields() {
      ifFamily_ = "";
      fcNumber_ = 0;
      ifPackets_ = 0L;
      ifOctets_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getIfFamilyBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt32(2, fcNumber_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt64(3, ifPackets_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeUInt64(4, ifOctets_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getIfFamilyBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, fcNumber_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, ifPackets_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(4, ifOctets_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LogicalPortOuterClass.ForwardingClassAccounting parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LogicalPortOuterClass.ForwardingClassAccounting parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LogicalPortOuterClass.ForwardingClassAccounting parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LogicalPortOuterClass.ForwardingClassAccounting parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LogicalPortOuterClass.ForwardingClassAccounting parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LogicalPortOuterClass.ForwardingClassAccounting parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LogicalPortOuterClass.ForwardingClassAccounting parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LogicalPortOuterClass.ForwardingClassAccounting parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LogicalPortOuterClass.ForwardingClassAccounting parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LogicalPortOuterClass.ForwardingClassAccounting parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LogicalPortOuterClass.ForwardingClassAccounting prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code ForwardingClassAccounting}
     *
     * <pre>
     *  Interface forwarding class accounting
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:ForwardingClassAccounting)
        LogicalPortOuterClass.ForwardingClassAccountingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return LogicalPortOuterClass.internal_static_ForwardingClassAccounting_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return LogicalPortOuterClass.internal_static_ForwardingClassAccounting_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                LogicalPortOuterClass.ForwardingClassAccounting.class, LogicalPortOuterClass.ForwardingClassAccounting.Builder.class);
      }

      // Construct using LogicalPortOuterClass.ForwardingClassAccounting.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        ifFamily_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        fcNumber_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        ifPackets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        ifOctets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return LogicalPortOuterClass.internal_static_ForwardingClassAccounting_descriptor;
      }

      public LogicalPortOuterClass.ForwardingClassAccounting getDefaultInstanceForType() {
        return LogicalPortOuterClass.ForwardingClassAccounting.getDefaultInstance();
      }

      public LogicalPortOuterClass.ForwardingClassAccounting build() {
        LogicalPortOuterClass.ForwardingClassAccounting result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LogicalPortOuterClass.ForwardingClassAccounting buildPartial() {
        LogicalPortOuterClass.ForwardingClassAccounting result = new LogicalPortOuterClass.ForwardingClassAccounting(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.ifFamily_ = ifFamily_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.fcNumber_ = fcNumber_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.ifPackets_ = ifPackets_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.ifOctets_ = ifOctets_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof LogicalPortOuterClass.ForwardingClassAccounting) {
          return mergeFrom((LogicalPortOuterClass.ForwardingClassAccounting)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(LogicalPortOuterClass.ForwardingClassAccounting other) {
        if (other == LogicalPortOuterClass.ForwardingClassAccounting.getDefaultInstance()) return this;
        if (other.hasIfFamily()) {
          bitField0_ |= 0x00000001;
          ifFamily_ = other.ifFamily_;
          onChanged();
        }
        if (other.hasFcNumber()) {
          setFcNumber(other.getFcNumber());
        }
        if (other.hasIfPackets()) {
          setIfPackets(other.getIfPackets());
        }
        if (other.hasIfOctets()) {
          setIfOctets(other.getIfOctets());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LogicalPortOuterClass.ForwardingClassAccounting parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LogicalPortOuterClass.ForwardingClassAccounting) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object ifFamily_ = "";
      /**
       * <code>optional string if_family = 1;</code>
       *
       * <pre>
       * Interface protocol
       * </pre>
       */
      public boolean hasIfFamily() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string if_family = 1;</code>
       *
       * <pre>
       * Interface protocol
       * </pre>
       */
      public java.lang.String getIfFamily() {
        java.lang.Object ref = ifFamily_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            ifFamily_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string if_family = 1;</code>
       *
       * <pre>
       * Interface protocol
       * </pre>
       */
      public com.google.protobuf.ByteString
          getIfFamilyBytes() {
        java.lang.Object ref = ifFamily_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          ifFamily_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string if_family = 1;</code>
       *
       * <pre>
       * Interface protocol
       * </pre>
       */
      public Builder setIfFamily(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        ifFamily_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string if_family = 1;</code>
       *
       * <pre>
       * Interface protocol
       * </pre>
       */
      public Builder clearIfFamily() {
        bitField0_ = (bitField0_ & ~0x00000001);
        ifFamily_ = getDefaultInstance().getIfFamily();
        onChanged();
        return this;
      }
      /**
       * <code>optional string if_family = 1;</code>
       *
       * <pre>
       * Interface protocol
       * </pre>
       */
      public Builder setIfFamilyBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        ifFamily_ = value;
        onChanged();
        return this;
      }

      private int fcNumber_ ;
      /**
       * <code>optional uint32 fc_number = 2;</code>
       *
       * <pre>
       * Forwarding class number
       * </pre>
       */
      public boolean hasFcNumber() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint32 fc_number = 2;</code>
       *
       * <pre>
       * Forwarding class number
       * </pre>
       */
      public int getFcNumber() {
        return fcNumber_;
      }
      /**
       * <code>optional uint32 fc_number = 2;</code>
       *
       * <pre>
       * Forwarding class number
       * </pre>
       */
      public Builder setFcNumber(int value) {
        bitField0_ |= 0x00000002;
        fcNumber_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 fc_number = 2;</code>
       *
       * <pre>
       * Forwarding class number
       * </pre>
       */
      public Builder clearFcNumber() {
        bitField0_ = (bitField0_ & ~0x00000002);
        fcNumber_ = 0;
        onChanged();
        return this;
      }

      private long ifPackets_ ;
      /**
       * <code>optional uint64 if_packets = 3;</code>
       *
       * <pre>
       * Count of packets
       * </pre>
       */
      public boolean hasIfPackets() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint64 if_packets = 3;</code>
       *
       * <pre>
       * Count of packets
       * </pre>
       */
      public long getIfPackets() {
        return ifPackets_;
      }
      /**
       * <code>optional uint64 if_packets = 3;</code>
       *
       * <pre>
       * Count of packets
       * </pre>
       */
      public Builder setIfPackets(long value) {
        bitField0_ |= 0x00000004;
        ifPackets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 if_packets = 3;</code>
       *
       * <pre>
       * Count of packets
       * </pre>
       */
      public Builder clearIfPackets() {
        bitField0_ = (bitField0_ & ~0x00000004);
        ifPackets_ = 0L;
        onChanged();
        return this;
      }

      private long ifOctets_ ;
      /**
       * <code>optional uint64 if_octets = 4;</code>
       *
       * <pre>
       * Count of bytes
       * </pre>
       */
      public boolean hasIfOctets() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional uint64 if_octets = 4;</code>
       *
       * <pre>
       * Count of bytes
       * </pre>
       */
      public long getIfOctets() {
        return ifOctets_;
      }
      /**
       * <code>optional uint64 if_octets = 4;</code>
       *
       * <pre>
       * Count of bytes
       * </pre>
       */
      public Builder setIfOctets(long value) {
        bitField0_ |= 0x00000008;
        ifOctets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 if_octets = 4;</code>
       *
       * <pre>
       * Count of bytes
       * </pre>
       */
      public Builder clearIfOctets() {
        bitField0_ = (bitField0_ & ~0x00000008);
        ifOctets_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:ForwardingClassAccounting)
    }

    static {
      defaultInstance = new ForwardingClassAccounting(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:ForwardingClassAccounting)
  }

  public static final int JNPRLOGICALINTERFACEEXT_FIELD_NUMBER = 7;
  /**
   * <code>extend .JuniperNetworksSensors { ... }</code>
   */
  public static final
    com.google.protobuf.GeneratedMessage.GeneratedExtension<
      TelemetryTop.JuniperNetworksSensors,
      LogicalPortOuterClass.LogicalPort> jnprLogicalInterfaceExt = com.google.protobuf.GeneratedMessage
          .newFileScopedGeneratedExtension(
        LogicalPortOuterClass.LogicalPort.class,
        LogicalPortOuterClass.LogicalPort.getDefaultInstance());
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_LogicalPort_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_LogicalPort_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_LogicalInterfaceInfo_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_LogicalInterfaceInfo_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_IngressInterfaceStats_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_IngressInterfaceStats_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_EgressInterfaceStats_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_EgressInterfaceStats_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_OperationalState_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_OperationalState_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_ForwardingClassAccounting_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_ForwardingClassAccounting_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\022logical_port.proto\032\023telemetry_top.prot" +
      "o\"<\n\013LogicalPort\022-\n\016interface_info\030\001 \003(\013" +
      "2\025.LogicalInterfaceInfo\"\206\002\n\024LogicalInter" +
      "faceInfo\022\026\n\007if_name\030\001 \002(\tB\005\202@\002\010\001\022\030\n\tinit" +
      "_time\030\002 \002(\004B\005\202@\002\020\001\022\034\n\rsnmp_if_index\030\003 \001(" +
      "\rB\005\202@\002\010\001\022\035\n\016parent_ae_name\030\004 \001(\tB\005\202@\002\010\001\022" +
      "-\n\ringress_stats\030\005 \001(\0132\026.IngressInterfac" +
      "eStats\022+\n\014egress_stats\030\006 \001(\0132\025.EgressInt" +
      "erfaceStats\022#\n\010op_state\030\007 \001(\0132\021.Operatio" +
      "nalState\"\277\001\n\025IngressInterfaceStats\022\031\n\nif",
      "_packets\030\001 \002(\004B\005\202@\002\030\001\022\030\n\tif_octets\030\002 \002(\004" +
      "B\005\202@\002\030\001\022\037\n\020if_ucast_packets\030\003 \001(\004B\005\202@\002\030\001" +
      "\022\037\n\020if_mcast_packets\030\004 \002(\004B\005\202@\002\030\001\022/\n\013if_" +
      "fc_stats\030\005 \003(\0132\032.ForwardingClassAccounti" +
      "ng\"K\n\024EgressInterfaceStats\022\031\n\nif_packets" +
      "\030\001 \002(\004B\005\202@\002\030\001\022\030\n\tif_octets\030\002 \002(\004B\005\202@\002\030\001\"" +
      ".\n\020OperationalState\022\032\n\022operational_statu" +
      "s\030\001 \001(\t\"\204\001\n\031ForwardingClassAccounting\022\030\n" +
      "\tif_family\030\001 \001(\tB\005\202@\002\010\001\022\030\n\tfc_number\030\002 \001" +
      "(\rB\005\202@\002\010\001\022\031\n\nif_packets\030\003 \001(\004B\005\202@\002\030\001\022\030\n\t",
      "if_octets\030\004 \001(\004B\005\202@\002\030\001:F\n\027jnprLogicalInt" +
      "erfaceExt\022\027.JuniperNetworksSensors\030\007 \001(\013" +
      "2\014.LogicalPort"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          TelemetryTop.getDescriptor(),
        }, assigner);
    internal_static_LogicalPort_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_LogicalPort_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_LogicalPort_descriptor,
        new java.lang.String[] { "InterfaceInfo", });
    internal_static_LogicalInterfaceInfo_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_LogicalInterfaceInfo_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_LogicalInterfaceInfo_descriptor,
        new java.lang.String[] { "IfName", "InitTime", "SnmpIfIndex", "ParentAeName", "IngressStats", "EgressStats", "OpState", });
    internal_static_IngressInterfaceStats_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_IngressInterfaceStats_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_IngressInterfaceStats_descriptor,
        new java.lang.String[] { "IfPackets", "IfOctets", "IfUcastPackets", "IfMcastPackets", "IfFcStats", });
    internal_static_EgressInterfaceStats_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_EgressInterfaceStats_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_EgressInterfaceStats_descriptor,
        new java.lang.String[] { "IfPackets", "IfOctets", });
    internal_static_OperationalState_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_OperationalState_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_OperationalState_descriptor,
        new java.lang.String[] { "OperationalStatus", });
    internal_static_ForwardingClassAccounting_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_ForwardingClassAccounting_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_ForwardingClassAccounting_descriptor,
        new java.lang.String[] { "IfFamily", "FcNumber", "IfPackets", "IfOctets", });
    jnprLogicalInterfaceExt.internalInit(descriptor.getExtensions().get(0));
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    TelemetryTop.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
