/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.sms.reflector.smsservice.MatchingRequestLocator;
import org.opennms.sms.reflector.smsservice.MobileMsgRequest;
import org.opennms.sms.reflector.smsservice.MobileMsgResponse;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseMatcher;
import org.opennms.sms.reflector.smsservice.PingResponseMatcher;
import org.opennms.sms.reflector.smsservice.SmsRequest;
import org.opennms.sms.reflector.smsservice.SmsResponse;
import org.smslib.InboundMessage;
import org.smslib.OutboundMessage;

public class MatchingRequestLocatorTest {
    MatchingRequestLocator m_locator;

    @Before
    public void setUp() {
        this.m_locator = new MatchingRequestLocator();
    }

    @Test
    public void testMatchPingPong() {
        SmsRequest request = new SmsRequest(this.getMessage("+19195551212", "+19195552121", "ping"), 60000L, 0, null, (MobileMsgResponseMatcher)new PingResponseMatcher());
        SmsRequest request2 = new SmsRequest(this.getMessage("+19195551313", "+19195553131", "ping"), 60000L, 0, null, (MobileMsgResponseMatcher)new PingResponseMatcher());
        this.m_locator.trackRequest((MobileMsgRequest)request);
        this.m_locator.trackRequest((MobileMsgRequest)request2);
        SmsResponse response = this.createResponse("+19195552121", "+19195551212", "pong");
        SmsResponse response2 = this.createResponse("+19195553131", "+19195551313", "pong");
        MobileMsgRequest matchedRequest2 = this.m_locator.locateMatchingRequest((MobileMsgResponse)response2);
        Assert.assertSame((Object)request2, (Object)matchedRequest2);
        this.m_locator.requestComplete((MobileMsgRequest)request2);
        MobileMsgRequest matchedRequest = this.m_locator.locateMatchingRequest((MobileMsgResponse)response);
        Assert.assertSame((Object)request, (Object)matchedRequest);
        this.m_locator.requestComplete((MobileMsgRequest)request);
    }

    OutboundMessage getMessage(String originator, String recipient, String text) {
        OutboundMessage msg = new OutboundMessage(recipient, text);
        msg.setValidityPeriod(1);
        msg.setFrom(originator);
        return msg;
    }

    @Test
    public void testMatchPingPingPong() {
        SmsRequest request = new SmsRequest(this.getMessage("+19195551212", "+19195552121", "ping"), 60000L, 0, null, (MobileMsgResponseMatcher)new PingResponseMatcher());
        this.m_locator.trackRequest((MobileMsgRequest)request);
        SmsResponse badResponse = this.createResponse("+19195552121", "+19195551212", "ping");
        MobileMsgRequest matchedRequest = this.m_locator.locateMatchingRequest((MobileMsgResponse)badResponse);
        Assert.assertNull((Object)matchedRequest);
        SmsResponse goodResponse = this.createResponse("+19195552121", "+19195551212", "pong");
        matchedRequest = this.m_locator.locateMatchingRequest((MobileMsgResponse)goodResponse);
        Assert.assertSame((Object)request, (Object)matchedRequest);
    }

    public SmsResponse createResponse(String originator, String recipient, String text) {
        InboundMessage msg = new InboundMessage(new Date(), originator, text, 0, "0");
        return new SmsResponse(msg, System.currentTimeMillis());
    }

    @Test
    public void testMatchPingPingTimeoutPong() {
        SmsRequest request = new SmsRequest(this.getMessage("+19195551212", "+19195552121", "ping"), 60000L, 0, null, (MobileMsgResponseMatcher)new PingResponseMatcher());
        this.m_locator.trackRequest((MobileMsgRequest)request);
        SmsResponse badResponse = this.createResponse("+19195552121", "+19195551212", "ping");
        MobileMsgRequest matchedRequest = this.m_locator.locateMatchingRequest((MobileMsgResponse)badResponse);
        Assert.assertNull((Object)matchedRequest);
        this.m_locator.requestTimedOut((MobileMsgRequest)request);
        SmsResponse goodResponse = this.createResponse("+19195552121", "+19195551212", "pong");
        matchedRequest = this.m_locator.locateMatchingRequest((MobileMsgResponse)goodResponse);
        Assert.assertNull((Object)matchedRequest);
    }
}

