/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice.internal;

import org.opennms.core.utils.ThreadCategory;
import org.opennms.sms.reflector.smsservice.GatewayGroup;
import org.opennms.sms.reflector.smsservice.OnmsInboundMessageNotification;
import org.opennms.sms.reflector.smsservice.SmsService;
import org.opennms.sms.reflector.smsservice.internal.SmsServiceImpl;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.IGatewayStatusNotification;
import org.smslib.IOutboundMessageNotification;
import org.smslib.Service;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmsServiceListFactoryBean
implements FactoryBean<SmsService[]>,
InitializingBean {
    private GatewayGroup[] m_gatewayGroups;
    private SmsService[] m_services;
    private IOutboundMessageNotification m_outboundMessageNotification;
    private OnmsInboundMessageNotification m_inboundMessageNotification;
    private IGatewayStatusNotification m_gatewayStatusNotification;

    public void setOutboundMessageNotification(IOutboundMessageNotification mOutboundMessageNotification) {
        this.m_outboundMessageNotification = mOutboundMessageNotification;
    }

    public void setInboundMessageNotification(OnmsInboundMessageNotification mInboundMessageNotification) {
        this.m_inboundMessageNotification = mInboundMessageNotification;
    }

    public void setGatewayStatusNotification(IGatewayStatusNotification mGatewayStatusNotification) {
        this.m_gatewayStatusNotification = mGatewayStatusNotification;
    }

    public void setGatewayGroupList(GatewayGroup[] groupList) {
        this.m_gatewayGroups = groupList;
    }

    public void afterPropertiesSet() {
        this.m_services = new SmsService[this.m_gatewayGroups.length];
        int count = 0;
        for (GatewayGroup group : this.m_gatewayGroups) {
            AGateway[] gateways = group.getGateways();
            if (gateways.length == 0) {
                this.log().warn("A Gateway group was registered with ZERO gateways!");
                return;
            }
            SmsServiceImpl smsService = new SmsServiceImpl();
            smsService.setOutboundNotification(this.m_outboundMessageNotification);
            smsService.setInboundNotification(this.m_inboundMessageNotification);
            for (int i = 0; i < gateways.length; ++i) {
                try {
                    if (smsService.getServiceStatus() == Service.ServiceStatus.STARTED) {
                        smsService.stop();
                    }
                    smsService.addGateway(gateways[i]);
                    continue;
                }
                catch (GatewayException e) {
                    e.printStackTrace();
                }
            }
            smsService.start();
            this.m_services[count++] = smsService;
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public SmsService[] getObject() throws Exception {
        return this.m_services;
    }

    public Class<? extends SmsService[]> getObjectType() {
        return SmsService[].class;
    }

    public boolean isSingleton() {
        return true;
    }
}

