/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice.internal;

import java.util.Collection;
import java.util.List;
import org.opennms.sms.reflector.smsservice.OnmsInboundMessageNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smslib.AGateway;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InboundMessageNotification
implements OnmsInboundMessageNotification {
    private static Logger log = LoggerFactory.getLogger(InboundMessageNotification.class);
    private Collection<OnmsInboundMessageNotification> m_listenerList;
    private ApplicationContext m_applicationContext;

    public InboundMessageNotification() {
    }

    public InboundMessageNotification(List<OnmsInboundMessageNotification> listeners) {
        this.m_listenerList = listeners;
    }

    public Collection<OnmsInboundMessageNotification> getListeners() {
        return this.m_listenerList;
    }

    @Override
    public void process(AGateway gateway, Message.MessageTypes msgType, InboundMessage msg) {
        this.deleteMessage(gateway, msg);
        for (OnmsInboundMessageNotification listener : this.getListeners()) {
            if (listener == this) continue;
            this.notifyListener(gateway, msgType, msg, listener);
        }
    }

    private void notifyListener(AGateway gateway, Message.MessageTypes msgType, InboundMessage msg, OnmsInboundMessageNotification listener) {
        try {
            listener.process(gateway, msgType, msg);
        }
        catch (Throwable e) {
            log.error("Unexpected exception processing InboundMessage " + msg + " listener: " + listener, e);
        }
    }

    private void deleteMessage(AGateway gateway, InboundMessage msg) {
        try {
            gateway.deleteMessage(msg);
        }
        catch (Exception e) {
            log.error("Unable to delete message " + msg, (Throwable)e);
        }
    }

    public void setListenerList(List<OnmsInboundMessageNotification> listeners) {
        this.m_listenerList = listeners;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.m_applicationContext = applicationContext;
    }
}

