package org.opennms.sms.reflector.smsservice;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.ICallNotification;
import org.smslib.IGatewayStatusNotification;
import org.smslib.IOutboundMessageNotification;
import org.smslib.IQueueSendingNotification;
import org.smslib.IUSSDNotification;
import org.smslib.InboundMessage;
import org.smslib.OutboundMessage;
import org.smslib.Phonebook;
import org.smslib.SMSLibException;
import org.smslib.Settings;
import org.smslib.TimeoutException;
import org.smslib.USSDRequest;
import org.smslib.InboundMessage.MessageClasses;
import org.smslib.Service.ServiceStatus;
import org.smslib.balancing.LoadBalancer;
import org.smslib.crypto.KeyManager;
import org.smslib.queues.QueueManager;
import org.smslib.routing.Router;

public interface SmsService {

	void addGateway(AGateway gateway) throws GatewayException;
	boolean removeGateway(AGateway gateway) throws GatewayException;
	void startService() throws SMSLibException, TimeoutException, GatewayException, IOException, InterruptedException;
	void stopService() throws TimeoutException, GatewayException, IOException, InterruptedException;
	int readMessages(Collection<InboundMessage> msgList, MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException;
	InboundMessage[] readMessages(MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException;
	int readMessages(Collection<InboundMessage> msgList, MessageClasses msgClass, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException;
	InboundMessage[] readMessages(MessageClasses msgClass, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException;
	int readMessages(Collection<InboundMessage> msgList, MessageClasses msgClass, AGateway gateway) throws TimeoutException, GatewayException, IOException, InterruptedException;
	InboundMessage[] readMessages(MessageClasses msgClass, AGateway gateway) throws TimeoutException, GatewayException, IOException, InterruptedException;
	InboundMessage readMessage(String gatewayId, String memLoc, int memIndex) throws TimeoutException, GatewayException, IOException, InterruptedException;
	boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException;
	boolean sendMessage(OutboundMessage msg, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException;
	int sendMessages(Collection<OutboundMessage> msgList) throws TimeoutException, GatewayException, IOException, InterruptedException;
	int sendMessages(OutboundMessage[] msgArray) throws TimeoutException, GatewayException, IOException, InterruptedException;
	int sendMessages(Collection<OutboundMessage> msgList, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException;
	int sendMessages(OutboundMessage[] msgArray, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException;
	boolean queueMessage(OutboundMessage msg);
	boolean queueMessage(OutboundMessage msg, String gatewayId);
	int queueMessages(Collection<OutboundMessage> msgList);
	int queueMessages(OutboundMessage[] msgArray);
	int queueMessages(Collection<OutboundMessage> msgList, String gatewayId);
	int queueMessages(OutboundMessage[] msgArray, String gatewayId);
	boolean removeMessage(OutboundMessage msg);
	boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException;
	int readPhonebook(Phonebook phonebook, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException;
	int getInboundMessageCount(String gatewayId);
	int getInboundMessageCount(AGateway gateway);
	int getOutboundMessageCount(String gatewayId);
	int getOutboundMessageCount(AGateway gateway);
	int getInboundMessageCount();
	int getOutboundMessageCount();
	AGateway findGateway(String gatewayId);
	Collection<AGateway> getGateways();
	AGateway[] getGatewaysNET();
	LoadBalancer getLoadBalancer();
	void setLoadBalancer(LoadBalancer loadBalancer);
	Router getRouter();
	void setRouter(Router router);
	OnmsInboundMessageNotification getInboundNotification();
	void setInboundNotification(OnmsInboundMessageNotification inboundNotification);
	IOutboundMessageNotification getOutboundNotification();
	void setOutboundNotification(IOutboundMessageNotification outboundNotification);
	ICallNotification getCallNotification();
	void setCallNotification(ICallNotification callNotification);
	IGatewayStatusNotification getGatewayStatusNotification();
	void setGatewayStatusNotification(IGatewayStatusNotification gatewayStatusNotification);
	IQueueSendingNotification getQueueSendingNotification();
	void setQueueSendingNotification(IQueueSendingNotification queueSendingNotification);
	long getStartMillis();
	ServiceStatus getServiceStatus();
	Settings getSettings();
	boolean createGroup(String groupName);
	boolean removeGroup(String groupName);
	ArrayList<String> expandGroup(String groupName);
	boolean addToGroup(String groupName, String number);
	boolean removeFromGroup(String groupName, String number);
	QueueManager getQueueManager();
	KeyManager getKeyManager();
	boolean sendUSSDRequest(USSDRequest req, String gatewayId) throws GatewayException, TimeoutException, IOException, InterruptedException;
	void setUSSDNotification(IUSSDNotification notif);
	IUSSDNotification getUSSDNotification();
}
