/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice.internal;

import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smslib.IUSSDNotification;
import org.smslib.USSDResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UssdNotificationDispatcher
implements IUSSDNotification {
    private static Logger log = LoggerFactory.getLogger(UssdNotificationDispatcher.class);
    private Collection<IUSSDNotification> m_listenerList;

    public UssdNotificationDispatcher() {
    }

    public UssdNotificationDispatcher(List<IUSSDNotification> listeners) {
        this.m_listenerList = listeners;
    }

    public void process(String gatewayId, USSDResponse msg) {
        log.debug("Forwarding message to registered listeners: " + this.getListeners() + " : " + msg);
        for (IUSSDNotification listener : this.getListeners()) {
            if (listener == this) continue;
            listener.process(gatewayId, msg);
        }
    }

    private Collection<IUSSDNotification> getListeners() {
        return this.m_listenerList;
    }

    public void setListenerList(List<IUSSDNotification> list) {
        this.m_listenerList = list;
    }
}

