/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice.internal;

import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smslib.IOutboundMessageNotification;
import org.smslib.OutboundMessage;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutboundMessageNotification
implements IOutboundMessageNotification,
ApplicationContextAware {
    private static Logger log = LoggerFactory.getLogger(OutboundMessageNotification.class);
    private Collection<IOutboundMessageNotification> m_listenerList;
    private ApplicationContext m_applicationContext;

    public OutboundMessageNotification() {
    }

    public OutboundMessageNotification(List<IOutboundMessageNotification> listeners) {
        this.m_listenerList = listeners;
    }

    public void process(String gatewayId, OutboundMessage msg) {
        log.debug("Forwarding message to registered listeners: " + this.getListeners() + " : " + msg);
        for (IOutboundMessageNotification listener : this.getListeners()) {
            if (listener == this) continue;
            listener.process(gatewayId, msg);
        }
    }

    private Collection<IOutboundMessageNotification> getListeners() {
        if (this.m_listenerList == null) {
            this.m_listenerList = this.m_applicationContext.getBeansOfType(IOutboundMessageNotification.class).values();
        }
        return this.m_listenerList;
    }

    public void setListenerList(List<IOutboundMessageNotification> list) {
        this.m_listenerList = list;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.m_applicationContext = applicationContext;
    }
}

