/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice.internal;

import java.util.HashMap;
import java.util.Map;
import org.opennms.core.soa.Registration;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.sms.reflector.smsservice.SmsService;
import org.opennms.sms.reflector.smsservice.internal.SmsServiceRegistrar;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class OnmsSmsServiceRegistrar
implements SmsServiceRegistrar,
InitializingBean {
    private ServiceRegistry m_serviceRegistry;
    private Map<SmsService, Registration> m_registrationMap = new HashMap<SmsService, Registration>();

    public void registerSmsService(SmsService service) {
        Registration registration = this.getServiceRegistry().register((Object)service, new Class[]{SmsService.class});
        this.m_registrationMap.put(service, registration);
    }

    public void unregisterSmsService(SmsService service) {
        Registration registration = this.m_registrationMap.remove(service);
        if (registration != null) {
            registration.unregister();
        }
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.m_serviceRegistry = serviceRegistry;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.m_serviceRegistry;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_serviceRegistry);
    }
}

