/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice.internal;

import java.util.Collection;
import java.util.List;
import org.smslib.AGateway;
import org.smslib.IGatewayStatusNotification;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatewayStatusNotification
implements IGatewayStatusNotification,
ApplicationContextAware {
    private Collection<IGatewayStatusNotification> m_listenerList;
    private ApplicationContext m_applicationContext;

    public GatewayStatusNotification() {
    }

    public GatewayStatusNotification(List<IGatewayStatusNotification> listeners) {
        this.m_listenerList = listeners;
    }

    public void process(String gtwId, AGateway.GatewayStatuses oldStatus, AGateway.GatewayStatuses newStatus) {
        for (IGatewayStatusNotification listener : this.getListeners()) {
            if (listener == this) continue;
            listener.process(gtwId, oldStatus, newStatus);
        }
    }

    private Collection<IGatewayStatusNotification> getListeners() {
        if (this.m_listenerList == null) {
            this.m_listenerList = this.m_applicationContext.getBeansOfType(IGatewayStatusNotification.class).values();
        }
        return this.m_listenerList;
    }

    public void setListenerList(List<IGatewayStatusNotification> list) {
        this.m_listenerList = list;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.m_applicationContext = applicationContext;
    }
}

