/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.opennms.protocols.rt.Request;
import org.opennms.sms.reflector.smsservice.MobileMsgResponse;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseCallback;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MobileMsgRequest
implements Request<String, MobileMsgRequest, MobileMsgResponse> {
    private long m_timeout;
    private int m_retries;
    private MobileMsgResponseCallback m_cb;
    private MobileMsgResponseMatcher m_responseMatcher;
    private long m_expiration;
    private long m_sentTime;
    private volatile boolean m_processed = false;

    public MobileMsgRequest(long timeout, int retries, MobileMsgResponseCallback cb, MobileMsgResponseMatcher responseMatcher) {
        this.m_timeout = timeout;
        this.m_retries = retries;
        this.m_cb = cb;
        this.m_responseMatcher = responseMatcher;
    }

    public long getSentTime() {
        return this.m_sentTime;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(long timeout) {
        this.m_timeout = timeout;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public void setRetries(int retries) {
        this.m_retries = retries;
    }

    public MobileMsgResponseCallback getCb() {
        return this.m_cb;
    }

    public void setCb(MobileMsgResponseCallback cb) {
        this.m_cb = cb;
    }

    public MobileMsgResponseMatcher getResponseMatcher() {
        return this.m_responseMatcher;
    }

    public void setResponseMatcher(MobileMsgResponseMatcher responseMatcher) {
        this.m_responseMatcher = responseMatcher;
    }

    public void setSendTimestamp(long timeInMillis) {
        this.m_sentTime = timeInMillis;
        this.m_expiration = timeInMillis + this.m_timeout;
    }

    public long getDelay(TimeUnit unit) {
        return unit.convert(this.m_expiration - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public abstract String getId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processError(Throwable t) {
        try {
            this.m_cb.handleError(this, t);
        }
        finally {
            this.m_processed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processResponse(MobileMsgResponse response) {
        try {
            response.setRequest(this);
            boolean bl = this.m_cb.handleResponse(this, response);
            return bl;
        }
        finally {
            this.m_processed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MobileMsgRequest processTimeout() {
        try {
            MobileMsgRequest retry = this.createNextRetry();
            if (retry == null) {
                this.m_cb.handleTimeout(this);
            }
            MobileMsgRequest mobileMsgRequest = retry;
            return mobileMsgRequest;
        }
        finally {
            this.m_processed = true;
        }
    }

    public abstract MobileMsgRequest createNextRetry();

    public int compareTo(Delayed o) {
        long anotherVal;
        long thisVal = this.getDelay(TimeUnit.NANOSECONDS);
        return thisVal < (anotherVal = o.getDelay(TimeUnit.NANOSECONDS)) ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public boolean matches(MobileMsgResponse response) {
        return this.m_responseMatcher.matches(this, response);
    }

    public boolean isProcessed() {
        return this.m_processed;
    }
}

