/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice;

import org.opennms.sms.reflector.smsservice.MobileMsgRequest;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseCallback;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseMatcher;
import org.smslib.OutboundMessage;
import org.springframework.core.style.ToStringCreator;

public class SmsRequest
extends MobileMsgRequest {
    private OutboundMessage m_msg;

    public SmsRequest(OutboundMessage msg, long timeout, int retries, MobileMsgResponseCallback cb, MobileMsgResponseMatcher responseMatcher) {
        super(timeout, retries, cb, responseMatcher);
        this.m_msg = msg;
    }

    public int getValidityPeriodInHours() {
        return this.m_msg.getValidityPeriod();
    }

    public void setValidityPeriodInHours(int validityPeriod) {
        this.m_msg.setValidityPeriod(validityPeriod);
    }

    public String getOriginator() {
        return this.m_msg.getFrom();
    }

    public void setOriginator(String originator) {
        this.m_msg.setFrom(originator);
    }

    public String getRecipient() {
        return this.m_msg.getRecipient();
    }

    public void setRecipient(String recipient) {
        this.m_msg.setRecipient(recipient);
    }

    public String getText() {
        return this.m_msg.getText();
    }

    @Override
    public String getId() {
        return this.m_msg.getRecipient();
    }

    @Override
    public MobileMsgRequest createNextRetry() {
        if (this.getRetries() > 0) {
            return new SmsRequest(this.m_msg, this.getTimeout(), this.getRetries() - 1, this.getCb(), this.getResponseMatcher());
        }
        return null;
    }

    public OutboundMessage getMessage() {
        return this.m_msg;
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this).append("recipient", (Object)this.getRecipient()).append("text", (Object)this.getText()).toString();
    }
}

