/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice;

import java.util.Date;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.tasks.Callback;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.protocols.rt.Messenger;
import org.opennms.sms.reflector.smsservice.MobileMsgRequest;
import org.opennms.sms.reflector.smsservice.MobileMsgResponse;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseCallback;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseMatcher;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseMatchers;
import org.opennms.sms.reflector.smsservice.MobileMsgTrackerImpl;
import org.opennms.sms.reflector.smsservice.PingResponseMatcher;
import org.opennms.sms.reflector.smsservice.SmsResponse;
import org.opennms.sms.reflector.smsservice.UssdResponse;
import org.smslib.InboundMessage;
import org.smslib.OutboundMessage;
import org.smslib.USSDDcs;
import org.smslib.USSDRequest;
import org.smslib.USSDResponse;
import org.smslib.USSDSessionStatus;

public class MobileMsgTrackerTest {
    private static final String PHONE_NUMBER = "+19195551212";
    public static final String TMOBILE_RESPONSE = "37.28 received on 08/31/09. For continued service through 10/28/09, please pay 79.56 by 09/28/09.    ";
    public static final String TMOBILE_USSD_MATCH = "^.*[\\d\\.]+ received on \\d\\d/\\d\\d/\\d\\d. For continued service through \\d\\d/\\d\\d/\\d\\d, please pay [\\d\\.]+ by \\d\\d/\\d\\d/\\d\\d.*$";
    TestMessenger m_messenger;
    MobileMsgTrackerImpl m_tracker;
    DefaultTaskCoordinator m_coordinator;
    private Properties m_session;

    @Before
    public void setUp() throws Exception {
        this.m_messenger = new TestMessenger();
        this.m_tracker = new MobileMsgTrackerImpl("test", (Messenger)this.m_messenger);
        this.m_tracker.start();
        this.m_session = new Properties();
        this.m_coordinator = new DefaultTaskCoordinator("MobileMsgTrackerTest", (Executor)Executors.newSingleThreadExecutor((ThreadFactory)new LogPreservingThreadFactory("MobileMsgTrackerTest", 1, false)));
        System.err.println("=== STARTING TEST ===");
    }

    @Test
    public void testResponseButNotTimeout() throws Exception {
        long timeout = 1000L;
        OutboundMessage msg = new OutboundMessage("+19195552121", "ping");
        TestCallback cb = new TestCallback();
        this.m_tracker.sendSmsRequest(msg, timeout, 0, (MobileMsgResponseCallback)cb, (MobileMsgResponseMatcher)new PingResponseMatcher());
        InboundMessage responseMsg = this.createInboundMessage("+19195552121", "pong");
        this.m_messenger.sendTestResponse(responseMsg);
        Assert.assertSame((Object)responseMsg, (Object)cb.getMessage());
        Assert.assertEquals((Object)"handleResponse", (Object)cb.getCalledMethods());
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Expect no 'handleTimeout' since response was received", (Object)"handleResponse", (Object)cb.getCalledMethods());
    }

    @Test
    public void testPing() throws Exception {
        OutboundMessage msg = new OutboundMessage("+19195552121", "ping");
        OutboundMessage msg2 = new OutboundMessage("+19195553131", "ping");
        TestCallback cb = new TestCallback();
        TestCallback cb2 = new TestCallback();
        this.m_tracker.sendSmsRequest(msg, 60000L, 0, (MobileMsgResponseCallback)cb, (MobileMsgResponseMatcher)new PingResponseMatcher());
        this.m_tracker.sendSmsRequest(msg2, 60000L, 0, (MobileMsgResponseCallback)cb2, (MobileMsgResponseMatcher)new PingResponseMatcher());
        InboundMessage responseMsg = this.createInboundMessage("+19195552121", "pong");
        InboundMessage responseMsg2 = this.createInboundMessage("+19195553131", "pong");
        this.m_messenger.sendTestResponse(responseMsg);
        this.m_messenger.sendTestResponse(responseMsg2);
        Assert.assertSame((Object)responseMsg, (Object)cb.getMessage());
        Assert.assertSame((Object)responseMsg2, (Object)cb2.getMessage());
    }

    @Test
    public void testTMobileGetBalance() throws Exception {
        String gatewayId = "G";
        TestCallback cb = new TestCallback();
        USSDRequest request = new USSDRequest("#225#");
        this.m_tracker.sendUssdRequest(request, 10000L, 0, (MobileMsgResponseCallback)cb, MobileMsgResponseMatchers.and((MobileMsgResponseMatcher[])new MobileMsgResponseMatcher[]{MobileMsgResponseMatchers.isUssd(), MobileMsgResponseMatchers.textMatches((String)TMOBILE_USSD_MATCH)}));
        USSDResponse response = this.sendTmobileUssdResponse(gatewayId);
        Assert.assertSame((Object)response, (Object)cb.getUSSDResponse());
    }

    private USSDResponse sendTmobileUssdResponse(String gatewayId) {
        USSDResponse response = new USSDResponse();
        response.setContent(TMOBILE_RESPONSE);
        response.setUSSDSessionStatus(USSDSessionStatus.NO_FURTHER_ACTION_REQUIRED);
        response.setDcs(USSDDcs.UNSPECIFIED_7BIT);
        this.m_messenger.sendTestResponse(gatewayId, response);
        return response;
    }

    private InboundMessage createInboundMessage(String originator, String text) {
        InboundMessage msg = new InboundMessage(new Date(), originator, text, 0, "0");
        return msg;
    }

    public static class TestCallback
    implements MobileMsgResponseCallback {
        AtomicReference<String> m_calledMethods = new AtomicReference();
        CountDownLatch m_latch = new CountDownLatch(1);
        AtomicReference<MobileMsgResponse> m_response = new AtomicReference<Object>(null);

        MobileMsgResponse getResponse() throws InterruptedException {
            this.m_latch.await();
            return this.m_response.get();
        }

        String getCalledMethods() {
            return this.m_calledMethods.get();
        }

        private void methodCalled(String methodName) {
            String newVal;
            String prevVal;
            while (!this.m_calledMethods.compareAndSet(prevVal, newVal = (prevVal = this.m_calledMethods.get()) == null ? methodName : prevVal + " " + methodName)) {
            }
        }

        public void handleError(MobileMsgRequest request, Throwable t) {
            this.methodCalled("handleError");
            System.err.println("Error processing SmsRequest: " + request);
            this.m_latch.countDown();
        }

        public boolean handleResponse(MobileMsgRequest request, MobileMsgResponse response) {
            this.methodCalled("handleResponse");
            this.m_response.set(response);
            this.m_latch.countDown();
            return true;
        }

        public void handleTimeout(MobileMsgRequest request) {
            this.methodCalled("handleTimeout");
            System.err.println("Timeout waiting for SmsRequest: " + request);
            this.m_latch.countDown();
        }

        public InboundMessage getMessage() throws InterruptedException {
            MobileMsgResponse response = this.getResponse();
            if (response instanceof SmsResponse) {
                return ((SmsResponse)response).getMessage();
            }
            return null;
        }

        public USSDResponse getUSSDResponse() throws InterruptedException {
            MobileMsgResponse response = this.getResponse();
            if (response instanceof UssdResponse) {
                return ((UssdResponse)response).getMessage();
            }
            return null;
        }
    }

    public class TestMessenger
    implements Messenger<MobileMsgRequest, MobileMsgResponse> {
        Queue<MobileMsgResponse> m_q;

        public void sendRequest(MobileMsgRequest request) throws Exception {
            request.setSendTimestamp(System.currentTimeMillis());
        }

        public void start(Queue<MobileMsgResponse> q) {
            this.m_q = q;
        }

        public void sendTestResponse(MobileMsgResponse response) {
            this.m_q.offer(response);
        }

        public void sendTestResponse(InboundMessage msg) {
            this.sendTestResponse((MobileMsgResponse)new SmsResponse(msg, System.currentTimeMillis()));
        }

        public void sendTestResponse(String gatewayId, USSDResponse response) {
            this.sendTestResponse((MobileMsgResponse)new UssdResponse(gatewayId, response, System.currentTimeMillis()));
        }
    }

    private final class LatencyCallback
    implements Callback<MobileMsgResponse> {
        private final AtomicLong m_start = new AtomicLong();
        private final AtomicLong m_end = new AtomicLong();

        private LatencyCallback(long startTime) {
            this.m_start.set(startTime);
        }

        public void complete(MobileMsgResponse t) {
            if (t != null) {
                this.m_end.set(System.currentTimeMillis());
            }
        }

        public void handleException(Throwable t) {
        }

        public Long getLatency() {
            if (this.m_end.get() == 0L) {
                return null;
            }
            return this.m_end.get() - this.m_start.get();
        }
    }
}

