/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice.internal;

import java.util.Map;
import org.opennms.core.utils.LogUtils;
import org.smslib.AGateway;
import org.smslib.Service;

public class GatewayListener {
    private Service m_service;

    public void setService(Service service) {
        this.m_service = service;
    }

    public void addGateway(AGateway gateway, Map<?, ?> properties) {
        if (this.m_service != null) {
            try {
                if (this.m_service.getServiceStatus() == Service.ServiceStatus.STARTED) {
                    this.m_service.stopService();
                }
                this.m_service.addGateway(gateway);
                this.m_service.startService();
            }
            catch (Exception e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to add gateway (%s) to SMS service", (Object[])new Object[]{gateway});
            }
        }
    }

    public void removeGateway(AGateway gateway, Map<?, ?> properties) {
        if (this.m_service != null) {
            try {
                if (this.m_service.getServiceStatus() == Service.ServiceStatus.STARTED) {
                    this.m_service.stopService();
                }
                this.m_service.removeGateway(gateway);
                this.m_service.startService();
            }
            catch (Exception e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to remove gateway (%s) from SMS service", (Object[])new Object[]{gateway});
            }
        }
    }

    public void bind(Object arg0, Map<?, ?> arg1) throws Exception {
    }

    public void unbind(Object arg0, Map<?, ?> arg1) throws Exception {
    }
}

