/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice.internal;

import java.io.IOException;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.opennms.protocols.rt.Messenger;
import org.opennms.sms.reflector.smsservice.MobileMsgRequest;
import org.opennms.sms.reflector.smsservice.MobileMsgResponse;
import org.opennms.sms.reflector.smsservice.OnmsInboundMessageNotification;
import org.opennms.sms.reflector.smsservice.SmsRequest;
import org.opennms.sms.reflector.smsservice.SmsResponse;
import org.opennms.sms.reflector.smsservice.SmsService;
import org.opennms.sms.reflector.smsservice.UssdRequest;
import org.opennms.sms.reflector.smsservice.UssdResponse;
import org.smslib.AGateway;
import org.smslib.IUSSDNotification;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.smslib.USSDResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class SmsMessenger
implements Messenger<MobileMsgRequest, MobileMsgResponse>,
OnmsInboundMessageNotification,
IUSSDNotification,
InitializingBean {
    Logger log = Logger.getLogger(this.getClass());
    private SmsService m_smsService;
    private Queue<MobileMsgResponse> m_replyQueue;

    public void setSmsService(SmsService smsService) {
        this.m_smsService = smsService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_smsService, (String)"the smsService must not be null");
    }

    public void sendRequest(MobileMsgRequest request) throws Exception {
        request.setSendTimestamp(System.currentTimeMillis());
        if (request instanceof SmsRequest) {
            SmsRequest smsRequest = (SmsRequest)request;
            this.debugf("SmsMessenger.send sms message %s", smsRequest);
            if (!this.m_smsService.sendMessage(smsRequest.getMessage())) {
                throw new IOException("Failed to send sms message");
            }
        } else if (request instanceof UssdRequest) {
            UssdRequest ussdRequest = (UssdRequest)request;
            this.debugf("SmsMessenger.send ussd message %s", ussdRequest);
            if (!this.m_smsService.sendUSSDRequest(ussdRequest.getMessage(), ussdRequest.getGatewayId())) {
                throw new IOException("Unable to send ussd message");
            }
        } else {
            throw new IOException("Unrecognized type of request: " + request);
        }
    }

    public void start(Queue<MobileMsgResponse> replyQueue) {
        this.debugf("SmsMessenger.start", new Object[0]);
        this.m_replyQueue = replyQueue;
    }

    @Override
    public void process(AGateway gateway, Message.MessageTypes msgType, InboundMessage msg) {
        long receiveTime = System.currentTimeMillis();
        this.debugf("SmsMessenger.processInboundMessage", new Object[0]);
        if (this.m_replyQueue != null) {
            this.m_replyQueue.add(new SmsResponse(msg, receiveTime));
        }
    }

    public void process(String gatewayId, USSDResponse ussdResponse) {
        long receiveTime = System.currentTimeMillis();
        this.debugf("SmsMessenger.processUSSDResponse", new Object[0]);
        if (this.m_replyQueue != null) {
            this.m_replyQueue.add(new UssdResponse(gatewayId, ussdResponse, receiveTime));
        }
    }

    private void debugf(String fmt, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format(fmt, args));
        }
    }
}

