/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opennms.protocols.rt.RequestLocator;
import org.opennms.sms.reflector.smsservice.MobileMsgRequest;
import org.opennms.sms.reflector.smsservice.MobileMsgResponse;

public class MatchingRequestLocator
implements RequestLocator<MobileMsgRequest, MobileMsgResponse> {
    private final Set<MobileMsgRequest> m_requests = new CopyOnWriteArraySet<MobileMsgRequest>();

    public boolean trackRequest(MobileMsgRequest request) {
        this.m_requests.add(request);
        return true;
    }

    public MobileMsgRequest locateMatchingRequest(MobileMsgResponse response) {
        for (MobileMsgRequest request : this.m_requests) {
            if (!request.matches(response)) continue;
            return request;
        }
        return null;
    }

    public MobileMsgRequest requestTimedOut(MobileMsgRequest timedOutRequest) {
        return this.m_requests.remove(timedOutRequest) ? timedOutRequest : null;
    }

    public void requestComplete(MobileMsgRequest request) {
        this.m_requests.remove(request);
    }
}

