/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.ping.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.opennms.sms.ping.PingResponseCallback;
import org.opennms.sms.ping.internal.PingRequest;
import org.smslib.Message;

public class SinglePingResponseCallback
implements PingResponseCallback {
    private CountDownLatch bs = new CountDownLatch(1);
    private Throwable error = null;
    private Long responseTime = null;
    private String m_phoneNumber;

    public SinglePingResponseCallback(String phoneNumber) {
        this.m_phoneNumber = phoneNumber;
    }

    @Override
    public void handleResponse(PingRequest request, Message packet) {
        this.info("got response for request " + request + ", message = " + packet);
        this.responseTime = request.getRoundTripTime();
        this.bs.countDown();
    }

    private Logger log() {
        return Logger.getLogger(this.getClass());
    }

    @Override
    public void handleTimeout(PingRequest request, Message packet) {
        this.info("timed out pinging request " + request + ", message = " + packet);
        this.bs.countDown();
    }

    @Override
    public void handleError(PingRequest request, Message pr, Throwable t) {
        this.info("an error occurred pinging " + request, t);
        this.error = t;
        this.bs.countDown();
    }

    public void waitFor(long timeout) throws InterruptedException {
        this.bs.await(timeout, TimeUnit.MILLISECONDS);
    }

    public void waitFor() throws InterruptedException {
        this.info("waiting for ping to " + this.m_phoneNumber + " to finish");
        this.bs.await();
        this.info("finished waiting for ping to " + this.m_phoneNumber + " to finish");
    }

    public Long getResponseTime() {
        return this.responseTime;
    }

    public void info(String msg) {
        this.log().info((Object)msg);
    }

    public void info(String msg, Throwable t) {
        this.log().info((Object)msg, t);
    }
}

