/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.ping.internal;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.opennms.protocols.rt.Request;
import org.opennms.sms.ping.PingRequestId;
import org.opennms.sms.ping.PingResponseCallback;
import org.opennms.sms.ping.internal.PingReply;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.smslib.OutboundMessage;

public final class PingRequest
implements Request<PingRequestId, PingRequest, PingReply> {
    private PingRequestId m_id;
    private OutboundMessage m_request = null;
    private InboundMessage m_response = null;
    private PingResponseCallback m_callback = null;
    private int m_retries;
    private long m_timeout;
    private long m_expiration = -1L;
    private Logger m_log;
    private Long m_sentTimestamp;
    private Long m_responseTimestamp;
    private volatile boolean m_processed = false;

    PingRequest(PingRequestId id, long timeout, int retries, Logger logger, PingResponseCallback cb) {
        this.m_id = id;
        this.m_retries = retries;
        this.m_timeout = timeout;
        this.m_log = logger;
        this.m_callback = cb;
        this.m_expiration = System.currentTimeMillis() + timeout;
        this.m_request = new OutboundMessage(id.getDestination(), "ping");
        this.m_request.setSrcPort(6996);
        this.m_request.setValidityPeriod(1);
    }

    public PingRequest(PingRequestId id, long timeout, int retries, PingResponseCallback cb) {
        this(id, timeout, retries, Logger.getLogger(PingRequest.class), cb);
    }

    public PingRequestId getId() {
        return this.m_id;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public OutboundMessage getRequest() {
        return this.m_request;
    }

    public InboundMessage getResponse() {
        return this.m_response;
    }

    public long getExpiration() {
        return this.m_expiration;
    }

    private Logger log() {
        return this.m_log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processResponse(PingReply reply) {
        try {
            this.setResponseTimestamp(reply.getReceiveTimestamp());
            this.processResponse(reply.getPacket());
            boolean bl = true;
            return bl;
        }
        finally {
            this.m_processed = true;
        }
    }

    private void processResponse(InboundMessage packet) {
        this.m_response = packet;
        this.log().debug((Object)(System.currentTimeMillis() + ": Ping Response Received " + this));
        this.m_callback.handleResponse(this, (Message)packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PingRequest processTimeout() {
        try {
            PingRequest returnval = null;
            if (this.isExpired()) {
                if (this.getRetries() > 0) {
                    returnval = new PingRequest(this.getId(), this.getTimeout(), this.getRetries() - 1, this.log(), this.m_callback);
                    this.log().debug((Object)(System.currentTimeMillis() + ": Retrying Ping Request " + returnval));
                } else {
                    this.log().debug((Object)(System.currentTimeMillis() + ": Ping Request Timed out " + this));
                    this.m_callback.handleTimeout(this, (Message)this.getRequest());
                }
            }
            PingRequest pingRequest = returnval;
            return pingRequest;
        }
        finally {
            this.m_processed = true;
        }
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.getExpiration();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append("ID=").append(this.getId()).append(',');
        sb.append("Retries=").append(this.getRetries()).append(",");
        sb.append("Timeout=").append(this.getTimeout()).append(",");
        sb.append("Expiration=").append(this.getExpiration()).append(',');
        sb.append("Callback=").append(this.m_callback).append(',');
        sb.append("Request=").append(this.m_request);
        sb.append("]");
        return sb.toString();
    }

    public long getDelay(TimeUnit unit) {
        return unit.convert(this.getExpiration() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public int compareTo(Delayed request) {
        long otherDelay;
        long myDelay = this.getDelay(TimeUnit.MILLISECONDS);
        if (myDelay < (otherDelay = request.getDelay(TimeUnit.MILLISECONDS))) {
            return -1;
        }
        if (myDelay == otherDelay) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processError(Throwable t) {
        try {
            this.m_callback.handleError(this, (Message)this.getRequest(), t);
        }
        finally {
            this.m_processed = true;
        }
    }

    public void setSentTimestamp(Long millis) {
        this.m_sentTimestamp = millis;
    }

    public void setResponseTimestamp(Long millis) {
        this.m_responseTimestamp = millis;
    }

    public long getRoundTripTime() {
        return this.m_responseTimestamp - this.m_sentTimestamp;
    }

    public boolean isProcessed() {
        return this.m_processed;
    }
}

