/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor.internal.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.sms.monitor.MobileSequenceSession;
import org.opennms.sms.monitor.internal.config.MobileSequenceOperation;
import org.opennms.sms.monitor.internal.config.MobileSequenceTransaction;
import org.opennms.sms.monitor.internal.config.SequenceResponseMatcher;
import org.opennms.sms.reflector.smsservice.MobileMsgRequest;
import org.opennms.sms.reflector.smsservice.MobileMsgResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MobileSequenceResponse
extends MobileSequenceOperation {
    private List<SequenceResponseMatcher> m_matchers = Collections.synchronizedList(new ArrayList());
    private MobileSequenceTransaction m_transaction;

    public MobileSequenceResponse() {
    }

    public MobileSequenceResponse(String label) {
        super(label);
    }

    public MobileSequenceResponse(String gatewayId, String label) {
        super(gatewayId, label);
    }

    @XmlElementRef
    public List<SequenceResponseMatcher> getMatchers() {
        return this.m_matchers;
    }

    public void setMatchers(List<SequenceResponseMatcher> matchers) {
        this.m_matchers.clear();
        this.m_matchers.addAll(matchers);
    }

    public void addMatcher(SequenceResponseMatcher matcher) {
        this.m_matchers.add(matcher);
    }

    public String getEffectiveLabel(MobileSequenceSession session) {
        return this.getLabel() != null ? session.substitute(this.getLabel()) : this.getTransaction().getResponseLabel(session, this);
    }

    @XmlTransient
    public MobileSequenceTransaction getTransaction() {
        return this.m_transaction;
    }

    public void setTransaction(MobileSequenceTransaction transaction) {
        this.m_transaction = transaction;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("gatewayId", (Object)this.getGatewayId()).append("label", (Object)this.getLabel()).append("matchers", this.getMatchers()).toString();
    }

    protected abstract boolean matchesResponseType(MobileMsgRequest var1, MobileMsgResponse var2);

    private boolean matchesCriteria(MobileSequenceSession session, MobileMsgRequest request, MobileMsgResponse response) {
        for (SequenceResponseMatcher m : this.getMatchers()) {
            if (m.matches(session, request, response)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(MobileSequenceSession session, MobileMsgRequest request, MobileMsgResponse response) {
        return this.matchesResponseType(request, response) && this.matchesCriteria(session, request, response);
    }

    public abstract void processResponse(MobileSequenceSession var1, MobileMsgRequest var2, MobileMsgResponse var3);
}

