/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.IPv4NetworkInterface;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.sms.monitor.MobileMsgSequenceMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobileMsgSequenceMonitorTest {
    private MonitoredService m_service;
    private MobileMsgSequenceMonitor m_monitor;

    @Before
    public void setUp() {
        this.m_service = new MonitoredService(){

            public InetAddress getAddress() {
                try {
                    return InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            public String getIpAddr() {
                return "127.0.0.1";
            }

            public NetworkInterface getNetInterface() {
                return new IPv4NetworkInterface(this.getAddress());
            }

            public int getNodeId() {
                return 1;
            }

            public String getNodeLabel() {
                return "localhost";
            }

            public String getSvcName() {
                return "SMS";
            }
        };
        this.m_monitor = this.createAndInitializeMonitor();
    }

    @Test
    public void testBrokenConfiguration() throws Exception {
        this.assertUnavailable("<mobile-sequence xmlns=\"http://xmlns.opennms.org/xsd/config/mobile-sequence\">   <octagon sides=\"8\" /></mobile-sequence>");
    }

    @Test
    public void testInlineSequence() throws Exception {
        this.assertAvailable("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mobile-sequence xmlns=\"http://xmlns.opennms.org/xsd/config/mobile-sequence\">\n<transaction label=\"sms-ping\">\n<sms-request recipient=\"${recipient}\" text=\"You suck!\"/>\n<sms-response>\n<from-recipient/>\n<matches>^[Nn]o$</matches>\n</sms-response>\n</transaction>\n</mobile-sequence>");
    }

    @Test
    public void handleNullToInit() {
        MobileMsgSequenceMonitor m = new MobileMsgSequenceMonitor();
        m.initialize((Map)null);
    }

    @Test
    public void testParseConfiguration() throws Exception {
        PollStatus s = this.assertUnavailable("<mobile-sequence xmlns=\"http://xmlns.opennms.org/xsd/config/mobile-sequence\" />");
        Assert.assertEquals((Object)"No transactions were configured for host 127.0.0.1", (Object)s.getReason());
    }

    @Test
    public void testSimpleSequence() throws Exception {
        PollStatus s = this.assertAvailable(this.getXmlBuffer("sms-ping-sequence.xml"));
        Assert.assertTrue((s.getProperty("sms-ping").longValue() > 10L ? 1 : 0) != 0);
    }

    @Test
    public void testUssdSequence() throws Exception {
        this.assertAvailable(this.getXmlBuffer("tmobile-balance-sequence.xml"));
    }

    private PollStatus assertUnavailable(String config) {
        return this.assertPollStatus(config, 2);
    }

    private PollStatus assertAvailable(String config) {
        return this.assertPollStatus(config, 1);
    }

    private PollStatus assertPollStatus(String config, int expectedStatus) {
        Map<String, Object> parameters = this.createConfigParameters(config);
        PollStatus s = this.m_monitor.poll(this.m_service, parameters);
        Assert.assertEquals((String)"unaccepted poll status", (long)expectedStatus, (long)s.getStatusCode());
        return s;
    }

    private MobileMsgSequenceMonitor createAndInitializeMonitor() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mobileMessageContextName", "testMobileMessagePollerContext");
        MobileMsgSequenceMonitor m = new MobileMsgSequenceMonitor();
        m.initialize(params);
        return m;
    }

    private Map<String, Object> createConfigParameters(String mobileConfig) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("retry", "0");
        parameters.put("timeout", "3000");
        parameters.put("sequence", mobileConfig);
        return parameters;
    }

    private String getXmlBuffer(String fileName) throws IOException {
        File xmlFile = new File(ClassLoader.getSystemResource(fileName).getFile());
        Assert.assertTrue((String)"xml file is readable", (boolean)xmlFile.canRead());
        return FileUtils.readFileToString((File)xmlFile);
    }
}

