/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.opennms.core.utils.LogUtils;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.TimeoutException;
import org.smslib.USSDRequest;
import org.smslib.USSDResponse;

public class FakeTestGateway
extends AGateway {
    private int refCounter = 0;
    private int counter = 0;
    private DelayQueue<QueueRunner> m_delayQueue = new DelayQueue();
    Thread incomingMessagesThread;

    public FakeTestGateway(String id) {
        super(id);
        System.err.println("Initializing FakeTestGateway");
        this.setAttributes(1);
        this.setInbound(true);
        this.setOutbound(true);
    }

    public boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return true;
    }

    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.startGateway();
        this.incomingMessagesThread = new Thread(new Runnable(){

            public void run() {
                while (!FakeTestGateway.this.incomingMessagesThread.isInterrupted()) {
                    try {
                        QueueRunner runner = (QueueRunner)FakeTestGateway.this.m_delayQueue.take();
                        runner.run();
                    }
                    catch (InterruptedException e) {
                        LogUtils.warnf((Object)this, (Throwable)e, (String)"failed to run queue", (Object[])new Object[0]);
                        break;
                    }
                }
            }
        }, "IncomingMessagesThread");
        this.incomingMessagesThread.start();
    }

    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.stopGateway();
        if (this.incomingMessagesThread != null) {
            this.incomingMessagesThread.interrupt();
        }
    }

    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getService().getLogger().logInfo("Sending to: " + msg.getRecipient() + " via: " + msg.getGatewayId(), null, this.getGatewayId());
        Thread.sleep(500L);
        ++this.counter;
        msg.setDispatchDate(new Date());
        msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
        msg.setRefNo(Integer.toString(++this.refCounter));
        msg.setGatewayId(this.getGatewayId());
        this.getService().getLogger().logInfo("Sent to: " + msg.getRecipient() + " via: " + msg.getGatewayId(), null, this.getGatewayId());
        String msgText = msg.getText();
        if (msgText != null) {
            if (msgText.startsWith("ping")) {
                msgText = "pong";
            } else if (msgText.startsWith("You suck")) {
                msgText = "No";
            }
        }
        InboundMessage inbound = new InboundMessage(msg.getDate(), msg.getRecipient(), msgText, 1, "DEADBEEF");
        QueueRunner runner = new QueueRunner(inbound, 500L);
        this.m_delayQueue.offer(runner);
        return true;
    }

    public boolean sendUSSDRequest(USSDRequest request) throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.getService().getLogger().logInfo("Sending to: " + request.getContent() + " via: " + request.getGatewayId(), null, this.getGatewayId());
        Thread.sleep(500L);
        ++this.counter;
        request.setGatewayId(this.getGatewayId());
        String content = request.getContent();
        if (content != null && content.equals("#225#")) {
            content = "+CUSD: 0,\"37.28 received on 08/31/09. For continued service through 10/28/09, please pay 79.56 by 09/28/09.    \"";
        }
        USSDResponse response = new USSDResponse(content, this.getGatewayId());
        QueueRunner runner = new QueueRunner(response, 500L);
        this.m_delayQueue.offer(runner);
        return true;
    }

    public int getQueueSchedulingInterval() {
        return 500;
    }

    private class QueueRunner
    implements Runnable,
    Delayed {
        InboundMessage m_message;
        private USSDResponse m_response;
        long m_expiration = 0L;

        public QueueRunner(USSDResponse response, long milliseconds) {
            System.err.println("QueueRunner initialized with timeout " + milliseconds + " for message: " + response);
            this.m_response = response;
            this.m_expiration = System.currentTimeMillis() + milliseconds;
        }

        public QueueRunner(InboundMessage message, long milliseconds) {
            System.err.println("QueueRunner initialized with timeout " + milliseconds + " for message: " + message);
            this.m_message = message;
            this.m_expiration = System.currentTimeMillis() + milliseconds;
        }

        public void run() {
            if (this.m_message != null) {
                System.err.println("QueueRunner(run): " + FakeTestGateway.this.getService().getInboundNotification());
                if (FakeTestGateway.this.getService().getInboundNotification() != null) {
                    FakeTestGateway.this.getService().getInboundNotification().process(FakeTestGateway.this.getGatewayId(), Message.MessageTypes.INBOUND, this.m_message);
                }
            } else if (this.m_response != null) {
                System.err.println("QueueRunner(run): " + FakeTestGateway.this.getService().getUSSDNotification());
                if (FakeTestGateway.this.getService().getUSSDNotification() != null) {
                    FakeTestGateway.this.getService().getUSSDNotification().process(FakeTestGateway.this.getGatewayId(), this.m_response);
                }
            }
        }

        public long getDelay(TimeUnit unit) {
            long remainder = this.m_expiration - System.currentTimeMillis();
            return unit.convert(remainder, TimeUnit.MILLISECONDS);
        }

        public int compareTo(Delayed o) {
            long anotherVal;
            long thisVal = this.getDelay(TimeUnit.NANOSECONDS);
            return thisVal < (anotherVal = o.getDelay(TimeUnit.NANOSECONDS)) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }
}

