/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor.internal.config;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.sms.monitor.MobileSequenceSession;
import org.opennms.sms.monitor.internal.config.MobileSequenceRequest;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseHandler;

@XmlRootElement(name="sms-request")
public class SmsSequenceRequest
extends MobileSequenceRequest {
    private String m_recipient;
    private int m_validityPeriodInHours = 1;

    public SmsSequenceRequest() {
    }

    public SmsSequenceRequest(String label, String text) {
        super(label, text);
    }

    public SmsSequenceRequest(String gatewayId, String label, String text) {
        super(gatewayId, label, text);
    }

    @XmlAttribute(name="recipient")
    public String getRecipient() {
        return this.m_recipient;
    }

    public void setRecipient(String recipient) {
        this.m_recipient = recipient;
    }

    @XmlAttribute(name="validity-in-hours", required=false)
    public int getValidityPeriodInHours() {
        return this.m_validityPeriodInHours;
    }

    public void setValidityPeriodInHours(int validityPeriodInHours) {
        this.m_validityPeriodInHours = validityPeriodInHours;
    }

    public void send(MobileSequenceSession session, MobileMsgResponseHandler responseHandler) {
        session.sendSms(this.getGatewayIdForRequest(), this.getRecipient(), this.getText(), this.getValidityPeriodInHours(), responseHandler);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("gatewayId", (Object)this.getGatewayId()).append("label", (Object)this.getLabel()).append("recipient", (Object)this.getRecipient()).append("text", (Object)this.getText()).toString();
    }
}

