/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor;

import java.util.Map;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.sms.phonebook.Phonebook;
import org.opennms.sms.phonebook.PhonebookException;
import org.opennms.sms.phonebook.PropertyPhonebook;
import org.opennms.sms.ping.SmsPinger;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable(value={DistributionContext.DAEMON})
public final class SMSPingMonitor
extends IPv4Monitor {
    Phonebook phonebook = new PropertyPhonebook();

    public void initialize(Map<String, Object> params) {
        super.initialize(params);
        BeanUtils.getFactory((String)"mobileMessagePollerContext", ClassPathXmlApplicationContext.class);
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        int retries = ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)2);
        long timeout = ParameterMap.getKeyedLong(parameters, (String)"timeout", (long)60000L);
        Long rtt = null;
        String phoneNumber = null;
        try {
            phoneNumber = this.phonebook.getTargetForAddress(svc.getIpAddr());
        }
        catch (PhonebookException e) {
            LogUtils.warnf((Object)((Object)this), (Throwable)e, (String)"Unable to get phonebook target for %s", (Object[])new Object[]{svc.getIpAddr()});
        }
        if (phoneNumber != null) {
            try {
                rtt = SmsPinger.ping((String)phoneNumber, (long)timeout, (int)retries);
            }
            catch (Exception e) {
                LogUtils.warnf((Object)((Object)this), (Throwable)e, (String)"Unable to ping phone number: %s", (Object[])new Object[]{phoneNumber});
            }
        }
        if (rtt != null) {
            return PollStatus.available((Double)rtt.doubleValue());
        }
        return PollStatus.unavailable();
    }
}

