/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.sms.monitor.internal.config.SequenceSessionVariable;
import org.opennms.sms.monitor.session.SessionVariableGenerator;
import org.opennms.sms.reflector.smsservice.MobileMsgRequest;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseCallback;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseHandler;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseMatcher;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseMatchers;
import org.opennms.sms.reflector.smsservice.MobileMsgTracker;
import org.smslib.OutboundMessage;
import org.smslib.USSDRequest;
import org.smslib.USSDSessionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobileSequenceSession {
    private static final int DEFAULT_RETRIES = 0;
    private static final long DEFAULT_TIMEOUT = 10000L;
    private List<SequenceSessionVariable> m_sessionVariables;
    private MobileMsgTracker m_tracker;
    private Properties m_properties = new Properties();
    private Map<String, SessionVariableGenerator> m_generators = new HashMap<String, SessionVariableGenerator>();

    public MobileSequenceSession(MobileMsgTracker tracker) {
        this(new HashMap<String, Object>(), Collections.emptyList(), tracker);
    }

    public MobileSequenceSession(Map<String, Object> parameters, List<SequenceSessionVariable> sessionVariables, MobileMsgTracker tracker) {
        this.m_sessionVariables = sessionVariables;
        this.m_tracker = tracker;
        if (parameters.get("retry") == null) {
            parameters.put("retry", String.valueOf(0));
        }
        if (parameters.get("timeout") == null) {
            parameters.put("timeout", String.valueOf(10000L));
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.getProperties().put(entry.getKey(), entry.getValue());
        }
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public Map<String, SessionVariableGenerator> getGenerators() {
        return this.m_generators;
    }

    void setRecipient(String recipient) {
        this.getProperties().setProperty("recipient", recipient);
    }

    public int getRetries() {
        return Integer.parseInt(this.getProperties().getProperty("retry", String.valueOf(0)));
    }

    public long getTimeout() {
        return Long.parseLong(this.getProperties().getProperty("timeout", String.valueOf(10000L)));
    }

    public void setTimeout(long timeout) {
        this.getProperties().setProperty("timeout", String.valueOf(timeout));
    }

    public void setRetries(int retries) {
        this.getProperties().setProperty("retry", String.valueOf(retries));
    }

    public void setVariable(String varName, String value) {
        this.getProperties().setProperty(varName, value);
    }

    public String substitute(String string) {
        return PropertiesUtils.substitute((String)string, (Properties[])new Properties[]{this.getProperties()});
    }

    void checkinVariables() {
        for (SequenceSessionVariable var : this.m_sessionVariables) {
            var.checkIn(this.getProperties());
        }
    }

    void checkoutVariables() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (SequenceSessionVariable var : this.m_sessionVariables) {
            var.checkOut(this.getProperties());
        }
    }

    public boolean eqOrMatches(String expected, String actual) {
        return MobileMsgResponseMatchers.isAMatch((String)this.substitute(expected), (String)actual);
    }

    public boolean matches(String expected, String actual) {
        return actual == null ? expected == null : actual.matches(this.substitute(expected));
    }

    public boolean ussdStatusMatches(String expected, USSDSessionStatus actual) {
        USSDSessionStatus status;
        try {
            int statusVal = Integer.parseInt(this.substitute(expected));
            status = USSDSessionStatus.getByNumeric((int)statusVal);
        }
        catch (NumberFormatException e) {
            status = USSDSessionStatus.valueOf((String)this.substitute(expected));
        }
        return status.equals((Object)actual);
    }

    public void sendSms(String gatewayId, String recipient, String text, int validityPeriodInHours, MobileMsgResponseHandler responseHandler) {
        MobileMsgRequest request = null;
        try {
            OutboundMessage msg = new OutboundMessage(this.substitute(recipient), this.substitute(text));
            msg.setGatewayId(this.substitute(gatewayId));
            msg.setValidityPeriod(validityPeriodInHours);
            request = this.m_tracker.sendSmsRequest(msg, this.getTimeout(), this.getRetries(), (MobileMsgResponseCallback)responseHandler, (MobileMsgResponseMatcher)responseHandler);
        }
        catch (Exception e) {
            responseHandler.handleError(request, (Throwable)e);
        }
    }

    public void sendUssd(String gatewayId, String text, MobileMsgResponseHandler responseHandler) {
        MobileMsgRequest request = null;
        try {
            USSDRequest ussdRequest = new USSDRequest(this.substitute(text));
            ussdRequest.setGatewayId(this.substitute(gatewayId));
            request = this.m_tracker.sendUssdRequest(ussdRequest, this.getTimeout(), this.getRetries(), (MobileMsgResponseCallback)responseHandler, (MobileMsgResponseMatcher)responseHandler);
        }
        catch (Exception e) {
            responseHandler.handleError(request, (Throwable)e);
        }
    }
}

