/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor.internal.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.sms.monitor.internal.MobileSequenceConfigBuilder;
import org.opennms.sms.monitor.internal.config.MobileSequenceConfig;
import org.opennms.sms.monitor.internal.config.MobileSequenceNamespacePrefixMapper;
import org.opennms.sms.monitor.internal.config.MobileSequenceTransaction;
import org.opennms.sms.monitor.internal.config.SequenceConfigFactory;
import org.opennms.sms.monitor.internal.config.SmsFromRecipientResponseMatcher;
import org.opennms.sms.monitor.internal.config.SmsSequenceRequest;
import org.opennms.sms.monitor.internal.config.SmsSequenceResponse;
import org.opennms.sms.monitor.internal.config.SmsSourceMatcher;
import org.opennms.sms.monitor.internal.config.TextResponseMatcher;
import org.opennms.sms.monitor.internal.config.UssdSequenceRequest;
import org.opennms.sms.monitor.internal.config.UssdSequenceResponse;
import org.opennms.sms.monitor.internal.config.UssdSessionStatusMatcher;
import org.opennms.sms.monitor.session.UniqueNumber;
import org.opennms.test.FileAnticipator;
import org.smslib.USSDSessionStatus;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SequenceXmlTest {
    private FileAnticipator m_fileAnticipator;
    private MobileSequenceConfig m_smsSequence;
    private JAXBContext m_context;
    private Marshaller m_marshaller;
    private Unmarshaller m_unmarshaller;

    @Before
    public void setUp() throws Exception {
        this.m_fileAnticipator = new FileAnticipator();
        MobileSequenceConfigBuilder bldr = new MobileSequenceConfigBuilder();
        bldr.variable("amount", UniqueNumber.class).parameter("min", (Object)1).parameter("max", (Object)15);
        bldr.ussdRequest("req-balance-transfer", "ACM0", "*327*${recipient}*${amount}#").withTransactionLabel("ussd-transfer").withGatewayId("ACM0").expectUssdResponse("balance-conf-resp").onGateway("ACM0").withSessionStatus(USSDSessionStatus.FURTHER_ACTION_REQUIRED).matching("^Transfiere L ${amount} al ${recipient}$");
        MobileSequenceConfigBuilder.MobileSequenceTransactionBuilder transBldr = bldr.ussdRequest("conf-transfer", "ACM0", "1");
        transBldr.withTransactionLabel("req-conf").withGatewayId("ACM0").expectUssdResponse("processing").onGateway("ACM0").withSessionStatus(USSDSessionStatus.NO_FURTHER_ACTION_REQUIRED).matching("^.*Su transaccion se esta procesando.*$");
        transBldr.expectSmsResponse("transferred").onGateway("ACM0").matching("^.*le ha transferido L ${amount}.*$").srcMatches("+3746");
        this.m_smsSequence = bldr.getSequence();
        this.m_context = JAXBContext.newInstance((Class[])new Class[]{MobileSequenceConfig.class, SmsSequenceRequest.class, UssdSequenceRequest.class, SmsSequenceResponse.class, UssdSequenceResponse.class, SmsFromRecipientResponseMatcher.class, SmsSourceMatcher.class, TextResponseMatcher.class, UssdSessionStatusMatcher.class});
        this.m_marshaller = this.m_context.createMarshaller();
        this.m_marshaller.setProperty("jaxb.formatted.output", (Object)true);
        this.m_marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new MobileSequenceNamespacePrefixMapper());
        this.m_unmarshaller = this.m_context.createUnmarshaller();
        this.m_unmarshaller.setSchema(null);
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setNormalize((boolean)true);
    }

    @After
    public void tearDown() throws Exception {
        this.m_fileAnticipator.tearDown();
    }

    @Test
    public void generateSchema() throws Exception {
        File schemaFile = this.m_fileAnticipator.expecting("mobile-sequence.xsd");
        this.m_context.generateSchema((SchemaOutputResolver)new TestOutputResolver(schemaFile));
        this.printFile(schemaFile);
        if (this.m_fileAnticipator.isInitialized()) {
            this.m_fileAnticipator.deleteExpected();
        }
    }

    @Test
    public void generateXML() throws Exception {
        StringWriter objectXML = new StringWriter();
        this.m_marshaller.marshal((Object)this.m_smsSequence, (Writer)objectXML);
        System.err.println(objectXML.toString());
    }

    @Test(expected=UnmarshalException.class)
    public void readInvalidXML() throws Exception {
        File exampleFile = new File(ClassLoader.getSystemResource("invalid-sequence.xml").getFile());
        DefaultValidationEventHandler handler = new DefaultValidationEventHandler();
        this.m_unmarshaller.setEventHandler((ValidationEventHandler)handler);
        MobileSequenceConfig s = (MobileSequenceConfig)this.m_unmarshaller.unmarshal(exampleFile);
        System.err.println("sequence = " + s);
        this.assertTransactionParentsSet(s);
    }

    @Test(expected=UnmarshalException.class)
    public void readPoorlyFormedXML() throws Exception {
        File exampleFile = new File(ClassLoader.getSystemResource("poorly-formed-sequence.xml").getFile());
        DefaultValidationEventHandler handler = new DefaultValidationEventHandler();
        this.m_unmarshaller.setEventHandler((ValidationEventHandler)handler);
        MobileSequenceConfig s = (MobileSequenceConfig)this.m_unmarshaller.unmarshal(exampleFile);
        System.err.println("sequence = " + s);
        this.assertTransactionParentsSet(s);
    }

    @Test
    public void readAnotherSampleXML() throws Exception {
        File exampleFile = new File(ClassLoader.getSystemResource("alternate-ping-sequence.xml").getFile());
        DefaultValidationEventHandler handler = new DefaultValidationEventHandler();
        this.m_unmarshaller.setEventHandler((ValidationEventHandler)handler);
        MobileSequenceConfig s = (MobileSequenceConfig)this.m_unmarshaller.unmarshal(exampleFile);
        System.err.println("sequence = " + s);
        this.assertTransactionParentsSet(s);
    }

    @Test
    public void readXML() throws Exception {
        File exampleFile = new File(ClassLoader.getSystemResource("ussd-balance-sequence.xml").getFile());
        DefaultValidationEventHandler handler = new DefaultValidationEventHandler();
        this.m_unmarshaller.setEventHandler((ValidationEventHandler)handler);
        MobileSequenceConfig s = (MobileSequenceConfig)this.m_unmarshaller.unmarshal(exampleFile);
        System.err.println("sequence = " + s);
        this.assertTransactionParentsSet(s);
    }

    @Test
    public void validateXML() throws Exception {
        StringWriter objectXML = new StringWriter();
        this.m_marshaller.marshal((Object)this.m_smsSequence, (Writer)objectXML);
        StringBuffer exampleXML = this.getXmlBuffer("ussd-balance-sequence.xml");
        System.err.println("========================================================================");
        System.err.println("Object XML:");
        System.err.println("========================================================================");
        System.err.print(objectXML.toString());
        System.err.println("========================================================================");
        System.err.println("Example XML:");
        System.err.println("========================================================================");
        System.err.print(exampleXML.toString());
        DetailedDiff myDiff = this.getDiff(objectXML, exampleXML);
        Assert.assertEquals((String)"number of XMLUnit differences between the example XML and the mock object XML is 0", (long)0L, (long)myDiff.getAllDifferences().size());
    }

    @Test
    public void validateAgainstSchema() throws Exception {
        File schemaFile = this.m_fileAnticipator.expecting("mobile-sequence.xsd");
        this.m_context.generateSchema((SchemaOutputResolver)new TestOutputResolver(schemaFile));
        this.printFile(schemaFile);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder parser = dbFactory.newDocumentBuilder();
        File sequenceFile = new File(ClassLoader.getSystemResource("ussd-balance-sequence.xml").getFile());
        this.printFile(sequenceFile);
        Document document = parser.parse(sequenceFile);
        validator.validate(new DOMSource(document));
        if (this.m_fileAnticipator.isInitialized()) {
            this.m_fileAnticipator.deleteExpected();
        }
    }

    @Test
    public void tryFactory() throws Exception {
        File exampleFile = new File(ClassLoader.getSystemResource("ussd-balance-sequence.xml").getFile());
        MobileSequenceConfig sequence = SequenceConfigFactory.getInstance().getSequenceForFile(exampleFile);
        Assert.assertEquals((Object)"ussd-transfer", (Object)((MobileSequenceTransaction)sequence.getTransactions().iterator().next()).getLabel());
    }

    private DetailedDiff getDiff(StringWriter objectXML, StringBuffer exampleXML) throws SAXException, IOException {
        DetailedDiff myDiff = new DetailedDiff(XMLUnit.compareXML((String)exampleXML.toString(), (String)objectXML.toString()));
        List allDifferences = myDiff.getAllDifferences();
        if (allDifferences.size() > 0) {
            for (Difference d : allDifferences) {
                System.err.println(d);
            }
        }
        return myDiff;
    }

    private void assertTransactionParentsSet(MobileSequenceConfig s) {
        for (MobileSequenceTransaction t : s.getTransactions()) {
            Assert.assertEquals((Object)s, (Object)t.getSequenceConfig());
        }
    }

    private StringBuffer getXmlBuffer(String fileName) throws IOException {
        StringBuffer xmlBuffer = new StringBuffer();
        File xmlFile = new File(ClassLoader.getSystemResource("ussd-balance-sequence.xml").getFile());
        Assert.assertTrue((String)"ussd-balance-sequence.xml is readable", (boolean)xmlFile.canRead());
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(xmlFile), "UTF-8"));
        while (true) {
            String line;
            if ((line = reader.readLine()) == null) break;
            xmlBuffer.append(line).append("\n");
        }
        reader.close();
        return xmlBuffer;
    }

    private void printFile(File file) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line).append("\n");
        }
        System.err.println(sb.toString());
    }

    private static class TestOutputResolver
    extends SchemaOutputResolver {
        private final File m_schemaFile;

        public TestOutputResolver(File schemaFile) {
            this.m_schemaFile = schemaFile;
        }

        public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
            return new StreamResult(this.m_schemaFile);
        }
    }
}

