/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;

public class UssdMessageParsingTest {
    @Test
    public void testUssdSingleLine() {
        this.parseMessage("+CUSD: 2,\"a message\"\r", 2, "2", "a message", null);
    }

    @Test
    public void testUssdSingleLineSpaceAfterStatus() {
        this.parseMessage("+CUSD: 2, \"a message\"\r", 2, "2", "a message", null);
    }

    @Test
    public void testUssdSingleLineWithEncoding() {
        this.parseMessage("+CUSD: 2,\"a message with an encoding\",15\r", 2, "2", "a message with an encoding", "15");
    }

    @Test
    public void testUssdSingleLineWithEncodingSpaceBeforeEncoding() {
        this.parseMessage("+CUSD: 2,\"a message with an encoding\", 15\r", 2, "2", "a message with an encoding", "15");
    }

    @Test
    public void testOperationNotSupprted() {
        this.parseMessage("+CUSD: 4\r", 2, "4", null, null);
    }

    public void parseMessage(String msg, int expectedCount, String status, String content, String encoding) {
        Pattern MSG_PATTERN = Pattern.compile("(?s)^\\+CUSD:\\s+(\\d)(?:,\\s*\"([^\"]*))?(?:\",\\s*(\\d+))?(?:\"\r|\r)$");
        int STATUS_INDEX = 1;
        int CONTENT_INDEX = 2;
        int ENCODING_INDEX = 3;
        Matcher matcher = MSG_PATTERN.matcher(msg);
        Assert.assertTrue((boolean)matcher.matches());
        Assert.assertEquals((Object)status, (Object)this.group(matcher, STATUS_INDEX));
        Assert.assertEquals((Object)content, (Object)this.group(matcher, CONTENT_INDEX));
        Assert.assertEquals((Object)encoding, (Object)this.group(matcher, ENCODING_INDEX));
    }

    private String group(Matcher matcher, int index) {
        return matcher.groupCount() >= index ? matcher.group(index) : null;
    }
}

