/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor;

import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.protocols.rt.Messenger;
import org.opennms.sms.monitor.MobileSequenceSession;
import org.opennms.sms.monitor.TestMessenger;
import org.opennms.sms.monitor.internal.MobileSequenceConfigBuilder;
import org.opennms.sms.monitor.internal.MobileSequenceExecution;
import org.opennms.sms.reflector.smsservice.MobileMsgTracker;
import org.opennms.sms.reflector.smsservice.MobileMsgTrackerImpl;
import org.smslib.USSDSessionStatus;

public class MobileMsgSequenceBuilderTest {
    private static final String PHONE_NUMBER = "+19195551212";
    public static final String TMOBILE_RESPONSE = "37.28 received on 08/31/09. For continued service through 10/28/09, please pay 79.56 by 09/28/09.    ";
    public static final String TMOBILE_USSD_MATCH = "^.*[\\d\\.]+ received on \\d\\d/\\d\\d/\\d\\d. For continued service through \\d\\d/\\d\\d/\\d\\d, please pay [\\d\\.]+ by \\d\\d/\\d\\d/\\d\\d.*$";
    TestMessenger m_messenger;
    MobileMsgTrackerImpl m_tracker;
    DefaultTaskCoordinator m_coordinator;
    MobileSequenceSession m_session;

    @Before
    public void setUp() throws Exception {
        this.m_messenger = new TestMessenger();
        this.m_tracker = new MobileMsgTrackerImpl("test", (Messenger)this.m_messenger);
        this.m_tracker.start();
        this.m_session = new MobileSequenceSession((MobileMsgTracker)this.m_tracker);
        this.m_coordinator = new DefaultTaskCoordinator("MobileMsgSequenceBuilderTest", (Executor)Executors.newSingleThreadExecutor((ThreadFactory)new LogPreservingThreadFactory("MobileMsgSequenceBuilderTest", 1, false)));
        System.err.println("=== STARTING TEST ===");
    }

    @Test(expected=SocketTimeoutException.class)
    public void testPingTimeoutWithBuilder() throws Throwable {
        MobileSequenceConfigBuilder bldr = new MobileSequenceConfigBuilder();
        this.ping(bldr);
        MobileSequenceExecution execution = bldr.getSequence().start(this.m_session, this.m_coordinator);
        bldr.getSequence().waitFor(this.m_session, execution);
    }

    @Test
    public void testPingWithBuilder() throws Throwable {
        MobileSequenceConfigBuilder bldr = new MobileSequenceConfigBuilder();
        this.ping(bldr);
        MobileSequenceExecution execution = bldr.getSequence().start(this.m_session, this.m_coordinator);
        Thread.sleep(500L);
        this.sendPong();
        bldr.getSequence().waitFor(this.m_session, execution);
        Map timing = execution.getResponseTimes();
        Assert.assertNotNull((Object)timing);
        Assert.assertTrue((this.latency(timing, "SMS Ping") > 400.0 ? 1 : 0) != 0);
    }

    @Test
    public void testUssdWithBuilder() throws Throwable {
        MobileSequenceConfigBuilder bldr = new MobileSequenceConfigBuilder();
        this.balanceInquiry(bldr);
        MobileSequenceExecution execution = bldr.getSequence().start(this.m_session, this.m_coordinator);
        Thread.sleep(500L);
        this.sendBalance();
        bldr.getSequence().waitFor(this.m_session, execution);
        Map timing = execution.getResponseTimes();
        Assert.assertNotNull((Object)timing);
        Assert.assertTrue((this.latency(timing, "USSD request") > 400.0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleStepSequenceBuilder() throws Throwable {
        MobileSequenceConfigBuilder bldr = new MobileSequenceConfigBuilder();
        this.ping(bldr);
        this.balanceInquiry(bldr);
        MobileSequenceExecution execution = bldr.getSequence().start(this.m_session, this.m_coordinator);
        Thread.sleep(100L);
        this.sendPong();
        Thread.sleep(100L);
        this.sendBalance();
        bldr.getSequence().waitFor(this.m_session, execution);
        Map timing = execution.getResponseTimes();
        Assert.assertNotNull((Object)this.m_session);
        Assert.assertEquals((Object)PHONE_NUMBER, (Object)this.m_session.substitute("${SMS Pong.smsOriginator}"));
        Assert.assertNotNull((Object)timing);
        Assert.assertTrue((this.latency(timing, "response-time") > 150.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.latency(timing, "SMS Ping") > 50.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.latency(timing, "USSD request") > 50.0 ? 1 : 0) != 0);
        Assert.assertEquals((String)("Unexpected size for timing " + timing), (long)3L, (long)timing.size());
    }

    private double latency(Map<String, Number> timing, String label) {
        Number latency = timing.get(label);
        Assert.assertNotNull((String)("no latency found for " + label), (Object)latency);
        return latency.doubleValue();
    }

    private void ping(MobileSequenceConfigBuilder bldr) {
        bldr.smsRequest("SMS Ping", "G", PHONE_NUMBER, "ping").expectSmsResponse("SMS Pong").matching("^pong$");
    }

    private void sendPong() {
        this.m_messenger.sendTestResponse(PHONE_NUMBER, "pong");
    }

    private void balanceInquiry(MobileSequenceConfigBuilder bldr) {
        bldr.ussdRequest("USSD request", "G", "#225#").expectUssdResponse("USSD response").matching(TMOBILE_USSD_MATCH).withSessionStatus(USSDSessionStatus.NO_FURTHER_ACTION_REQUIRED);
    }

    private void sendBalance() {
        this.m_messenger.sendTestResponse("G", TMOBILE_RESPONSE, USSDSessionStatus.NO_FURTHER_ACTION_REQUIRED);
    }
}

