/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor.internal.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.LogUtils;
import org.opennms.sms.monitor.internal.config.SequenceParameter;
import org.opennms.sms.monitor.session.SessionVariableGenerator;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SequenceSessionVariableType", propOrder={"m_name", "m_className", "m_parameters"})
@XmlRootElement(name="session-variable")
public class SequenceSessionVariable {
    @XmlAttribute(name="name")
    private String m_name;
    @XmlAttribute(name="class")
    private String m_className;
    @XmlElementWrapper(name="parameters", required=false)
    @XmlElement(name="parameter")
    private List<SequenceParameter> m_parameters;
    @XmlTransient
    private SessionVariableGenerator m_generator;

    public SequenceSessionVariable() {
    }

    public SequenceSessionVariable(String name, String className) {
        this.setName(name);
        this.setClassName(className);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setClassName(String name) {
        this.m_className = name;
    }

    public void addParameter(String key, String value) {
        if (this.m_parameters == null) {
            this.m_parameters = Collections.synchronizedList(new ArrayList());
        }
        this.m_parameters.add(new SequenceParameter(key, value));
    }

    public List<SequenceParameter> getParameters() {
        return this.m_parameters;
    }

    public Map<String, String> getParametersAsMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        if (this.m_parameters != null) {
            for (SequenceParameter p : this.m_parameters) {
                m.put(p.getKey(), p.getValue());
            }
        }
        return m;
    }

    public void setParameters(List<SequenceParameter> parameters) {
        this.m_parameters = parameters;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).append("class", (Object)this.getClassName()).append("parameters", this.getParameters()).toString();
    }

    public SessionVariableGenerator getGenerator() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.m_generator == null) {
            Class<?> c = Class.forName(this.getClassName());
            if (SessionVariableGenerator.class.isAssignableFrom(c)) {
                SessionVariableGenerator generator = (SessionVariableGenerator)c.newInstance();
                generator.setParameters(this.getParametersAsMap());
                this.m_generator = generator;
            } else {
                LogUtils.warnf((Object)this, (String)"unable to get instance of session class: %s", (Object[])new Object[]{c});
            }
        }
        return this.m_generator;
    }

    public void checkOut(Properties properties) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        SessionVariableGenerator generator = this.getGenerator();
        if (generator != null) {
            String value = generator.checkOut();
            if (value == null) {
                value = "";
            }
            properties.setProperty(this.getName(), value);
        }
    }

    public void checkIn(Properties properties) {
        SessionVariableGenerator generator = this.m_generator;
        if (generator != null) {
            generator.checkIn(properties.getProperty(this.getName()));
        }
    }
}

