/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.Callback;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.core.tasks.SequenceTask;
import org.opennms.sms.monitor.MobileSequenceSession;
import org.opennms.sms.monitor.internal.MobileTransactionExecution;
import org.opennms.sms.monitor.internal.config.MobileSequenceConfig;
import org.opennms.sms.monitor.internal.config.MobileSequenceTransaction;
import org.opennms.sms.reflector.smsservice.MobileMsgResponse;

public class MobileSequenceExecution {
    private Map<String, Number> m_responseTimes = new LinkedHashMap<String, Number>();
    private Long m_startTime;
    private SequenceTask m_task;
    private MobileSequenceConfig m_sequenceConfig;
    private List<MobileTransactionExecution> m_transactionExecutions = new ArrayList<MobileTransactionExecution>();

    public MobileSequenceExecution(MobileSequenceConfig sequenceConfig) {
        this.m_sequenceConfig = sequenceConfig;
        for (MobileSequenceTransaction transaction : sequenceConfig.getTransactions()) {
            this.m_transactionExecutions.add(new MobileTransactionExecution(transaction));
        }
    }

    public MobileSequenceConfig getSequenceConfig() {
        return this.m_sequenceConfig;
    }

    public List<MobileTransactionExecution> getTransactionExecutions() {
        return this.m_transactionExecutions;
    }

    public Long getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(Long startTime) {
        this.m_startTime = startTime;
    }

    public Map<String, Number> getResponseTimes() {
        return this.m_responseTimes;
    }

    public void end() {
        long end = System.currentTimeMillis();
        this.getResponseTimes().put("response-time", end - this.getStartTime());
    }

    public void waitFor() throws InterruptedException, ExecutionException {
        SequenceTask task = this.getTask();
        if (task == null) {
            throw new IllegalStateException("attempting to wait for the sequence to complete but the sequence has never been started!");
        }
        task.waitFor();
        this.end();
    }

    public SequenceTask getTask() {
        return this.m_task;
    }

    public void setTask(SequenceTask task) {
        this.m_task = task;
    }

    public void updateResults(MobileSequenceSession session) throws Throwable {
        for (MobileTransactionExecution execution : this.getTransactionExecutions()) {
            MobileSequenceTransaction transaction = execution.getTransaction();
            if (execution.getError() != null) {
                throw execution.getError();
            }
            this.getResponseTimes().put(transaction.getLabel(session), execution.getLatency());
        }
    }

    public void start(MobileSequenceSession session, DefaultTaskCoordinator coordinator) {
        this.setTask((SequenceTask)coordinator.createSequence().get());
        for (MobileTransactionExecution execution : this.getTransactionExecutions()) {
            this.getTask().add(this.createAsync(session, execution), null);
        }
        this.setStartTime(System.currentTimeMillis());
        this.getTask().schedule();
    }

    private Async<MobileMsgResponse> createAsync(final MobileSequenceSession session, final MobileTransactionExecution execution) {
        return new Async<MobileMsgResponse>(){

            public void submit(Callback<MobileMsgResponse> cb) {
                if (MobileSequenceExecution.this.hasFailed()) {
                    cb.complete(null);
                } else {
                    execution.sendRequest(session, cb);
                }
            }
        };
    }

    private boolean hasFailed() {
        for (MobileTransactionExecution execution : this.getTransactionExecutions()) {
            if (execution.getError() == null) continue;
            return true;
        }
        return false;
    }
}

