/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.opennms.sms.reflector.smsservice.MobileMsgRequest;
import org.opennms.sms.reflector.smsservice.MobileMsgResponse;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseCallback;
import org.opennms.sms.reflector.smsservice.SmsResponse;
import org.opennms.sms.reflector.smsservice.UssdResponse;
import org.smslib.InboundMessage;
import org.smslib.USSDResponse;

public class TestCallback
implements MobileMsgResponseCallback {
    CountDownLatch m_latch = new CountDownLatch(1);
    AtomicReference<MobileMsgResponse> m_response = new AtomicReference<Object>(null);

    MobileMsgResponse getResponse() throws InterruptedException {
        this.m_latch.await();
        return this.m_response.get();
    }

    public void handleError(MobileMsgRequest request, Throwable t) {
        System.err.println("Error processing SmsRequest: " + request);
        this.m_latch.countDown();
    }

    public boolean handleResponse(MobileMsgRequest request, MobileMsgResponse response) {
        this.m_response.set(response);
        this.m_latch.countDown();
        return true;
    }

    public void handleTimeout(MobileMsgRequest request) {
        System.err.println("Timeout waiting for SmsRequest: " + request);
        this.m_latch.countDown();
    }

    public InboundMessage getMessage() throws InterruptedException {
        MobileMsgResponse response = this.getResponse();
        if (response instanceof SmsResponse) {
            return ((SmsResponse)response).getMessage();
        }
        return null;
    }

    public USSDResponse getUSSDResponse() throws InterruptedException {
        MobileMsgResponse response = this.getResponse();
        if (response instanceof UssdResponse) {
            return ((UssdResponse)response).getMessage();
        }
        return null;
    }
}

