/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.rxtx.test.internal;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXVersion;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TooManyListenersException;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opennms.rxtx.test.internal.LoopbackEventTest;
import org.ops4j.io.Pipe;

public final class RxtxCommands
implements CommandProvider {
    private Map<String, SerialPort> m_openPorts = new HashMap<String, SerialPort>();
    private Map<String, Pipe> m_loggingPorts = new HashMap<String, Pipe>();

    public Object _rxtxVersion(CommandInterpreter intp) {
        intp.println((Object)("RXTX Version: " + RXTXVersion.getVersion()));
        intp.println((Object)("RXTX NativeVersion: " + RXTXVersion.nativeGetVersion()));
        return null;
    }

    public Object _rxtxListPorts(CommandInterpreter intp) {
        Enumeration en = CommPortIdentifier.getPortIdentifiers();
        while (en.hasMoreElements()) {
            CommPortIdentifier commPortId = (CommPortIdentifier)en.nextElement();
            intp.println((Object)("Port: " + commPortId.getName() + " Type: " + commPortId.getPortType()));
        }
        return null;
    }

    public Object _rxtxOpen(CommandInterpreter intp) {
        CommPortIdentifier portId;
        String id = intp.nextArgument();
        String port = intp.nextArgument();
        if (id == null || port == null) {
            intp.println((Object)"usage: rxtxOpen <id> <port>");
            return null;
        }
        if (this.m_openPorts.containsKey(id)) {
            intp.println((Object)("there is already a port with id " + id));
            return null;
        }
        try {
            portId = CommPortIdentifier.getPortIdentifier((String)port);
            if (portId.getPortType() != 1) {
                intp.println((Object)"Only Serial Ports are currently supported.");
                return null;
            }
        }
        catch (NoSuchPortException e) {
            intp.println((Object)("port not found: " + e.getMessage()));
            return null;
        }
        try {
            SerialPort commPort = (SerialPort)portId.open("rxtx-test", 4000);
            this.m_openPorts.put(id, commPort);
            intp.println((Object)("Port " + commPort.getName() + " assigned to id " + id));
            return null;
        }
        catch (PortInUseException e) {
            intp.println((Object)("exception opening port: " + e.getMessage()));
            return null;
        }
    }

    public Object _rxtxClose(CommandInterpreter intp) {
        try {
            String id = intp.nextArgument();
            this.assertNotNull(id, "usage: rxtxClose <id>");
            this.assertOpenPort(id);
            Pipe pipe = this.m_loggingPorts.remove(id);
            if (pipe != null) {
                pipe.stop();
            }
            SerialPort port = this.m_openPorts.remove(id);
            intp.print((Object)("Closing port " + port.getName() + " with id " + id + "..."));
            port.close();
            intp.println((Object)"done.");
        }
        catch (IllegalArgumentException e) {
            intp.println((Object)e.getMessage());
        }
        return null;
    }

    public Object _rxtxWrite(CommandInterpreter intp) {
        String id = intp.nextArgument();
        String text = intp.nextArgument();
        try {
            this.assertNotNull(id, "usage: rxtxWrite <id> <text>");
            this.assertNotNull(text, "usage: rxtxWrite <id> <text>");
            this.assertOpenPort(id);
            SerialPort port = this.m_openPorts.get(id);
            OutputStreamWriter out = new OutputStreamWriter(port.getOutputStream(), "US-ASCII");
            if (text.startsWith("<<")) {
                String eof = text.substring(2);
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                String line = in.readLine();
                while (!eof.equals(line)) {
                    out.write(line + "\r\n");
                    ((Writer)out).flush();
                    line = in.readLine();
                }
            } else {
                text = text.replace("\\r", "\r");
                text = text.replace("\\n", "\n");
                text = text.replace("\\\\", "\\");
                out.write(text + "\r\n");
                ((Writer)out).flush();
            }
        }
        catch (IllegalArgumentException e) {
            intp.println((Object)e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            intp.println((Object)("Unsupported Encoded " + e.getMessage()));
        }
        catch (IOException e) {
            intp.println((Object)("Exception writing " + text + " to port with id " + id));
            intp.printStackTrace((Throwable)e);
        }
        return null;
    }

    public Object _rxtxRead(CommandInterpreter intp) {
        try {
            String id = intp.nextArgument();
            this.assertNotNull(id, "usage: rxtxRead <id> <timeout>");
            this.assertOpenPort(id);
            SerialPort port = this.m_openPorts.get(id);
            InputStreamReader r = new InputStreamReader(port.getInputStream(), "US-ASCII");
            while (((Reader)r).ready()) {
                intp.print((Object)Character.valueOf((char)((Reader)r).read()));
            }
        }
        catch (IllegalArgumentException e) {
            intp.println((Object)e.getMessage());
        }
        catch (Exception e) {
            intp.println((Object)"Exception will reading.");
            intp.printStackTrace((Throwable)e);
        }
        return null;
    }

    public Object _rxtxLog(CommandInterpreter intp) {
        try {
            String id = intp.nextArgument();
            this.assertNotNull(id, "usage: rxtxLog <id>");
            this.assertOpenPort(id);
            SerialPort port = this.m_openPorts.get(id);
            Pipe pipe = new Pipe(port.getInputStream(), (OutputStream)System.out).start("Modem DataStream");
            this.m_loggingPorts.put(id, pipe);
        }
        catch (IllegalArgumentException e) {
            intp.println((Object)e.getMessage());
        }
        catch (IOException e) {
            intp.println((Object)"Error reading from port");
            intp.printStackTrace((Throwable)e);
        }
        return null;
    }

    public Object _rxtxUnlog(CommandInterpreter intp) {
        try {
            String id = intp.nextArgument();
            this.assertNotNull(id, "usage: rxtxUnlog <id>");
            this.assertOpenPort(id);
            this.assertTrue(this.m_loggingPorts.containsKey(id), "port with id " + id + " is not currently logging");
            Pipe pipe = this.m_loggingPorts.remove(id);
            pipe.stop();
        }
        catch (IllegalArgumentException e) {
            intp.println((Object)e.getMessage());
        }
        return null;
    }

    public Object _rxtxInfo(CommandInterpreter intp) {
        try {
            String id = intp.nextArgument();
            this.assertNotNull(id, "usage: rxtxInfo <id>");
            this.assertOpenPort(id);
            SerialPort port = this.m_openPorts.get(id);
            intp.println((Object)("===== Info for port " + port.getName() + " ====="));
            intp.println((Object)("\tbaudRate: " + port.getBaudRate()));
            intp.println((Object)("\tisCD: " + port.isCD()));
            intp.println((Object)("\tisCTS: " + port.isCTS()));
            intp.println((Object)("\tisDSR: " + port.isDSR()));
            intp.println((Object)("\tisDTR: " + port.isDTR()));
            intp.println((Object)("\tisRI: " + port.isRI()));
            intp.println((Object)("\tisRTS: " + port.isRTS()));
            intp.println((Object)("\tdataBits: " + port.getDataBits()));
            intp.println((Object)("\tendOfInputChar: " + port.getEndOfInputChar()));
            intp.println((Object)("\tflowControlMode: " + port.getFlowControlMode()));
            intp.println((Object)("\tinputBufferSize: " + port.getInputBufferSize()));
            intp.println((Object)("\toutputBufferSize: " + port.getOutputBufferSize()));
            intp.println((Object)("\tparity: " + port.getParity()));
            intp.println((Object)("\tparityErrorChar: " + port.getParityErrorChar()));
            intp.println((Object)("\treceiveFramingEnabled: " + port.isReceiveFramingEnabled()));
            intp.println((Object)("\treceiveFramingByte: " + port.getReceiveFramingByte()));
            intp.println((Object)("\treceiveThresholdEnabled: " + port.isReceiveThresholdEnabled()));
            intp.println((Object)("\treceiveThreshold: " + port.getReceiveThreshold()));
            intp.println((Object)("\treceiveTimeoutEnabled: " + port.isReceiveTimeoutEnabled()));
            intp.println((Object)("\treceiveTimeout: " + port.getReceiveTimeout()));
            intp.println((Object)("\tstopBits: " + port.getStopBits()));
            intp.println((Object)"===================================================");
        }
        catch (IllegalArgumentException e) {
            intp.println((Object)e.getMessage());
        }
        catch (Exception e) {
            intp.printStackTrace((Throwable)e);
        }
        return null;
    }

    public void _rxtxEnableEvents(CommandInterpreter intp) {
        try {
            String id = intp.nextArgument();
            this.assertNotNull(id, "usage: rxtxEnableEvents <id>");
            this.assertOpenPort(id);
            SerialPort port = this.m_openPorts.get(id);
            EventLogger listener = new EventLogger(intp);
            port.addEventListener((SerialPortEventListener)listener);
            port.notifyOnBreakInterrupt(true);
            port.notifyOnCarrierDetect(true);
            port.notifyOnCTS(true);
            port.notifyOnDataAvailable(true);
            port.notifyOnDSR(true);
            port.notifyOnFramingError(true);
            port.notifyOnOutputEmpty(true);
            port.notifyOnOverrunError(true);
            port.notifyOnParityError(true);
            port.notifyOnRingIndicator(true);
        }
        catch (TooManyListenersException e) {
            intp.printStackTrace((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            intp.println((Object)e.getMessage());
        }
    }

    public void _rxtxDisableEvents(CommandInterpreter intp) {
        try {
            String id = intp.nextArgument();
            this.assertNotNull(id, "usage: rxtxDisableEvents <id>");
            this.assertOpenPort(id);
            SerialPort port = this.m_openPorts.get(id);
            this.removeListener(port);
        }
        catch (IllegalArgumentException e) {
            intp.print((Object)e.getMessage());
        }
    }

    private void removeListener(SerialPort port) {
        port.notifyOnRingIndicator(false);
        port.notifyOnParityError(false);
        port.notifyOnOverrunError(false);
        port.notifyOnOutputEmpty(false);
        port.notifyOnFramingError(false);
        port.notifyOnDSR(false);
        port.notifyOnDataAvailable(false);
        port.notifyOnCTS(false);
        port.notifyOnCarrierDetect(false);
        port.notifyOnBreakInterrupt(false);
        port.removeEventListener();
    }

    public void _rxtxEventTest(CommandInterpreter intp) {
        try {
            String[] stringArray;
            String port = intp.nextArgument();
            String testString = intp.nextArgument();
            this.assertNotNull(port, "usage: rxtxEventTest <port>");
            if (testString == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = port;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = port;
                stringArray = stringArray3;
                stringArray3[1] = testString;
            }
            String[] args = stringArray;
            LoopbackEventTest.SerialEventHandler.main(args);
        }
        catch (IllegalArgumentException e) {
            intp.println((Object)e.getMessage());
        }
    }

    public String getHelp() {
        StringBuilder buf = new StringBuilder();
        buf.append("--- RXTX Commands ---").append("\n\t").append("rxtxVersion            -- display the rxtx version").append("\n\t").append("rxtxListPorts          -- list the available ports").append("\n\t").append("rxtxOpen <id> <port>   -- open <port> and assign to <id>").append("\n\t").append("rxtxClose <id>         -- close port <id>").append("\n\t").append("rxtxInfo <id>          -- print info about port <id>").append("\n\t").append("rxtxRead <id>          -- read all available bytes from port <id>").append("\n\t").append("rxtxWrite <id> <text>  -- write <text> to port <id> followed by \\r\\n").append("\n\t").append("rxtxLog <id>           -- redirect all bytes from port <id> to stdin").append("\n\t").append("rxtxUnlog <id>         -- stop redirectory of data from port <id>").append("\n\t").append("rxtxEnableEvents <id>  -- enable logging of events for port <id>").append("\n\t").append("rxtxDisableEvents <id> -- disable logging of events for port <id>").append("\n\t").append("rxtxEventTest <port>   -- test serial events on device").append("\n");
        return buf.toString();
    }

    public void stop() {
        for (Pipe pipe : this.m_loggingPorts.values()) {
            pipe.stop();
        }
        this.m_loggingPorts.clear();
        System.out.print("Closing " + this.m_openPorts.size() + " open comm ports... ");
        for (SerialPort port : this.m_openPorts.values()) {
            this.removeListener(port);
            port.close();
        }
        this.m_openPorts.clear();
        System.out.println("done.");
    }

    private void assertNotNull(Object arg, String msg) {
        this.assertFalse(arg == null, msg);
    }

    private void assertOpenPort(String id) {
        this.assertTrue(this.m_openPorts.containsKey(id), "No open port with id " + id + " found.");
    }

    private void assertTrue(boolean test, String msg) {
        if (!test) {
            throw new IllegalArgumentException(msg);
        }
    }

    private void assertFalse(boolean test, String msg) {
        if (test) {
            throw new IllegalArgumentException(msg);
        }
    }

    private final class EventLogger
    implements SerialPortEventListener {
        private final CommandInterpreter intp;

        private EventLogger(CommandInterpreter intp) {
            this.intp = intp;
        }

        public void serialEvent(SerialPortEvent ev) {
            switch (ev.getEventType()) {
                case 10: {
                    this.intp.println((Object)String.format("EVENT: Received BI event: changed %s to %s", ev.getOldValue(), ev.getNewValue()));
                    break;
                }
                case 6: {
                    this.intp.println((Object)String.format("EVENT: Received CD event: changed %s to %s", ev.getOldValue(), ev.getNewValue()));
                    break;
                }
                case 3: {
                    this.intp.println((Object)String.format("EVENT: Received CTS event: changed %s to %s", ev.getOldValue(), ev.getNewValue()));
                    break;
                }
                case 1: {
                    this.intp.println((Object)String.format("EVENT: Received DATA_AVAIL event: changed %s to %s", ev.getOldValue(), ev.getNewValue()));
                    break;
                }
                case 4: {
                    this.intp.println((Object)String.format("EVENT: Received DSR event: changed %s to %s", ev.getOldValue(), ev.getNewValue()));
                    break;
                }
                case 9: {
                    this.intp.println((Object)String.format("EVENT: Received FE event: changed %s to %s", ev.getOldValue(), ev.getNewValue()));
                    break;
                }
                case 7: {
                    this.intp.println((Object)String.format("EVENT: Received OE event: changed %s to %s", ev.getOldValue(), ev.getNewValue()));
                    break;
                }
                case 2: {
                    this.intp.println((Object)String.format("EVENT: Received OUT_BUF_EMPTY event: changed %s to %s", ev.getOldValue(), ev.getNewValue()));
                    break;
                }
                case 8: {
                    this.intp.println((Object)String.format("EVENT: Received PE event: changed %s to %s", ev.getOldValue(), ev.getNewValue()));
                    break;
                }
                case 5: {
                    this.intp.println((Object)String.format("EVENT: Received RI event: changed %s to %s", ev.getOldValue(), ev.getNewValue()));
                }
            }
        }
    }
}

