/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.rxtx.test.internal;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;

public class LoopbackEventTest {
    private SerialPort serialPort;
    private OutputStream outStream;
    private InputStream inStream;

    public void connect(String portName) throws IOException {
        try {
            CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)portName);
            this.serialPort = (SerialPort)portId.open("Demo application", 5000);
            this.setSerialPortParameters();
            this.outStream = this.serialPort.getOutputStream();
            this.inStream = this.serialPort.getInputStream();
        }
        catch (NoSuchPortException e) {
            throw new IOException(e.getMessage());
        }
        catch (PortInUseException e) {
            throw new IOException(e.getMessage());
        }
        catch (IOException e) {
            this.serialPort.close();
            throw e;
        }
    }

    public InputStream getSerialInputStream() {
        return this.inStream;
    }

    public OutputStream getSerialOutputStream() {
        return this.outStream;
    }

    public void addDataAvailableEventHandler(SerialPortEventListener eventHandler) {
        try {
            this.serialPort.addEventListener(eventHandler);
            this.serialPort.notifyOnDataAvailable(true);
        }
        catch (TooManyListenersException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public void disconnect() {
        if (this.serialPort != null) {
            try {
                this.outStream.close();
                this.inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serialPort.close();
        }
    }

    private void setSerialPortParameters() throws IOException {
        int baudRate = 57600;
        try {
            this.serialPort.setSerialPortParams(baudRate, 8, 1, 0);
            this.serialPort.setFlowControlMode(1);
        }
        catch (UnsupportedCommOperationException ex) {
            throw new IOException("Unsupported serial port parameter");
        }
    }

    public static class SerialEventHandler
    implements SerialPortEventListener {
        private InputStream inStream;
        private int readBufferLen;
        private int readBufferOffset;
        private byte[] readBuffer;

        public SerialEventHandler(InputStream inStream, int readBufferLen) {
            this.inStream = inStream;
            this.readBufferLen = readBufferLen;
            this.readBuffer = new byte[readBufferLen];
        }

        public boolean isBufferFull() {
            return this.readBufferOffset == this.readBufferLen;
        }

        public String getReadBuffer() {
            return new String(this.readBuffer);
        }

        public void serialEvent(SerialPortEvent event) {
            switch (event.getEventType()) {
                case 1: {
                    System.out.println("DATA_AVAILABLE");
                    this.readSerial();
                }
            }
        }

        private void readSerial() {
            try {
                int availableBytes = this.inStream.available();
                System.out.println("inStream " + availableBytes + " available");
                if (availableBytes > 0) {
                    int n = this.inStream.read(this.readBuffer, this.readBufferOffset, 1);
                    if (n > 0) {
                        byte b = this.readBuffer[this.readBufferOffset];
                        System.out.println(String.format("READ: %d bytes: %c (0x%02x)", n, Character.valueOf((char)b), b));
                        this.readBufferOffset += n;
                    } else {
                        System.out.println("No bytes read.");
                    }
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }

        public static void main(String[] args) {
            int TIMEOUT_VALUE = 10000;
            LoopbackEventTest loopbackTest = new LoopbackEventTest();
            try {
                long elapsedTime;
                loopbackTest.connect(args[0]);
                String testString = args.length < 2 ? "The quick brown fox jumps over the lazy dog" : args[1].replace("\\r", "\r").replace("\\n", "\n").replace("\\\\", "\\");
                InputStream inStream = loopbackTest.getSerialInputStream();
                String result = args.length < 3 ? testString : args[2].replace("\\r", "\r").replace("\\n", "\n").replace("\\\\", "\\");
                SerialEventHandler serialEventHandler = new SerialEventHandler(inStream, 2048);
                loopbackTest.addDataAvailableEventHandler(serialEventHandler);
                OutputStream outStream = loopbackTest.getSerialOutputStream();
                byte[] bytes = testString.getBytes();
                for (int i = 0; i < bytes.length; ++i) {
                    outStream.write(bytes[i]);
                }
                long startTime = System.currentTimeMillis();
                boolean matches = false;
                do {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    elapsedTime = System.currentTimeMillis() - startTime;
                    String actual = serialEventHandler.getReadBuffer();
                    matches = actual.equals(result);
                    System.out.println("Expected: " + result + " Actual: " + actual + " Equals? " + matches);
                } while (elapsedTime < 10000L && !matches);
                if (elapsedTime < 10000L) {
                    if (serialEventHandler.getReadBuffer().matches(result)) {
                        System.out.println("All data is received successfully");
                    } else {
                        System.out.println("Test failed");
                        System.out.println("Sent:" + testString);
                        System.out.println("Received:" + serialEventHandler.getReadBuffer());
                    }
                } else {
                    System.err.println("Timeout");
                }
                System.out.println("Test done");
                loopbackTest.disconnect();
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
        }
    }
}

