/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.situationfeedback.elastic;

import com.google.gson.Gson;
import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.client.JestClient;
import io.searchbox.core.Bulk;
import io.searchbox.core.Index;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.MetricAggregation;
import io.searchbox.core.search.aggregation.TermsAggregation;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.opennms.features.jest.client.bulk.BulkRequest;
import org.opennms.features.jest.client.bulk.BulkWrapper;
import org.opennms.features.jest.client.index.IndexStrategy;
import org.opennms.features.jest.client.template.IndexSettings;
import org.opennms.features.situationfeedback.api.AlarmFeedback;
import org.opennms.features.situationfeedback.api.AlarmFeedbackListener;
import org.opennms.features.situationfeedback.api.FeedbackException;
import org.opennms.features.situationfeedback.api.FeedbackRepository;
import org.opennms.features.situationfeedback.elastic.ElasticFeedbackRepositoryInitializer;
import org.opennms.features.situationfeedback.elastic.FeedbackDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticFeedbackRepository
implements FeedbackRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticFeedbackRepository.class);
    private static final String INDEX_NAME = "situation-feedback";
    private final Gson gson = new Gson();
    private final ElasticFeedbackRepositoryInitializer initializer;
    private final JestClient client;
    private final int bulkRetryCount;
    private final IndexSettings indexSettings;
    private IndexStrategy indexStrategy;
    private final Collection<AlarmFeedbackListener> alarmFeedbackListeners = new CopyOnWriteArrayList<AlarmFeedbackListener>();

    public ElasticFeedbackRepository(JestClient jestClient, IndexStrategy indexStrategy, int bulkRetryCount, ElasticFeedbackRepositoryInitializer initializer) {
        this.client = jestClient;
        this.indexStrategy = indexStrategy;
        this.bulkRetryCount = bulkRetryCount;
        this.initializer = initializer;
        this.indexSettings = initializer.getIndexSettings();
    }

    public void persist(List<AlarmFeedback> feedback) throws FeedbackException {
        this.ensureInitialized();
        if (LOG.isDebugEnabled()) {
            for (AlarmFeedback fb : feedback) {
                LOG.debug("Persisting {} feedback.", (Object)fb);
            }
        }
        List feedbackDocuments = feedback.stream().map(FeedbackDocument::from).collect(Collectors.toList());
        BulkRequest bulkRequest = new BulkRequest(this.client, feedbackDocuments, documents -> {
            Bulk.Builder bulkBuilder = new Bulk.Builder();
            for (FeedbackDocument document : documents) {
                String index = this.indexStrategy.getIndex(this.indexSettings, INDEX_NAME, (TemporalAccessor)Instant.ofEpochMilli(document.getTimestamp()));
                Index.Builder indexBuilder = (Index.Builder)new Index.Builder((Object)document).index(index);
                bulkBuilder.addAction((BulkableAction)indexBuilder.build());
            }
            return new BulkWrapper(bulkBuilder);
        }, this.bulkRetryCount);
        try {
            bulkRequest.execute();
        }
        catch (IOException e) {
            LOG.error("Failed to persist feedback [{}]: {}", feedback, (Object)e.getMessage());
            throw new FeedbackException("Failed to persist feedback", (Throwable)e);
        }
        this.notifyListeners(feedback);
    }

    public Collection<AlarmFeedback> getFeedback(String situationKey) throws FeedbackException {
        String query = "{\n  \"query\": { \"match\": { \"situation_key\": " + this.gson.toJson((Object)situationKey) + " } }\n}";
        return this.search(query);
    }

    public List<AlarmFeedback> getAllFeedback() throws FeedbackException {
        String query = "{\n\t\"query\": {\"match_all\": {}},\n\t\"sort\": [{\"@timestamp\": {\"order\" : \"asc\"}}]\n}";
        return this.search(query);
    }

    public List<String> getTags(String prefix) throws FeedbackException {
        SearchResult result;
        String query = "{\n  \"size\": 0,\n  \"aggs\": {\n    \"terms\": {\n      \"terms\": {\n        \"field\": \"tags\",\n        \"include\": \"" + this.gson.toJson((Object)prefix) + ".*\"\n      }\n    }\n  }\n}";
        Search.Builder builder = new Search.Builder(query);
        Search search = builder.build();
        try {
            result = (SearchResult)this.client.execute((Action)search);
        }
        catch (IOException e) {
            throw new FeedbackException("Failed to execute Tags search", (Throwable)e);
        }
        if (result == null) {
            return Collections.emptyList();
        }
        MetricAggregation aggregations = result.getAggregations();
        if (aggregations == null) {
            return Collections.emptyList();
        }
        TermsAggregation terms = aggregations.getTermsAggregation("terms");
        if (terms == null) {
            return Collections.emptyList();
        }
        return terms.getBuckets().stream().map(TermsAggregation.Entry::getKey).collect(Collectors.toList());
    }

    public synchronized void onBind(AlarmFeedbackListener alarmFeedbackListener, Map properties) {
        LOG.debug("bind called with {}: {}", (Object)alarmFeedbackListener, (Object)properties);
        if (alarmFeedbackListener != null) {
            this.alarmFeedbackListeners.add(alarmFeedbackListener);
        }
    }

    public synchronized void onUnbind(AlarmFeedbackListener alarmFeedbackListener, Map properties) {
        LOG.debug("Unbind called with {}: {}", (Object)alarmFeedbackListener, (Object)properties);
        if (alarmFeedbackListener != null) {
            this.alarmFeedbackListeners.remove(alarmFeedbackListener);
        }
    }

    private void notifyListeners(List<AlarmFeedback> feedback) {
        LOG.debug("Notifying listeners {} of feedback {}", this.alarmFeedbackListeners, feedback);
        this.alarmFeedbackListeners.forEach(listener -> {
            try {
                LOG.trace("Notifying listener {}", listener);
                listener.handleAlarmFeedback(feedback);
            }
            catch (Exception e) {
                LOG.warn("Failed to notify listener of alarm feedback", (Throwable)e);
            }
        });
    }

    private List<AlarmFeedback> search(String query) throws FeedbackException {
        Search.Builder builder = new Search.Builder(query);
        try {
            return this.execute(builder.build());
        }
        catch (IOException e) {
            throw new FeedbackException("Failed to get feedback for query: " + query, (Throwable)e);
        }
    }

    private List<AlarmFeedback> execute(Search search) throws IOException, FeedbackException {
        SearchResult result = (SearchResult)this.client.execute((Action)search);
        if (result == null) {
            throw new FeedbackException("Failed to get result");
        }
        List feedback = result.getHits(FeedbackDocument.class);
        if (feedback == null) {
            return Collections.emptyList();
        }
        return feedback.stream().map(hit -> (FeedbackDocument)hit.source).map(FeedbackDocument::toAlarmFeedback).collect(Collectors.toList());
    }

    private void ensureInitialized() {
        if (!this.initializer.isInitialized()) {
            LOG.debug("Initializing Repository.");
            this.initializer.initialize();
        }
    }
}

