/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.situationfeedback.elastic;

import com.google.gson.annotations.SerializedName;
import org.opennms.features.situationfeedback.api.AlarmFeedback;

public class FeedbackDocument {
    private static final int DOCUMENT_VERSION = 1;
    @SerializedName(value="@timestamp")
    private long timestamp;
    @SerializedName(value="@version")
    private final Integer version = 1;
    @SerializedName(value="alarm_key")
    private String alarmKey;
    @SerializedName(value="feedback_type")
    private String feedbackType;
    @SerializedName(value="situation_fingerprint")
    private String situationFingerprint;
    @SerializedName(value="situation_key")
    private String situationKey;
    @SerializedName(value="reason")
    private String reason;
    @SerializedName(value="user")
    private String user;

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getAlarmKey() {
        return this.alarmKey;
    }

    public void setAlarmKey(String alarmKey) {
        this.alarmKey = alarmKey;
    }

    public String getFeedbackType() {
        return this.feedbackType;
    }

    public void setFeedbackType(String feedbackType) {
        this.feedbackType = feedbackType;
    }

    public String getSituationFingerprint() {
        return this.situationFingerprint;
    }

    public void setSituationFingerprint(String situationFingerprint) {
        this.situationFingerprint = situationFingerprint;
    }

    public String getSituationKey() {
        return this.situationKey;
    }

    public void setSituationKey(String situationKey) {
        this.situationKey = situationKey;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public static FeedbackDocument from(AlarmFeedback feedback) {
        FeedbackDocument doc = new FeedbackDocument();
        doc.setTimestamp(System.currentTimeMillis());
        doc.setAlarmKey(feedback.getAlarmKey());
        doc.setFeedbackType(feedback.getFeedbackType().toString());
        doc.setReason(feedback.getReason());
        doc.setSituationFingerprint(feedback.getSituationFingerprint());
        doc.setSituationKey(feedback.getSituationKey());
        doc.setUser(feedback.getUser());
        return doc;
    }

    public static AlarmFeedback toAlarmFeedback(FeedbackDocument doc) {
        return new AlarmFeedback(doc.situationKey, doc.situationFingerprint, doc.alarmKey, AlarmFeedback.FeedbackType.getType((String)doc.feedbackType), doc.reason, doc.user, doc.timestamp);
    }
}

