/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.situationfeedback.elastic;

import com.google.gson.Gson;
import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.client.JestClient;
import io.searchbox.core.Bulk;
import io.searchbox.core.Index;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.features.situationfeedback.api.AlarmFeedback;
import org.opennms.features.situationfeedback.api.FeedbackException;
import org.opennms.features.situationfeedback.api.FeedbackRepository;
import org.opennms.features.situationfeedback.elastic.ElasticFeedbackRepositoryInitializer;
import org.opennms.features.situationfeedback.elastic.FeedbackDocument;
import org.opennms.plugins.elasticsearch.rest.bulk.BulkRequest;
import org.opennms.plugins.elasticsearch.rest.bulk.BulkWrapper;
import org.opennms.plugins.elasticsearch.rest.index.IndexStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticFeedbackRepository
implements FeedbackRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticFeedbackRepository.class);
    private static final String TYPE = "situation-feedback";
    private final Gson gson = new Gson();
    private final ElasticFeedbackRepositoryInitializer initializer;
    private final JestClient client;
    private final int bulkRetryCount;
    private IndexStrategy indexStrategy;

    public ElasticFeedbackRepository(JestClient jestClient, IndexStrategy indexStrategy, int bulkRetryCount, ElasticFeedbackRepositoryInitializer initializer) {
        this.client = jestClient;
        this.indexStrategy = indexStrategy;
        this.bulkRetryCount = bulkRetryCount;
        this.initializer = initializer;
    }

    public void persist(Collection<AlarmFeedback> feedback) throws FeedbackException {
        this.ensureInitialized();
        if (LOG.isDebugEnabled()) {
            for (AlarmFeedback fb : feedback) {
                LOG.debug("Persiting {} feedback.", (Object)fb);
            }
        }
        List feedbackDocuments = feedback.stream().map(FeedbackDocument::from).collect(Collectors.toList());
        BulkRequest bulkRequest = new BulkRequest(this.client, feedbackDocuments, documents -> {
            Bulk.Builder bulkBuilder = new Bulk.Builder();
            for (FeedbackDocument document : documents) {
                String index = this.indexStrategy.getIndex(TYPE, (TemporalAccessor)Instant.ofEpochMilli(document.getTimestamp()));
                Index.Builder indexBuilder = (Index.Builder)((Index.Builder)new Index.Builder((Object)document).index(index)).type(TYPE);
                bulkBuilder.addAction((BulkableAction)indexBuilder.build());
            }
            return new BulkWrapper(bulkBuilder);
        }, this.bulkRetryCount);
        try {
            bulkRequest.execute();
        }
        catch (IOException e) {
            LOG.error("Failed to persist feedback [{}]: {}", feedback, (Object)e.getMessage());
            throw new FeedbackException("Failed to persist feedback", (Throwable)e);
        }
    }

    public Collection<AlarmFeedback> getFeedback(String situationKey) throws FeedbackException {
        String query = "{\n  \"query\": { \"match\": { \"situation_key\": " + this.gson.toJson((Object)situationKey) + " } }\n}";
        return this.search(query);
    }

    private Collection<AlarmFeedback> search(String query) throws FeedbackException {
        Search.Builder builder = (Search.Builder)new Search.Builder(query).addType(TYPE);
        try {
            return this.execute(builder.build());
        }
        catch (IOException e) {
            throw new FeedbackException("Failed to get feedback for query: " + query, (Throwable)e);
        }
    }

    private Collection<AlarmFeedback> execute(Search search) throws IOException, FeedbackException {
        SearchResult result = (SearchResult)this.client.execute((Action)search);
        if (result == null) {
            throw new FeedbackException("Failed to get result");
        }
        List feedback = result.getHits(FeedbackDocument.class);
        if (feedback == null) {
            return Collections.emptyList();
        }
        return feedback.stream().map(hit -> (FeedbackDocument)hit.source).map(FeedbackDocument::toAlarmFeedback).collect(Collectors.toList());
    }

    private void ensureInitialized() {
        if (!this.initializer.isInitialized()) {
            LOG.debug("Initializing Repository.");
            this.initializer.initialize();
        }
    }
}

