/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import io.searchbox.action.BulkableAction;
import io.searchbox.client.JestClient;
import io.searchbox.core.Bulk;
import io.searchbox.core.Index;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opennms.core.tracing.api.TracerRegistry;
import org.opennms.distributed.core.api.Identity;
import org.opennms.features.jest.client.bulk.BulkException;
import org.opennms.features.jest.client.bulk.BulkRequest;
import org.opennms.features.jest.client.bulk.BulkWrapper;
import org.opennms.features.jest.client.index.IndexStrategy;
import org.opennms.features.jest.client.template.IndexSettings;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.flows.api.Conversation;
import org.opennms.netmgt.flows.api.Directional;
import org.opennms.netmgt.flows.api.EnrichedFlowForwarder;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.flows.api.FlowException;
import org.opennms.netmgt.flows.api.FlowRepository;
import org.opennms.netmgt.flows.api.FlowSource;
import org.opennms.netmgt.flows.api.Host;
import org.opennms.netmgt.flows.api.TrafficSummary;
import org.opennms.netmgt.flows.elastic.Direction;
import org.opennms.netmgt.flows.elastic.DocumentEnricher;
import org.opennms.netmgt.flows.elastic.FlowDocument;
import org.opennms.netmgt.flows.elastic.PersistenceException;
import org.opennms.netmgt.flows.elastic.SmartQueryService;
import org.opennms.netmgt.flows.filter.api.Filter;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticFlowRepository
implements FlowRepository {
    public static final String TRACER_FLOW_MODULE = "ElasticFlow";
    private static final Logger LOG = LoggerFactory.getLogger(ElasticFlowRepository.class);
    private final RateLimitedLog RATE_LIMITED_LOGGER = RateLimitedLog.withRateLimit((Logger)LOG).maxRate(5).every(Duration.ofSeconds(30L)).build();
    private static final String INDEX_NAME = "netflow";
    private final JestClient client;
    private final IndexStrategy indexStrategy;
    private final DocumentEnricher documentEnricher;
    private final Meter flowsPersistedMeter;
    private final Timer logEnrichementTimer;
    private final Timer logPersistingTimer;
    private final Timer logMarkingTimer;
    private final Histogram flowsPerLog;
    private final Counter emptyFlows;
    private final SessionUtils sessionUtils;
    private final NodeDao nodeDao;
    private final SnmpInterfaceDao snmpInterfaceDao;
    private final Identity identity;
    private final TracerRegistry tracerRegistry;
    private final IndexSettings indexSettings;
    private final SmartQueryService smartQueryService;
    private final EnrichedFlowForwarder enrichedFlowForwarder;
    private boolean enableFlowForwarding = false;
    private int bulkRetryCount = 1;
    private boolean skipElasticsearchPersistence = false;
    private final Map<Direction, Cache<Integer, Set<Integer>>> markerCache = Maps.newEnumMap(Direction.class);

    public ElasticFlowRepository(MetricRegistry metricRegistry, JestClient jestClient, IndexStrategy indexStrategy, DocumentEnricher documentEnricher, SessionUtils sessionUtils, NodeDao nodeDao, SnmpInterfaceDao snmpInterfaceDao, Identity identity, TracerRegistry tracerRegistry, EnrichedFlowForwarder enrichedFlowForwarder, IndexSettings indexSettings, SmartQueryService smartQueryService) {
        this.client = Objects.requireNonNull(jestClient);
        this.indexStrategy = Objects.requireNonNull(indexStrategy);
        this.documentEnricher = Objects.requireNonNull(documentEnricher);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.snmpInterfaceDao = Objects.requireNonNull(snmpInterfaceDao);
        this.identity = identity;
        this.tracerRegistry = tracerRegistry;
        this.enrichedFlowForwarder = enrichedFlowForwarder;
        this.indexSettings = Objects.requireNonNull(indexSettings);
        this.smartQueryService = Objects.requireNonNull(smartQueryService);
        this.emptyFlows = metricRegistry.counter("emptyFlows");
        this.flowsPersistedMeter = metricRegistry.meter("flowsPersisted");
        this.logEnrichementTimer = metricRegistry.timer("logEnrichment");
        this.logPersistingTimer = metricRegistry.timer("logPersisting");
        this.logMarkingTimer = metricRegistry.timer("logMarking");
        this.flowsPerLog = metricRegistry.histogram("flowsPerLog");
        this.markerCache.put(Direction.INGRESS, (Cache<Integer, Set<Integer>>)CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build());
        this.markerCache.put(Direction.EGRESS, (Cache<Integer, Set<Integer>>)CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build());
        this.sessionUtils.withTransaction(() -> {
            for (OnmsNode node : this.nodeDao.findAllHavingIngressFlows()) {
                this.markerCache.get((Object)Direction.INGRESS).put((Object)node.getId(), (Object)this.snmpInterfaceDao.findAllHavingIngressFlows(node.getId()).stream().map(OnmsSnmpInterface::getIfIndex).collect(Collectors.toCollection(Sets::newConcurrentHashSet)));
            }
            for (OnmsNode node : this.nodeDao.findAllHavingEgressFlows()) {
                this.markerCache.get((Object)Direction.EGRESS).put((Object)node.getId(), (Object)this.snmpInterfaceDao.findAllHavingEgressFlows(node.getId()).stream().map(OnmsSnmpInterface::getIfIndex).collect(Collectors.toCollection(Sets::newConcurrentHashSet)));
            }
            return null;
        });
    }

    public void persist(Collection<Flow> flows, FlowSource source) throws FlowException {
        List<FlowDocument> flowDocuments;
        Throwable throwable;
        Timer.Context ctx;
        this.flowsPerLog.update(flows.size());
        if (flows.isEmpty()) {
            this.emptyFlows.inc();
            LOG.info("Received empty flows from {} @ {}. Nothing to do.", (Object)source.getSourceAddress(), (Object)source.getLocation());
            return;
        }
        LOG.debug("Enriching {} flow documents.", (Object)flows.size());
        try {
            ctx = this.logEnrichementTimer.time();
            throwable = null;
            try {
                flowDocuments = this.documentEnricher.enrich(flows, source);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ctx != null) {
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new FlowException("Failed to enrich one or more flows.", (Throwable)e);
        }
        if (this.enableFlowForwarding) {
            LOG.debug("Forwarding {} flow documents.", (Object)flowDocuments.size());
            flowDocuments.stream().map(FlowDocument::buildEnrichedFlow).forEach(arg_0 -> ((EnrichedFlowForwarder)this.enrichedFlowForwarder).forward(arg_0));
        }
        if (this.skipElasticsearchPersistence) {
            this.RATE_LIMITED_LOGGER.info("Flow persistence disabled. Dropping {} flow documents.", (Object)flowDocuments.size());
        } else {
            LOG.debug("Persisting {} flow documents.", (Object)flowDocuments.size());
            Tracer tracer = this.getTracer();
            try (Timer.Context ctx2 = this.logPersistingTimer.time();){
                Scope scope = tracer.buildSpan(TRACER_FLOW_MODULE).startActive(true);
                Object object = null;
                try {
                    scope.span().setTag("location", source.getLocation());
                    scope.span().setTag("sourceAddress", source.getSourceAddress());
                    scope.span().setTag("thread", Thread.currentThread().getName());
                    BulkRequest bulkRequest = new BulkRequest(this.client, flowDocuments, documents -> {
                        Bulk.Builder bulkBuilder = new Bulk.Builder();
                        for (FlowDocument flowDocument : documents) {
                            String index = this.indexStrategy.getIndex(this.indexSettings, INDEX_NAME, (TemporalAccessor)Instant.ofEpochMilli(flowDocument.getTimestamp()));
                            Index.Builder indexBuilder = (Index.Builder)new Index.Builder((Object)flowDocument).index(index);
                            bulkBuilder.addAction((BulkableAction)indexBuilder.build());
                        }
                        return new BulkWrapper(bulkBuilder);
                    }, this.bulkRetryCount);
                    try {
                        bulkRequest.execute();
                    }
                    catch (BulkException ex) {
                        throw new PersistenceException(ex.getMessage(), ex.getBulkResult().getFailedDocuments());
                    }
                    catch (IOException ex) {
                        LOG.error("An error occurred while executing the given request: {}", (Object)ex.getMessage(), (Object)ex);
                        throw new FlowException(ex.getMessage(), (Throwable)ex);
                    }
                    this.flowsPersistedMeter.mark((long)flowDocuments.size());
                }
                catch (Throwable bulkRequest) {
                    object = bulkRequest;
                    throw bulkRequest;
                }
                finally {
                    if (scope != null) {
                        if (object != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable bulkRequest) {
                                ((Throwable)object).addSuppressed(bulkRequest);
                            }
                        } else {
                            scope.close();
                        }
                    }
                }
            }
        }
        ctx = this.logMarkingTimer.time();
        throwable = null;
        try {
            EnumMap nodesToUpdate = Maps.newEnumMap(Direction.class);
            EnumMap interfacesToUpdate = Maps.newEnumMap(Direction.class);
            nodesToUpdate.put(Direction.INGRESS, Lists.newArrayListWithExpectedSize((int)flowDocuments.size()));
            nodesToUpdate.put(Direction.EGRESS, Lists.newArrayListWithExpectedSize((int)flowDocuments.size()));
            interfacesToUpdate.put(Direction.INGRESS, Maps.newHashMap());
            interfacesToUpdate.put(Direction.EGRESS, Maps.newHashMap());
            for (FlowDocument flow : flowDocuments) {
                if (flow.getNodeExporter() == null || flow.getNodeExporter().getNodeId() == null) continue;
                Integer nodeId = flow.getNodeExporter().getNodeId();
                Set ifaceMarkerCache = (Set)this.markerCache.get((Object)flow.getDirection()).getIfPresent((Object)nodeId);
                if (ifaceMarkerCache == null) {
                    ifaceMarkerCache = Sets.newConcurrentHashSet();
                    this.markerCache.get((Object)flow.getDirection()).put((Object)nodeId, (Object)ifaceMarkerCache);
                    ((List)nodesToUpdate.get((Object)flow.getDirection())).add(nodeId);
                }
                if (flow.getInputSnmp() != null && flow.getInputSnmp() != 0 && flow.getDirection() == Direction.INGRESS && !ifaceMarkerCache.contains(flow.getInputSnmp())) {
                    ifaceMarkerCache.add(flow.getInputSnmp());
                    ((Map)interfacesToUpdate.get((Object)flow.getDirection())).computeIfAbsent(nodeId, k -> Lists.newArrayList()).add(flow.getInputSnmp());
                }
                if (flow.getOutputSnmp() == null || flow.getOutputSnmp() == 0 || flow.getDirection() != Direction.EGRESS || ifaceMarkerCache.contains(flow.getOutputSnmp())) continue;
                ifaceMarkerCache.add(flow.getOutputSnmp());
                ((Map)interfacesToUpdate.get((Object)flow.getDirection())).computeIfAbsent(nodeId, k -> Lists.newArrayList()).add(flow.getOutputSnmp());
            }
            if (!(((List)nodesToUpdate.get((Object)Direction.INGRESS)).isEmpty() && ((Map)interfacesToUpdate.get((Object)Direction.INGRESS)).isEmpty() && ((List)nodesToUpdate.get((Object)Direction.EGRESS)).isEmpty() && ((Map)interfacesToUpdate.get((Object)Direction.EGRESS)).isEmpty())) {
                this.sessionUtils.withTransaction(() -> {
                    if (!((List)nodesToUpdate.get((Object)Direction.INGRESS)).isEmpty() || !((List)nodesToUpdate.get((Object)Direction.EGRESS)).isEmpty()) {
                        this.nodeDao.markHavingFlows((Collection)nodesToUpdate.get((Object)Direction.INGRESS), (Collection)nodesToUpdate.get((Object)Direction.EGRESS));
                    }
                    for (Map.Entry e : ((Map)interfacesToUpdate.get((Object)Direction.INGRESS)).entrySet()) {
                        this.snmpInterfaceDao.markHavingIngressFlows((Integer)e.getKey(), (Collection)e.getValue());
                    }
                    for (Map.Entry e : ((Map)interfacesToUpdate.get((Object)Direction.EGRESS)).entrySet()) {
                        this.snmpInterfaceDao.markHavingEgressFlows((Integer)e.getKey(), (Collection)e.getValue());
                    }
                    return null;
                });
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (ctx != null) {
                if (throwable != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    ctx.close();
                }
            }
        }
    }

    public CompletableFuture<Long> getFlowCount(List<Filter> filters) {
        return this.smartQueryService.getFlowCount(filters);
    }

    public CompletableFuture<List<String>> getApplications(String matchingPrefix, long limit, List<Filter> filters) {
        return this.smartQueryService.getApplications(matchingPrefix, limit, filters);
    }

    public CompletableFuture<List<TrafficSummary<String>>> getTopNApplicationSummaries(int N, boolean includeOther, List<Filter> filters) {
        return this.smartQueryService.getTopNApplicationSummaries(N, includeOther, filters);
    }

    public CompletableFuture<List<TrafficSummary<String>>> getApplicationSummaries(Set<String> applications, boolean includeOther, List<Filter> filters) {
        return this.smartQueryService.getApplicationSummaries(applications, includeOther, filters);
    }

    public CompletableFuture<Table<Directional<String>, Long, Double>> getApplicationSeries(Set<String> applications, long step, boolean includeOther, List<Filter> filters) {
        return this.smartQueryService.getApplicationSeries(applications, step, includeOther, filters);
    }

    public CompletableFuture<Table<Directional<String>, Long, Double>> getTopNApplicationSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.smartQueryService.getTopNApplicationSeries(N, step, includeOther, filters);
    }

    public CompletableFuture<List<String>> getConversations(String locationPattern, String protocolPattern, String lowerIPPattern, String upperIPPattern, String applicationPattern, long limit, List<Filter> filters) {
        return this.smartQueryService.getConversations(locationPattern, protocolPattern, lowerIPPattern, upperIPPattern, applicationPattern, limit, filters);
    }

    public CompletableFuture<List<TrafficSummary<Conversation>>> getTopNConversationSummaries(int N, boolean includeOther, List<Filter> filters) {
        return this.smartQueryService.getTopNConversationSummaries(N, includeOther, filters);
    }

    public CompletableFuture<List<TrafficSummary<Conversation>>> getConversationSummaries(Set<String> conversations, boolean includeOther, List<Filter> filters) {
        return this.smartQueryService.getConversationSummaries(conversations, includeOther, filters);
    }

    public CompletableFuture<Table<Directional<Conversation>, Long, Double>> getConversationSeries(Set<String> conversations, long step, boolean includeOther, List<Filter> filters) {
        return this.smartQueryService.getConversationSeries(conversations, step, includeOther, filters);
    }

    public CompletableFuture<Table<Directional<Conversation>, Long, Double>> getTopNConversationSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.smartQueryService.getTopNConversationSeries(N, step, includeOther, filters);
    }

    public CompletableFuture<List<String>> getHosts(String regex, long limit, List<Filter> filters) {
        return this.smartQueryService.getHosts(regex, limit, filters);
    }

    public CompletableFuture<List<TrafficSummary<Host>>> getTopNHostSummaries(int N, boolean includeOther, List<Filter> filters) {
        return this.smartQueryService.getTopNHostSummaries(N, includeOther, filters);
    }

    public CompletableFuture<List<TrafficSummary<Host>>> getHostSummaries(Set<String> hosts, boolean includeOther, List<Filter> filters) {
        return this.smartQueryService.getHostSummaries(hosts, includeOther, filters);
    }

    public CompletableFuture<Table<Directional<Host>, Long, Double>> getHostSeries(Set<String> hosts, long step, boolean includeOther, List<Filter> filters) {
        return this.smartQueryService.getHostSeries(hosts, step, includeOther, filters);
    }

    public CompletableFuture<Table<Directional<Host>, Long, Double>> getTopNHostSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.smartQueryService.getTopNHostSeries(N, step, includeOther, filters);
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public TracerRegistry getTracerRegistry() {
        return this.tracerRegistry;
    }

    public void start() {
        if (this.tracerRegistry != null && this.identity != null) {
            this.tracerRegistry.init(this.identity.getId());
        }
    }

    private Tracer getTracer() {
        if (this.tracerRegistry != null) {
            return this.tracerRegistry.getTracer();
        }
        return GlobalTracer.get();
    }

    public boolean isEnableFlowForwarding() {
        return this.enableFlowForwarding;
    }

    public void setEnableFlowForwarding(boolean enableFlowForwarding) {
        this.enableFlowForwarding = enableFlowForwarding;
    }

    public int getBulkRetryCount() {
        return this.bulkRetryCount;
    }

    public void setBulkRetryCount(int bulkRetryCount) {
        this.bulkRetryCount = bulkRetryCount;
    }

    public boolean isSkipElasticsearchPersistence() {
        return this.skipElasticsearchPersistence;
    }

    public void setSkipElasticsearchPersistence(boolean skipElasticsearchPersistence) {
        this.skipElasticsearchPersistence = skipElasticsearchPersistence;
    }
}

