/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.opennms.features.jest.client.index.IndexSelector;
import org.opennms.netmgt.flows.api.Directional;
import org.opennms.netmgt.flows.api.FlowQueryService;
import org.opennms.netmgt.flows.filter.api.TimeRangeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElasticFlowQueryService
implements FlowQueryService {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticFlowQueryService.class);
    private final JestClient client;
    private final IndexSelector indexSelector;

    public ElasticFlowQueryService(JestClient client, IndexSelector indexSelector) {
        this.client = Objects.requireNonNull(client);
        this.indexSelector = Objects.requireNonNull(indexSelector);
    }

    protected static <T> CompletableFuture<Table<Directional<T>, Long, Double>> mapTable(Table<Directional<String>, Long, Double> source, Function<String, CompletableFuture<T>> fn) {
        Set columnKeys = source.columnKeySet();
        List<CompletableFuture<T>> rowKeys = source.rowKeySet().stream().map(rk -> ((CompletableFuture)fn.apply((String)rk.getValue())).thenApply(t -> Maps.immutableEntry((Object)new Directional(t, rk.isIngress()), (Object)source.row(rk)))).collect(Collectors.toList());
        return ElasticFlowQueryService.transpose(rowKeys, Collectors.toList()).thenApply(rows -> {
            ImmutableTable.Builder target = ImmutableTable.builder();
            for (Map.Entry row : rows) {
                for (Long columnKey : columnKeys) {
                    Double value = (Double)((Map)row.getValue()).get(columnKey);
                    if (value == null) {
                        value = Double.NaN;
                    }
                    target.put(row.getKey(), (Object)columnKey, (Object)value);
                }
            }
            return target.build();
        });
    }

    protected static <T, A, R> CompletableFuture<R> transpose(Collection<CompletableFuture<T>> futures, Collector<? super T, A, R> collector) {
        return CompletableFuture.allOf((CompletableFuture[])Iterables.toArray(futures, CompletableFuture.class)).thenApply(v -> futures.stream().map(CompletableFuture::join).collect(collector));
    }

    public CompletableFuture<SearchResult> searchAsync(String query, TimeRangeFilter timeRangeFilter) {
        Search.Builder builder = new Search.Builder(query);
        if (timeRangeFilter != null) {
            List indices = this.indexSelector.getIndexNames(timeRangeFilter.getStart(), timeRangeFilter.getEnd());
            builder.addIndices((Collection)indices);
            builder.setParameter("ignore_unavailable", (Object)"true");
            LOG.debug("Executing asynchronous query on {}: {}", (Object)indices, (Object)query);
        } else {
            LOG.debug("Executing asynchronous query on all indices: {}", (Object)query);
        }
        return this.executeAsync((Action)builder.build());
    }

    public <T extends JestResult> CompletableFuture<T> executeAsync(Action<T> action) {
        final CompletableFuture future = new CompletableFuture();
        this.client.executeAsync(action, new JestResultHandler<T>(){

            public void completed(T result) {
                if (!result.isSucceeded()) {
                    future.completeExceptionally(new Exception(result.getErrorMessage()));
                } else {
                    future.complete(result);
                }
            }

            public void failed(Exception ex) {
                future.completeExceptionally(ex);
            }
        });
        return future;
    }
}

