/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.dao.api.FilterWatcher;
import org.opennms.netmgt.dao.api.ServiceRef;
import org.opennms.netmgt.dao.api.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultServiceTracker
implements ServiceTracker {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServiceTracker.class);
    @Autowired
    private FilterWatcher filterWatcher;
    private final List<TrackingSession> trackingSessions = new LinkedList<TrackingSession>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Closeable trackServiceMatchingFilterRule(String serviceName, String filterRule, ServiceTracker.ServiceListener listener) {
        TrackingSession trackingSession;
        if (StringUtils.isEmpty((String)serviceName)) {
            throw new IllegalArgumentException("Service name is required, but was given: " + serviceName);
        }
        List<TrackingSession> list = this.trackingSessions;
        synchronized (list) {
            trackingSession = new TrackingSession(serviceName, filterRule, listener);
            this.trackingSessions.add(trackingSession);
        }
        return trackingSession;
    }

    @Override
    public Closeable trackService(String serviceName, ServiceTracker.ServiceListener listener) {
        return this.trackServiceMatchingFilterRule(serviceName, null, listener);
    }

    public void setFilterWatcher(FilterWatcher filterWatcher) {
        this.filterWatcher = filterWatcher;
    }

    private class TrackingSession
    implements Closeable {
        private final String serviceName;
        private final String filterRule;
        private final Closeable filterSession;
        private final ServiceTracker.ServiceListener listener;
        private final Set<ServiceRef> activeServices = new HashSet<ServiceRef>();

        public TrackingSession(String serviceName, String filterRule, ServiceTracker.ServiceListener listener) {
            this.serviceName = Objects.requireNonNull(serviceName);
            this.listener = Objects.requireNonNull(listener);
            this.filterRule = filterRule;
            this.filterSession = DefaultServiceTracker.this.filterWatcher.watch(filterRule, this::onFilterChanged);
        }

        private void onFilterChanged(FilterWatcher.FilterResults results) {
            Set<ServiceRef> candidateServices = results.getServicesNamed(this.serviceName);
            Sets.SetView servicesToAdd = Sets.difference(candidateServices, this.activeServices);
            Sets.SetView servicesToRemove = Sets.difference(this.activeServices, candidateServices);
            for (ServiceRef service : servicesToAdd) {
                this.activeServices.add(service);
                this.listener.onServiceMatched(service);
            }
            for (ServiceRef service : servicesToRemove) {
                this.activeServices.remove(service);
                this.listener.onServiceStoppedMatching(service);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            List list = DefaultServiceTracker.this.trackingSessions;
            synchronized (list) {
                DefaultServiceTracker.this.trackingSessions.remove(this);
                try {
                    this.filterSession.close();
                }
                catch (IOException e) {
                    LOG.warn("Error closing session for filter rule: {}. Some resources may not be cleaned up properly.", (Object)this.filterRule);
                }
            }
        }
    }
}

