/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.model.HeatMapElement;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.model.outage.CurrentOutageDetails;
import org.opennms.netmgt.model.outage.OutageSummary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.HibernateCallback;

public class OutageDaoHibernate
extends AbstractDaoHibernate<OnmsOutage, Integer>
implements OutageDao {
    @Autowired
    private FilterDao m_filterDao;

    public OutageDaoHibernate() {
        super(OnmsOutage.class);
    }

    @Override
    public Integer currentOutageCount() {
        return this.queryInt("select count(*) from OnmsOutage as o where o.perspective is null and o.ifRegainedService is null");
    }

    @Override
    public Collection<OnmsOutage> currentOutages() {
        return this.find("from OnmsOutage as o where o.perspective is null and o.ifRegainedService is null");
    }

    @Override
    public OnmsOutage currentOutageForService(OnmsMonitoredService service) {
        return (OnmsOutage)this.findUnique("from OnmsOutage as o where o.perspective is null and o.monitoredService = ? and o.ifRegainedService is null", service);
    }

    @Override
    public OnmsOutage currentOutageForServiceFromPerspective(OnmsMonitoredService service, OnmsMonitoringLocation perspective) {
        return (OnmsOutage)this.findUnique("from OnmsOutage as o where o.monitoredService = ? and o.perspective = ? and o.ifRegainedService is null", service, perspective);
    }

    @Override
    public Collection<OnmsOutage> currentOutagesForServiceFromPerspectivePoller(OnmsMonitoredService service) {
        return this.find("from OnmsOutage as o where o.monitoredService = ?  and o.perspective is not null and o.ifRegainedService is null", service);
    }

    @Override
    public Collection<OnmsOutage> findAll(final Integer offset, final Integer limit) {
        return (Collection)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Collection<OnmsOutage>>(){

            public Collection<OnmsOutage> doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(OnmsOutage.class).setFirstResult(offset.intValue()).setMaxResults(limit.intValue()).list();
            }
        });
    }

    @Override
    public Collection<CurrentOutageDetails> newestCurrentOutages(final List<String> serviceNames) {
        return (Collection)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<CurrentOutageDetails>>(){

            public List<CurrentOutageDetails> doInHibernate(Session session) throws HibernateException, SQLException {
                StringBuilder query = new StringBuilder().append("SELECT DISTINCT\n").append("        outages.outageId,\n").append("        outages.ifServiceId AS monitoredServiceId,\n").append("        service.serviceName AS serviceName,\n").append("        outages.ifLostService,\n").append("        node.nodeId,\n").append("        node.foreignSource,\n").append("        node.foreignId,\n").append("        node.location\n").append("FROM outages\n").append("        LEFT JOIN ifServices ON outages.ifServiceId = ifServices.id\n").append("        LEFT JOIN service ON ifServices.serviceId = service.serviceId\n").append("        LEFT JOIN ipInterface ON ifServices.ipInterfaceId = ipInterface.id\n").append("        LEFT JOIN node ON ipInterface.nodeId = node.nodeId\n").append("WHERE\n").append("        outages.ifRegainedService IS NULL AND outages.perspective IS NULL\n");
                if (serviceNames.size() > 0) {
                    query.append("        AND service.serviceName IN ( :serviceNames )\n");
                }
                query.append("ORDER BY outages.outageId\n").append(";\n");
                SQLQuery sqlQuery = session.createSQLQuery(query.toString());
                if (serviceNames.size() > 0) {
                    sqlQuery = sqlQuery.setParameterList("serviceNames", (Collection)serviceNames);
                }
                return sqlQuery.setResultTransformer(new ResultTransformer(){
                    private static final long serialVersionUID = 1L;

                    public Object transformTuple(Object[] tuple, String[] aliases) {
                        return new CurrentOutageDetails((Integer)tuple[0], (Integer)tuple[1], (String)tuple[2], (Date)tuple[3], (Integer)tuple[4], (String)tuple[5], (String)tuple[6], (String)tuple[7]);
                    }

                    public List transformList(List collection) {
                        return collection;
                    }
                }).list();
            }
        });
    }

    @Override
    public Collection<OnmsOutage> matchingCurrentOutages(ServiceSelector selector) {
        HashSet matchingAddrs = new HashSet(this.m_filterDao.getIPAddressList(selector.getFilterRule()));
        HashSet matchingSvcs = new HashSet(selector.getServiceNames());
        LinkedList<OnmsOutage> matchingOutages = new LinkedList<OnmsOutage>();
        Collection<OnmsOutage> outages = this.currentOutages();
        for (OnmsOutage outage : outages) {
            OnmsMonitoredService svc = outage.getMonitoredService();
            if (!matchingSvcs.contains(svc.getServiceName()) && !matchingSvcs.isEmpty() || !matchingAddrs.contains(svc.getIpAddress())) continue;
            matchingOutages.add(outage);
        }
        return matchingOutages;
    }

    @Override
    public int countOutagesByNode() {
        return this.getNodeOutageSummaries(0).size();
    }

    @Override
    public List<OutageSummary> getNodeOutageSummaries(int rows) {
        List<OutageSummary> outages = this.findObjects(OutageSummary.class, "SELECT DISTINCT new org.opennms.netmgt.model.outage.OutageSummary(node.id, node.label, max(outage.ifLostService)) FROM OnmsOutage AS outage LEFT JOIN outage.monitoredService AS monitoredService LEFT JOIN monitoredService.ipInterface AS ipInterface LEFT JOIN ipInterface.node AS node WHERE outage.ifRegainedService IS NULL AND outage.perspective IS NULL GROUP BY node.id, node.label ORDER BY max(outage.ifLostService) DESC, node.label ASC, node.id ASC", new Object[0]);
        if (rows == 0 || outages.size() < rows) {
            return outages;
        }
        return outages.subList(0, rows);
    }

    @Override
    public List<HeatMapElement> getHeatMapItemsForEntity(final String entityNameColumn, final String entityIdColumn, final String restrictionColumn, final String restrictionValue, String ... groupByColumns) {
        String grouping = "";
        if (groupByColumns != null && groupByColumns.length > 0) {
            for (String groupByColumn : groupByColumns) {
                if (!"".equals(grouping)) {
                    grouping = grouping + ", ";
                }
                grouping = grouping + groupByColumn;
            }
        } else {
            grouping = entityNameColumn + ", " + entityIdColumn;
        }
        final String groupByClause = grouping;
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<HeatMapElement>>(){

            public List<HeatMapElement> doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createSQLQuery("select coalesce(" + entityNameColumn + ",'Uncategorized'), " + entityIdColumn + ", count(distinct case when outages.outageid is not null and ifservices.status <> 'D' then ifservices.id else null end) as servicesDown, count(distinct case when ifservices.status <> 'D' then ifservices.id else null end) as servicesTotal, count(distinct case when outages.outageid is null and ifservices.status <> 'D' then node.nodeid else null end) as nodesUp, count(distinct node.nodeid) as nodeTotalCount from node left join category_node using (nodeid) left join categories using (categoryid) left outer join ipinterface using (nodeid) left outer join ifservices on (ifservices.ipinterfaceid = ipinterface.id) left outer join service on (ifservices.serviceid = service.serviceid) left outer join outages on (outages.ifserviceid = ifservices.id and outages.perspective is null and outages.ifregainedservice is null) where nodeType <> 'D' " + (restrictionColumn != null ? "and coalesce(" + restrictionColumn + ",'Uncategorized')='" + restrictionValue + "' " : "") + "group by " + groupByClause + " having count(distinct case when ifservices.status <> 'D' then ifservices.id else null end) > 0").setResultTransformer(new ResultTransformer(){
                    private static final long serialVersionUID = 5152094813503430377L;

                    public Object transformTuple(Object[] tuple, String[] aliases) {
                        return new HeatMapElement((String)tuple[0], (Number)tuple[1], (Number)tuple[2], (Number)tuple[3], (Number)tuple[4], (Number)tuple[5]);
                    }

                    public List transformList(List collection) {
                        return collection;
                    }
                }).list();
            }
        });
    }

    @Override
    public Collection<OnmsOutage> getStatusChangesForApplicationIdBetween(Date startDate, Date endDate, Integer applicationId) {
        return this.find("SELECT DISTINCT o FROM OnmsOutage o WHERE o.perspective IS NOT NULL AND o.monitoredService.id IN (SELECT m.id FROM OnmsApplication a LEFT JOIN a.monitoredServices m WHERE a.id = ?) AND o.perspective.id IN (SELECT p.id FROM OnmsApplication a LEFT JOIN a.perspectiveLocations p WHERE a.id = ?) AND ((o.ifRegainedService >= ? AND o.ifLostService <= ?) OR (o.ifLostService <= ? AND o.ifRegainedService IS NULL))", applicationId, applicationId, startDate, endDate, endDate);
    }
}

