/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.RouteNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.TracedRouteNodes;

public class DefaultTracedRouteNodes
implements TracedRouteNodes {
    private final Stack<List<RouteNode>> routeNodes = new Stack();
    private final Map<ProcessorDefinition<?>, AtomicInteger> nodeCounter = new HashMap();

    public DefaultTracedRouteNodes() {
        this.routeNodes.push(new ArrayList());
    }

    @Override
    public void addTraced(RouteNode entry) {
        List<RouteNode> list;
        List<RouteNode> list2 = list = this.routeNodes.isEmpty() ? null : this.routeNodes.peek();
        if (list == null) {
            list = new ArrayList<RouteNode>();
            this.routeNodes.push(list);
        }
        list.add(entry);
    }

    @Override
    public RouteNode getLastNode() {
        List<RouteNode> list;
        List<RouteNode> list2 = list = this.routeNodes.isEmpty() ? null : this.routeNodes.peek();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    @Override
    public RouteNode getSecondLastNode() {
        List<RouteNode> list;
        List<RouteNode> list2 = list = this.routeNodes.isEmpty() ? null : this.routeNodes.peek();
        if (list == null || list.isEmpty() || list.size() == 1) {
            return null;
        }
        return list.get(list.size() - 2);
    }

    @Override
    public List<RouteNode> getNodes() {
        ArrayList answer = new ArrayList();
        for (List list : this.routeNodes) {
            answer.addAll(list);
        }
        return Collections.unmodifiableList(answer);
    }

    @Override
    public void popBlock() {
        if (!this.routeNodes.isEmpty()) {
            this.routeNodes.pop();
        }
    }

    @Override
    public void pushBlock() {
        RouteNode last = this.getLastNode();
        this.routeNodes.push(new ArrayList());
        if (last != null) {
            this.addTraced(last);
        }
    }

    @Override
    public void clear() {
        this.routeNodes.clear();
    }

    @Override
    public int getAndIncrementCounter(ProcessorDefinition<?> node) {
        AtomicInteger count = this.nodeCounter.get(node);
        if (count == null) {
            count = new AtomicInteger();
            this.nodeCounter.put(node, count);
        }
        return count.getAndIncrement();
    }
}

